/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterInfoServiceUtils;
import org.elasticsearch.cluster.InternalClusterInfoService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.monitor.fs.FsInfo;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.threadpool.ThreadPool;

public class MockInternalClusterInfoService
extends InternalClusterInfoService {
    @Nullable
    private volatile Function<ShardRouting, Long> shardSizeFunction;
    @Nullable
    private volatile BiFunction<DiscoveryNode, FsInfo.Path, FsInfo.Path> diskUsageFunction;

    public MockInternalClusterInfoService(Settings settings, ClusterService clusterService, ThreadPool threadPool, NodeClient client) {
        super(settings, clusterService, threadPool, (Client)client);
    }

    public void setDiskUsageFunctionAndRefresh(BiFunction<DiscoveryNode, FsInfo.Path, FsInfo.Path> diskUsageFn) {
        this.diskUsageFunction = diskUsageFn;
        ClusterInfoServiceUtils.refresh(this);
    }

    public void setShardSizeFunctionAndRefresh(Function<ShardRouting, Long> shardSizeFn) {
        this.shardSizeFunction = shardSizeFn;
        ClusterInfoServiceUtils.refresh(this);
    }

    List<NodeStats> adjustNodesStats(List<NodeStats> nodesStats) {
        BiFunction<DiscoveryNode, FsInfo.Path, FsInfo.Path> diskUsageFunctionCopy = this.diskUsageFunction;
        if (diskUsageFunctionCopy == null) {
            return nodesStats;
        }
        return nodesStats.stream().map(nodeStats -> {
            DiscoveryNode discoveryNode = nodeStats.getNode();
            FsInfo oldFsInfo = nodeStats.getFs();
            return new NodeStats(discoveryNode, nodeStats.getTimestamp(), nodeStats.getIndices(), nodeStats.getOs(), nodeStats.getProcess(), nodeStats.getJvm(), nodeStats.getThreadPool(), new FsInfo(oldFsInfo.getTimestamp(), oldFsInfo.getIoStats(), (FsInfo.Path[])StreamSupport.stream(oldFsInfo.spliterator(), false).map(fsInfoPath -> (FsInfo.Path)diskUsageFunctionCopy.apply(discoveryNode, (FsInfo.Path)fsInfoPath)).toArray(FsInfo.Path[]::new)), nodeStats.getTransport(), nodeStats.getHttp(), nodeStats.getBreaker(), nodeStats.getScriptStats(), nodeStats.getDiscoveryStats(), nodeStats.getIngestStats(), nodeStats.getAdaptiveSelectionStats(), nodeStats.getScriptCacheStats(), nodeStats.getIndexingPressureStats(), nodeStats.getRepositoriesStats());
        }).collect(Collectors.toList());
    }

    ShardStats[] adjustShardStats(ShardStats[] shardsStats) {
        Function<ShardRouting, Long> shardSizeFunctionCopy = this.shardSizeFunction;
        if (shardSizeFunctionCopy == null) {
            return shardsStats;
        }
        return (ShardStats[])Arrays.stream(shardsStats).map(shardStats -> {
            ShardRouting shardRouting = shardStats.getShardRouting();
            StoreStats storeStats = new StoreStats(((Long)shardSizeFunctionCopy.apply(shardRouting)).longValue(), ((Long)shardSizeFunctionCopy.apply(shardRouting)).longValue(), shardStats.getStats().store.getReservedSize().getBytes());
            CommonStats commonStats = new CommonStats(new CommonStatsFlags(new CommonStatsFlags.Flag[]{CommonStatsFlags.Flag.Store}));
            commonStats.store = storeStats;
            return new ShardStats(shardRouting, commonStats, shardStats.getCommitStats(), shardStats.getSeqNoStats(), shardStats.getRetentionLeaseStats(), shardStats.getDataPath(), shardStats.getStatePath(), shardStats.isCustomDataPath(), shardStats.isSearchIdle(), shardStats.getSearchIdleTime());
        }).toArray(ShardStats[]::new);
    }

    public void setUpdateFrequency(TimeValue updateFrequency) {
        super.setUpdateFrequency(updateFrequency);
    }

    public static class TestPlugin
    extends Plugin {
    }
}

