/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.Collections;
import java.util.Random;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RelocationFailureInfo;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.test.ESTestCase;

public class TestShardRouting {
    public static ShardRouting newShardRouting(String index, int shardId, String currentNodeId, boolean primary, ShardRoutingState state) {
        return TestShardRouting.newShardRouting(new ShardId(index, "_na_", shardId), currentNodeId, primary, state);
    }

    public static ShardRouting newShardRouting(ShardId shardId, String currentNodeId, boolean primary, ShardRoutingState state) {
        return new ShardRouting(shardId, currentNodeId, null, primary, state, TestShardRouting.buildRecoveryTarget(primary, state), TestShardRouting.buildUnassignedInfo(state), TestShardRouting.buildRelocationFailureInfo(state), TestShardRouting.buildAllocationId(state), -1L, ShardRouting.Role.DEFAULT);
    }

    public static ShardRouting newShardRouting(ShardId shardId, String currentNodeId, boolean primary, ShardRoutingState state, RecoverySource recoverySource) {
        return new ShardRouting(shardId, currentNodeId, null, primary, state, recoverySource, TestShardRouting.buildUnassignedInfo(state), TestShardRouting.buildRelocationFailureInfo(state), TestShardRouting.buildAllocationId(state), -1L, ShardRouting.Role.DEFAULT);
    }

    public static ShardRouting newShardRouting(String index, int shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state) {
        return TestShardRouting.newShardRouting(new ShardId(index, "_na_", shardId), currentNodeId, relocatingNodeId, primary, state, ShardRouting.Role.DEFAULT);
    }

    public static ShardRouting newShardRouting(String index, int shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state, ShardRouting.Role role) {
        return TestShardRouting.newShardRouting(new ShardId(index, "_na_", shardId), currentNodeId, relocatingNodeId, primary, state, role);
    }

    public static ShardRouting newShardRouting(ShardId shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state) {
        return TestShardRouting.newShardRouting(shardId, currentNodeId, relocatingNodeId, primary, state, ShardRouting.Role.DEFAULT);
    }

    public static ShardRouting newShardRouting(ShardId shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state, ShardRouting.Role role) {
        return new ShardRouting(shardId, currentNodeId, relocatingNodeId, primary, state, TestShardRouting.buildRecoveryTarget(primary, state), TestShardRouting.buildUnassignedInfo(state), TestShardRouting.buildRelocationFailureInfo(state), TestShardRouting.buildAllocationId(state), -1L, role);
    }

    public static ShardRouting newShardRouting(String index, int shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state, AllocationId allocationId) {
        return TestShardRouting.newShardRouting(new ShardId(index, "_na_", shardId), currentNodeId, relocatingNodeId, primary, state, allocationId);
    }

    public static ShardRouting newShardRouting(ShardId shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state, AllocationId allocationId) {
        return new ShardRouting(shardId, currentNodeId, relocatingNodeId, primary, state, TestShardRouting.buildRecoveryTarget(primary, state), TestShardRouting.buildUnassignedInfo(state), TestShardRouting.buildRelocationFailureInfo(state), allocationId, -1L, ShardRouting.Role.DEFAULT);
    }

    public static ShardRouting newShardRouting(String index, int shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state, UnassignedInfo unassignedInfo) {
        return TestShardRouting.newShardRouting(index, shardId, currentNodeId, relocatingNodeId, primary, state, unassignedInfo, ShardRouting.Role.DEFAULT);
    }

    public static ShardRouting newShardRouting(String index, int shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state, UnassignedInfo unassignedInfo, ShardRouting.Role role) {
        return TestShardRouting.newShardRouting(new ShardId(index, "_na_", shardId), currentNodeId, relocatingNodeId, primary, state, unassignedInfo, role);
    }

    public static ShardRouting newShardRouting(ShardId shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state, UnassignedInfo unassignedInfo) {
        return TestShardRouting.newShardRouting(shardId, currentNodeId, relocatingNodeId, primary, state, unassignedInfo, ShardRouting.Role.DEFAULT);
    }

    public static ShardRouting newShardRouting(ShardId shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state, UnassignedInfo unassignedInfo, ShardRouting.Role role) {
        return new ShardRouting(shardId, currentNodeId, relocatingNodeId, primary, state, TestShardRouting.buildRecoveryTarget(primary, state), unassignedInfo, TestShardRouting.buildRelocationFailureInfo(state), TestShardRouting.buildAllocationId(state), -1L, role);
    }

    public static ShardRouting relocate(ShardRouting shardRouting, String relocatingNodeId, long expectedShardSize) {
        return shardRouting.relocate(relocatingNodeId, expectedShardSize);
    }

    public static RecoverySource buildRecoveryTarget(boolean primary, ShardRoutingState state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case ShardRoutingState.UNASSIGNED, ShardRoutingState.INITIALIZING -> {
                if (primary) {
                    yield ESTestCase.randomFrom(RecoverySource.EmptyStoreRecoverySource.INSTANCE, RecoverySource.ExistingStoreRecoverySource.INSTANCE);
                }
                yield RecoverySource.PeerRecoverySource.INSTANCE;
            }
            case ShardRoutingState.STARTED, ShardRoutingState.RELOCATING -> null;
        };
    }

    public static AllocationId buildAllocationId(ShardRoutingState state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case ShardRoutingState.UNASSIGNED -> null;
            case ShardRoutingState.INITIALIZING, ShardRoutingState.STARTED -> AllocationId.newInitializing();
            case ShardRoutingState.RELOCATING -> AllocationId.newRelocation((AllocationId)AllocationId.newInitializing());
        };
    }

    public static UnassignedInfo buildUnassignedInfo(ShardRoutingState state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case ShardRoutingState.UNASSIGNED, ShardRoutingState.INITIALIZING -> TestShardRouting.randomUnassignedInfo("auto generated for test");
            case ShardRoutingState.STARTED, ShardRoutingState.RELOCATING -> null;
        };
    }

    public static RelocationFailureInfo buildRelocationFailureInfo(ShardRoutingState state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case ShardRoutingState.UNASSIGNED, ShardRoutingState.INITIALIZING, ShardRoutingState.STARTED -> RelocationFailureInfo.NO_FAILURES;
            case ShardRoutingState.RELOCATING -> ESTestCase.randomBoolean() ? RelocationFailureInfo.NO_FAILURES : new RelocationFailureInfo(ESTestCase.randomIntBetween(1, 10));
        };
    }

    public static UnassignedInfo randomUnassignedInfo(String message) {
        UnassignedInfo.Reason reason = ESTestCase.randomFrom(UnassignedInfo.Reason.values());
        String lastAllocatedNodeId = null;
        boolean delayed = false;
        if (reason == UnassignedInfo.Reason.NODE_LEFT || reason == UnassignedInfo.Reason.NODE_RESTARTING) {
            if (ESTestCase.randomBoolean()) {
                delayed = true;
            }
            lastAllocatedNodeId = ESTestCase.randomAlphaOfLength(10);
        }
        int failedAllocations = reason == UnassignedInfo.Reason.ALLOCATION_FAILED ? 1 : 0;
        return new UnassignedInfo(reason, message, null, failedAllocations, System.nanoTime(), System.currentTimeMillis(), delayed, UnassignedInfo.AllocationStatus.NO_ATTEMPT, Collections.emptySet(), lastAllocatedNodeId);
    }

    public static RecoverySource randomRecoverySource() {
        return ESTestCase.randomFrom(RecoverySource.EmptyStoreRecoverySource.INSTANCE, RecoverySource.ExistingStoreRecoverySource.INSTANCE, RecoverySource.PeerRecoverySource.INSTANCE, RecoverySource.LocalShardsRecoverySource.INSTANCE, new RecoverySource.SnapshotRecoverySource(UUIDs.randomBase64UUID(), new Snapshot("repo", new SnapshotId(ESTestCase.randomAlphaOfLength(8), UUIDs.randomBase64UUID())), IndexVersion.current(), new IndexId("some_index", UUIDs.randomBase64UUID((Random)LuceneTestCase.random()))));
    }
}

