/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.MapperRegistry;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.plugins.internal.DocumentParsingObserver;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public class TranslogHandler
implements Engine.TranslogRecoveryRunner {
    private final MapperService mapperService;
    private final AtomicLong appliedOperations = new AtomicLong();

    long appliedOperations() {
        return this.appliedOperations.get();
    }

    public TranslogHandler(NamedXContentRegistry xContentRegistry, IndexSettings indexSettings) {
        SimilarityService similarityService = new SimilarityService(indexSettings, null, Collections.emptyMap());
        MapperRegistry mapperRegistry = new IndicesModule(Collections.emptyList()).getMapperRegistry();
        this.mapperService = new MapperService(() -> TransportVersion.current(), indexSettings, (type, name) -> Lucene.STANDARD_ANALYZER, XContentParserConfiguration.EMPTY.withRegistry(xContentRegistry).withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), similarityService, mapperRegistry, () -> null, indexSettings.getMode().idFieldMapperWithoutFieldData(), null, () -> DocumentParsingObserver.EMPTY_INSTANCE);
    }

    private void applyOperation(Engine engine, Engine.Operation operation) throws IOException {
        switch (operation.operationType()) {
            case INDEX: {
                engine.index((Engine.Index)operation);
                break;
            }
            case DELETE: {
                engine.delete((Engine.Delete)operation);
                break;
            }
            case NO_OP: {
                engine.noOp((Engine.NoOp)operation);
                break;
            }
            default: {
                throw new IllegalStateException("No operation defined for [" + operation + "]");
            }
        }
    }

    public int run(Engine engine, Translog.Snapshot snapshot) throws IOException {
        Translog.Operation operation;
        int opsRecovered = 0;
        while ((operation = snapshot.next()) != null) {
            this.applyOperation(engine, this.convertToEngineOp(operation, Engine.Operation.Origin.LOCAL_TRANSLOG_RECOVERY));
            ++opsRecovered;
            this.appliedOperations.incrementAndGet();
        }
        engine.syncTranslog();
        return opsRecovered;
    }

    public Engine.Operation convertToEngineOp(Translog.Operation operation, Engine.Operation.Origin origin) {
        VersionType versionType = origin == Engine.Operation.Origin.PRIMARY ? VersionType.EXTERNAL : null;
        switch (operation.opType()) {
            case INDEX: {
                Translog.Index index = (Translog.Index)operation;
                Engine.Index engineIndex = IndexShard.prepareIndex((MapperService)this.mapperService, (SourceToParse)new SourceToParse(index.id(), index.source(), XContentHelper.xContentType((BytesReference)index.source()), index.routing(), Map.of(), false), (long)index.seqNo(), (long)index.primaryTerm(), (long)index.version(), (VersionType)versionType, (Engine.Operation.Origin)origin, (long)index.getAutoGeneratedIdTimestamp(), (boolean)true, (long)-2L, (long)0L, (long)System.nanoTime());
                return engineIndex;
            }
            case DELETE: {
                Translog.Delete delete = (Translog.Delete)operation;
                return IndexShard.prepareDelete((String)delete.id(), (long)delete.seqNo(), (long)delete.primaryTerm(), (long)delete.version(), (VersionType)versionType, (Engine.Operation.Origin)origin, (long)-2L, (long)0L);
            }
            case NO_OP: {
                Translog.NoOp noOp = (Translog.NoOp)operation;
                Engine.NoOp engineNoOp = new Engine.NoOp(noOp.seqNo(), noOp.primaryTerm(), origin, System.nanoTime(), noOp.reason());
                return engineNoOp;
            }
        }
        throw new IllegalStateException("No operation defined for [" + operation + "]");
    }
}

