/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.node.info.PluginsAndModules;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.env.Environment;
import org.elasticsearch.jdk.ModuleQualifiedExportsService;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginDescriptor;
import org.elasticsearch.plugins.PluginRuntimeInfo;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.plugins.spi.SPIClassIterator;

public class MockPluginsService
extends PluginsService {
    private static final Logger logger = LogManager.getLogger(MockPluginsService.class);
    private final List<PluginsService.LoadedPlugin> classpathPlugins;
    private static final Map<Class<?>, Collection<Class<?>>> spiClassesByService = ConcurrentCollections.newConcurrentMap();

    public MockPluginsService(Settings settings, Environment environment, Collection<Class<? extends Plugin>> classpathPlugins) {
        super(settings, environment.configFile(), environment.modulesFile(), environment.pluginsFile());
        Path configPath = environment.configFile();
        ArrayList<PluginsService.LoadedPlugin> pluginsLoaded = new ArrayList<PluginsService.LoadedPlugin>();
        for (Class<? extends Plugin> pluginClass : classpathPlugins) {
            Plugin plugin = MockPluginsService.loadPlugin(pluginClass, (Settings)settings, (Path)configPath);
            PluginDescriptor pluginInfo = new PluginDescriptor(pluginClass.getName(), "classpath plugin", "NA", Version.CURRENT, Integer.toString(Runtime.version().feature()), pluginClass.getName(), null, Collections.emptyList(), false, false, false, false);
            if (logger.isTraceEnabled()) {
                logger.trace("plugin loaded from classpath [{}]", (Object)pluginInfo);
            }
            pluginsLoaded.add(new PluginsService.LoadedPlugin(pluginInfo, plugin, pluginClass.getClassLoader(), ModuleLayer.boot()));
        }
        MockPluginsService.loadExtensions(pluginsLoaded);
        this.classpathPlugins = List.copyOf(pluginsLoaded);
    }

    protected final List<PluginsService.LoadedPlugin> plugins() {
        return this.classpathPlugins;
    }

    public PluginsAndModules info() {
        return new PluginsAndModules(this.classpathPlugins.stream().map(PluginsService.LoadedPlugin::descriptor).map(PluginRuntimeInfo::new).toList(), List.of());
    }

    public <T> List<? extends T> loadServiceProviders(Class<T> service) {
        HashMap result = new HashMap();
        for (PluginsService.LoadedPlugin pluginTuple : this.plugins()) {
            Plugin plugin = pluginTuple.instance();
            ClassLoader classLoader = plugin.getClass().getClassLoader();
            List<Object> extension = classLoader == ClassLoader.getSystemClassLoader() ? MockPluginsService.createExtensions(service, plugin, spiClassesByService.computeIfAbsent(service, s -> {
                ArrayList res = new ArrayList();
                SPIClassIterator.get((Class)service, (ClassLoader)classLoader).forEachRemaining(res::add);
                return List.copyOf(res);
            }).iterator(), result::containsKey) : MockPluginsService.createExtensions(service, plugin, result::containsKey);
            extension.forEach(e -> result.put(e.getClass(), e));
        }
        return List.copyOf(result.values());
    }

    static <T> List<? extends T> createExtensions(Class<T> extensionPointType, Plugin plugin, Predicate<Class<? extends T>> loadedPredicate) {
        SPIClassIterator classIterator = SPIClassIterator.get(extensionPointType, (ClassLoader)plugin.getClass().getClassLoader());
        return MockPluginsService.createExtensions(extensionPointType, plugin, classIterator, loadedPredicate);
    }

    private static <T> List<T> createExtensions(Class<T> extensionPointType, Plugin plugin, Iterator<Class<? extends T>> classIterator, Predicate<Class<? extends T>> loadedPredicate) {
        ArrayList<Object> extensions = new ArrayList<Object>();
        while (classIterator.hasNext()) {
            Class<T> extensionClass = classIterator.next();
            if (loadedPredicate.test(extensionClass)) continue;
            Constructor<?>[] constructors = extensionClass.getConstructors();
            boolean compatible = true;
            for (Constructor<?> constructor : constructors) {
                if (constructor.getParameterCount() != 1 || constructor.getParameterTypes()[0] == plugin.getClass()) continue;
                compatible = false;
                break;
            }
            if (!compatible) continue;
            extensions.add(MockPluginsService.createExtension(extensionClass, extensionPointType, (Plugin)plugin));
        }
        return extensions;
    }

    protected void addServerExportsService(Map<String, List<ModuleQualifiedExportsService>> qualifiedExports) {
    }
}

