/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.rest.ChunkedRestResponseBody;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.transport.BytesRefRecycler;

public class RestResponseUtils {
    private RestResponseUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BytesReference getBodyContent(RestResponse restResponse) {
        int pageSize;
        if (!restResponse.isChunked()) {
            return restResponse.content();
        }
        ChunkedRestResponseBody chunkedRestResponseBody = restResponse.chunkedContent();
        assert (!chunkedRestResponseBody.isDone());
        try (Recycler.V page = BytesRefRecycler.NON_RECYCLING_INSTANCE.obtain();){
            pageSize = ((BytesRef)page.v()).length;
        }
        try (BytesStreamOutput out = new BytesStreamOutput();){
            while (!chunkedRestResponseBody.isDone()) {
                ReleasableBytesReference chunk = chunkedRestResponseBody.encodeChunk(pageSize, (Recycler)BytesRefRecycler.NON_RECYCLING_INSTANCE);
                try {
                    chunk.writeTo((OutputStream)out);
                }
                finally {
                    if (chunk == null) continue;
                    chunk.close();
                }
            }
            out.flush();
            BytesReference bytesReference = out.bytes();
            return bytesReference;
        }
        catch (Exception e) {
            throw new AssertionError("unexpected", e);
        }
    }

    public static String getTextBodyContent(Iterator<CheckedConsumer<Writer, IOException>> iterator) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            while (iterator.hasNext()) {
                iterator.next().accept((Object)writer);
            }
            writer.flush();
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new AssertionError("unexpected", e);
            }
        }
        writer.close();
        return string;
    }
}

