/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.geo;

import java.io.IOException;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.query.GeoValidationMethod;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class GeoBoundingBoxQueryIntegTestCase
extends ESIntegTestCase {
    public abstract XContentBuilder getMapping() throws IOException;

    public abstract IndexVersion randomSupportedVersion() throws IOException;

    @Override
    protected boolean forbidPrivateIndexSettings() {
        return false;
    }

    public void testSimpleBoundingBoxTest() throws Exception {
        Settings settings = Settings.builder().put("index.version.created", (VersionId)this.randomSupportedVersion()).build();
        XContentBuilder xContentBuilder = this.getMapping();
        ElasticsearchAssertions.assertAcked(this.prepareCreate("test").setSettings(settings).setMapping(xContentBuilder));
        this.ensureGreen(new String[0]);
        GeoBoundingBoxQueryIntegTestCase.client().prepareIndex("test").setId("1").setSource(XContentFactory.jsonBuilder().startObject().field("name", "New York").field("location", "POINT(-74.0059731 40.7143528)").endObject()).get();
        GeoBoundingBoxQueryIntegTestCase.client().prepareIndex("test").setId("2").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Times Square").field("location", "POINT(-73.9844722 40.759011)").endObject()).get();
        GeoBoundingBoxQueryIntegTestCase.client().prepareIndex("test").setId("3").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Tribeca").field("location", "POINT(-74.007819 40.718266)").endObject()).get();
        GeoBoundingBoxQueryIntegTestCase.client().prepareIndex("test").setId("4").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Wall Street").field("location", "POINT(-74.0088305 40.7051157)").endObject()).get();
        GeoBoundingBoxQueryIntegTestCase.client().prepareIndex("test").setId("5").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Soho").field("location", "POINT(-74 40.7247222)").endObject()).get();
        GeoBoundingBoxQueryIntegTestCase.client().prepareIndex("test").setId("6").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Greenwich Village").field("location", "POINT(-73.9962255 40.731033)").endObject()).get();
        GeoBoundingBoxQueryIntegTestCase.client().prepareIndex("test").setId("7").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Brooklyn").field("location", "POINT(-73.95 40.65)").endObject()).get();
        GeoBoundingBoxQueryIntegTestCase.client().admin().indices().prepareRefresh(new String[0]).get();
        SearchResponse searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setCorners(40.73, -74.1, 40.717, -73.99)).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)2L));
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getHits().length, (Matcher)Matchers.equalTo((Object)2));
        for (SearchHit hit : searchResponse.getHits()) {
            GeoBoundingBoxQueryIntegTestCase.assertThat((Object)hit.getId(), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)"1"), (Matcher)Matchers.equalTo((Object)"3"), (Matcher)Matchers.equalTo((Object)"5")));
        }
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setCorners(40.73, -74.1, 40.717, -73.99)).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)2L));
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getHits().length, (Matcher)Matchers.equalTo((Object)2));
        for (SearchHit hit : searchResponse.getHits()) {
            GeoBoundingBoxQueryIntegTestCase.assertThat((Object)hit.getId(), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)"1"), (Matcher)Matchers.equalTo((Object)"3"), (Matcher)Matchers.equalTo((Object)"5")));
        }
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setCorners(40.7143528, -74.0059731, 40.7143528, -74.0059731)).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getHits().length, (Matcher)Matchers.equalTo((Object)1));
        for (SearchHit hit : searchResponse.getHits()) {
            GeoBoundingBoxQueryIntegTestCase.assertThat((Object)hit.getId(), (Matcher)Matchers.equalTo((Object)"1"));
        }
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setCorners(40.759011, -74.00009, 40.759011, -73.0059731)).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getHits().length, (Matcher)Matchers.equalTo((Object)1));
        for (SearchHit hit : searchResponse.getHits()) {
            GeoBoundingBoxQueryIntegTestCase.assertThat((Object)hit.getId(), (Matcher)Matchers.equalTo((Object)"2"));
        }
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setCorners(41.8, -73.9844722, 40.7, -73.9844722)).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getHits().length, (Matcher)Matchers.equalTo((Object)1));
        for (SearchHit hit : searchResponse.getHits()) {
            GeoBoundingBoxQueryIntegTestCase.assertThat((Object)hit.getId(), (Matcher)Matchers.equalTo((Object)"2"));
        }
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.geoDistanceQuery((String)"location").point(40.5, -73.9).distance(25.0, DistanceUnit.KILOMETERS)).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)2L));
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getHits().length, (Matcher)Matchers.equalTo((Object)2));
        for (SearchHit hit : searchResponse.getHits()) {
            GeoBoundingBoxQueryIntegTestCase.assertThat((Object)hit.getId(), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)"7"), (Matcher)Matchers.equalTo((Object)"4")));
        }
    }

    public void testLimit2BoundingBox() throws Exception {
        Settings settings = Settings.builder().put("index.version.created", (VersionId)this.randomSupportedVersion()).build();
        XContentBuilder xContentBuilder = this.getMapping();
        ElasticsearchAssertions.assertAcked(this.prepareCreate("test").setSettings(settings).setMapping(xContentBuilder));
        this.ensureGreen(new String[0]);
        ((IndexRequestBuilder)GeoBoundingBoxQueryIntegTestCase.client().prepareIndex("test").setId("1").setSource(XContentFactory.jsonBuilder().startObject().field("userid", 880).field("title", "Place in Stockholm").field("location", "POINT(59.328355000000002 18.036842)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ((IndexRequestBuilder)GeoBoundingBoxQueryIntegTestCase.client().prepareIndex("test").setId("2").setSource(XContentFactory.jsonBuilder().startObject().field("userid", 534).field("title", "Place in Montreal").field("location", "POINT(-73.570986000000005 45.509526999999999)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        SearchResponse searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"userid", (int)880)).filter((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setCorners(74.579422, 143.5, -66.668904, 113.96875))).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"userid", (int)880)).filter((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setCorners(74.579422, 143.5, -66.668904, 113.96875))).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"userid", (int)534)).filter((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setCorners(74.579422, 143.5, -66.668904, 113.96875))).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"userid", (int)534)).filter((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setCorners(74.579422, 143.5, -66.668904, 113.96875))).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"userid", (int)880)).filter((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setCorners(18.036842, 59.328355, 18.036842, 59.328355))).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"userid", (int)534)).filter((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setCorners(45.509527, -73.570986, 45.509527, -73.570986))).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"userid", (int)880)).filter((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setCorners(18.036842, 143.5, 18.036842, 113.96875))).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"userid", (int)534)).filter((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setCorners(45.509527, 143.5, 45.509527, 113.96875))).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"userid", (int)880)).filter((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setCorners(74.579422, 59.328355, -66.668904, 59.328355))).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"userid", (int)534)).filter((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setCorners(74.579422, -73.570986, -66.668904, -73.570986))).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"userid", (int)880)).filter((QueryBuilder)QueryBuilders.geoDistanceQuery((String)"location").point(20.0, 60.0).distance(500.0, DistanceUnit.MILES))).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"userid", (int)534)).filter((QueryBuilder)QueryBuilders.geoDistanceQuery((String)"location").point(45.0, -73.0).distance(500.0, DistanceUnit.MILES))).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
    }

    public void testCompleteLonRange() throws Exception {
        Settings settings = Settings.builder().put("index.version.created", (VersionId)this.randomSupportedVersion()).build();
        XContentBuilder xContentBuilder = this.getMapping();
        ElasticsearchAssertions.assertAcked(this.prepareCreate("test").setSettings(settings).setMapping(xContentBuilder));
        this.ensureGreen(new String[0]);
        ((IndexRequestBuilder)GeoBoundingBoxQueryIntegTestCase.client().prepareIndex("test").setId("1").setSource(XContentFactory.jsonBuilder().startObject().field("userid", 880).field("title", "Place in Stockholm").field("location", "POINT(18.036842 59.328355000000002)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ((IndexRequestBuilder)GeoBoundingBoxQueryIntegTestCase.client().prepareIndex("test").setId("2").setSource(XContentFactory.jsonBuilder().startObject().field("userid", 534).field("title", "Place in Montreal").field("location", "POINT(-73.570986000000005 45.509526999999999)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        SearchResponse searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setValidationMethod(GeoValidationMethod.COERCE).setCorners(50.0, -180.0, -50.0, 180.0)).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setValidationMethod(GeoValidationMethod.COERCE).setCorners(50.0, -180.0, -50.0, 180.0)).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setValidationMethod(GeoValidationMethod.COERCE).setCorners(90.0, -180.0, -90.0, 180.0)).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)2L));
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setValidationMethod(GeoValidationMethod.COERCE).setCorners(90.0, -180.0, -90.0, 180.0)).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)2L));
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setValidationMethod(GeoValidationMethod.COERCE).setCorners(50.0, 0.0, -50.0, 360.0)).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setValidationMethod(GeoValidationMethod.COERCE).setCorners(50.0, 0.0, -50.0, 360.0)).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setValidationMethod(GeoValidationMethod.COERCE).setCorners(90.0, 0.0, -90.0, 360.0)).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)2L));
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setValidationMethod(GeoValidationMethod.COERCE).setCorners(90.0, 0.0, -90.0, 360.0)).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)2L));
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setValidationMethod(GeoValidationMethod.COERCE).setCorners(59.328355, 0.0, 59.328355, 360.0)).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"location").setValidationMethod(GeoValidationMethod.COERCE).setCorners(59.328355, -180.0, 59.328355, 180.0)).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        searchResponse = (SearchResponse)GeoBoundingBoxQueryIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.geoDistanceQuery((String)"location").point(60.0, -20.0).distance(1800.0, DistanceUnit.MILES)).get();
        GeoBoundingBoxQueryIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
    }
}

