/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.routing.allocation.decider.EnableAllocationDecider;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.FinalizeSnapshotContext;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.repositories.blobstore.BlobStoreTestUtil;
import org.elasticsearch.repositories.blobstore.ChecksumBlobStoreFormat;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.snapshots.mockstore.MockRepository;
import org.elasticsearch.test.ClusterServiceUtils;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.test.index.IndexVersionUtils;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.threadpool.ThreadPoolStats;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;

public abstract class AbstractSnapshotIntegTestCase
extends ESIntegTestCase {
    public static final String RANDOM_SNAPSHOT_NAME_PREFIX = "snap-";
    public static final String OLD_VERSION_SNAPSHOT_PREFIX = "old-version-snapshot-";
    protected static final int LARGE_POOL_SIZE = 10;
    protected static final Settings LARGE_SNAPSHOT_POOL_SETTINGS = Settings.builder().put("thread_pool.snapshot.core", 10).put("thread_pool.snapshot.max", 10).build();
    protected static final Settings SMALL_SNAPSHOT_POOL_SETTINGS = Settings.builder().put("thread_pool.snapshot.core", 1).put("thread_pool.snapshot.max", 1).build();
    private String skipRepoConsistencyCheckReason;
    public static final Settings SINGLE_SHARD_NO_REPLICA = AbstractSnapshotIntegTestCase.indexSettingsNoReplicas(1).build();

    @Override
    protected Settings nodeSettings(int nodeOrdinal, Settings otherSettings) {
        return Settings.builder().put(super.nodeSettings(nodeOrdinal, otherSettings)).put(EnableAllocationDecider.CLUSTER_ROUTING_REBALANCE_ENABLE_SETTING.getKey(), (Enum)EnableAllocationDecider.Rebalance.NONE).build();
    }

    @Override
    protected Collection<Class<? extends Plugin>> nodePlugins() {
        return Arrays.asList(MockRepository.Plugin.class);
    }

    @After
    public void assertConsistentHistoryInLuceneIndex() throws Exception {
        AbstractSnapshotIntegTestCase.internalCluster().assertConsistentHistoryBetweenTranslogAndLuceneIndex();
    }

    @After
    public void verifyNoLeakedListeners() throws Exception {
        AbstractSnapshotIntegTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            for (SnapshotsService snapshotsService : AbstractSnapshotIntegTestCase.internalCluster().getInstances(SnapshotsService.class)) {
                AbstractSnapshotIntegTestCase.assertTrue((boolean)snapshotsService.assertAllListenersResolved());
            }
        }), 30L, TimeUnit.SECONDS);
    }

    @After
    public void assertRepoConsistency() {
        if (this.skipRepoConsistencyCheckReason == null) {
            ((GetRepositoriesResponse)AbstractSnapshotIntegTestCase.clusterAdmin().prepareGetRepositories(new String[0]).get()).repositories().forEach(repositoryMetadata -> {
                String name = repositoryMetadata.name();
                if (!repositoryMetadata.settings().getAsBoolean("readonly", Boolean.valueOf(false)).booleanValue()) {
                    AbstractSnapshotIntegTestCase.clusterAdmin().prepareDeleteSnapshot(name, new String[]{"old-version-snapshot-*"}).get();
                    AbstractSnapshotIntegTestCase.clusterAdmin().prepareCleanupRepository(name).get();
                }
                BlobStoreTestUtil.assertConsistency((BlobStoreRepository)AbstractSnapshotIntegTestCase.getRepositoryOnMaster(name));
            });
        } else {
            this.logger.info("--> skipped repo consistency checks because [{}]", (Object)this.skipRepoConsistencyCheckReason);
        }
    }

    protected void disableRepoConsistencyCheck(String reason) {
        AbstractSnapshotIntegTestCase.assertNotNull((Object)reason);
        this.skipRepoConsistencyCheckReason = reason;
    }

    protected RepositoryData getRepositoryData(String repoName, IndexVersion version) {
        RepositoryData repositoryData = this.getRepositoryData(repoName);
        if (!SnapshotsService.includesUUIDs((IndexVersion)version)) {
            return repositoryData.withoutUUIDs();
        }
        return repositoryData;
    }

    protected RepositoryData getRepositoryData(String repository) {
        return this.getRepositoryData((Repository)AbstractSnapshotIntegTestCase.getRepositoryOnMaster(repository));
    }

    protected RepositoryData getRepositoryData(Repository repository) {
        return (RepositoryData)PlainActionFuture.get(arg_0 -> ((Repository)repository).getRepositoryData(arg_0));
    }

    public static long getFailureCount(String repository) {
        long failureCount = 0L;
        for (RepositoriesService repositoriesService : AbstractSnapshotIntegTestCase.internalCluster().getDataOrMasterNodeInstances(RepositoriesService.class)) {
            MockRepository mockRepository = (MockRepository)repositoriesService.repository(repository);
            failureCount += mockRepository.getFailureCount();
        }
        return failureCount;
    }

    public static void assertFileCount(Path dir, int expectedCount) throws IOException {
        ArrayList found = new ArrayList();
        AbstractSnapshotIntegTestCase.forEachFileRecursively(dir, (CheckedBiConsumer<Path, BasicFileAttributes, IOException>)((CheckedBiConsumer)(path, basicFileAttributes) -> found.add(path)));
        AbstractSnapshotIntegTestCase.assertEquals((String)("Unexpected file count, found: [" + found + "]."), (long)expectedCount, (long)found.size());
    }

    protected void stopNode(String node) throws IOException {
        this.logger.info("--> stopping node {}", (Object)node);
        AbstractSnapshotIntegTestCase.internalCluster().stopNode(node);
    }

    protected static String startDataNodeWithLargeSnapshotPool() {
        return AbstractSnapshotIntegTestCase.internalCluster().startDataOnlyNode(LARGE_SNAPSHOT_POOL_SETTINGS);
    }

    public void waitForBlock(String node, String repository) throws Exception {
        this.logger.info("--> waiting for [{}] to be blocked on node [{}]", (Object)repository, (Object)node);
        MockRepository mockRepository = (MockRepository)((Object)AbstractSnapshotIntegTestCase.getRepositoryOnNode(repository, node));
        AbstractSnapshotIntegTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> AbstractSnapshotIntegTestCase.assertTrue((boolean)mockRepository.blocked())), 30L, TimeUnit.SECONDS);
    }

    public static void blockMasterFromFinalizingSnapshotOnIndexFile(String repositoryName) {
        ((MockRepository)((Object)AbstractSnapshotIntegTestCase.getRepositoryOnMaster(repositoryName))).setBlockAndFailOnWriteIndexFile();
    }

    public static void blockMasterOnWriteIndexFile(String repositoryName) {
        ((MockRepository)((Object)AbstractSnapshotIntegTestCase.getRepositoryOnMaster(repositoryName))).setBlockOnWriteIndexFile();
    }

    public static void blockMasterFromDeletingIndexNFile(String repositoryName) {
        ((MockRepository)((Object)AbstractSnapshotIntegTestCase.getRepositoryOnMaster(repositoryName))).setBlockOnDeleteIndexFile();
    }

    public static void blockMasterFromFinalizingSnapshotOnSnapFile(String repositoryName) {
        ((MockRepository)((Object)AbstractSnapshotIntegTestCase.getRepositoryOnMaster(repositoryName))).setBlockAndFailOnWriteSnapFiles();
    }

    public static void blockMasterOnAnyDataFile(String repositoryName) {
        ((MockRepository)((Object)AbstractSnapshotIntegTestCase.getRepositoryOnMaster(repositoryName))).blockOnDataFiles();
    }

    public static void blockMasterOnShardLevelSnapshotFile(String repositoryName, String indexId) {
        ((MockRepository)((Object)AbstractSnapshotIntegTestCase.getRepositoryOnMaster(repositoryName))).setBlockOnShardLevelSnapFiles(indexId);
    }

    public static <T extends Repository> T getRepositoryOnMaster(String repositoryName) {
        return (T)AbstractSnapshotIntegTestCase.internalCluster().getCurrentMasterNodeInstance(RepositoriesService.class).repository(repositoryName);
    }

    protected static <T extends Repository> T getRepositoryOnNode(String repositoryName, String nodeName) {
        return (T)AbstractSnapshotIntegTestCase.internalCluster().getInstance(RepositoriesService.class, nodeName).repository(repositoryName);
    }

    public static String blockNodeWithIndex(String repositoryName, String indexName) {
        Iterator<String> iterator = AbstractSnapshotIntegTestCase.internalCluster().nodesInclude(indexName).iterator();
        if (iterator.hasNext()) {
            String node = iterator.next();
            ((MockRepository)((Object)AbstractSnapshotIntegTestCase.getRepositoryOnNode(repositoryName, node))).blockOnDataFiles();
            return node;
        }
        AbstractSnapshotIntegTestCase.fail((String)("No nodes for the index " + indexName + " found"));
        return null;
    }

    public static void blockNodeOnAnyFiles(String repository, String nodeName) {
        ((MockRepository)((Object)AbstractSnapshotIntegTestCase.getRepositoryOnNode(repository, nodeName))).setBlockOnAnyFiles();
    }

    public static void blockDataNode(String repository, String nodeName) {
        ((MockRepository)((Object)AbstractSnapshotIntegTestCase.getRepositoryOnNode(repository, nodeName))).blockOnDataFiles();
    }

    public static void blockAndFailDataNode(String repository, String nodeName) {
        ((MockRepository)((Object)AbstractSnapshotIntegTestCase.getRepositoryOnNode(repository, nodeName))).blockAndFailOnDataFiles();
    }

    public static void blockAllDataNodes(String repository) {
        for (RepositoriesService repositoriesService : AbstractSnapshotIntegTestCase.internalCluster().getDataNodeInstances(RepositoriesService.class)) {
            ((MockRepository)repositoriesService.repository(repository)).blockOnDataFiles();
        }
    }

    public static void unblockAllDataNodes(String repository) {
        for (RepositoriesService repositoriesService : AbstractSnapshotIntegTestCase.internalCluster().getDataNodeInstances(RepositoriesService.class)) {
            ((MockRepository)repositoriesService.repository(repository)).unblock();
        }
    }

    public static void failReadsAllDataNodes(String repository) {
        for (RepositoriesService repositoriesService : AbstractSnapshotIntegTestCase.internalCluster().getDataNodeInstances(RepositoriesService.class)) {
            MockRepository mockRepository = (MockRepository)repositoriesService.repository(repository);
            mockRepository.setFailReadsAfterUnblock(true);
        }
    }

    public static void waitForBlockOnAnyDataNode(String repository) throws InterruptedException {
        boolean blocked = AbstractSnapshotIntegTestCase.waitUntil(() -> {
            for (RepositoriesService repositoriesService : AbstractSnapshotIntegTestCase.internalCluster().getDataNodeInstances(RepositoriesService.class)) {
                MockRepository mockRepository = (MockRepository)repositoriesService.repository(repository);
                if (!mockRepository.blocked()) continue;
                return true;
            }
            return false;
        }, 30L, TimeUnit.SECONDS);
        AbstractSnapshotIntegTestCase.assertTrue((String)"No repository is blocked waiting on a data node", (boolean)blocked);
    }

    public void unblockNode(String repository, String node) {
        this.logger.info("--> unblocking [{}] on node [{}]", (Object)repository, (Object)node);
        ((MockRepository)((Object)AbstractSnapshotIntegTestCase.getRepositoryOnNode(repository, node))).unblock();
    }

    protected void createRepository(String repoName, String type, Settings.Builder settings, boolean verify) {
        AbstractSnapshotIntegTestCase.createRepository(this.logger, repoName, type, settings, verify);
    }

    public static void createRepository(Logger logger, String repoName, String type, Settings.Builder settings, boolean verify) {
        logger.info("--> creating or updating repository [{}] [{}]", (Object)repoName, (Object)type);
        ElasticsearchAssertions.assertAcked(AbstractSnapshotIntegTestCase.clusterAdmin().preparePutRepository(repoName).setVerify(verify).setType(type).setSettings(settings));
    }

    protected void createRepository(String repoName, String type, Settings.Builder settings) {
        this.createRepository(repoName, type, settings, true);
    }

    protected void createRepository(String repoName, String type, Path location) {
        this.createRepository(repoName, type, Settings.builder().put("location", location));
    }

    protected void createRepository(String repoName, String type) {
        AbstractSnapshotIntegTestCase.createRepository(this.logger, repoName, type);
    }

    protected void createRepositoryNoVerify(String repoName, String type) {
        this.createRepository(repoName, type, AbstractSnapshotIntegTestCase.randomRepositorySettings(), false);
    }

    public static void createRepository(Logger logger, String repoName, String type) {
        AbstractSnapshotIntegTestCase.createRepository(logger, repoName, type, AbstractSnapshotIntegTestCase.randomRepositorySettings(), true);
    }

    protected void deleteRepository(String repoName) {
        ElasticsearchAssertions.assertAcked(AbstractSnapshotIntegTestCase.clusterAdmin().prepareDeleteRepository(repoName));
    }

    public static Settings.Builder randomRepositorySettings() {
        Settings.Builder settings = Settings.builder();
        settings.put("location", AbstractSnapshotIntegTestCase.randomRepoPath()).put("compress", AbstractSnapshotIntegTestCase.randomBoolean());
        if (AbstractSnapshotIntegTestCase.rarely()) {
            settings.put("chunk_size", (long)AbstractSnapshotIntegTestCase.randomIntBetween(100, 1000), ByteSizeUnit.BYTES);
        }
        if (AbstractSnapshotIntegTestCase.randomBoolean()) {
            settings.put(BlobStoreRepository.USE_FOR_PEER_RECOVERY_SETTING.getKey(), AbstractSnapshotIntegTestCase.randomBoolean());
        }
        return settings;
    }

    protected static Settings.Builder indexSettingsNoReplicas(int shards) {
        return AbstractSnapshotIntegTestCase.indexSettings(shards, 0);
    }

    protected void maybeInitWithOldSnapshotVersion(String repoName, Path repoPath) throws Exception {
        if (AbstractSnapshotIntegTestCase.randomBoolean() && AbstractSnapshotIntegTestCase.randomBoolean()) {
            this.initWithSnapshotVersion(repoName, repoPath, IndexVersionUtils.randomVersionBetween(AbstractSnapshotIntegTestCase.random(), IndexVersion.V_7_0_0, IndexVersion.V_8_9_0));
        }
    }

    protected String initWithSnapshotVersion(String repoName, Path repoPath, IndexVersion version) throws Exception {
        AbstractSnapshotIntegTestCase.assertThat((String)"This hack only works on an empty repository", (Object)this.getRepositoryData(repoName).getSnapshotIds(), (Matcher)Matchers.empty());
        String oldVersionSnapshot = OLD_VERSION_SNAPSHOT_PREFIX + version.id();
        CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)AbstractSnapshotIntegTestCase.clusterAdmin().prepareCreateSnapshot(repoName, oldVersionSnapshot).setIndices(new String[]{"does-not-exist-for-sure-*"}).setWaitForCompletion(true).get();
        SnapshotInfo snapshotInfo = createSnapshotResponse.getSnapshotInfo();
        AbstractSnapshotIntegTestCase.assertThat((Object)snapshotInfo.totalShards(), (Matcher)Matchers.is((Object)0));
        this.logger.info("--> writing downgraded RepositoryData for repository metadata version [{}]", (Object)version);
        RepositoryData repositoryData = this.getRepositoryData(repoName, version);
        XContentBuilder jsonBuilder = JsonXContent.contentBuilder();
        repositoryData.snapshotsToXContent(jsonBuilder, version);
        String currentVersionString = Strings.toString((XContentBuilder)jsonBuilder);
        String oldVersionString = version.onOrAfter((VersionId)IndexVersion.V_8_500_000) ? currentVersionString.replace(",\"index_version\":" + IndexVersion.current(), ",\"index_version\":" + version) : currentVersionString.replace(",\"index_version\":" + IndexVersion.current(), "").replace(",\"version\":\"8.11.0\"", ",\"version\":\"" + Version.fromId((int)version.id()) + "\"");
        RepositoryData downgradedRepoData = RepositoryData.snapshotsFromXContent((XContentParser)JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, oldVersionString), (long)repositoryData.getGenId(), (boolean)AbstractSnapshotIntegTestCase.randomBoolean());
        Files.write(repoPath.resolve("index-" + repositoryData.getGenId()), BytesReference.toBytes((BytesReference)BytesReference.bytes((XContentBuilder)downgradedRepoData.snapshotsToXContent(XContentFactory.jsonBuilder(), version))), StandardOpenOption.TRUNCATE_EXISTING);
        SnapshotInfo downgradedSnapshotInfo = SnapshotInfo.fromXContentInternal((String)repoName, (XContentParser)JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, Strings.toString((ToXContent)snapshotInfo, (ToXContent.Params)ChecksumBlobStoreFormat.SNAPSHOT_ONLY_FORMAT_PARAMS).replace(IndexVersion.current().toString(), version.toString())));
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)AbstractSnapshotIntegTestCase.getRepositoryOnMaster(repoName);
        PlainActionFuture.get(f -> blobStoreRepository.threadPool().generic().execute((Runnable)ActionRunnable.run((ActionListener)f, () -> BlobStoreRepository.SNAPSHOT_FORMAT.write((Object)downgradedSnapshotInfo, blobStoreRepository.blobStore().blobContainer(blobStoreRepository.basePath()), snapshotInfo.snapshotId().getUUID(), AbstractSnapshotIntegTestCase.randomBoolean()))));
        RepositoryMetadata repoMetadata = blobStoreRepository.getMetadata();
        if (((Boolean)BlobStoreRepository.CACHE_REPOSITORY_DATA.get(repoMetadata.settings())).booleanValue()) {
            this.logger.info("--> recreating repository to clear caches");
            ElasticsearchAssertions.assertAcked(AbstractSnapshotIntegTestCase.clusterAdmin().prepareDeleteRepository(repoName));
            this.createRepository(repoName, repoMetadata.type(), Settings.builder().put(repoMetadata.settings()));
        }
        return oldVersionSnapshot;
    }

    protected SnapshotInfo createFullSnapshot(String repoName, String snapshotName) {
        return AbstractSnapshotIntegTestCase.createFullSnapshot(this.logger, repoName, snapshotName);
    }

    public static SnapshotInfo createFullSnapshot(Logger logger, String repoName, String snapshotName) {
        logger.info("--> creating full snapshot [{}] in [{}]", (Object)snapshotName, (Object)repoName);
        CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)AbstractSnapshotIntegTestCase.clusterAdmin().prepareCreateSnapshot(repoName, snapshotName).setIncludeGlobalState(true).setWaitForCompletion(true).get();
        SnapshotInfo snapshotInfo = createSnapshotResponse.getSnapshotInfo();
        AbstractSnapshotIntegTestCase.assertThat((Object)snapshotInfo.successfulShards(), (Matcher)Matchers.is((Object)snapshotInfo.totalShards()));
        AbstractSnapshotIntegTestCase.assertThat((Object)snapshotInfo.state(), (Matcher)Matchers.is((Object)SnapshotState.SUCCESS));
        return snapshotInfo;
    }

    protected SnapshotInfo createSnapshot(String repositoryName, String snapshot, List<String> indices, List<String> featureStates) {
        this.logger.info("--> creating snapshot [{}] of {} in [{}]", (Object)snapshot, indices, (Object)repositoryName);
        CreateSnapshotResponse response = (CreateSnapshotResponse)AbstractSnapshotIntegTestCase.clusterAdmin().prepareCreateSnapshot(repositoryName, snapshot).setIndices(indices.toArray(Strings.EMPTY_ARRAY)).setWaitForCompletion(true).setFeatureStates(featureStates.toArray(Strings.EMPTY_ARRAY)).get();
        SnapshotInfo snapshotInfo = response.getSnapshotInfo();
        AbstractSnapshotIntegTestCase.assertThat((Object)snapshotInfo.state(), (Matcher)Matchers.is((Object)SnapshotState.SUCCESS));
        AbstractSnapshotIntegTestCase.assertThat((Object)snapshotInfo.successfulShards(), (Matcher)Matchers.equalTo((Object)snapshotInfo.totalShards()));
        AbstractSnapshotIntegTestCase.assertThat((Object)snapshotInfo.failedShards(), (Matcher)Matchers.equalTo((Object)0));
        return snapshotInfo;
    }

    protected SnapshotInfo createSnapshot(String repositoryName, String snapshot, List<String> indices) {
        return this.createSnapshot(repositoryName, snapshot, indices, Collections.singletonList("none"));
    }

    protected void createIndexWithRandomDocs(String indexName, int docCount) throws InterruptedException {
        this.createIndex(indexName);
        this.ensureGreen(new String[0]);
        this.indexRandomDocs(indexName, docCount);
    }

    protected void indexRandomDocs(String index, int numdocs) throws InterruptedException {
        this.logger.info("--> indexing [{}] documents into [{}]", (Object)numdocs, (Object)index);
        IndexRequestBuilder[] builders = new IndexRequestBuilder[numdocs];
        for (int i = 0; i < builders.length; ++i) {
            builders[i] = AbstractSnapshotIntegTestCase.client().prepareIndex(index).setId(Integer.toString(i)).setSource(new Object[]{"field1", "bar " + i});
        }
        this.indexRandom(true, builders);
        this.flushAndRefresh(index);
        this.assertDocCount(index, numdocs);
    }

    protected long getCountForIndex(String indexName) {
        return ((SearchResponse)AbstractSnapshotIntegTestCase.client().search((SearchRequest)new SearchRequest((SearchRequest)new SearchRequest((String[])new String[]{indexName}).source((SearchSourceBuilder)new SearchSourceBuilder().size((int)0).trackTotalHits((boolean)true)))).actionGet()).getHits().getTotalHits().value;
    }

    protected void assertDocCount(String index, long count) {
        AbstractSnapshotIntegTestCase.assertEquals((long)this.getCountForIndex(index), (long)count);
    }

    protected void addBwCFailedSnapshot(String repoName, String snapshotName, Map<String, Object> metadata) throws Exception {
        ClusterState state = ((ClusterStateResponse)AbstractSnapshotIntegTestCase.clusterAdmin().prepareState().get()).getState();
        RepositoriesMetadata repositoriesMetadata = (RepositoriesMetadata)state.metadata().custom("repositories");
        AbstractSnapshotIntegTestCase.assertNotNull((Object)repositoriesMetadata);
        RepositoryMetadata initialRepoMetadata = repositoriesMetadata.repository(repoName);
        AbstractSnapshotIntegTestCase.assertNotNull((Object)initialRepoMetadata);
        AbstractSnapshotIntegTestCase.assertThat((String)"We can only manually insert a snapshot into a repository that does not have a generation tracked in the CS", (Object)initialRepoMetadata.generation(), (Matcher)Matchers.is((Object)-2L));
        Object repo = AbstractSnapshotIntegTestCase.getRepositoryOnMaster(repoName);
        SnapshotId snapshotId = new SnapshotId(snapshotName, UUIDs.randomBase64UUID((Random)AbstractSnapshotIntegTestCase.random()));
        this.logger.info("--> adding old version FAILED snapshot [{}] to repository [{}]", (Object)snapshotId, (Object)repoName);
        SnapshotInfo snapshotInfo = new SnapshotInfo(new Snapshot(repoName, snapshotId), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "failed on purpose", SnapshotsService.OLD_SNAPSHOT_FORMAT, 0L, 0L, 0, 0, Collections.emptyList(), Boolean.valueOf(AbstractSnapshotIntegTestCase.randomBoolean()), metadata, SnapshotState.FAILED, Collections.emptyMap());
        PlainActionFuture.get(f -> repo.finalizeSnapshot(new FinalizeSnapshotContext(ShardGenerations.EMPTY, this.getRepositoryData(repoName).getGenId(), state.metadata(), snapshotInfo, SnapshotsService.OLD_SNAPSHOT_FORMAT, (ActionListener)f, info -> {})));
    }

    protected void awaitNDeletionsInProgress(int count) throws Exception {
        this.logger.info("--> wait for [{}] deletions to show up in the cluster state", (Object)count);
        this.awaitClusterState(state -> SnapshotDeletionsInProgress.get((ClusterState)state).getEntries().size() == count);
    }

    protected void awaitNoMoreRunningOperations() throws Exception {
        this.awaitNoMoreRunningOperations(AbstractSnapshotIntegTestCase.internalCluster().getMasterName());
    }

    protected void awaitNoMoreRunningOperations(String viaNode) throws Exception {
        this.logger.info("--> verify no more operations in the cluster state");
        AbstractSnapshotIntegTestCase.awaitClusterState(this.logger, viaNode, state -> SnapshotsInProgress.get((ClusterState)state).isEmpty() && !SnapshotDeletionsInProgress.get((ClusterState)state).hasDeletionsInProgress());
    }

    protected void awaitClusterState(Predicate<ClusterState> statePredicate) throws Exception {
        AbstractSnapshotIntegTestCase.awaitClusterState(this.logger, AbstractSnapshotIntegTestCase.internalCluster().getMasterName(), statePredicate);
    }

    public static void awaitClusterState(Logger logger, Predicate<ClusterState> statePredicate) throws Exception {
        AbstractSnapshotIntegTestCase.awaitClusterState(logger, AbstractSnapshotIntegTestCase.internalCluster().getMasterName(), statePredicate);
    }

    public static void awaitClusterState(Logger logger, String viaNode, Predicate<ClusterState> statePredicate) throws Exception {
        ClusterServiceUtils.awaitClusterState(logger, statePredicate, AbstractSnapshotIntegTestCase.internalCluster().getInstance(ClusterService.class, viaNode));
    }

    protected ActionFuture<CreateSnapshotResponse> startFullSnapshotBlockedOnDataNode(String snapshotName, String repoName, String dataNode) throws Exception {
        AbstractSnapshotIntegTestCase.blockDataNode(repoName, dataNode);
        ActionFuture<CreateSnapshotResponse> fut = this.startFullSnapshot(repoName, snapshotName);
        this.waitForBlock(dataNode, repoName);
        return fut;
    }

    protected ActionFuture<CreateSnapshotResponse> startFullSnapshot(String repoName, String snapshotName) {
        return this.startFullSnapshot(repoName, snapshotName, false);
    }

    protected ActionFuture<CreateSnapshotResponse> startFullSnapshot(String repoName, String snapshotName, boolean partial) {
        return AbstractSnapshotIntegTestCase.startFullSnapshot(this.logger, repoName, snapshotName, partial);
    }

    public static ActionFuture<CreateSnapshotResponse> startFullSnapshot(Logger logger, String repoName, String snapshotName, boolean partial) {
        logger.info("--> creating full snapshot [{}] to repo [{}]", (Object)snapshotName, (Object)repoName);
        return AbstractSnapshotIntegTestCase.clusterAdmin().prepareCreateSnapshot(repoName, snapshotName).setWaitForCompletion(true).setPartial(partial).execute();
    }

    protected void awaitNumberOfSnapshotsInProgress(int count) throws Exception {
        AbstractSnapshotIntegTestCase.awaitNumberOfSnapshotsInProgress(this.logger, count);
    }

    public static void awaitNumberOfSnapshotsInProgress(Logger logger, int count) throws Exception {
        logger.info("--> wait for [{}] snapshots to show up in the cluster state", (Object)count);
        AbstractSnapshotIntegTestCase.awaitClusterState(logger, state -> SnapshotsInProgress.get((ClusterState)state).count() == count);
    }

    protected SnapshotInfo assertSuccessful(ActionFuture<CreateSnapshotResponse> future) throws Exception {
        return AbstractSnapshotIntegTestCase.assertSuccessful(this.logger, future);
    }

    public static SnapshotInfo assertSuccessful(Logger logger, ActionFuture<CreateSnapshotResponse> future) throws Exception {
        logger.info("--> wait for snapshot to finish");
        SnapshotInfo snapshotInfo = ((CreateSnapshotResponse)future.get()).getSnapshotInfo();
        AbstractSnapshotIntegTestCase.assertThat((Object)snapshotInfo.state(), (Matcher)Matchers.is((Object)SnapshotState.SUCCESS));
        return snapshotInfo;
    }

    protected void createIndexWithContent(String indexName) {
        this.createIndexWithContent(indexName, SINGLE_SHARD_NO_REPLICA);
    }

    protected void createIndexWithContent(String indexName, Settings indexSettings) {
        this.logger.info("--> creating index [{}]", (Object)indexName);
        this.createIndex(indexName, indexSettings);
        this.ensureGreen(indexName);
        this.indexDoc(indexName, "some_id", "foo", "bar");
    }

    protected ActionFuture<AcknowledgedResponse> startDeleteSnapshot(String repoName, String snapshotName) {
        this.logger.info("--> deleting snapshot [{}] from repo [{}]", (Object)snapshotName, (Object)repoName);
        return AbstractSnapshotIntegTestCase.clusterAdmin().prepareDeleteSnapshot(repoName, new String[]{snapshotName}).execute();
    }

    protected ActionFuture<AcknowledgedResponse> startDeleteSnapshots(String repoName, List<String> snapshotNames, String viaNode) {
        this.logger.info("--> deleting snapshots {} from repo [{}]", snapshotNames, (Object)repoName);
        return AbstractSnapshotIntegTestCase.client(viaNode).admin().cluster().prepareDeleteSnapshot(repoName, snapshotNames.toArray(Strings.EMPTY_ARRAY)).execute();
    }

    protected static void updateClusterState(final Function<ClusterState, ClusterState> updater) throws Exception {
        final PlainActionFuture future = PlainActionFuture.newFuture();
        ClusterService clusterService = AbstractSnapshotIntegTestCase.internalCluster().getCurrentMasterNodeInstance(ClusterService.class);
        clusterService.submitUnbatchedStateUpdateTask("test", new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) {
                return (ClusterState)updater.apply(currentState);
            }

            public void onFailure(Exception e) {
                future.onFailure(e);
            }

            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                future.onResponse(null);
            }
        });
        future.get();
    }

    protected SnapshotInfo getSnapshot(String repository, String snapshot) {
        List snapshotInfos = ((GetSnapshotsResponse)AbstractSnapshotIntegTestCase.clusterAdmin().prepareGetSnapshots(new String[]{repository}).setSnapshots(new String[]{snapshot}).get()).getSnapshots();
        AbstractSnapshotIntegTestCase.assertThat((Object)snapshotInfos, (Matcher)Matchers.hasSize((int)1));
        return (SnapshotInfo)snapshotInfos.get(0);
    }

    protected static ThreadPoolStats.Stats snapshotThreadPoolStats(String node) {
        return StreamSupport.stream(AbstractSnapshotIntegTestCase.internalCluster().getInstance(ThreadPool.class, node).stats().spliterator(), false).filter(threadPool -> threadPool.name().equals("snapshot")).findFirst().orElseThrow(() -> new AssertionError((Object)("Failed to find snapshot pool on node [" + node + "]")));
    }

    protected void awaitMasterFinishRepoOperations() throws Exception {
        this.logger.info("--> waiting for master to finish all repo operations on its SNAPSHOT pool");
        String masterName = AbstractSnapshotIntegTestCase.internalCluster().getMasterName();
        AbstractSnapshotIntegTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> AbstractSnapshotIntegTestCase.assertEquals((long)AbstractSnapshotIntegTestCase.snapshotThreadPoolStats(masterName).active(), (long)0L)));
    }

    protected List<String> createNSnapshots(String repoName, int count) throws Exception {
        return AbstractSnapshotIntegTestCase.createNSnapshots(this.logger, repoName, count);
    }

    public static List<String> createNSnapshots(Logger logger, String repoName, int count) throws Exception {
        PlainActionFuture allSnapshotsDone = PlainActionFuture.newFuture();
        GroupedActionListener snapshotsListener = new GroupedActionListener(count, (ActionListener)allSnapshotsDone);
        ArrayList<String> snapshotNames = new ArrayList<String>(count);
        String prefix = RANDOM_SNAPSHOT_NAME_PREFIX + UUIDs.randomBase64UUID((Random)AbstractSnapshotIntegTestCase.random()).toLowerCase(Locale.ROOT) + "-";
        for (int i = 0; i < count; ++i) {
            String snapshot = prefix + i;
            snapshotNames.add(snapshot);
            Map<String, Object> userMetadata = AbstractSnapshotIntegTestCase.randomUserMetadata();
            AbstractSnapshotIntegTestCase.clusterAdmin().prepareCreateSnapshot(repoName, snapshot).setWaitForCompletion(true).setUserMetadata(userMetadata).execute(snapshotsListener.delegateFailure((l, response) -> {
                SnapshotInfo snapshotInfoInResponse = response.getSnapshotInfo();
                AbstractSnapshotIntegTestCase.assertEquals((Object)userMetadata, (Object)snapshotInfoInResponse.userMetadata());
                AbstractSnapshotIntegTestCase.clusterAdmin().prepareGetSnapshots(new String[]{repoName}).setSnapshots(new String[]{snapshot}).execute(l.safeMap(getResponse -> {
                    AbstractSnapshotIntegTestCase.assertEquals((Object)snapshotInfoInResponse, getResponse.getSnapshots().get(0));
                    return response;
                }));
            }));
        }
        for (CreateSnapshotResponse snapshotResponse : (Collection)allSnapshotsDone.get()) {
            AbstractSnapshotIntegTestCase.assertThat((Object)snapshotResponse.getSnapshotInfo().state(), (Matcher)Matchers.is((Object)SnapshotState.SUCCESS));
        }
        logger.info("--> created {} in [{}]", snapshotNames, (Object)repoName);
        return snapshotNames;
    }

    public static void forEachFileRecursively(Path path, final CheckedBiConsumer<Path, BasicFileAttributes, IOException> forEach) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                forEach.accept((Object)file, (Object)attrs);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void assertSnapshotListSorted(List<SnapshotInfo> snapshotInfos, @Nullable GetSnapshotsRequest.SortBy sort, SortOrder sortOrder) {
        BiConsumer<SnapshotInfo, SnapshotInfo> assertion;
        if (sort == null) {
            assertion = (s1, s2) -> AbstractSnapshotIntegTestCase.assertThat((Object)s2, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)s1));
        } else {
            assertion = switch (sort) {
                default -> throw new IncompatibleClassChangeError();
                case GetSnapshotsRequest.SortBy.START_TIME -> (s1, s2) -> AbstractSnapshotIntegTestCase.assertThat((Object)s2.startTime(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(s1.startTime())));
                case GetSnapshotsRequest.SortBy.NAME -> (s1, s2) -> AbstractSnapshotIntegTestCase.assertThat((Object)s2.snapshotId().getName(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)((Object)s1.snapshotId().getName())));
                case GetSnapshotsRequest.SortBy.DURATION -> (s1, s2) -> AbstractSnapshotIntegTestCase.assertThat((Object)(s2.endTime() - s2.startTime()), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(s1.endTime() - s1.startTime())));
                case GetSnapshotsRequest.SortBy.INDICES -> (s1, s2) -> AbstractSnapshotIntegTestCase.assertThat((Object)s2.indices().size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(s1.indices().size())));
                case GetSnapshotsRequest.SortBy.SHARDS -> (s1, s2) -> AbstractSnapshotIntegTestCase.assertThat((Object)s2.totalShards(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(s1.totalShards())));
                case GetSnapshotsRequest.SortBy.FAILED_SHARDS -> (s1, s2) -> AbstractSnapshotIntegTestCase.assertThat((Object)s2.failedShards(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(s1.failedShards())));
                case GetSnapshotsRequest.SortBy.REPOSITORY -> (s1, s2) -> AbstractSnapshotIntegTestCase.assertThat((Object)s2.repository(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)((Object)s1.repository())));
            };
        }
        BiConsumer<SnapshotInfo, SnapshotInfo> orderAssertion = sortOrder == SortOrder.ASC ? assertion : (s1, s2) -> assertion.accept((SnapshotInfo)s2, (SnapshotInfo)s1);
        for (int i = 0; i < snapshotInfos.size() - 1; ++i) {
            orderAssertion.accept(snapshotInfos.get(i), snapshotInfos.get(i + 1));
        }
    }

    @Nullable
    public static Map<String, Object> randomUserMetadata() {
        if (AbstractSnapshotIntegTestCase.randomBoolean()) {
            return null;
        }
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        long fields = AbstractSnapshotIntegTestCase.randomLongBetween(0L, 4L);
        int i = 0;
        while ((long)i < fields) {
            if (AbstractSnapshotIntegTestCase.randomBoolean()) {
                metadata.put(AbstractSnapshotIntegTestCase.randomValueOtherThanMany(metadata::containsKey, () -> AbstractSnapshotIntegTestCase.randomAlphaOfLengthBetween(2, 10)), AbstractSnapshotIntegTestCase.randomAlphaOfLengthBetween(5, 5));
            } else {
                HashMap<String, String> nested = new HashMap<String, String>();
                long nestedFields = AbstractSnapshotIntegTestCase.randomLongBetween(0L, 4L);
                int j = 0;
                while ((long)j < nestedFields) {
                    nested.put(AbstractSnapshotIntegTestCase.randomValueOtherThanMany(nested::containsKey, () -> AbstractSnapshotIntegTestCase.randomAlphaOfLengthBetween(2, 10)), AbstractSnapshotIntegTestCase.randomAlphaOfLengthBetween(5, 5));
                    ++j;
                }
                metadata.put(AbstractSnapshotIntegTestCase.randomValueOtherThanMany(metadata::containsKey, () -> AbstractSnapshotIntegTestCase.randomAlphaOfLengthBetween(2, 10)), nested);
            }
            ++i;
        }
        return metadata;
    }

    public static String[] matchAllPattern() {
        String[] stringArray;
        if (AbstractSnapshotIntegTestCase.randomBoolean()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "*";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "_all";
        }
        return stringArray;
    }

    public RepositoryMetadata getRepositoryMetadata(String repo) {
        Optional<RepositoryMetadata> repositoryMetadata = RepositoriesMetadata.get((ClusterState)this.clusterService().state()).repositories().stream().filter(x -> x.name().equals(repo)).findFirst();
        AbstractSnapshotIntegTestCase.assertTrue((boolean)repositoryMetadata.isPresent());
        return repositoryMetadata.get();
    }
}

