/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.test.AbstractXContentTestCase;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public abstract class AbstractBroadcastResponseTestCase<T extends BroadcastResponse>
extends AbstractXContentTestCase<T> {
    @Override
    protected T createTestInstance() {
        int totalShards = AbstractBroadcastResponseTestCase.randomIntBetween(1, 10);
        ArrayList<DefaultShardOperationFailedException> failures = null;
        int successfulShards = AbstractBroadcastResponseTestCase.randomInt(totalShards);
        int failedShards = totalShards - successfulShards;
        if (failedShards > 0) {
            failures = new ArrayList<DefaultShardOperationFailedException>();
            for (int i = 0; i < failedShards; ++i) {
                ElasticsearchException exception = new ElasticsearchException("exception message " + i, new Object[0]);
                String index = AbstractBroadcastResponseTestCase.randomAlphaOfLengthBetween(3, 10);
                exception.setIndex(new Index(index, "_na_"));
                exception.setShard(new ShardId(index, "_na_", i));
                if (AbstractBroadcastResponseTestCase.randomBoolean()) {
                    failures.add(new DefaultShardOperationFailedException(exception));
                    continue;
                }
                failures.add(new DefaultShardOperationFailedException(index, i, (Throwable)new Exception("exception message " + i)));
            }
        }
        return this.createTestInstance(totalShards, successfulShards, failedShards, failures);
    }

    protected abstract T createTestInstance(int var1, int var2, int var3, List<DefaultShardOperationFailedException> var4);

    @Override
    protected void assertEqualInstances(T response, T parsedResponse) {
        AbstractBroadcastResponseTestCase.assertThat((Object)response.getTotalShards(), (Matcher)CoreMatchers.equalTo((Object)parsedResponse.getTotalShards()));
        AbstractBroadcastResponseTestCase.assertThat((Object)response.getSuccessfulShards(), (Matcher)CoreMatchers.equalTo((Object)parsedResponse.getSuccessfulShards()));
        AbstractBroadcastResponseTestCase.assertThat((Object)response.getFailedShards(), (Matcher)CoreMatchers.equalTo((Object)parsedResponse.getFailedShards()));
        DefaultShardOperationFailedException[] originalFailures = response.getShardFailures();
        DefaultShardOperationFailedException[] parsedFailures = parsedResponse.getShardFailures();
        AbstractBroadcastResponseTestCase.assertThat((Object)originalFailures.length, (Matcher)CoreMatchers.equalTo((Object)parsedFailures.length));
        for (int i = 0; i < originalFailures.length; ++i) {
            AbstractBroadcastResponseTestCase.assertThat((Object)originalFailures[i].index(), (Matcher)CoreMatchers.equalTo((Object)parsedFailures[i].index()));
            AbstractBroadcastResponseTestCase.assertThat((Object)originalFailures[i].shardId(), (Matcher)CoreMatchers.equalTo((Object)parsedFailures[i].shardId()));
            AbstractBroadcastResponseTestCase.assertThat((Object)originalFailures[i].status(), (Matcher)CoreMatchers.equalTo((Object)parsedFailures[i].status()));
            AbstractBroadcastResponseTestCase.assertThat((Object)parsedFailures[i].getCause().getMessage(), (Matcher)CoreMatchers.containsString((String)originalFailures[i].getCause().getMessage()));
        }
    }

    @Override
    protected boolean supportsUnknownFields() {
        return true;
    }

    @Override
    protected boolean assertToXContentEquivalence() {
        return false;
    }

    public void testFailuresDeduplication() throws IOException {
        BroadcastResponse parsedResponse;
        ArrayList<DefaultShardOperationFailedException> failures = new ArrayList<DefaultShardOperationFailedException>();
        Index index = new Index("test", "_na_");
        ElasticsearchException exception1 = new ElasticsearchException("foo", (Throwable)new IllegalArgumentException("bar"), new Object[0]);
        exception1.setIndex(index);
        exception1.setShard(new ShardId(index, 0));
        ElasticsearchException exception2 = new ElasticsearchException("foo", (Throwable)new IllegalArgumentException("bar"), new Object[0]);
        exception2.setIndex(index);
        exception2.setShard(new ShardId(index, 1));
        ElasticsearchException exception3 = new ElasticsearchException("fizz", (Throwable)new IllegalStateException("buzz"), new Object[0]);
        exception3.setIndex(index);
        exception3.setShard(new ShardId(index, 2));
        failures.add(new DefaultShardOperationFailedException(exception1));
        failures.add(new DefaultShardOperationFailedException(exception2));
        failures.add(new DefaultShardOperationFailedException(exception3));
        T response = this.createTestInstance(10, 7, 3, failures);
        boolean humanReadable = AbstractBroadcastResponseTestCase.randomBoolean();
        XContentType xContentType = AbstractBroadcastResponseTestCase.randomFrom(XContentType.values());
        BytesReference bytesReference = this.toShuffledXContent((ToXContent)response, xContentType, ToXContent.EMPTY_PARAMS, humanReadable, new String[0]);
        try (XContentParser parser = this.createParser(xContentType.xContent(), bytesReference);){
            parsedResponse = (BroadcastResponse)this.doParseInstance(parser);
            AbstractBroadcastResponseTestCase.assertNull((Object)parser.nextToken());
        }
        AbstractBroadcastResponseTestCase.assertThat((Object)parsedResponse.getShardFailures().length, (Matcher)CoreMatchers.equalTo((Object)2));
        DefaultShardOperationFailedException[] parsedFailures = parsedResponse.getShardFailures();
        AbstractBroadcastResponseTestCase.assertThat((Object)parsedFailures[0].index(), (Matcher)CoreMatchers.equalTo((Object)"test"));
        AbstractBroadcastResponseTestCase.assertThat((Object)parsedFailures[0].shardId(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)0), CoreMatchers.equalTo((Object)1)}));
        AbstractBroadcastResponseTestCase.assertThat((Object)parsedFailures[0].status(), (Matcher)CoreMatchers.equalTo((Object)RestStatus.INTERNAL_SERVER_ERROR));
        AbstractBroadcastResponseTestCase.assertThat((Object)parsedFailures[0].getCause().getMessage(), (Matcher)CoreMatchers.containsString((String)"foo"));
        AbstractBroadcastResponseTestCase.assertThat((Object)parsedFailures[1].index(), (Matcher)CoreMatchers.equalTo((Object)"test"));
        AbstractBroadcastResponseTestCase.assertThat((Object)parsedFailures[1].shardId(), (Matcher)CoreMatchers.equalTo((Object)2));
        AbstractBroadcastResponseTestCase.assertThat((Object)parsedFailures[1].status(), (Matcher)CoreMatchers.equalTo((Object)RestStatus.INTERNAL_SERVER_ERROR));
        AbstractBroadcastResponseTestCase.assertThat((Object)parsedFailures[1].getCause().getMessage(), (Matcher)CoreMatchers.containsString((String)"fizz"));
    }

    public void testToXContent() throws IOException {
        T response = this.createTestInstance(10, 10, 0, null);
        String output = Strings.toString(response);
        AbstractBroadcastResponseTestCase.assertEquals((Object)"{\"_shards\":{\"total\":10,\"successful\":10,\"failed\":0}}", (Object)output);
    }
}

