/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.SeedUtils;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.termvectors.MultiTermVectorsRequest;
import org.elasticsearch.action.termvectors.MultiTermVectorsResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.TestEnvironment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.MapperRegistry;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.CoordinatorRewriteContext;
import org.elasticsearch.index.query.DataRewriteContext;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.IndexLongFieldRange;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardLongFieldRange;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.elasticsearch.node.InternalSettingsPreparer;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.MockPluginsService;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.plugins.internal.DocumentParsingObserver;
import org.elasticsearch.plugins.scanners.StablePluginsRegistry;
import org.elasticsearch.script.MockScriptEngine;
import org.elasticsearch.script.MockScriptService;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.ScriptModule;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.test.AbstractQueryTestCase;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.IndexSettingsModule;
import org.elasticsearch.test.index.IndexVersionUtils;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.TestThreadPool;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class AbstractBuilderTestCase
extends ESTestCase {
    public static final String TEXT_FIELD_NAME = "mapped_string";
    public static final String TEXT_ALIAS_FIELD_NAME = "mapped_string_alias";
    protected static final String KEYWORD_FIELD_NAME = "mapped_string_2";
    protected static final String INT_FIELD_NAME = "mapped_int";
    protected static final String INT_ALIAS_FIELD_NAME = "mapped_int_field_alias";
    protected static final String INT_RANGE_FIELD_NAME = "mapped_int_range";
    protected static final String DOUBLE_FIELD_NAME = "mapped_double";
    protected static final String BOOLEAN_FIELD_NAME = "mapped_boolean";
    protected static final String DATE_NANOS_FIELD_NAME = "mapped_date_nanos";
    protected static final String DATE_FIELD_NAME = "mapped_date";
    protected static final String DATE_ALIAS_FIELD_NAME = "mapped_date_alias";
    protected static final String DATE_RANGE_FIELD_NAME = "mapped_date_range";
    protected static final String OBJECT_FIELD_NAME = "mapped_object";
    protected static final String GEO_POINT_FIELD_NAME = "mapped_geo_point";
    protected static final String GEO_POINT_ALIAS_FIELD_NAME = "mapped_geo_point_alias";
    protected static final String BINARY_FIELD_NAME = "mapped_binary";
    protected static final String[] MAPPED_FIELD_NAMES = new String[]{"mapped_string", "mapped_string_alias", "mapped_int", "mapped_int_range", "mapped_double", "mapped_boolean", "mapped_date_nanos", "mapped_date", "mapped_date_range", "mapped_object", "mapped_geo_point", "mapped_geo_point_alias"};
    protected static final String[] MAPPED_LEAF_FIELD_NAMES = new String[]{"mapped_string", "mapped_string_alias", "mapped_int", "mapped_int_range", "mapped_double", "mapped_boolean", "mapped_date_nanos", "mapped_date", "mapped_date_range", "mapped_geo_point", "mapped_geo_point_alias"};
    private static final Map<String, String> ALIAS_TO_CONCRETE_FIELD_NAME = new HashMap<String, String>();
    private static ServiceHolder serviceHolder;
    private static ServiceHolder serviceHolderWithNoType;
    private static int queryNameId;
    private static Settings nodeSettings;
    private static Index index;
    private static long nowInMillis;
    private TestThreadPool testThreadPool;

    protected static Index getIndex() {
        return index;
    }

    protected Collection<Class<? extends Plugin>> getPlugins() {
        return Collections.emptyList();
    }

    protected Collection<Class<? extends Plugin>> getExtraPlugins() {
        return Collections.emptyList();
    }

    protected void initializeAdditionalMappings(MapperService mapperService) throws IOException {
    }

    @BeforeClass
    public static void beforeClass() {
        nodeSettings = Settings.builder().put("node.name", AbstractQueryTestCase.class.toString()).put(Environment.PATH_HOME_SETTING.getKey(), AbstractBuilderTestCase.createTempDir()).build();
        index = new Index(AbstractBuilderTestCase.randomAlphaOfLengthBetween(1, 10), AbstractBuilderTestCase.randomAlphaOfLength(10));
        nowInMillis = AbstractBuilderTestCase.randomNonNegativeLong();
    }

    @Override
    protected NamedXContentRegistry xContentRegistry() {
        return AbstractBuilderTestCase.serviceHolder.parserConfiguration.registry();
    }

    protected NamedWriteableRegistry namedWriteableRegistry() {
        return AbstractBuilderTestCase.serviceHolder.namedWriteableRegistry;
    }

    protected static String createUniqueRandomName() {
        String queryName = AbstractBuilderTestCase.randomAlphaOfLengthBetween(1, 10) + queryNameId;
        ++queryNameId;
        return queryName;
    }

    protected Settings createTestIndexSettings() {
        IndexVersion indexVersionCreated = AbstractBuilderTestCase.randomBoolean() ? IndexVersion.current() : IndexVersionUtils.randomCompatibleVersion(AbstractBuilderTestCase.random());
        return Settings.builder().put("index.version.created", (VersionId)indexVersionCreated).build();
    }

    protected static IndexSettings indexSettings() {
        return AbstractBuilderTestCase.serviceHolder.idxSettings;
    }

    protected static String expectedFieldName(String builderFieldName) {
        return ALIAS_TO_CONCRETE_FIELD_NAME.getOrDefault(builderFieldName, builderFieldName);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        IOUtils.close((Closeable)serviceHolder);
        IOUtils.close((Closeable)serviceHolderWithNoType);
        serviceHolder = null;
        serviceHolderWithNoType = null;
    }

    @Before
    public void beforeTest() throws Exception {
        if (serviceHolder == null) {
            assert (serviceHolderWithNoType == null);
            long masterSeed = SeedUtils.parseSeed((String)RandomizedTest.getContext().getRunnerSeedAsString());
            RandomizedTest.getContext().runWithPrivateRandomness(masterSeed, () -> {
                ArrayList<Class<? extends Plugin>> plugins = new ArrayList<Class<? extends Plugin>>(this.getPlugins());
                plugins.addAll(this.getExtraPlugins());
                serviceHolder = new ServiceHolder(nodeSettings, this.createTestIndexSettings(), plugins, nowInMillis, this, true);
                serviceHolderWithNoType = new ServiceHolder(nodeSettings, this.createTestIndexSettings(), plugins, nowInMillis, this, false);
                return null;
            });
        }
        AbstractBuilderTestCase.serviceHolder.clientInvocationHandler.delegate = this;
        AbstractBuilderTestCase.serviceHolderWithNoType.clientInvocationHandler.delegate = this;
        AbstractBuilderTestCase.serviceHolder.clientInvocationHandler.testThreadPool = this.testThreadPool = new TestThreadPool(this.getTestName(), new ExecutorBuilder[0]);
        AbstractBuilderTestCase.serviceHolderWithNoType.clientInvocationHandler.testThreadPool = this.testThreadPool;
    }

    @After
    public void afterTest() {
        AbstractBuilderTestCase.serviceHolder.clientInvocationHandler.delegate = null;
        AbstractBuilderTestCase.serviceHolderWithNoType.clientInvocationHandler.delegate = null;
        this.testThreadPool.shutdown();
    }

    protected GetResponse executeGet(GetRequest getRequest) {
        throw new UnsupportedOperationException("this test can't handle GET requests");
    }

    protected MultiTermVectorsResponse executeMultiTermVectors(MultiTermVectorsRequest mtvRequest) {
        throw new UnsupportedOperationException("this test can't handle MultiTermVector requests");
    }

    protected boolean canSimulateMethod(Method method, Object[] args) throws NoSuchMethodException {
        return false;
    }

    protected Object simulateMethod(Method method, Object[] args) {
        throw new UnsupportedOperationException("this test can't simulate method [" + method.getName() + "]");
    }

    protected static SearchExecutionContext createSearchExecutionContext(IndexSearcher searcher) {
        return serviceHolder.createShardContext(searcher);
    }

    protected static CoordinatorRewriteContext createCoordinatorRewriteContext(DateFieldMapper.DateFieldType dateFieldType, long min, long max) {
        return serviceHolder.createCoordinatorContext(dateFieldType, min, max);
    }

    protected static DataRewriteContext dataRewriteContext() {
        return serviceHolder.createDataContext();
    }

    protected static SearchExecutionContext createShardContextWithNoType() {
        return serviceHolderWithNoType.createShardContext(null);
    }

    protected static SearchExecutionContext createSearchExecutionContext() {
        return AbstractBuilderTestCase.createSearchExecutionContext(null);
    }

    protected static QueryRewriteContext createQueryRewriteContext() {
        return serviceHolder.createQueryRewriteContext();
    }

    static {
        ALIAS_TO_CONCRETE_FIELD_NAME.put(TEXT_ALIAS_FIELD_NAME, TEXT_FIELD_NAME);
        ALIAS_TO_CONCRETE_FIELD_NAME.put(INT_ALIAS_FIELD_NAME, INT_FIELD_NAME);
        ALIAS_TO_CONCRETE_FIELD_NAME.put(DATE_ALIAS_FIELD_NAME, DATE_FIELD_NAME);
        ALIAS_TO_CONCRETE_FIELD_NAME.put(GEO_POINT_ALIAS_FIELD_NAME, GEO_POINT_FIELD_NAME);
        queryNameId = 0;
    }

    private static class ServiceHolder
    implements Closeable {
        private final IndexFieldDataService indexFieldDataService;
        private final SearchModule searchModule;
        private final NamedWriteableRegistry namedWriteableRegistry;
        private final XContentParserConfiguration parserConfiguration;
        private final ClientInvocationHandler clientInvocationHandler = new ClientInvocationHandler();
        private final IndexSettings idxSettings;
        private final SimilarityService similarityService;
        private final MapperService mapperService;
        private final BitsetFilterCache bitsetFilterCache;
        private final ScriptService scriptService;
        private final Client client;
        private final long nowInMillis;

        ServiceHolder(Settings nodeSettings, Settings indexSettings, Collection<Class<? extends Plugin>> plugins, long nowInMillis, AbstractBuilderTestCase testCase, boolean registerType) throws IOException {
            this.nowInMillis = nowInMillis;
            Environment env = InternalSettingsPreparer.prepareEnvironment((Settings)nodeSettings, Collections.emptyMap(), null, () -> {
                throw new AssertionError((Object)"node.name must be set");
            });
            MockPluginsService pluginsService = new MockPluginsService(nodeSettings, env, plugins);
            ClusterService clusterService = new ClusterService(Settings.EMPTY, new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS), null, (TaskManager)null);
            this.client = (Client)Proxy.newProxyInstance(Client.class.getClassLoader(), new Class[]{Client.class}, (InvocationHandler)this.clientInvocationHandler);
            ScriptModule scriptModule = this.createScriptModule(pluginsService.filterPlugins(ScriptPlugin.class));
            SettingsModule settingsModule = new SettingsModule(nodeSettings, pluginsService.flatMap(Plugin::getSettings).toList(), pluginsService.flatMap(Plugin::getSettingsFilter).toList());
            this.searchModule = new SearchModule(nodeSettings, pluginsService.filterPlugins(SearchPlugin.class));
            IndicesModule indicesModule = new IndicesModule(pluginsService.filterPlugins(MapperPlugin.class));
            ArrayList entries = new ArrayList();
            entries.addAll(IndicesModule.getNamedWriteables());
            entries.addAll(this.searchModule.getNamedWriteables());
            this.namedWriteableRegistry = new NamedWriteableRegistry(entries);
            this.parserConfiguration = XContentParserConfiguration.EMPTY.withRegistry(new NamedXContentRegistry(Stream.of(this.searchModule.getNamedXContents().stream()).flatMap(Function.identity()).collect(Collectors.toList()))).withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
            IndexScopedSettings indexScopedSettings = settingsModule.getIndexScopedSettings();
            this.idxSettings = IndexSettingsModule.newIndexSettings(index, indexSettings, indexScopedSettings);
            AnalysisModule analysisModule = new AnalysisModule(TestEnvironment.newEnvironment(nodeSettings), Collections.emptyList(), new StablePluginsRegistry());
            IndexAnalyzers indexAnalyzers = analysisModule.getAnalysisRegistry().build(IndexService.IndexCreationContext.CREATE_INDEX, this.idxSettings);
            this.scriptService = new MockScriptService(Settings.EMPTY, scriptModule.engines, scriptModule.contexts);
            this.similarityService = new SimilarityService(this.idxSettings, null, Collections.emptyMap());
            MapperRegistry mapperRegistry = indicesModule.getMapperRegistry();
            this.mapperService = new MapperService(clusterService, this.idxSettings, indexAnalyzers, this.parserConfiguration, this.similarityService, mapperRegistry, () -> this.createShardContext(null), this.idxSettings.getMode().idFieldMapperWithoutFieldData(), ScriptCompiler.NONE, () -> DocumentParsingObserver.EMPTY_INSTANCE);
            IndicesFieldDataCache indicesFieldDataCache = new IndicesFieldDataCache(nodeSettings, new IndexFieldDataCache.Listener(){});
            this.indexFieldDataService = new IndexFieldDataService(this.idxSettings, indicesFieldDataCache, (CircuitBreakerService)new NoneCircuitBreakerService());
            this.bitsetFilterCache = new BitsetFilterCache(this.idxSettings, new BitsetFilterCache.Listener(){

                public void onCache(ShardId shardId, Accountable accountable) {
                }

                public void onRemoval(ShardId shardId, Accountable accountable) {
                }
            });
            if (registerType) {
                this.mapperService.merge("_doc", new CompressedXContent(Strings.toString((XContentBuilder)PutMappingRequest.simpleMapping((String[])new String[]{AbstractBuilderTestCase.TEXT_FIELD_NAME, "type=text", AbstractBuilderTestCase.KEYWORD_FIELD_NAME, "type=keyword", AbstractBuilderTestCase.TEXT_ALIAS_FIELD_NAME, "type=alias,path=mapped_string", AbstractBuilderTestCase.INT_FIELD_NAME, "type=integer", AbstractBuilderTestCase.INT_ALIAS_FIELD_NAME, "type=alias,path=mapped_int", AbstractBuilderTestCase.INT_RANGE_FIELD_NAME, "type=integer_range", AbstractBuilderTestCase.DOUBLE_FIELD_NAME, "type=double", AbstractBuilderTestCase.BOOLEAN_FIELD_NAME, "type=boolean", AbstractBuilderTestCase.DATE_NANOS_FIELD_NAME, "type=date_nanos", AbstractBuilderTestCase.DATE_FIELD_NAME, "type=date", AbstractBuilderTestCase.DATE_ALIAS_FIELD_NAME, "type=alias,path=mapped_date", AbstractBuilderTestCase.DATE_RANGE_FIELD_NAME, "type=date_range", AbstractBuilderTestCase.OBJECT_FIELD_NAME, "type=object", AbstractBuilderTestCase.GEO_POINT_FIELD_NAME, "type=geo_point", AbstractBuilderTestCase.GEO_POINT_ALIAS_FIELD_NAME, "type=alias,path=mapped_geo_point", AbstractBuilderTestCase.BINARY_FIELD_NAME, "type=binary"}))), MapperService.MergeReason.MAPPING_UPDATE);
                this.mapperService.merge("_doc", new CompressedXContent(Strings.format((String)"{\n  \"properties\": {\n    \"%s\": {\n      \"type\": \"object\",\n      \"properties\": {\n        \"%s\": {\n          \"type\": \"date\"\n        },\n        \"%s\": {\n          \"type\": \"integer\"\n        }\n      }\n    }\n  }\n}", (Object[])new Object[]{AbstractBuilderTestCase.OBJECT_FIELD_NAME, AbstractBuilderTestCase.DATE_FIELD_NAME, AbstractBuilderTestCase.INT_FIELD_NAME})), MapperService.MergeReason.MAPPING_UPDATE);
                testCase.initializeAdditionalMappings(this.mapperService);
            }
        }

        public static Predicate<String> indexNameMatcher() {
            return pattern -> Regex.simpleMatch((String)pattern, (String)index.getName());
        }

        @Override
        public void close() throws IOException {
        }

        SearchExecutionContext createShardContext(IndexSearcher searcher) {
            return new SearchExecutionContext(0, 0, this.idxSettings, this.bitsetFilterCache, (arg_0, arg_1) -> ((IndexFieldDataService)this.indexFieldDataService).getForField(arg_0, arg_1), this.mapperService, this.mapperService.mappingLookup(), this.similarityService, (ScriptCompiler)this.scriptService, this.parserConfiguration, this.namedWriteableRegistry, this.client, searcher, () -> this.nowInMillis, null, ServiceHolder.indexNameMatcher(), () -> true, null, Collections.emptyMap());
        }

        QueryRewriteContext createQueryRewriteContext() {
            return new QueryRewriteContext(this.parserConfiguration, this.client, () -> this.nowInMillis, this.mapperService, this.mapperService.mappingLookup(), Collections.emptyMap(), null, this.idxSettings, new Index(RemoteClusterAware.buildRemoteIndexName(null, (String)this.idxSettings.getIndex().getName()), this.idxSettings.getIndex().getUUID()), ServiceHolder.indexNameMatcher(), this.namedWriteableRegistry, null, () -> true, (ScriptCompiler)this.scriptService);
        }

        CoordinatorRewriteContext createCoordinatorContext(DateFieldMapper.DateFieldType dateFieldType, long min, long max) {
            return new CoordinatorRewriteContext(this.parserConfiguration, this.client, () -> this.nowInMillis, IndexLongFieldRange.NO_SHARDS.extendWithShardRange(0, 1, ShardLongFieldRange.of((long)min, (long)max)), dateFieldType);
        }

        DataRewriteContext createDataContext() {
            return new DataRewriteContext(this.parserConfiguration, this.client, () -> this.nowInMillis);
        }

        ScriptModule createScriptModule(List<ScriptPlugin> scriptPlugins) {
            if (scriptPlugins == null || scriptPlugins.isEmpty()) {
                return new ScriptModule(Settings.EMPTY, Collections.singletonList(new ScriptPlugin(){

                    public ScriptEngine getScriptEngine(Settings settings, Collection<ScriptContext<?>> contexts) {
                        return new MockScriptEngine("mockscript", Collections.singletonMap("1", script -> "1"), Collections.emptyMap());
                    }
                }));
            }
            return new ScriptModule(Settings.EMPTY, scriptPlugins);
        }
    }

    private static class ClientInvocationHandler
    implements InvocationHandler {
        AbstractBuilderTestCase delegate;
        TestThreadPool testThreadPool;

        private ClientInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, final Object[] args) throws Throwable {
            if (method.equals(Client.class.getMethod("get", GetRequest.class, ActionListener.class))) {
                GetResponse getResponse = this.delegate.executeGet((GetRequest)args[0]);
                ActionListener listener = (ActionListener)args[1];
                if (ESTestCase.randomBoolean()) {
                    listener.onResponse((Object)getResponse);
                } else {
                    new Thread(() -> listener.onResponse((Object)getResponse)).start();
                }
                return null;
            }
            if (method.equals(Client.class.getMethod("multiTermVectors", MultiTermVectorsRequest.class))) {
                return new PlainActionFuture<MultiTermVectorsResponse>(){

                    public MultiTermVectorsResponse get() throws InterruptedException, ExecutionException {
                        return delegate.executeMultiTermVectors((MultiTermVectorsRequest)args[0]);
                    }
                };
            }
            if (method.equals(Object.class.getMethod("toString", new Class[0]))) {
                return "MockClient";
            }
            if (method.equals(Client.class.getMethod("threadPool", new Class[0]))) {
                return this.testThreadPool;
            }
            if (this.delegate.canSimulateMethod(method, args)) {
                return this.delegate.simulateMethod(method, args);
            }
            throw new UnsupportedOperationException("this test can't handle calls to: " + method);
        }
    }
}

