/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.CheckedBiFunction;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.search.vectors.KnnSearchBuilder;
import org.elasticsearch.search.vectors.QueryVectorBuilder;
import org.elasticsearch.test.AbstractXContentSerializingTestCase;
import org.elasticsearch.test.AbstractXContentTestCase;
import org.elasticsearch.test.client.NoOpClient;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentParser;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;

public abstract class AbstractQueryVectorBuilderTestCase<T extends QueryVectorBuilder>
extends AbstractXContentSerializingTestCase<T> {
    private NamedWriteableRegistry namedWriteableRegistry;
    private NamedXContentRegistry namedXContentRegistry;

    protected List<SearchPlugin> additionalPlugins() {
        return List.of();
    }

    @Before
    public void registerNamedXContents() {
        SearchModule searchModule = new SearchModule(Settings.EMPTY, this.additionalPlugins());
        this.namedXContentRegistry = new NamedXContentRegistry(searchModule.getNamedXContents());
        this.namedWriteableRegistry = new NamedWriteableRegistry(searchModule.getNamedWriteables());
    }

    @Override
    protected NamedXContentRegistry xContentRegistry() {
        return this.namedXContentRegistry;
    }

    @Override
    protected NamedWriteableRegistry getNamedWriteableRegistry() {
        return this.namedWriteableRegistry;
    }

    protected T createTestInstance(float[] expected) {
        return (T)((QueryVectorBuilder)this.createTestInstance());
    }

    public final void testKnnSearchBuilderXContent() throws Exception {
        AbstractXContentTestCase.XContentTester<KnnSearchBuilder> tester = AbstractXContentTestCase.xContentTester((CheckedBiFunction<XContent, BytesReference, XContentParser, IOException>)((CheckedBiFunction)this::createParser), () -> new KnnSearchBuilder(AbstractQueryVectorBuilderTestCase.randomAlphaOfLength(10), (QueryVectorBuilder)this.createTestInstance(), 5, 10, AbstractQueryVectorBuilderTestCase.randomBoolean() ? null : Float.valueOf(AbstractQueryVectorBuilderTestCase.randomFloat())), this.getToXContentParams(), KnnSearchBuilder::fromXContent);
        tester.test();
    }

    public final void testKnnSearchBuilderWireSerialization() throws IOException {
        for (int i = 0; i < 20; ++i) {
            KnnSearchBuilder searchBuilder = new KnnSearchBuilder(AbstractQueryVectorBuilderTestCase.randomAlphaOfLength(10), (QueryVectorBuilder)this.createTestInstance(), 5, 10, AbstractQueryVectorBuilderTestCase.randomBoolean() ? null : Float.valueOf(AbstractQueryVectorBuilderTestCase.randomFloat()));
            KnnSearchBuilder serialized = AbstractQueryVectorBuilderTestCase.copyWriteable(searchBuilder, this.getNamedWriteableRegistry(), KnnSearchBuilder::new, TransportVersion.current());
            AbstractQueryVectorBuilderTestCase.assertThat((Object)serialized, (Matcher)Matchers.equalTo((Object)searchBuilder));
            AbstractQueryVectorBuilderTestCase.assertNotSame((Object)serialized, (Object)searchBuilder);
        }
    }

    public final void testKnnSearchRewrite() throws Exception {
        for (int i = 0; i < 20; ++i) {
            float[] expected = AbstractQueryVectorBuilderTestCase.randomVector(AbstractQueryVectorBuilderTestCase.randomIntBetween(10, 1024));
            T queryVectorBuilder = this.createTestInstance(expected);
            KnnSearchBuilder searchBuilder = new KnnSearchBuilder(AbstractQueryVectorBuilderTestCase.randomAlphaOfLength(10), queryVectorBuilder, 5, 10, AbstractQueryVectorBuilderTestCase.randomBoolean() ? null : Float.valueOf(AbstractQueryVectorBuilderTestCase.randomFloat()));
            KnnSearchBuilder serialized = AbstractQueryVectorBuilderTestCase.copyWriteable(searchBuilder, this.getNamedWriteableRegistry(), KnnSearchBuilder::new, TransportVersion.current());
            try (AssertingClient client = new AssertingClient(this, expected, queryVectorBuilder);){
                QueryRewriteContext context = new QueryRewriteContext(null, (Client)client, null);
                PlainActionFuture future = new PlainActionFuture();
                Rewriteable.rewriteAndFetch((Rewriteable)AbstractQueryVectorBuilderTestCase.randomFrom(serialized, searchBuilder), (QueryRewriteContext)context, (ActionListener)future);
                KnnSearchBuilder rewritten = (KnnSearchBuilder)future.get();
                AbstractQueryVectorBuilderTestCase.assertThat((Object)rewritten.getQueryVector(), (Matcher)Matchers.equalTo((Object)expected));
                AbstractQueryVectorBuilderTestCase.assertThat((Object)rewritten.getQueryVectorBuilder(), (Matcher)Matchers.nullValue());
                continue;
            }
        }
    }

    public final void testVectorFetch() throws Exception {
        float[] expected = AbstractQueryVectorBuilderTestCase.randomVector(AbstractQueryVectorBuilderTestCase.randomIntBetween(10, 1024));
        T queryVectorBuilder = this.createTestInstance(expected);
        try (AssertingClient client = new AssertingClient(this, expected, queryVectorBuilder);){
            PlainActionFuture future = new PlainActionFuture();
            queryVectorBuilder.buildVector((Client)client, (ActionListener)future);
            AbstractQueryVectorBuilderTestCase.assertThat((Object)((float[])future.get()), (Matcher)Matchers.equalTo((Object)expected));
        }
    }

    protected abstract void doAssertClientRequest(ActionRequest var1, T var2);

    protected abstract ActionResponse createResponse(float[] var1, T var2);

    protected static float[] randomVector(int dim) {
        float[] vector = new float[dim];
        for (int i = 0; i < vector.length; ++i) {
            vector[i] = AbstractQueryVectorBuilderTestCase.randomFloat();
        }
        return vector;
    }

    private static class AssertingClient
    extends NoOpClient {
        private final float[] array;
        private final T queryVectorBuilder;
        final /* synthetic */ AbstractQueryVectorBuilderTestCase this$0;

        AssertingClient(float[] array, T queryVectorBuilder) {
            this.this$0 = var1_1;
            super("query_vector_builder_tests");
            this.array = array;
            this.queryVectorBuilder = queryVectorBuilder;
        }

        @Override
        protected <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
            this.this$0.doAssertClientRequest(request, this.queryVectorBuilder);
            listener.onResponse((Object)this.this$0.createResponse(this.array, this.queryVectorBuilder));
        }
    }
}

