/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.Build;
import org.elasticsearch.test.ESTestCase;

public class BuildUtils {
    private static final MethodHandle buildCtor;

    public static Build newBuild(Build existing, Map<String, Object> extraArgs) {
        HashMap<String, Object> argsOverrides = new HashMap<String, Object>(extraArgs);
        RecordComponent[] argsComponents = Build.class.getRecordComponents();
        try {
            Object[] args = new Object[argsComponents.length];
            int i = 0;
            for (RecordComponent argComponent : argsComponents) {
                Object value = argsOverrides.remove(argComponent.getName());
                if (value == null) {
                    value = argComponent.getAccessor().invoke((Object)existing, new Object[0]);
                }
                args[i++] = value;
            }
            if (!argsOverrides.isEmpty()) {
                throw new AssertionError((Object)("Unknown Build arguments: " + argsOverrides.keySet()));
            }
            return (Build)buildCtor.invokeWithArguments(args);
        }
        catch (Throwable t) {
            throw new AssertionError("Failed to create test Build instance", t);
        }
    }

    public static Build mutateBuild(Build existing) {
        Object newValue;
        Object currentValue;
        RecordComponent[] argsComponents = Build.class.getRecordComponents();
        RecordComponent argToChange = argsComponents[ESTestCase.randomInt(argsComponents.length - 1)];
        Class<?> argType = argToChange.getType();
        try {
            currentValue = argToChange.getAccessor().invoke((Object)existing, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        if (argType.isEnum()) {
            newValue = ESTestCase.randomValueOtherThan(currentValue, () -> ESTestCase.randomFrom(argType.getEnumConstants()));
        } else if (argType.equals(String.class)) {
            newValue = BuildUtils.randomStringExcept((String)currentValue);
        } else if (argType.equals(Boolean.TYPE)) {
            newValue = (Boolean)currentValue == false;
        } else {
            throw new AssertionError((Object)("Build has unknown arg type: " + argType.getName()));
        }
        return BuildUtils.newBuild(existing, Map.of(argToChange.getName(), newValue));
    }

    private static String randomStringExcept(String s) {
        return ESTestCase.randomAlphaOfLength(13 - s.length());
    }

    static {
        try {
            buildCtor = MethodHandles.publicLookup().unreflectConstructor(Build.class.getConstructors()[0]);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }
}

