/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.util.function.Consumer;
import org.elasticsearch.test.ESTestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class EqualsHashCodeTestUtils {
    private static Object[] someObjects = new Object[]{"some string", 1, 1.0};

    public static <T> void checkEqualsAndHashCode(T original, CopyFunction<T> copyFunction) {
        EqualsHashCodeTestUtils.checkEqualsAndHashCode(original, copyFunction, null);
    }

    public static <T> void checkEqualsAndHashCode(T original, CopyFunction<T> copyFunction, MutateFunction<T> mutationFunction) {
        EqualsHashCodeTestUtils.checkEqualsAndHashCode(original, copyFunction, mutationFunction, unused -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void checkEqualsAndHashCode(T original, CopyFunction<T> copyFunction, MutateFunction<T> mutationFunction, Consumer<T> dispose) {
        try {
            String objectName = original.getClass().getSimpleName();
            Assert.assertFalse((String)(objectName + " is equal to null"), (boolean)original.equals(null));
            Assert.assertFalse((String)(objectName + " is equal to incompatible type"), (boolean)original.equals(ESTestCase.randomFrom(someObjects)));
            Assert.assertTrue((String)(objectName + " is not equal to self"), (boolean)original.equals(original));
            Assert.assertThat((String)(objectName + " hashcode returns different values if called multiple times"), (Object)original.hashCode(), (Matcher)Matchers.equalTo((Object)original.hashCode()));
            if (mutationFunction != null) {
                T mutation = mutationFunction.mutate(original);
                try {
                    Assert.assertThat((String)(objectName + " mutation should not be equal to original"), mutation, (Matcher)Matchers.not((Matcher)Matchers.equalTo(original)));
                    Assert.assertThat((String)("original should not be equal to mutation" + objectName), original, (Matcher)Matchers.not((Matcher)Matchers.equalTo(mutation)));
                }
                finally {
                    dispose.accept(mutation);
                }
            }
            T copy = copyFunction.copy(original);
            try {
                Assert.assertTrue((String)(objectName + " copy is not equal to self"), (boolean)copy.equals(copy));
                Assert.assertTrue((String)(objectName + " is not equal to its copy"), (boolean)original.equals(copy));
                Assert.assertTrue((String)"equals is not symmetric", (boolean)copy.equals(original));
                Assert.assertThat((String)(objectName + " hashcode is different from copies hashcode"), (Object)copy.hashCode(), (Matcher)Matchers.equalTo((Object)original.hashCode()));
                T secondCopy = copyFunction.copy(copy);
                try {
                    Assert.assertTrue((String)"second copy is not equal to self", (boolean)secondCopy.equals(secondCopy));
                    Assert.assertTrue((String)"copy is not equal to its second copy", (boolean)copy.equals(secondCopy));
                    Assert.assertThat((String)"second copy's hashcode is different from original hashcode", (Object)copy.hashCode(), (Matcher)Matchers.equalTo((Object)secondCopy.hashCode()));
                    Assert.assertTrue((String)"equals is not transitive", (boolean)original.equals(secondCopy));
                    Assert.assertTrue((String)"equals is not symmetric", (boolean)secondCopy.equals(copy));
                    Assert.assertTrue((String)"equals is not symmetric", (boolean)secondCopy.equals(original));
                }
                finally {
                    dispose.accept(secondCopy);
                }
            }
            finally {
                dispose.accept(copy);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface CopyFunction<T> {
        public T copy(T var1) throws IOException;
    }

    public static interface MutateFunction<T> {
        public T mutate(T var1) throws IOException;
    }
}

