/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public final class MockIndexEventListener {

    public static class TestEventListener
    implements IndexEventListener {
        private volatile IndexEventListener delegate = new IndexEventListener(){};

        public void setNewDelegate(IndexEventListener listener) {
            this.delegate = listener == null ? new IndexEventListener(){} : listener;
        }

        public void shardRoutingChanged(IndexShard indexShard, @Nullable ShardRouting oldRouting, ShardRouting newRouting) {
            this.delegate.shardRoutingChanged(indexShard, oldRouting, newRouting);
        }

        public void afterIndexShardCreated(IndexShard indexShard) {
            this.delegate.afterIndexShardCreated(indexShard);
        }

        public void afterIndexShardStarted(IndexShard indexShard) {
            this.delegate.afterIndexShardStarted(indexShard);
        }

        public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
            this.delegate.beforeIndexShardClosed(shardId, indexShard, indexSettings);
        }

        public void afterIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
            this.delegate.afterIndexShardClosed(shardId, indexShard, indexSettings);
        }

        public void indexShardStateChanged(IndexShard indexShard, @Nullable IndexShardState previousState, IndexShardState currentState, @Nullable String reason) {
            this.delegate.indexShardStateChanged(indexShard, previousState, currentState, reason);
        }

        public void beforeIndexCreated(Index index, Settings indexSettings) {
            this.delegate.beforeIndexCreated(index, indexSettings);
        }

        public void afterIndexCreated(IndexService indexService) {
            this.delegate.afterIndexCreated(indexService);
        }

        public void beforeIndexShardCreated(ShardRouting shardrouting, Settings indexSettings) {
            this.delegate.beforeIndexShardCreated(shardrouting, indexSettings);
        }

        public void beforeIndexRemoved(IndexService indexService, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
            this.delegate.beforeIndexRemoved(indexService, reason);
        }

        public void afterIndexRemoved(Index index, IndexSettings indexSettings, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
            this.delegate.afterIndexRemoved(index, indexSettings, reason);
        }

        public void beforeIndexShardDeleted(ShardId shardId, Settings indexSettings) {
            this.delegate.beforeIndexShardDeleted(shardId, indexSettings);
        }

        public void afterIndexShardDeleted(ShardId shardId, Settings indexSettings) {
            this.delegate.afterIndexShardDeleted(shardId, indexSettings);
        }

        public void beforeIndexAddedToCluster(Index index, Settings indexSettings) {
            this.delegate.beforeIndexAddedToCluster(index, indexSettings);
        }
    }

    public static class TestPlugin
    extends Plugin {
        private final TestEventListener listener = new TestEventListener();
        public static final Setting<Boolean> INDEX_FAIL = Setting.boolSetting((String)"index.fail", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope});

        public List<Setting<?>> getSettings() {
            return Arrays.asList(INDEX_FAIL);
        }

        public void onIndexModule(IndexModule module) {
            module.addIndexEventListener((IndexEventListener)this.listener);
        }

        public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier, TelemetryProvider telemetryProvider, AllocationService allocationService, IndicesService indicesService) {
            return Collections.singletonList(this.listener);
        }
    }
}

