/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.junit.Assert;

public class ReachabilityChecker {
    private final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private final Queue<Registered> references = ConcurrentCollections.newQueue();

    public ReachabilityChecker() {
        this.memoryMXBean.gc();
    }

    public <T> T register(T target) {
        ReferenceQueue referenceQueue = new ReferenceQueue();
        this.references.add(new Registered(target.toString(), new PhantomReference<T>(Objects.requireNonNull(target), referenceQueue), referenceQueue));
        return target;
    }

    public void ensureUnreachable() {
        this.ensureUnreachable(TimeUnit.SECONDS.toMillis(10L));
    }

    void ensureUnreachable(long timeoutMillis) {
        Registered registered;
        while ((registered = this.references.poll()) != null) {
            registered.assertReferenceEnqueuedForCollection(this.memoryMXBean, timeoutMillis);
        }
    }

    public void checkReachable() {
        if (this.references.peek() == null) {
            throw new AssertionError((Object)"no references registered");
        }
        int target = Randomness.get().nextInt(this.references.size());
        Iterator iterator = this.references.iterator();
        for (int i = 0; i < target; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertNotNull(iterator.next());
        }
        Assert.assertTrue((boolean)iterator.hasNext());
        ((Registered)iterator.next()).assertReferenceNotEnqueuedForCollection(this.memoryMXBean);
    }

    private static final class Registered {
        private final String description;
        private final PhantomReference<?> phantomReference;
        private final ReferenceQueue<?> referenceQueue;

        Registered(String description, PhantomReference<?> phantomReference, ReferenceQueue<?> referenceQueue) {
            this.description = description;
            this.phantomReference = phantomReference;
            this.referenceQueue = referenceQueue;
        }

        public void assertReferenceEnqueuedForCollection(MemoryMXBean memoryMXBean, long timeoutMillis) {
            try {
                long timeoutAt = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeoutMillis);
                while (true) {
                    memoryMXBean.gc();
                    Reference<?> ref = this.referenceQueue.remove(500L);
                    if (ref != null) {
                        ref.clear();
                        return;
                    }
                    Assert.assertTrue((String)("still reachable: " + this.description), (System.nanoTime() < timeoutAt ? 1 : 0) != 0);
                    Assert.assertNull(this.phantomReference.get());
                }
            }
            catch (Exception e) {
                throw new AssertionError("unexpected", e);
            }
        }

        public void assertReferenceNotEnqueuedForCollection(MemoryMXBean memoryMXBean) {
            try {
                memoryMXBean.gc();
                Assert.assertNull((String)("became unreachable: " + this.description), this.referenceQueue.remove(100L));
            }
            catch (Exception e) {
                throw new AssertionError("unexpected", e);
            }
        }
    }
}

