/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.client;

import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.tests.util.TestUtil;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.FilterClient;
import org.elasticsearch.cluster.routing.Preference;
import org.elasticsearch.core.TimeValue;

public class RandomizingClient
extends FilterClient {
    private final SearchType defaultSearchType;
    private final String defaultPreference;
    private final int batchedReduceSize;
    private final int maxConcurrentShardRequests;
    private final int preFilterShardSize;
    private final boolean doTimeout;

    public RandomizingClient(Client client, Random random) {
        super(client);
        String s;
        this.defaultSearchType = (SearchType)RandomPicks.randomFrom((Random)random, Arrays.asList(SearchType.DFS_QUERY_THEN_FETCH, SearchType.QUERY_THEN_FETCH));
        this.defaultPreference = random.nextInt(10) == 0 ? Preference.LOCAL.type() : (random.nextInt(10) == 0 ? ((s = TestUtil.randomRealisticUnicodeString((Random)random, (int)1, (int)10)).startsWith("_") ? null : s) : null);
        this.batchedReduceSize = 2 + random.nextInt(10);
        this.maxConcurrentShardRequests = random.nextBoolean() ? 1 + random.nextInt(1 << random.nextInt(8)) : -1;
        this.preFilterShardSize = random.nextBoolean() ? 1 + random.nextInt(1 << random.nextInt(7)) : -1;
        this.doTimeout = random.nextBoolean();
    }

    public SearchRequestBuilder prepareSearch(String ... indices) {
        SearchRequestBuilder searchRequestBuilder = this.in.prepareSearch(indices).setSearchType(this.defaultSearchType).setPreference(this.defaultPreference).setBatchedReduceSize(this.batchedReduceSize);
        if (this.maxConcurrentShardRequests != -1) {
            searchRequestBuilder.setMaxConcurrentShardRequests(this.maxConcurrentShardRequests);
        }
        if (this.preFilterShardSize != -1) {
            searchRequestBuilder.setPreFilterShardSize(this.preFilterShardSize);
        }
        if (this.doTimeout) {
            searchRequestBuilder.setTimeout(new TimeValue(1L, TimeUnit.DAYS));
        }
        return searchRequestBuilder;
    }

    public String toString() {
        return "randomized(" + super.toString() + ")";
    }

    public Client in() {
        return super.in();
    }
}

