/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.disruption;

import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.test.disruption.LongGCDisruption;

public class IntermittentLongGCDisruption
extends LongGCDisruption {
    volatile boolean disrupting;
    volatile Thread worker;
    final long intervalBetweenDelaysMin;
    final long intervalBetweenDelaysMax;
    final long delayDurationMin;
    final long delayDurationMax;
    static final AtomicInteger thread_ids = new AtomicInteger();

    public IntermittentLongGCDisruption(Random random, String disruptedNode, long intervalBetweenDelaysMin, long intervalBetweenDelaysMax, long delayDurationMin, long delayDurationMax) {
        super(random, disruptedNode);
        this.intervalBetweenDelaysMin = intervalBetweenDelaysMin;
        this.intervalBetweenDelaysMax = intervalBetweenDelaysMax;
        this.delayDurationMin = delayDurationMin;
        this.delayDurationMax = delayDurationMax;
    }

    @Override
    public void startDisrupting() {
        this.disrupting = true;
        this.worker = new Thread((Runnable)new BackgroundWorker(), "long_gc_simulation_" + thread_ids.incrementAndGet());
        this.worker.setDaemon(true);
        this.worker.start();
    }

    @Override
    public void stopDisrupting() {
        if (this.worker == null) {
            return;
        }
        this.logger.info("stopping long GCs on [{}]", (Object)this.disruptedNode);
        this.disrupting = false;
        this.worker.interrupt();
        try {
            this.worker.join(2L * (this.intervalBetweenDelaysMax + this.delayDurationMax));
        }
        catch (InterruptedException e) {
            this.logger.info("background thread failed to stop");
        }
        this.worker = null;
    }

    private void simulateLongGC(TimeValue duration) throws InterruptedException {
        this.logger.info("node [{}] goes into GC for for [{}]", (Object)this.disruptedNode, (Object)duration);
        HashSet<Thread> nodeThreads = new HashSet<Thread>();
        try {
            while (this.suspendThreads(nodeThreads)) {
            }
            if (!nodeThreads.isEmpty()) {
                Thread.sleep(duration.millis());
            }
        }
        finally {
            this.logger.info("node [{}] resumes from GC", (Object)this.disruptedNode);
            this.resumeThreads(nodeThreads);
        }
    }

    class BackgroundWorker
    implements Runnable {
        BackgroundWorker() {
        }

        @Override
        public void run() {
            while (IntermittentLongGCDisruption.this.disrupting) {
                try {
                    TimeValue duration = new TimeValue(IntermittentLongGCDisruption.this.delayDurationMin + (long)IntermittentLongGCDisruption.this.random.nextInt((int)(IntermittentLongGCDisruption.this.delayDurationMax - IntermittentLongGCDisruption.this.delayDurationMin)));
                    IntermittentLongGCDisruption.this.simulateLongGC(duration);
                    duration = new TimeValue(IntermittentLongGCDisruption.this.intervalBetweenDelaysMin + (long)IntermittentLongGCDisruption.this.random.nextInt((int)(IntermittentLongGCDisruption.this.intervalBetweenDelaysMax - IntermittentLongGCDisruption.this.intervalBetweenDelaysMin)));
                    if (!IntermittentLongGCDisruption.this.disrupting) continue;
                    Thread.sleep(duration.millis());
                }
                catch (InterruptedException duration) {
                }
                catch (Exception e) {
                    IntermittentLongGCDisruption.this.logger.error("error in background worker", (Throwable)e);
                }
            }
        }
    }
}

