/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.index;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.KnownIndexVersions;
import org.elasticsearch.test.ESTestCase;

public class IndexVersionUtils {
    private static final List<IndexVersion> ALL_VERSIONS = KnownIndexVersions.ALL_VERSIONS;

    public static List<IndexVersion> allReleasedVersions() {
        return ALL_VERSIONS;
    }

    public static IndexVersion getFirstVersion() {
        return ALL_VERSIONS.get(0);
    }

    public static IndexVersion randomVersion() {
        return ESTestCase.randomFrom(ALL_VERSIONS);
    }

    public static IndexVersion randomVersion(Set<IndexVersion> ignore) {
        return (IndexVersion)ESTestCase.randomFrom(ALL_VERSIONS.stream().filter(v -> !ignore.contains(v)).collect(Collectors.toList()));
    }

    public static IndexVersion randomVersion(Random random) {
        return ALL_VERSIONS.get(random.nextInt(ALL_VERSIONS.size()));
    }

    public static IndexVersion randomVersionBetween(Random random, @Nullable IndexVersion minVersion, @Nullable IndexVersion maxVersion) {
        if (minVersion != null && maxVersion != null && maxVersion.before((VersionId)minVersion)) {
            throw new IllegalArgumentException("maxVersion [" + maxVersion + "] cannot be less than minVersion [" + minVersion + "]");
        }
        int minVersionIndex = 0;
        if (minVersion != null) {
            minVersionIndex = Collections.binarySearch(ALL_VERSIONS, minVersion);
        }
        int maxVersionIndex = ALL_VERSIONS.size() - 1;
        if (maxVersion != null) {
            maxVersionIndex = Collections.binarySearch(ALL_VERSIONS, maxVersion);
        }
        if (minVersionIndex < 0) {
            throw new IllegalArgumentException("minVersion [" + minVersion + "] does not exist.");
        }
        if (maxVersionIndex < 0) {
            throw new IllegalArgumentException("maxVersion [" + maxVersion + "] does not exist.");
        }
        int range = maxVersionIndex + 1 - minVersionIndex;
        return ALL_VERSIONS.get(minVersionIndex + random.nextInt(range));
    }

    public static IndexVersion getPreviousVersion() {
        IndexVersion version = IndexVersionUtils.getPreviousVersion(IndexVersion.current());
        assert (version.before((VersionId)IndexVersion.current()));
        return version;
    }

    public static IndexVersion getPreviousVersion(IndexVersion version) {
        int place = Collections.binarySearch(ALL_VERSIONS, version);
        if (place < 0) {
            place = -(place + 1);
        }
        if (place < 1) {
            throw new IllegalArgumentException("couldn't find any released versions before [" + version + "]");
        }
        return ALL_VERSIONS.get(place - 1);
    }

    public static IndexVersion getPreviousMajorVersion(IndexVersion version) {
        return IndexVersion.getMinimumCompatibleIndexVersion((int)version.id());
    }

    public static IndexVersion getNextVersion(IndexVersion version) {
        int place = Collections.binarySearch(ALL_VERSIONS, version);
        place = place < 0 ? -(place + 1) : ++place;
        if (place < 0 || place >= ALL_VERSIONS.size()) {
            throw new IllegalArgumentException("couldn't find any released versions after [" + version + "]");
        }
        return ALL_VERSIONS.get(place);
    }

    public static IndexVersion randomCompatibleVersion(Random random) {
        return IndexVersionUtils.randomVersionBetween(random, IndexVersion.MINIMUM_COMPATIBLE, IndexVersion.current());
    }

    public static IndexVersion randomPreviousCompatibleVersion(Random random, IndexVersion version) {
        return IndexVersionUtils.randomVersionBetween(random, IndexVersion.MINIMUM_COMPATIBLE, IndexVersionUtils.getPreviousVersion(version));
    }
}

