/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.action.support.ActionTestUtils;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.ESTestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class CancellableActionTestPlugin
extends Plugin
implements ActionPlugin {
    private volatile String capturedActionName;
    private final AtomicReference<SubscribableListener<Captured>> capturedRef = new AtomicReference();

    public static CapturingAction capturingActionOnNode(String actionName, String nodeName) {
        List plugins = ESIntegTestCase.internalCluster().getInstance(PluginsService.class, nodeName).filterPlugins(CancellableActionTestPlugin.class).toList();
        Assert.assertThat((String)("unique " + CancellableActionTestPlugin.class.getCanonicalName() + " plugin not found"), plugins, (Matcher)Matchers.hasSize((int)1));
        return ((CancellableActionTestPlugin)((Object)plugins.get(0))).capturingAction(actionName);
    }

    private CapturingAction capturingAction(String actionName) {
        final SubscribableListener captureListener = new SubscribableListener();
        this.capturedActionName = actionName;
        Assert.assertTrue((boolean)this.capturedRef.compareAndSet(null, (SubscribableListener<Captured>)captureListener));
        final CountDownLatch completionLatch = new CountDownLatch(1);
        return new CapturingAction(){

            @Override
            public void captureAndCancel(Runnable doCancel) {
                Assert.assertFalse((boolean)captureListener.isDone());
                captureListener.onResponse((Object)new Captured(doCancel, completionLatch));
                ESTestCase.safeAwait(completionLatch);
            }

            public void close() {
                Assert.assertNull(CancellableActionTestPlugin.this.capturedRef.get());
                Assert.assertEquals((long)0L, (long)completionLatch.getCount());
            }
        };
    }

    public List<ActionFilter> getActionFilters() {
        return List.of(new ActionFilter(){
            private final int order = ESTestCase.randomInt();

            public int order() {
                return this.order;
            }

            public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, Request request, final ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
                SubscribableListener capturingListener;
                if (action.equals(CancellableActionTestPlugin.this.capturedActionName) && (capturingListener = (SubscribableListener)CancellableActionTestPlugin.this.capturedRef.getAndSet(null)) != null) {
                    CancellableTask cancellableTask = ESTestCase.asInstanceOf(CancellableTask.class, task);
                    capturingListener.addListener(ActionTestUtils.assertNoFailureListener(captured -> {
                        cancellableTask.addListener(() -> chain.proceed(task, action, request, new ActionListener<Response>((Captured)captured){
                            final /* synthetic */ Captured val$captured;
                            {
                                this.val$captured = captured;
                            }

                            public void onResponse(Response response) {
                                Assert.fail((String)("cancelled action should not succeed, but got " + response));
                            }

                            public void onFailure(Exception e) {
                                Assert.assertThat((Object)ExceptionsHelper.unwrapCause((Throwable)e), (Matcher)Matchers.instanceOf(TaskCancelledException.class));
                                listener.onFailure(e);
                                this.val$captured.countDownLatch().countDown();
                            }
                        }));
                        Assert.assertFalse((boolean)cancellableTask.isCancelled());
                        captured.doCancel().run();
                    }));
                    return;
                }
                chain.proceed(task, action, request, listener);
            }
        });
    }

    public static interface CapturingAction
    extends Releasable {
        public void captureAndCancel(Runnable var1);
    }

    private record Captured(Runnable doCancel, CountDownLatch countDownLatch) {
    }
}

