/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.coordination.ClusterFormationInfoAction;
import org.elasticsearch.action.admin.cluster.coordination.CoordinationDiagnosticsAction;
import org.elasticsearch.action.admin.cluster.coordination.MasterHistoryAction;
import org.elasticsearch.action.admin.cluster.node.hotthreads.TransportNodesHotThreadsAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ESAllocationTestCase;
import org.elasticsearch.cluster.NodeConnectionsService;
import org.elasticsearch.cluster.TestShardRoutingRoleStrategies;
import org.elasticsearch.cluster.coordination.ClusterBootstrapService;
import org.elasticsearch.cluster.coordination.ClusterStatePublisher;
import org.elasticsearch.cluster.coordination.CoordinationDiagnosticsService;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.coordination.CoordinationState;
import org.elasticsearch.cluster.coordination.CoordinationStateRejectedException;
import org.elasticsearch.cluster.coordination.CoordinationStateTestCluster;
import org.elasticsearch.cluster.coordination.Coordinator;
import org.elasticsearch.cluster.coordination.CountingPageCacheRecycler;
import org.elasticsearch.cluster.coordination.ElectionSchedulerFactory;
import org.elasticsearch.cluster.coordination.ElectionStrategy;
import org.elasticsearch.cluster.coordination.FailedToCommitClusterStateException;
import org.elasticsearch.cluster.coordination.FollowersChecker;
import org.elasticsearch.cluster.coordination.InMemoryPersistedState;
import org.elasticsearch.cluster.coordination.JoinValidationService;
import org.elasticsearch.cluster.coordination.LeaderChecker;
import org.elasticsearch.cluster.coordination.LeaderHeartbeatService;
import org.elasticsearch.cluster.coordination.LinearizabilityChecker;
import org.elasticsearch.cluster.coordination.MasterHistoryService;
import org.elasticsearch.cluster.coordination.PreVoteCollector;
import org.elasticsearch.cluster.coordination.Reconfigurator;
import org.elasticsearch.cluster.coordination.StableMasterHealthIndicatorService;
import org.elasticsearch.cluster.coordination.StatefulPreVoteCollector;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodeUtils;
import org.elasticsearch.cluster.routing.BatchedRerouteService;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterApplier;
import org.elasticsearch.cluster.service.ClusterApplierService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.FakeThreadPoolMasterService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.cluster.version.CompatibilityVersionsUtils;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.RecyclerBytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.DeterministicTaskQueue;
import org.elasticsearch.common.util.concurrent.PrioritizedEsThreadPoolExecutor;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.discovery.PeerFinder;
import org.elasticsearch.discovery.SeedHostsProvider;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.gateway.ClusterStateUpdaters;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.gateway.MockGatewayMetaState;
import org.elasticsearch.gateway.PersistedClusterStateService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.monitor.NodeHealthService;
import org.elasticsearch.monitor.StatusInfo;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BytesRefRecycler;
import org.elasticsearch.transport.DisruptableMockTransport;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.TransportSettings;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class AbstractCoordinatorTestCase
extends ESTestCase {
    protected final List<NodeEnvironment> nodeEnvironments = new ArrayList<NodeEnvironment>();
    protected final Set<CoordinationState.PersistedState> openPersistedStates = new HashSet<CoordinationState.PersistedState>();
    protected final AtomicInteger nextNodeIndex = new AtomicInteger();
    public static final int CLUSTER_STATE_UPDATE_NUMBER_OF_DELAYS = 9;
    public static final long DEFAULT_CLUSTER_STATE_UPDATE_DELAY = 900L;
    private static final int ELECTION_RETRIES = 10;
    public static final long DEFAULT_ELECTION_DELAY = AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)PeerFinder.DISCOVERY_FIND_PEERS_INTERVAL_SETTING) * 2L + AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)ElectionSchedulerFactory.ELECTION_INITIAL_TIMEOUT_SETTING) * 10L + AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)ElectionSchedulerFactory.ELECTION_BACK_OFF_TIME_SETTING) * 10L * 9L / 2L + AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)ElectionSchedulerFactory.ELECTION_DURATION_SETTING) * 10L + 400L + 900L;
    public static final long DEFAULT_STABILISATION_TIME = (AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)LeaderChecker.LEADER_CHECK_INTERVAL_SETTING) + AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)LeaderChecker.LEADER_CHECK_TIMEOUT_SETTING)) * (long)AbstractCoordinatorTestCase.defaultInt((Setting<Integer>)LeaderChecker.LEADER_CHECK_RETRY_COUNT_SETTING) + DEFAULT_ELECTION_DELAY + AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)Coordinator.PUBLISH_TIMEOUT_SETTING) + DEFAULT_ELECTION_DELAY + AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)Coordinator.PUBLISH_TIMEOUT_SETTING) + DEFAULT_ELECTION_DELAY + (AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)FollowersChecker.FOLLOWER_CHECK_INTERVAL_SETTING) + AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)FollowersChecker.FOLLOWER_CHECK_TIMEOUT_SETTING)) * (long)AbstractCoordinatorTestCase.defaultInt((Setting<Integer>)FollowersChecker.FOLLOWER_CHECK_RETRY_COUNT_SETTING) + 900L + AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)JoinValidationService.JOIN_VALIDATION_CACHE_TIMEOUT_SETTING);
    protected static final Set<DiscoveryNodeRole> ALL_ROLES_EXCEPT_VOTING_ONLY = DiscoveryNodeRole.roles().stream().filter(r -> !r.equals((Object)DiscoveryNodeRole.VOTING_ONLY_NODE_ROLE)).collect(Collectors.toUnmodifiableSet());
    private final LinearizabilityChecker.SequentialSpec spec = new LinearizabilityChecker.KeyedSpec(){

        @Override
        public Object getKey(Object value) {
            return ((Tuple)value).v1();
        }

        @Override
        public Object getValue(Object value) {
            return ((Tuple)value).v2();
        }

        @Override
        public Object initialState() {
            return 0L;
        }

        @Override
        public Optional<Object> nextState(Object currentState, Object input, Object output) {
            if (input == null) {
                if (output == null || currentState.equals(output)) {
                    return Optional.of(currentState);
                }
            } else if (output == null || currentState.equals(output)) {
                return Optional.of(input);
            }
            return Optional.empty();
        }
    };

    @Before
    public void resetNodeIndexBeforeEachTest() {
        this.nextNodeIndex.set(0);
    }

    @After
    public void closeNodeEnvironmentsAfterEachTest() {
        for (NodeEnvironment nodeEnvironment : this.nodeEnvironments) {
            nodeEnvironment.close();
        }
        this.nodeEnvironments.clear();
    }

    @After
    public void assertAllPersistedStatesClosed() {
        AbstractCoordinatorTestCase.assertThat(this.openPersistedStates, (Matcher)Matchers.empty());
    }

    @Before
    public void resetPortCounterBeforeEachTest() {
        AbstractCoordinatorTestCase.resetPortCounter();
    }

    public void testRepeatableTests() throws Exception {
        Callable<Long> test = () -> {
            this.resetNodeIndexBeforeEachTest();
            try (Cluster cluster = new Cluster(AbstractCoordinatorTestCase.randomIntBetween(1, 5));){
                cluster.runRandomly();
                long afterRunRandomly = this.value(cluster.getAnyNode().getLastAppliedClusterState());
                cluster.stabilise();
                long afterStabilisation = this.value(cluster.getAnyNode().getLastAppliedClusterState());
                Long l = afterRunRandomly ^ afterStabilisation;
                return l;
            }
        };
        long seed = AbstractCoordinatorTestCase.randomLong();
        this.logger.info("First run with seed [{}]", (Object)seed);
        long result1 = (Long)RandomizedContext.current().runWithPrivateRandomness(seed, test);
        this.logger.info("Second run with seed [{}]", (Object)seed);
        long result2 = (Long)RandomizedContext.current().runWithPrivateRandomness(seed, test);
        AbstractCoordinatorTestCase.assertEquals((long)result1, (long)result2);
    }

    protected static long defaultMillis(Setting<TimeValue> setting) {
        return ((TimeValue)setting.get(Settings.EMPTY)).millis() + 100L;
    }

    protected static int defaultInt(Setting<Integer> setting) {
        return (Integer)setting.get(Settings.EMPTY);
    }

    protected TransportInterceptor getTransportInterceptor(DiscoveryNode localNode, ThreadPool threadPool) {
        return TransportService.NOOP_TRANSPORT_INTERCEPTOR;
    }

    protected CoordinatorStrategy createCoordinatorStrategy() {
        return new DefaultCoordinatorStrategy();
    }

    protected DiscoveryNode createDiscoveryNode(int nodeIndex, boolean masterEligible) {
        return DiscoveryNodeUtils.builder("node" + nodeIndex).ephemeralId(UUIDs.randomBase64UUID((Random)AbstractCoordinatorTestCase.random())).roles(masterEligible ? ALL_ROLES_EXCEPT_VOTING_ONLY : Collections.emptySet()).build();
    }

    public ClusterState setValue(ClusterState clusterState, int key, long value) {
        return ClusterState.builder((ClusterState)clusterState).metadata(Metadata.builder((Metadata)clusterState.metadata()).persistentSettings(Settings.builder().put(clusterState.metadata().persistentSettings()).put("value_" + key, value).build()).build()).build();
    }

    public long value(ClusterState clusterState) {
        return this.value(clusterState, 0);
    }

    public long value(ClusterState clusterState, int key) {
        return clusterState.metadata().persistentSettings().getAsLong("value_" + key, Long.valueOf(0L));
    }

    public void assertStateEquals(ClusterState clusterState1, ClusterState clusterState2) {
        AbstractCoordinatorTestCase.assertEquals((long)clusterState1.version(), (long)clusterState2.version());
        AbstractCoordinatorTestCase.assertEquals((long)clusterState1.term(), (long)clusterState2.term());
        AbstractCoordinatorTestCase.assertEquals(this.keySet(clusterState1), this.keySet(clusterState2));
        for (int key : this.keySet(clusterState1)) {
            AbstractCoordinatorTestCase.assertEquals((long)this.value(clusterState1, key), (long)this.value(clusterState2, key));
        }
    }

    public Set<Integer> keySet(ClusterState clusterState) {
        return clusterState.metadata().persistentSettings().keySet().stream().filter(s -> s.startsWith("value_")).map(s -> Integer.valueOf(s.substring("value_".length()))).collect(Collectors.toSet());
    }

    public void testRegisterSpecConsistency() {
        AbstractCoordinatorTestCase.assertThat((Object)this.spec.initialState(), (Matcher)Matchers.equalTo((Object)0L));
        AbstractCoordinatorTestCase.assertThat(this.spec.nextState(7, 42, 7), (Matcher)Matchers.equalTo(Optional.of(42)));
        AbstractCoordinatorTestCase.assertThat(this.spec.nextState(7, 42, null), (Matcher)Matchers.equalTo(Optional.of(42)));
        AbstractCoordinatorTestCase.assertThat(this.spec.nextState(7, null, 7), (Matcher)Matchers.equalTo(Optional.of(7)));
        AbstractCoordinatorTestCase.assertThat(this.spec.nextState(7, null, null), (Matcher)Matchers.equalTo(Optional.of(7)));
        AbstractCoordinatorTestCase.assertThat(this.spec.nextState(7, null, 42), (Matcher)Matchers.equalTo(Optional.empty()));
    }

    public class Cluster
    implements Releasable {
        static final long EXTREME_DELAY_VARIABILITY = 10000L;
        static final long DEFAULT_DELAY_VARIABILITY = 100L;
        final List<ClusterNode> clusterNodes;
        final DeterministicTaskQueue deterministicTaskQueue = new DeterministicTaskQueue();
        private boolean disruptStorage;
        final CoordinationMetadata.VotingConfiguration initialConfiguration;
        private final Set<String> disconnectedNodes = new HashSet<String>();
        private final Set<String> blackholedNodes = new HashSet<String>();
        private final Set<Tuple<String, String>> blackholedConnections = new HashSet<Tuple<String, String>>();
        private final Map<Long, ClusterState> committedStatesByVersion = new HashMap<Long, ClusterState>();
        private final LinearizabilityChecker.History history = new LinearizabilityChecker.History();
        private final CountingPageCacheRecycler countingPageCacheRecycler;
        private final Recycler<BytesRef> recycler;
        private final NodeHealthService nodeHealthService;
        private final CoordinatorStrategy coordinatorStrategy;
        @Nullable
        private List<TransportAddress> seedHostsList;
        private final DisruptableMockTransport.ConnectionStatus preferredUnknownNodeConnectionStatus = ESTestCase.randomFrom(DisruptableMockTransport.ConnectionStatus.DISCONNECTED, DisruptableMockTransport.ConnectionStatus.BLACK_HOLE);

        Cluster(int initialNodeCount) {
            this(initialNodeCount, true, Settings.EMPTY);
        }

        public Cluster(int initialNodeCount, boolean allNodesMasterEligible, Settings nodeSettings) {
            this(initialNodeCount, allNodesMasterEligible, nodeSettings, () -> new StatusInfo(StatusInfo.Status.HEALTHY, "healthy-info"));
        }

        Cluster(int initialNodeCount, boolean allNodesMasterEligible, Settings nodeSettings, NodeHealthService nodeHealthService) {
            this.nodeHealthService = nodeHealthService;
            this.countingPageCacheRecycler = new CountingPageCacheRecycler();
            this.recycler = new BytesRefRecycler((PageCacheRecycler)this.countingPageCacheRecycler);
            this.deterministicTaskQueue.setExecutionDelayVariabilityMillis(100L);
            this.coordinatorStrategy = AbstractCoordinatorTestCase.this.createCoordinatorStrategy();
            Assert.assertThat((Object)initialNodeCount, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            Set masterEligibleNodeIds = Sets.newHashSetWithExpectedSize((int)initialNodeCount);
            this.clusterNodes = new ArrayList<ClusterNode>(initialNodeCount);
            for (int i = 0; i < initialNodeCount; ++i) {
                ClusterNode clusterNode = new ClusterNode(AbstractCoordinatorTestCase.this.nextNodeIndex.getAndIncrement(), allNodesMasterEligible || i == 0 || ESTestCase.randomBoolean(), nodeSettings, nodeHealthService);
                this.clusterNodes.add(clusterNode);
                if (!clusterNode.getLocalNode().isMasterNode()) continue;
                masterEligibleNodeIds.add(clusterNode.getId());
            }
            this.initialConfiguration = new CoordinationMetadata.VotingConfiguration(new HashSet(ESTestCase.randomSubsetOf(ESTestCase.randomIntBetween(1, masterEligibleNodeIds.size()), masterEligibleNodeIds)));
            AbstractCoordinatorTestCase.this.logger.info("--> creating cluster of {} nodes (master-eligible nodes: {}) with initial configuration {}", (Object)initialNodeCount, (Object)masterEligibleNodeIds, (Object)this.initialConfiguration);
        }

        void addNodesAndStabilise(int newNodesCount) {
            this.addNodes(newNodesCount);
            this.stabilise(AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)PeerFinder.DISCOVERY_FIND_PEERS_INTERVAL_SETTING) + 100L + (long)(newNodesCount * 2) * 900L);
        }

        List<ClusterNode> addNodes(int newNodesCount) {
            AbstractCoordinatorTestCase.this.logger.info("--> adding {} nodes", (Object)newNodesCount);
            ArrayList<ClusterNode> addedNodes = new ArrayList<ClusterNode>();
            for (int i = 0; i < newNodesCount; ++i) {
                ClusterNode clusterNode = new ClusterNode(AbstractCoordinatorTestCase.this.nextNodeIndex.getAndIncrement(), true, Settings.EMPTY, this.nodeHealthService);
                addedNodes.add(clusterNode);
            }
            this.clusterNodes.addAll(addedNodes);
            return addedNodes;
        }

        int size() {
            return this.clusterNodes.size();
        }

        public void runRandomly() {
            this.runRandomly(true, true, 10000L);
        }

        void runRandomly(boolean allowReboots, boolean coolDown, long delayVariability) {
            Assert.assertThat((String)"may reconnect disconnected nodes, probably unexpected", this.disconnectedNodes, (Matcher)Matchers.empty());
            Assert.assertThat((String)"may reconnect blackholed nodes, probably unexpected", this.blackholedNodes, (Matcher)Matchers.empty());
            ArrayList<Runnable> cleanupActions = new ArrayList<Runnable>();
            cleanupActions.add(this.disconnectedNodes::clear);
            cleanupActions.add(this.blackholedNodes::clear);
            cleanupActions.add(() -> {
                this.disruptStorage = false;
            });
            int randomSteps = ESTestCase.scaledRandomIntBetween(10, 10000);
            int keyRange = randomSteps / 50;
            AbstractCoordinatorTestCase.this.logger.info("--> start of safety phase of at least [{}] steps with delay variability of [{}ms]", (Object)randomSteps, (Object)delayVariability);
            this.deterministicTaskQueue.setExecutionDelayVariabilityMillis(delayVariability);
            this.disruptStorage = true;
            int step = 0;
            long finishTime = -1L;
            while (finishTime == -1L || this.deterministicTaskQueue.getCurrentTimeMillis() <= finishTime) {
                int thisStep = ++step;
                if (randomSteps <= step && finishTime == -1L) {
                    if (coolDown) {
                        this.disconnectedNodes.clear();
                        this.blackholedNodes.clear();
                        this.deterministicTaskQueue.setExecutionDelayVariabilityMillis(100L);
                        AbstractCoordinatorTestCase.this.logger.debug("----> [runRandomly {}] reducing delay variability and running until [{}ms]", (Object)step, (Object)finishTime);
                    } else {
                        AbstractCoordinatorTestCase.this.logger.debug("----> [runRandomly {}] running until [{}ms] with delay variability of [{}ms]", (Object)step, (Object)finishTime, (Object)this.deterministicTaskQueue.getExecutionDelayVariabilityMillis());
                    }
                    finishTime = this.deterministicTaskQueue.getLatestDeferredExecutionTime();
                }
                try {
                    if (finishTime == -1L && ESTestCase.randomBoolean() && ESTestCase.randomBoolean() && ESTestCase.randomBoolean()) {
                        clusterNode = this.getAnyNodePreferringLeaders();
                        key = ESTestCase.randomIntBetween(0, keyRange);
                        int newValue = ESTestCase.randomInt();
                        clusterNode.onNode(() -> {
                            AbstractCoordinatorTestCase.this.logger.debug("----> [runRandomly {}] proposing new value [{}={}] to [{}]", (Object)thisStep, (Object)key, (Object)newValue, (Object)clusterNode.getId());
                            clusterNode.submitValue(key, newValue);
                        }).run();
                    } else if (finishTime == -1L && ESTestCase.randomBoolean() && ESTestCase.randomBoolean() && ESTestCase.randomBoolean()) {
                        clusterNode = this.getAnyNodePreferringLeaders();
                        key = ESTestCase.randomIntBetween(0, keyRange);
                        clusterNode.onNode(() -> {
                            AbstractCoordinatorTestCase.this.logger.debug("----> [runRandomly {}] reading value from [{}]", (Object)thisStep, (Object)clusterNode.getId());
                            clusterNode.readValue(key);
                        }).run();
                    } else if (LuceneTestCase.rarely()) {
                        clusterNode = this.getAnyNodePreferringLeaders();
                        boolean autoShrinkVotingConfiguration = ESTestCase.randomBoolean();
                        clusterNode.onNode(() -> {
                            AbstractCoordinatorTestCase.this.logger.debug("----> [runRandomly {}] setting auto-shrink configuration to {} on {}", (Object)thisStep, (Object)autoShrinkVotingConfiguration, (Object)clusterNode.getId());
                            clusterNode.submitSetAutoShrinkVotingConfiguration(autoShrinkVotingConfiguration);
                        }).run();
                    } else if (allowReboots && LuceneTestCase.rarely()) {
                        clusterNode = this.getAnyNode();
                        AbstractCoordinatorTestCase.this.logger.debug("----> [runRandomly {}] rebooting [{}]", (Object)thisStep, (Object)clusterNode.getId());
                        clusterNode.close();
                        this.clusterNodes.forEach(cn -> this.deterministicTaskQueue.scheduleNow(cn.onNode(new Runnable(){
                            final /* synthetic */ ClusterNode val$cn;
                            final /* synthetic */ ClusterNode val$clusterNode;
                            {
                                this.val$cn = clusterNode;
                                this.val$clusterNode = clusterNode2;
                            }

                            @Override
                            public void run() {
                                this.val$cn.transportService.disconnectFromNode(this.val$clusterNode.getLocalNode());
                            }

                            public String toString() {
                                return "disconnect from " + this.val$clusterNode.getLocalNode() + " after shutdown";
                            }
                        })));
                        this.clusterNodes.replaceAll(cn -> cn == clusterNode ? cn.restartedNode() : cn);
                    } else if (LuceneTestCase.rarely()) {
                        clusterNode = this.getAnyNode();
                        clusterNode.onNode(() -> {
                            AbstractCoordinatorTestCase.this.logger.debug("----> [runRandomly {}] forcing {} to become candidate", (Object)thisStep, (Object)clusterNode.getId());
                            Object object = clusterNode.coordinator.mutex;
                            synchronized (object) {
                                clusterNode.coordinator.becomeCandidate("runRandomly");
                            }
                        }).run();
                    } else if (LuceneTestCase.rarely()) {
                        clusterNode = this.getAnyNode();
                        switch (ESTestCase.randomInt(2)) {
                            case 0: {
                                if (!clusterNode.heal()) break;
                                AbstractCoordinatorTestCase.this.logger.debug("----> [runRandomly {}] healing {}", (Object)step, (Object)clusterNode.getId());
                                break;
                            }
                            case 1: {
                                if (finishTime != -1L || !clusterNode.disconnect()) break;
                                AbstractCoordinatorTestCase.this.logger.debug("----> [runRandomly {}] disconnecting {}", (Object)step, (Object)clusterNode.getId());
                                break;
                            }
                            case 2: {
                                if (finishTime != -1L || !clusterNode.blackhole()) break;
                                AbstractCoordinatorTestCase.this.logger.debug("----> [runRandomly {}] blackholing {}", (Object)step, (Object)clusterNode.getId());
                            }
                        }
                    } else if (LuceneTestCase.rarely()) {
                        clusterNode = this.getAnyNode();
                        AbstractCoordinatorTestCase.this.logger.debug("----> [runRandomly {}] applying initial configuration on {}", (Object)step, (Object)clusterNode.getId());
                        clusterNode.applyInitialConfiguration();
                    } else if (LuceneTestCase.rarely()) {
                        clusterNode = this.getAnyNode();
                        AbstractCoordinatorTestCase.this.logger.debug("----> [runRandomly {}] completing blackholed requests sent by {}", (Object)step, (Object)clusterNode.getId());
                        clusterNode.deliverBlackholedRequests();
                    } else if (this.deterministicTaskQueue.hasDeferredTasks() && ESTestCase.randomBoolean()) {
                        this.deterministicTaskQueue.advanceTime();
                    } else if (this.deterministicTaskQueue.hasRunnableTasks()) {
                        this.deterministicTaskQueue.runRandomTask();
                    }
                }
                catch (UncheckedIOException | CoordinationStateRejectedException throwable) {
                    // empty catch block
                }
                this.assertConsistentStates();
            }
            AbstractCoordinatorTestCase.this.logger.debug("delivering pending blackholed requests");
            this.clusterNodes.forEach(ClusterNode::deliverBlackholedRequests);
            AbstractCoordinatorTestCase.this.logger.debug("running {} cleanup actions", (Object)cleanupActions.size());
            cleanupActions.forEach(Runnable::run);
            AbstractCoordinatorTestCase.this.logger.debug("finished running cleanup actions");
        }

        private void assertConsistentStates() {
            for (ClusterNode clusterNode : this.clusterNodes) {
                clusterNode.coordinator.invariant();
            }
            this.updateCommittedStates();
        }

        private void updateCommittedStates() {
            for (ClusterNode clusterNode : this.clusterNodes) {
                ClusterState applierState = clusterNode.coordinator.getApplierState();
                ClusterState storedState = this.committedStatesByVersion.get(applierState.getVersion());
                if (storedState == null) {
                    this.committedStatesByVersion.put(applierState.getVersion(), applierState);
                    continue;
                }
                if (AbstractCoordinatorTestCase.this.value(applierState) == AbstractCoordinatorTestCase.this.value(storedState)) continue;
                Assert.fail((String)("expected " + applierState + " but got " + storedState));
            }
        }

        public void stabilise() {
            this.stabilise(DEFAULT_STABILISATION_TIME, true);
        }

        public void stabilise(long stabilisationDurationMillis) {
            this.stabilise(stabilisationDurationMillis, false);
        }

        private void stabilise(long stabilisationDurationMillis, boolean expectIdleJoinValidationService) {
            Assert.assertThat((String)"stabilisation requires default delay variability (and proper cleanup of raised variability)", (Object)this.deterministicTaskQueue.getExecutionDelayVariabilityMillis(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(100L)));
            Assert.assertFalse((String)"stabilisation requires stable storage", (boolean)this.disruptStorage);
            this.bootstrapIfNecessary();
            this.runFor(stabilisationDurationMillis, "stabilising");
            while (this.clusterNodes.stream().filter(ClusterNode::deliverBlackholedRegisterRequests).count() != 0L) {
                AbstractCoordinatorTestCase.this.logger.debug("--> delivering blackholed register requests");
                this.runFor(200L, "re-stabilising");
            }
            ClusterNode leader = this.getAnyLeader();
            long leaderTerm = leader.coordinator.getCurrentTerm();
            int pendingTaskCount = leader.getPendingTaskCount();
            this.runFor((long)(pendingTaskCount + 1) * 900L, "draining task queue");
            Matcher isEqualToLeaderVersion = Matchers.equalTo((Object)leader.coordinator.getLastAcceptedState().getVersion());
            String leaderId = leader.getId();
            Assert.assertTrue((String)(leaderId + " has been bootstrapped"), (boolean)leader.coordinator.isInitialConfigurationSet());
            Assert.assertTrue((String)(leaderId + " exists in its last-applied state"), (boolean)leader.getLastAppliedClusterState().getNodes().nodeExists(leaderId));
            Assert.assertThat((String)(leaderId + " has no NO_MASTER_BLOCK"), (Object)leader.getLastAppliedClusterState().blocks().hasGlobalBlockWithId(2), (Matcher)Matchers.equalTo((Object)false));
            Assert.assertThat((String)(leaderId + " has no STATE_NOT_RECOVERED_BLOCK"), (Object)leader.getLastAppliedClusterState().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK), (Matcher)Matchers.equalTo((Object)false));
            Assert.assertThat((String)(leaderId + " has applied its state "), (Object)leader.getLastAppliedClusterState().getVersion(), (Matcher)isEqualToLeaderVersion);
            String clusterUuid = leader.getLastAppliedClusterState().metadata().clusterUUID();
            for (ClusterNode clusterNode : this.clusterNodes) {
                String nodeId = clusterNode.getId();
                Assert.assertFalse((String)(nodeId + " should not have an active publication"), (boolean)clusterNode.coordinator.publicationInProgress());
                if (clusterNode == leader) {
                    Assert.assertThat((String)(nodeId + " is still the leader"), (Object)clusterNode.coordinator.getMode(), (Matcher)Matchers.is((Object)Coordinator.Mode.LEADER));
                    Assert.assertThat((String)(nodeId + " did not change term"), (Object)clusterNode.coordinator.getCurrentTerm(), (Matcher)Matchers.is((Object)leaderTerm));
                    continue;
                }
                if (this.isConnectedPair(leader, clusterNode)) {
                    Assert.assertThat((String)(nodeId + " is a follower of " + leaderId), (Object)clusterNode.coordinator.getMode(), (Matcher)Matchers.is((Object)Coordinator.Mode.FOLLOWER));
                    Assert.assertThat((String)(nodeId + " has the same term as " + leaderId), (Object)clusterNode.coordinator.getCurrentTerm(), (Matcher)Matchers.is((Object)leaderTerm));
                    Assert.assertFalse((String)(nodeId + " is not a missing vote for  " + leaderId), (boolean)leader.coordinator.missingJoinVoteFrom(clusterNode.getLocalNode()));
                    Assert.assertThat((String)(nodeId + " has the same accepted state as " + leaderId), (Object)clusterNode.coordinator.getLastAcceptedState().getVersion(), (Matcher)isEqualToLeaderVersion);
                    if (clusterNode.getClusterStateApplyResponse() == ClusterStateApplyResponse.SUCCEED) {
                        Assert.assertThat((String)(nodeId + " has the same applied state as " + leaderId), (Object)clusterNode.getLastAppliedClusterState().getVersion(), (Matcher)isEqualToLeaderVersion);
                        Assert.assertTrue((String)(nodeId + " is in its own latest applied state"), (boolean)clusterNode.getLastAppliedClusterState().getNodes().nodeExists(nodeId));
                    }
                    Assert.assertTrue((String)(nodeId + " is in the latest applied state on " + leaderId), (boolean)leader.getLastAppliedClusterState().getNodes().nodeExists(nodeId));
                    Assert.assertTrue((String)(nodeId + " has been bootstrapped"), (boolean)clusterNode.coordinator.isInitialConfigurationSet());
                    Assert.assertThat((String)(nodeId + " has correct master"), (Object)clusterNode.getLastAppliedClusterState().nodes().getMasterNode(), (Matcher)Matchers.equalTo((Object)leader.getLocalNode()));
                    Assert.assertThat((String)(nodeId + " has no NO_MASTER_BLOCK"), (Object)clusterNode.getLastAppliedClusterState().blocks().hasGlobalBlockWithId(2), (Matcher)Matchers.equalTo((Object)false));
                    Assert.assertThat((String)(nodeId + " has no STATE_NOT_RECOVERED_BLOCK"), (Object)clusterNode.getLastAppliedClusterState().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK), (Matcher)Matchers.equalTo((Object)false));
                    Assert.assertTrue((String)(nodeId + " has locked into the cluster"), (boolean)clusterNode.getLastAppliedClusterState().metadata().clusterUUIDCommitted());
                    Assert.assertThat((String)(nodeId + " has the correct cluster UUID"), (Object)clusterNode.getLastAppliedClusterState().metadata().clusterUUID(), (Matcher)Matchers.equalTo((Object)clusterUuid));
                    for (ClusterNode otherNode : this.clusterNodes) {
                        if (!this.isConnectedPair(leader, otherNode) || !this.isConnectedPair(otherNode, clusterNode)) continue;
                        Assert.assertTrue((String)(otherNode.getId() + " is connected to healthy node " + clusterNode.getId()), (boolean)otherNode.transportService.nodeConnected(clusterNode.localNode));
                    }
                } else {
                    Assert.assertThat((String)(nodeId + " is not following " + leaderId), (Object)clusterNode.coordinator.getMode(), (Matcher)Matchers.is((Object)Coordinator.Mode.CANDIDATE));
                    Assert.assertThat((String)(nodeId + " has no master"), (Object)clusterNode.getLastAppliedClusterState().nodes().getMasterNode(), (Matcher)Matchers.nullValue());
                    Assert.assertThat((String)(nodeId + " has NO_MASTER_BLOCK"), (Object)clusterNode.getLastAppliedClusterState().blocks().hasGlobalBlockWithId(2), (Matcher)Matchers.equalTo((Object)true));
                    Assert.assertFalse((String)(nodeId + " is not in the applied state on " + leaderId), (boolean)leader.getLastAppliedClusterState().getNodes().nodeExists(nodeId));
                    for (ClusterNode otherNode : this.clusterNodes) {
                        if (!this.isConnectedPair(leader, otherNode)) continue;
                        Assert.assertFalse((String)(otherNode.getId() + " is not connected to removed node " + clusterNode.getId()), (boolean)otherNode.transportService.nodeConnected(clusterNode.localNode));
                    }
                }
                Assert.assertTrue((String)(nodeId + " is not scheduling elections"), (!clusterNode.coordinator.electionSchedulerActive() || !this.coordinatorStrategy.verifyElectionSchedulerState(clusterNode) ? 1 : 0) != 0);
                if (!expectIdleJoinValidationService) continue;
                Assert.assertTrue((String)(nodeId + " has an idle join validation service"), (boolean)clusterNode.coordinator.hasIdleJoinValidationService());
            }
            Set connectedNodeIds = this.clusterNodes.stream().filter(n -> this.isConnectedPair(leader, (ClusterNode)n)).map(ClusterNode::getId).collect(Collectors.toSet());
            Assert.assertThat((Object)leader.getLastAppliedClusterState().getNodes().getSize(), (Matcher)Matchers.equalTo((Object)connectedNodeIds.size()));
            ClusterState lastAcceptedState = leader.coordinator.getLastAcceptedState();
            CoordinationMetadata.VotingConfiguration lastCommittedConfiguration = lastAcceptedState.getLastCommittedConfiguration();
            Assert.assertTrue((String)(connectedNodeIds + " should be a quorum of " + lastCommittedConfiguration), (boolean)lastCommittedConfiguration.hasQuorum(connectedNodeIds));
            Assert.assertThat((String)("leader " + leader.getLocalNode() + " should be part of voting configuration " + lastCommittedConfiguration), (Object)lastCommittedConfiguration.getNodeIds(), (Matcher)Matchers.hasItem((Object)leader.getLocalNode().getId()));
            Assert.assertThat((String)"no reconfiguration is in progress", (Object)lastAcceptedState.getLastCommittedConfiguration(), (Matcher)Matchers.equalTo((Object)lastAcceptedState.getLastAcceptedConfiguration()));
            leader.onNode(() -> Assert.assertThat((String)"current configuration is already optimal", (Object)leader.improveConfiguration(lastAcceptedState), (Matcher)Matchers.sameInstance((Object)lastAcceptedState)));
            AbstractCoordinatorTestCase.this.logger.info("checking linearizability of history with size {}: {}", (Object)this.history.size(), (Object)this.history);
            try {
                boolean linearizable = LinearizabilityChecker.isLinearizable(AbstractCoordinatorTestCase.this.spec, this.history, i -> null);
                Assert.assertTrue((String)("history is not linearizable: " + this.history), (boolean)linearizable);
            }
            catch (LinearizabilityChecker.LinearizabilityCheckAborted e) {
                AbstractCoordinatorTestCase.this.logger.warn("linearizability check check was aborted", (Throwable)e);
            }
        }

        void bootstrapIfNecessary() {
            if (this.clusterNodes.stream().allMatch(ClusterNode::isNotUsefullyBootstrapped)) {
                Assert.assertThat((String)"setting initial configuration may fail with disconnected nodes", this.disconnectedNodes, (Matcher)Matchers.empty());
                Assert.assertThat((String)"setting initial configuration may fail with blackholed nodes", this.blackholedNodes, (Matcher)Matchers.empty());
                this.runFor(AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)TransportSettings.CONNECT_TIMEOUT) + AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)PeerFinder.DISCOVERY_FIND_PEERS_INTERVAL_SETTING) * 2L, "discovery prior to setting initial configuration");
                ClusterNode bootstrapNode = this.getAnyBootstrappableNode();
                bootstrapNode.applyInitialConfiguration();
            } else {
                AbstractCoordinatorTestCase.this.logger.info("setting initial configuration not required");
            }
        }

        void runFor(long runDurationMillis, String description) {
            long endTime = this.deterministicTaskQueue.getCurrentTimeMillis() + runDurationMillis;
            AbstractCoordinatorTestCase.this.logger.info("--> runFor({}ms) running until [{}ms]: {}", (Object)runDurationMillis, (Object)endTime, (Object)description);
            while (this.deterministicTaskQueue.getCurrentTimeMillis() < endTime) {
                while (this.deterministicTaskQueue.hasRunnableTasks()) {
                    try {
                        this.deterministicTaskQueue.runRandomTask();
                    }
                    catch (CoordinationStateRejectedException e) {
                        AbstractCoordinatorTestCase.this.logger.debug("ignoring benign exception thrown when stabilising", (Throwable)e);
                    }
                    for (ClusterNode clusterNode : this.clusterNodes) {
                        clusterNode.coordinator.invariant();
                    }
                    this.updateCommittedStates();
                }
                if (!this.deterministicTaskQueue.hasDeferredTasks()) {
                    assert (this.clusterNodes.size() == 1) : this.clusterNodes.size();
                    break;
                }
                this.deterministicTaskQueue.advanceTime();
            }
            AbstractCoordinatorTestCase.this.logger.info("--> runFor({}ms) completed run until [{}ms]: {}", (Object)runDurationMillis, (Object)endTime, (Object)description);
        }

        private boolean isConnectedPair(ClusterNode n1, ClusterNode n2) {
            return n1 == n2 || this.getConnectionStatus(n1.getLocalNode(), n2.getLocalNode()) == DisruptableMockTransport.ConnectionStatus.CONNECTED && this.getConnectionStatus(n2.getLocalNode(), n1.getLocalNode()) == DisruptableMockTransport.ConnectionStatus.CONNECTED && n1.nodeHealthService.getHealth().getStatus() == StatusInfo.Status.HEALTHY && n2.nodeHealthService.getHealth().getStatus() == StatusInfo.Status.HEALTHY;
        }

        public ClusterNode getAnyLeader() {
            List allLeaders = this.clusterNodes.stream().filter(ClusterNode::isLeader).collect(Collectors.toList());
            Assert.assertThat((String)"leaders", allLeaders, (Matcher)Matchers.not((Matcher)Matchers.empty()));
            return (ClusterNode)ESTestCase.randomFrom(allLeaders);
        }

        private DisruptableMockTransport.ConnectionStatus getConnectionStatus(DiscoveryNode sender, DiscoveryNode destination) {
            DisruptableMockTransport.ConnectionStatus connectionStatus = this.blackholedNodes.contains(sender.getId()) || this.blackholedNodes.contains(destination.getId()) ? DisruptableMockTransport.ConnectionStatus.BLACK_HOLE : (this.disconnectedNodes.contains(sender.getId()) || this.disconnectedNodes.contains(destination.getId()) ? DisruptableMockTransport.ConnectionStatus.DISCONNECTED : (this.blackholedConnections.contains(Tuple.tuple((Object)sender.getId(), (Object)destination.getId())) ? DisruptableMockTransport.ConnectionStatus.BLACK_HOLE_REQUESTS_ONLY : (this.nodeExists(sender) && this.nodeExists(destination) ? DisruptableMockTransport.ConnectionStatus.CONNECTED : (LuceneTestCase.usually() ? this.preferredUnknownNodeConnectionStatus : ESTestCase.randomFrom(DisruptableMockTransport.ConnectionStatus.DISCONNECTED, DisruptableMockTransport.ConnectionStatus.BLACK_HOLE)))));
            return connectionStatus;
        }

        boolean nodeExists(DiscoveryNode node) {
            return this.clusterNodes.stream().anyMatch(cn -> cn.getLocalNode().equals((Object)node));
        }

        ClusterNode getAnyBootstrappableNode() {
            return (ClusterNode)ESTestCase.randomFrom(this.clusterNodes.stream().filter(n -> n.getLocalNode().isMasterNode()).filter(n -> this.initialConfiguration.getNodeIds().contains(n.getLocalNode().getId())).collect(Collectors.toList()));
        }

        ClusterNode getAnyNode() {
            return this.getAnyNodeExcept(new ClusterNode[0]);
        }

        ClusterNode getAnyNodeExcept(ClusterNode ... clusterNodesToExclude) {
            List<ClusterNode> filteredNodes = this.getAllNodesExcept(clusterNodesToExclude);
            assert (!filteredNodes.isEmpty());
            return ESTestCase.randomFrom(filteredNodes);
        }

        List<ClusterNode> getAllNodesExcept(ClusterNode ... clusterNodesToExclude) {
            Set forbiddenIds = Arrays.stream(clusterNodesToExclude).map(ClusterNode::getId).collect(Collectors.toSet());
            return this.clusterNodes.stream().filter(n -> !forbiddenIds.contains(n.getId())).collect(Collectors.toList());
        }

        ClusterNode getAnyNodePreferringLeaders() {
            for (int i = 0; i < 3; ++i) {
                ClusterNode clusterNode = this.getAnyNode();
                if (clusterNode.coordinator.getMode() != Coordinator.Mode.LEADER) continue;
                return clusterNode;
            }
            return this.getAnyNode();
        }

        void setEmptySeedHostsList() {
            this.seedHostsList = Collections.emptyList();
        }

        void blackholeConnectionsFrom(ClusterNode sender, ClusterNode destination) {
            this.blackholedConnections.add((Tuple<String, String>)Tuple.tuple((Object)sender.getId(), (Object)destination.getId()));
        }

        void clearBlackholedConnections() {
            this.blackholedConnections.clear();
        }

        CoordinatorStrategy getCoordinatorStrategy() {
            return this.coordinatorStrategy;
        }

        public void close() {
            while (this.clusterNodes.stream().filter(ClusterNode::deliverBlackholedRequests).count() != 0L) {
                AbstractCoordinatorTestCase.this.logger.debug("--> stabilising again after delivering blackholed requests");
                this.stabilise(DEFAULT_STABILISATION_TIME);
            }
            this.clusterNodes.forEach(ClusterNode::close);
            this.runFor(100L, "accumulate close-time tasks");
            this.deterministicTaskQueue.runAllRunnableTasks();
            this.countingPageCacheRecycler.assertAllPagesReleased();
            this.coordinatorStrategy.close();
        }

        protected List<NamedWriteableRegistry.Entry> extraNamedWriteables() {
            return Collections.emptyList();
        }

        private NamedWriteableRegistry getNamedWriteableRegistry() {
            return new NamedWriteableRegistry(Stream.concat(ClusterModule.getNamedWriteables().stream(), this.extraNamedWriteables().stream()).collect(Collectors.toList()));
        }

        CoordinationState.PersistedState createFreshPersistedState(DiscoveryNode localNode, ThreadPool threadPool) {
            return this.coordinatorStrategy.createFreshPersistedState(localNode, () -> this.disruptStorage, threadPool);
        }

        CoordinationState.PersistedState createPersistedStateFromExistingState(DiscoveryNode newLocalNode, CoordinationState.PersistedState oldState, Function<Metadata, Metadata> adaptGlobalMetadata, Function<Long, Long> adaptCurrentTerm, ThreadPool threadPool) {
            return this.coordinatorStrategy.createPersistedStateFromExistingState(newLocalNode, oldState, adaptGlobalMetadata, adaptCurrentTerm, this.deterministicTaskQueue::getCurrentTimeMillis, this.getNamedWriteableRegistry(), () -> this.disruptStorage, threadPool);
        }

        protected long transportDelayMillis(String actionName) {
            return 0L;
        }

        private List<TransportAddress> provideSeedHosts(SeedHostsProvider.HostsResolver ignored) {
            return this.seedHostsList != null ? this.seedHostsList : this.clusterNodes.stream().map(ClusterNode::getLocalNode).map(DiscoveryNode::getAddress).collect(Collectors.toList());
        }

        public final class ClusterNode {
            private static final Logger logger = LogManager.getLogger(ClusterNode.class);
            private final int nodeIndex;
            Coordinator coordinator;
            private final DiscoveryNode localNode;
            final CoordinationState.PersistedState persistedState;
            final Settings nodeSettings;
            private AckedFakeThreadPoolMasterService masterService;
            private DisruptableClusterApplierService clusterApplierService;
            private ClusterService clusterService;
            private FeatureService featureService;
            TransportService transportService;
            private MasterHistoryService masterHistoryService;
            CoordinationDiagnosticsService coordinationDiagnosticsService;
            StableMasterHealthIndicatorService stableMasterHealthIndicatorService;
            private DisruptableMockTransport mockTransport;
            private final NodeHealthService nodeHealthService;
            List<BiConsumer<DiscoveryNode, ClusterState>> extraJoinValidators = new ArrayList<BiConsumer<DiscoveryNode, ClusterState>>();
            private ClearableRecycler clearableRecycler;
            private List<Runnable> blackholedRegisterOperations = new ArrayList<Runnable>();

            ClusterNode(int nodeIndex, boolean masterEligible, Settings nodeSettings, NodeHealthService nodeHealthService) {
                this(nodeIndex, this$1.AbstractCoordinatorTestCase.this.createDiscoveryNode(nodeIndex, masterEligible), this$1::createFreshPersistedState, nodeSettings, nodeHealthService);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            ClusterNode(int nodeIndex, DiscoveryNode localNode, BiFunction<DiscoveryNode, ThreadPool, CoordinationState.PersistedState> persistedStateSupplier, Settings nodeSettings, NodeHealthService nodeHealthService) {
                this.nodeHealthService = nodeHealthService;
                this.nodeIndex = nodeIndex;
                this.localNode = localNode;
                this.nodeSettings = nodeSettings;
                ThreadPool threadPool = Cluster.this.deterministicTaskQueue.getThreadPool(this::onNode);
                this.persistedState = persistedStateSupplier.apply(localNode, threadPool);
                Assert.assertTrue((String)"must use a fresh PersistedState", (boolean)AbstractCoordinatorTestCase.this.openPersistedStates.add(this.persistedState));
                boolean success = false;
                try {
                    DeterministicTaskQueue.onNodeLog(localNode, () -> this.setUp(threadPool)).run();
                    success = true;
                }
                finally {
                    if (!success) {
                        IOUtils.closeWhileHandlingException((Closeable)this.persistedState);
                    }
                }
            }

            private void setUp(ThreadPool threadPool) {
                this.clearableRecycler = new ClearableRecycler(Cluster.this.recycler);
                this.mockTransport = new DisruptableMockTransport(this.localNode, Cluster.this.deterministicTaskQueue){

                    @Override
                    protected void execute(Runnable runnable) {
                        Cluster.this.deterministicTaskQueue.scheduleNow(ClusterNode.this.onNode(runnable));
                    }

                    @Override
                    protected DisruptableMockTransport.ConnectionStatus getConnectionStatus(DiscoveryNode destination) {
                        return Cluster.this.getConnectionStatus(this.getLocalNode(), destination);
                    }

                    @Override
                    protected Optional<DisruptableMockTransport> getDisruptableMockTransport(TransportAddress address) {
                        return Cluster.this.clusterNodes.stream().map(cn -> cn.mockTransport).filter(transport -> transport.getLocalNode().getAddress().equals((Object)address)).findAny();
                    }

                    @Override
                    protected void onSendRequest(final long requestId, final String action, TransportRequest request, TransportRequestOptions options, final DisruptableMockTransport destinationTransport) {
                        TransportRequestOptions.Type chanType = options.type();
                        switch (action) {
                            case "internal:cluster/coordination/join": 
                            case "internal:coordination/fault_detection/follower_check": 
                            case "internal:coordination/fault_detection/leader_check": {
                                Assert.assertThat((String)action, (Object)chanType, (Matcher)Matchers.equalTo((Object)TransportRequestOptions.Type.PING));
                                break;
                            }
                            case "internal:cluster/coordination/join/validate": 
                            case "internal:cluster/coordination/publish_state": 
                            case "internal:cluster/coordination/commit_state": {
                                Assert.assertThat((String)action, (Object)chanType, (Matcher)Matchers.equalTo((Object)TransportRequestOptions.Type.STATE));
                                break;
                            }
                            case "internal:cluster/coordination/join/ping": {
                                Assert.assertThat((String)action, (Object)chanType, (Matcher)Matchers.oneOf((Object[])new TransportRequestOptions.Type[]{TransportRequestOptions.Type.STATE, TransportRequestOptions.Type.PING}));
                                break;
                            }
                            default: {
                                Assert.assertThat((String)action, (Object)chanType, (Matcher)Matchers.equalTo((Object)TransportRequestOptions.Type.REG));
                            }
                        }
                        long transportDelayMillis = Cluster.this.transportDelayMillis(action);
                        final Runnable delivery = () -> super.onSendRequest(requestId, action, request, options, destinationTransport);
                        if (transportDelayMillis > 0L) {
                            Cluster.this.deterministicTaskQueue.scheduleAt(Cluster.this.deterministicTaskQueue.getCurrentTimeMillis() + transportDelayMillis, ClusterNode.this.onNode(new Runnable(){

                                @Override
                                public void run() {
                                    delivery.run();
                                }

                                public String toString() {
                                    return org.elasticsearch.common.Strings.format((String)"delayed onSendRequest for [%d][%s] from [%s] to [%s]", (Object[])new Object[]{requestId, action, ClusterNode.this.localNode, destinationTransport.getLocalNode()});
                                }
                            }));
                        } else {
                            delivery.run();
                        }
                    }

                    @Override
                    public RecyclerBytesStreamOutput newNetworkBytesStream() {
                        return new RecyclerBytesStreamOutput((Recycler)ClusterNode.this.clearableRecycler);
                    }
                };
                Settings settings = this.nodeSettings.hasValue(DiscoveryModule.DISCOVERY_TYPE_SETTING.getKey()) ? this.nodeSettings : Settings.builder().put(this.nodeSettings).putList(ClusterBootstrapService.INITIAL_MASTER_NODES_SETTING.getKey(), (List)ClusterBootstrapService.INITIAL_MASTER_NODES_SETTING.get(Settings.EMPTY)).build();
                this.transportService = this.mockTransport.createTransportService(settings, threadPool, AbstractCoordinatorTestCase.this.getTransportInterceptor(this.localNode, threadPool), a -> this.localNode, null, Collections.emptySet());
                this.masterService = new AckedFakeThreadPoolMasterService(this.localNode.getId(), threadPool, runnable -> Cluster.this.deterministicTaskQueue.scheduleNow(this.onNode((Runnable)runnable)));
                ClusterSettings clusterSettings = new ClusterSettings(settings, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS);
                this.clusterApplierService = new DisruptableClusterApplierService(this.localNode.getId(), this.localNode.getEphemeralId(), settings, clusterSettings, Cluster.this.deterministicTaskQueue, this::onNode, threadPool);
                this.clusterService = new ClusterService(settings, clusterSettings, (MasterService)this.masterService, (ClusterApplierService)this.clusterApplierService);
                this.featureService = new FeatureService(List.of());
                this.masterHistoryService = new MasterHistoryService(this.transportService, threadPool, this.clusterService);
                this.clusterService.setNodeConnectionsService(new NodeConnectionsService(this.clusterService.getSettings(), threadPool, this.transportService));
                List<BiConsumer<DiscoveryNode, ClusterState>> onJoinValidators = Collections.singletonList((dn, cs) -> this.extraJoinValidators.forEach(validator -> validator.accept(dn, cs)));
                ESAllocationTestCase.MockAllocationService allocationService = ESAllocationTestCase.createAllocationService(Settings.EMPTY);
                NodeClient client = new NodeClient(Settings.EMPTY, threadPool);
                CoordinationServices coordinationServices = Cluster.this.coordinatorStrategy.getCoordinationServices(threadPool, settings, clusterSettings, this.persistedState, new NodeDisruptibleRegisterConnection());
                this.coordinator = new Coordinator("test_node", settings, clusterSettings, this.transportService, (Client)client, Cluster.this.getNamedWriteableRegistry(), (AllocationService)allocationService, (MasterService)this.masterService, this::getPersistedState, Cluster.this::provideSeedHosts, (ClusterApplier)this.clusterApplierService, onJoinValidators, Randomness.get(), (s, p, r) -> {}, coordinationServices.getElectionStrategy(), this.nodeHealthService, (CircuitBreakerService)new NoneCircuitBreakerService(), coordinationServices.getReconfigurator(), coordinationServices.getLeaderHeartbeatService(), coordinationServices.getPreVoteCollectorFactory(), CompatibilityVersionsUtils.staticCurrent(), this.featureService);
                this.coordinationDiagnosticsService = new CoordinationDiagnosticsService(this.clusterService, this.transportService, this.coordinator, this.masterHistoryService);
                client.initialize(Map.of(TransportNodesHotThreadsAction.TYPE, new TransportNodesHotThreadsAction(threadPool, this.clusterService, this.transportService, new ActionFilters(Collections.emptySet())), MasterHistoryAction.INSTANCE, new MasterHistoryAction.TransportAction(this.transportService, new ActionFilters(Set.of()), this.masterHistoryService), ClusterFormationInfoAction.INSTANCE, new ClusterFormationInfoAction.TransportAction(this.transportService, new ActionFilters(Set.of()), this.coordinator), CoordinationDiagnosticsAction.INSTANCE, new CoordinationDiagnosticsAction.TransportAction(this.transportService, new ActionFilters(Set.of()), this.coordinationDiagnosticsService)), this.transportService.getTaskManager(), () -> ((DiscoveryNode)this.localNode).getId(), this.transportService.getLocalNodeConnection(), null, Cluster.this.getNamedWriteableRegistry());
                this.stableMasterHealthIndicatorService = new StableMasterHealthIndicatorService(this.coordinationDiagnosticsService, this.clusterService);
                this.masterService.setClusterStatePublisher((ClusterStatePublisher)this.coordinator);
                GatewayService gatewayService = new GatewayService(settings, (RerouteService)new BatchedRerouteService(this.clusterService, (arg_0, arg_1, arg_2) -> ((AllocationService)allocationService).reroute(arg_0, arg_1, arg_2)), this.clusterService, TestShardRoutingRoleStrategies.DEFAULT_ROLE_ONLY, threadPool);
                logger.trace("starting up [{}]", (Object)this.localNode);
                this.transportService.start();
                this.transportService.acceptIncomingRequests();
                this.coordinator.start();
                gatewayService.start();
                this.clusterService.start();
                this.coordinationDiagnosticsService.start();
                this.coordinator.startInitialJoin();
            }

            void close() {
                Assert.assertThat((String)"must add nodes to a cluster before closing them", Cluster.this.clusterNodes, (Matcher)Matchers.hasItem((Object)this));
                this.onNode(() -> {
                    logger.trace("closing");
                    this.coordinator.stop();
                    this.clusterService.stop();
                    this.clusterService.close();
                    this.coordinator.close();
                }).run();
            }

            ClusterNode restartedNode() {
                return this.restartedNode(Function.identity(), Function.identity(), this.nodeSettings);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            ClusterNode restartedNode(Function<Metadata, Metadata> adaptGlobalMetadata, Function<Long, Long> adaptCurrentTerm, Settings settings) {
                DiscoveryNode newLocalNode = DiscoveryNodeUtils.builder(this.localNode.getId()).name(this.localNode.getName()).ephemeralId(UUIDs.randomBase64UUID((Random)LuceneTestCase.random())).address(ESTestCase.randomBoolean() ? ESTestCase.buildNewFakeTransportAddress() : this.localNode.getAddress()).roles(this.localNode.isMasterNode() && DiscoveryNode.isMasterNode((Settings)settings) ? ALL_ROLES_EXCEPT_VOTING_ONLY : Collections.emptySet()).build();
                try {
                    ClusterNode clusterNode = new ClusterNode(this.nodeIndex, newLocalNode, (node, threadPool) -> Cluster.this.createPersistedStateFromExistingState(newLocalNode, this.persistedState, adaptGlobalMetadata, adaptCurrentTerm, (ThreadPool)threadPool), settings, this.nodeHealthService);
                    return clusterNode;
                }
                finally {
                    this.clearableRecycler.clear();
                }
            }

            private CoordinationState.PersistedState getPersistedState() {
                return this.persistedState;
            }

            String getId() {
                return this.localNode.getId();
            }

            public DiscoveryNode getLocalNode() {
                return this.localNode;
            }

            boolean isLeader() {
                return this.coordinator.getMode() == Coordinator.Mode.LEADER;
            }

            boolean isCandidate() {
                return this.coordinator.getMode() == Coordinator.Mode.CANDIDATE;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            ClusterState improveConfiguration(ClusterState currentState) {
                Object object = this.coordinator.mutex;
                synchronized (object) {
                    return this.coordinator.improveConfiguration(currentState);
                }
            }

            void setClusterStateApplyResponse(ClusterStateApplyResponse clusterStateApplyResponse) {
                this.clusterApplierService.clusterStateApplyResponse = clusterStateApplyResponse;
            }

            ClusterStateApplyResponse getClusterStateApplyResponse() {
                return this.clusterApplierService.clusterStateApplyResponse;
            }

            Runnable onNode(final Runnable runnable) {
                final Runnable wrapped = DeterministicTaskQueue.onNodeLog(this.localNode, runnable);
                return new Runnable(){

                    @Override
                    public void run() {
                        if (Cluster.this.clusterNodes.contains(ClusterNode.this)) {
                            wrapped.run();
                        } else if (runnable instanceof DisruptableMockTransport.RebootSensitiveRunnable) {
                            DisruptableMockTransport.RebootSensitiveRunnable rebootSensitiveRunnable = (DisruptableMockTransport.RebootSensitiveRunnable)runnable;
                            logger.trace("completing reboot-sensitive runnable {} from node {} as node has been removed from cluster", (Object)runnable, (Object)ClusterNode.this.localNode);
                            rebootSensitiveRunnable.ifRebooted();
                        } else {
                            logger.trace("ignoring runnable {} from node {} as node has been removed from cluster", (Object)runnable, (Object)ClusterNode.this.localNode);
                        }
                    }

                    public String toString() {
                        return wrapped.toString();
                    }
                };
            }

            void submitSetAutoShrinkVotingConfiguration(boolean autoShrinkVotingConfiguration) {
                this.submitUpdateTask("set master nodes failure tolerance [" + autoShrinkVotingConfiguration + "]", cs -> ClusterState.builder((ClusterState)cs).metadata(Metadata.builder((Metadata)cs.metadata()).persistentSettings(Settings.builder().put(cs.metadata().persistentSettings()).put(Reconfigurator.CLUSTER_AUTO_SHRINK_VOTING_CONFIGURATION.getKey(), autoShrinkVotingConfiguration).build()).build()).build(), e -> {});
            }

            AckCollector submitValue(long value) {
                return this.submitValue(0, value);
            }

            AckCollector submitValue(final int key, long value) {
                final int eventId = Cluster.this.history.invoke(new Tuple((Object)key, (Object)value));
                return this.submitUpdateTask("new value [" + key + "=" + value + "]", cs -> AbstractCoordinatorTestCase.this.setValue((ClusterState)cs, key, value), new CoordinatorTestClusterStateUpdateTask(){

                    @Override
                    public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                        Cluster.this.history.respond(eventId, AbstractCoordinatorTestCase.this.value(oldState, key));
                    }

                    public void onFailure(Exception e) {
                        if (!(e instanceof FailedToCommitClusterStateException)) {
                            Cluster.this.history.remove(eventId);
                        }
                    }
                });
            }

            void readValue(final int key) {
                final int eventId = Cluster.this.history.invoke(new Tuple((Object)key, null));
                this.submitUpdateTask("read value", cs -> ClusterState.builder((ClusterState)cs).build(), new CoordinatorTestClusterStateUpdateTask(){

                    @Override
                    public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                        Cluster.this.history.respond(eventId, AbstractCoordinatorTestCase.this.value(newState, key));
                    }

                    public void onFailure(Exception e) {
                        Cluster.this.history.remove(eventId);
                    }
                });
            }

            AckCollector submitUpdateTask(String source, final UnaryOperator<ClusterState> clusterStateUpdate, final CoordinatorTestClusterStateUpdateTask taskListener) {
                final AckCollector ackCollector = new AckCollector();
                this.onNode(() -> {
                    logger.trace("[{}] submitUpdateTask: enqueueing [{}]", (Object)this.localNode.getId(), (Object)source);
                    final long submittedTerm = this.coordinator.getCurrentTerm();
                    this.masterService.submitUnbatchedStateUpdateTask(source, new ClusterStateUpdateTask(){

                        public ClusterState execute(ClusterState currentState) {
                            Assert.assertThat((Object)currentState.term(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(submittedTerm)));
                            ClusterNode.this.masterService.nextAckCollector = ackCollector;
                            return (ClusterState)clusterStateUpdate.apply(currentState);
                        }

                        public void onFailure(Exception e) {
                            logger.debug("publication failed", (Throwable)e);
                            taskListener.onFailure(e);
                        }

                        public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                            Cluster.this.updateCommittedStates();
                            ClusterState state = Cluster.this.committedStatesByVersion.get(newState.version());
                            Assert.assertNotNull((String)("State not committed : " + newState), (Object)state);
                            boolean notRecovered = state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK);
                            Assert.assertEquals((Object)notRecovered, (Object)newState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK));
                            if (!notRecovered) {
                                AbstractCoordinatorTestCase.this.assertStateEquals(state, newState);
                            }
                            logger.trace("successfully published: [{}]", (Object)newState);
                            taskListener.clusterStateProcessed(oldState, newState);
                        }
                    });
                }).run();
                return ackCollector;
            }

            public String toString() {
                return this.localNode.toString();
            }

            boolean heal() {
                boolean unBlackholed = Cluster.this.blackholedNodes.remove(this.localNode.getId());
                boolean unDisconnected = Cluster.this.disconnectedNodes.remove(this.localNode.getId());
                assert (!unBlackholed || !unDisconnected);
                return unBlackholed || unDisconnected;
            }

            boolean disconnect() {
                boolean unBlackholed = Cluster.this.blackholedNodes.remove(this.localNode.getId());
                boolean disconnected = Cluster.this.disconnectedNodes.add(this.localNode.getId());
                assert (disconnected || !unBlackholed);
                return disconnected;
            }

            boolean blackhole() {
                boolean unDisconnected = Cluster.this.disconnectedNodes.remove(this.localNode.getId());
                boolean blackholed = Cluster.this.blackholedNodes.add(this.localNode.getId());
                assert (blackholed || !unDisconnected);
                return blackholed;
            }

            void onDisconnectEventFrom(ClusterNode clusterNode) {
                this.transportService.disconnectFromNode(clusterNode.localNode);
            }

            ClusterState getLastAppliedClusterState() {
                return this.clusterApplierService.state();
            }

            void addActionBlock(String actionName) {
                this.mockTransport.addActionBlock(actionName);
            }

            void clearActionBlocks() {
                this.mockTransport.clearActionBlocks();
            }

            void applyInitialConfiguration() {
                this.onNode(() -> {
                    HashSet nodeIdsWithPlaceholders = new HashSet(Cluster.this.initialConfiguration.getNodeIds());
                    Stream.generate(() -> "{bootstrap-placeholder}-" + UUIDs.randomBase64UUID((Random)LuceneTestCase.random())).limit((Math.max(Cluster.this.initialConfiguration.getNodeIds().size(), 2) - 1) / 2).forEach(nodeIdsWithPlaceholders::add);
                    HashSet<String> nodeIds = new HashSet<String>(ESTestCase.randomSubsetOf(Cluster.this.initialConfiguration.getNodeIds().size(), nodeIdsWithPlaceholders));
                    if (Cluster.this.initialConfiguration.getNodeIds().contains(this.localNode.getId()) && !nodeIds.contains(this.localNode.getId())) {
                        nodeIds.remove(nodeIds.iterator().next());
                        nodeIds.add(this.localNode.getId());
                    }
                    CoordinationMetadata.VotingConfiguration configurationWithPlaceholders = new CoordinationMetadata.VotingConfiguration(nodeIds);
                    try {
                        this.coordinator.setInitialConfiguration(configurationWithPlaceholders);
                        logger.info("successfully set initial configuration to {}", (Object)configurationWithPlaceholders);
                    }
                    catch (CoordinationStateRejectedException e) {
                        logger.info(() -> Strings.format((String)"failed to set initial configuration to %s", (Object[])new Object[]{configurationWithPlaceholders}), (Throwable)e);
                    }
                }).run();
            }

            private boolean isNotUsefullyBootstrapped() {
                return !this.getLocalNode().isMasterNode() || !this.coordinator.isInitialConfigurationSet();
            }

            void allowClusterStateApplicationFailure() {
                this.clusterApplierService.allowClusterStateApplicationFailure();
                this.masterService.allowPublicationFailure();
            }

            boolean deliverBlackholedRequests() {
                boolean deliveredBlackholedRequests = this.mockTransport.deliverBlackholedRequests();
                boolean deliveredBlackholedRegisterRequests = this.deliverBlackholedRegisterRequests();
                return deliveredBlackholedRequests || deliveredBlackholedRegisterRequests;
            }

            boolean deliverBlackholedRegisterRequests() {
                if (this.blackholedRegisterOperations.isEmpty()) {
                    return false;
                }
                this.blackholedRegisterOperations.forEach(Cluster.this.deterministicTaskQueue::scheduleNow);
                this.blackholedRegisterOperations.clear();
                return true;
            }

            int getPendingTaskCount() {
                return this.masterService.numberOfPendingTasks();
            }

            public boolean isRegisterDisconnected() {
                return Cluster.this.disconnectedNodes.contains(this.localNode.getId()) || this.getHealthStatus() != StatusInfo.Status.HEALTHY || Cluster.this.disruptStorage && LuceneTestCase.rarely();
            }

            public boolean isRegisterBlackholed() {
                return Cluster.this.blackholedNodes.contains(this.localNode.getId());
            }

            public StatusInfo.Status getHealthStatus() {
                return this.nodeHealthService.getHealth().getStatus();
            }

            private class NodeDisruptibleRegisterConnection
            implements DisruptibleRegisterConnection {
                private NodeDisruptibleRegisterConnection() {
                }

                @Override
                public <R> void runDisrupted(final ActionListener<R> listener, Consumer<ActionListener<R>> consumer) {
                    if (ClusterNode.this.isRegisterDisconnected()) {
                        listener.onFailure((Exception)new IOException("simulated disrupted connection to register"));
                    } else if (ClusterNode.this.isRegisterBlackholed()) {
                        final IOException exception = new IOException("simulated eventual failure to blackholed register");
                        logger.trace(() -> org.elasticsearch.common.Strings.format((String)"delaying failure of register request for [%s]", (Object[])new Object[]{listener}), (Throwable)exception);
                        ClusterNode.this.blackholedRegisterOperations.add(ClusterNode.this.onNode(new DisruptableMockTransport.RebootSensitiveRunnable(){

                            @Override
                            public void ifRebooted() {
                                this.run();
                            }

                            @Override
                            public void run() {
                                listener.onFailure((Exception)exception);
                            }

                            public String toString() {
                                return "simulated eventual failure to blackholed register: " + listener;
                            }
                        }));
                    } else {
                        consumer.accept(listener);
                    }
                }

                @Override
                public <R> void runDisruptedOrDrop(ActionListener<R> listener, Consumer<ActionListener<R>> consumer) {
                    if (ClusterNode.this.isRegisterDisconnected()) {
                        listener.onFailure((Exception)new IOException("simulated disrupted connection to register"));
                    } else if (ClusterNode.this.isRegisterBlackholed()) {
                        logger.trace(() -> org.elasticsearch.common.Strings.format((String)"dropping register request for [%s]", (Object[])new Object[]{listener}));
                    } else {
                        consumer.accept(listener);
                    }
                }
            }
        }
    }

    public class DefaultCoordinatorStrategy
    implements CoordinatorStrategy {
        private final ElectionStrategy electionStrategy;

        public DefaultCoordinatorStrategy() {
            this(ElectionStrategy.DEFAULT_INSTANCE);
        }

        public DefaultCoordinatorStrategy(ElectionStrategy electionStrategy) {
            this.electionStrategy = electionStrategy;
        }

        @Override
        public CoordinationServices getCoordinationServices(ThreadPool threadPool, final Settings settings, final ClusterSettings clusterSettings, CoordinationState.PersistedState persistedState, DisruptibleRegisterConnection disruptibleRegisterConnection) {
            return new CoordinationServices(){

                @Override
                public ElectionStrategy getElectionStrategy() {
                    return DefaultCoordinatorStrategy.this.electionStrategy;
                }

                @Override
                public Reconfigurator getReconfigurator() {
                    return new Reconfigurator(settings, clusterSettings);
                }

                @Override
                public LeaderHeartbeatService getLeaderHeartbeatService() {
                    return LeaderHeartbeatService.NO_OP;
                }

                @Override
                public PreVoteCollector.Factory getPreVoteCollectorFactory() {
                    return StatefulPreVoteCollector::new;
                }
            };
        }

        @Override
        public CoordinationState.PersistedState createFreshPersistedState(DiscoveryNode localNode, BooleanSupplier disruptStorage, ThreadPool threadPool) {
            return new MockPersistedState(localNode, disruptStorage);
        }

        @Override
        public CoordinationState.PersistedState createPersistedStateFromExistingState(DiscoveryNode newLocalNode, CoordinationState.PersistedState oldState, Function<Metadata, Metadata> adaptGlobalMetadata, Function<Long, Long> adaptCurrentTerm, LongSupplier currentTimeInMillisSupplier, NamedWriteableRegistry namedWriteableRegistry, BooleanSupplier disruptStorage, ThreadPool threadPool) {
            assert (oldState instanceof MockPersistedState) : oldState.getClass();
            return new MockPersistedState(newLocalNode, (MockPersistedState)oldState, adaptGlobalMetadata, adaptCurrentTerm, currentTimeInMillisSupplier, namedWriteableRegistry, disruptStorage);
        }
    }

    class MockPersistedState
    implements CoordinationState.PersistedState {
        private final DiscoveryNode localNode;
        private final CoordinationState.PersistedState delegate;
        private final NodeEnvironment nodeEnvironment;
        private final BooleanSupplier disruptStorage;

        MockPersistedState(DiscoveryNode localNode, BooleanSupplier disruptStorage) {
            this.localNode = localNode;
            this.disruptStorage = disruptStorage;
            try {
                if (LuceneTestCase.rarely()) {
                    this.nodeEnvironment = AbstractCoordinatorTestCase.this.newNodeEnvironment();
                    AbstractCoordinatorTestCase.this.nodeEnvironments.add(this.nodeEnvironment);
                    MockGatewayMetaState gatewayMetaState = new MockGatewayMetaState(localNode);
                    gatewayMetaState.start(Settings.EMPTY, this.nodeEnvironment, AbstractCoordinatorTestCase.this.xContentRegistry());
                    this.delegate = gatewayMetaState.getPersistedState();
                } else {
                    this.nodeEnvironment = null;
                    this.delegate = new InMemoryPersistedState(0L, ClusterStateUpdaters.addStateNotRecoveredBlock((ClusterState)CoordinationStateTestCluster.clusterState(0L, 0L, localNode, CoordinationMetadata.VotingConfiguration.EMPTY_CONFIG, CoordinationMetadata.VotingConfiguration.EMPTY_CONFIG, 0L)));
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to create MockPersistedState", e);
            }
        }

        MockPersistedState(DiscoveryNode newLocalNode, MockPersistedState oldState, Function<Metadata, Metadata> adaptGlobalMetadata, Function<Long, Long> adaptCurrentTerm, LongSupplier currentTimeInMillisSupplier, NamedWriteableRegistry namedWriteableRegistry, BooleanSupplier disruptStorage) {
            block18: {
                this.localNode = newLocalNode;
                this.disruptStorage = disruptStorage;
                try {
                    long persistedCurrentTerm;
                    if (oldState.nodeEnvironment != null) {
                        this.nodeEnvironment = oldState.nodeEnvironment;
                        Metadata updatedMetadata = adaptGlobalMetadata.apply(oldState.getLastAcceptedState().metadata());
                        long updatedTerm = adaptCurrentTerm.apply(oldState.getCurrentTerm());
                        Settings.Builder writerSettings = Settings.builder();
                        if (ESTestCase.randomBoolean()) {
                            writerSettings.put(PersistedClusterStateService.DOCUMENT_PAGE_SIZE.getKey(), ByteSizeValue.ofBytes((long)ESTestCase.randomLongBetween(1L, 1024L)));
                        }
                        if (updatedMetadata != oldState.getLastAcceptedState().metadata() || updatedTerm != oldState.getCurrentTerm()) {
                            try (PersistedClusterStateService.Writer writer = new PersistedClusterStateService(this.nodeEnvironment, AbstractCoordinatorTestCase.this.xContentRegistry(), new ClusterSettings(writerSettings.build(), ClusterSettings.BUILT_IN_CLUSTER_SETTINGS), currentTimeInMillisSupplier).createWriter();){
                                writer.writeFullStateAndCommit(updatedTerm, ClusterState.builder((ClusterState)oldState.getLastAcceptedState()).metadata(updatedMetadata).build());
                            }
                        }
                        MockGatewayMetaState gatewayMetaState = new MockGatewayMetaState(newLocalNode);
                        gatewayMetaState.start(Settings.EMPTY, this.nodeEnvironment, AbstractCoordinatorTestCase.this.xContentRegistry());
                        this.delegate = gatewayMetaState.getPersistedState();
                        break block18;
                    }
                    this.nodeEnvironment = null;
                    BytesStreamOutput outStream = new BytesStreamOutput();
                    outStream.setTransportVersion(TransportVersion.current());
                    if (!(oldState.getLastAcceptedState().nodes().getLocalNode().isMasterNode() && newLocalNode.isMasterNode()) && (oldState.getLastAcceptedState().term() > 0L || oldState.getLastAcceptedState().version() > 0L) && ESTestCase.randomBoolean()) {
                        long newLastAcceptedVersion;
                        long newLastAcceptedTerm;
                        persistedCurrentTerm = ESTestCase.randomLongBetween(0L, oldState.getCurrentTerm());
                        long lastAcceptedTerm = oldState.getLastAcceptedState().term();
                        long lastAcceptedVersion = oldState.getLastAcceptedState().version();
                        if (lastAcceptedVersion == 0L) {
                            newLastAcceptedTerm = ESTestCase.randomLongBetween(0L, Math.min(persistedCurrentTerm, lastAcceptedTerm - 1L));
                            newLastAcceptedVersion = ESTestCase.randomNonNegativeLong();
                        } else {
                            newLastAcceptedTerm = ESTestCase.randomLongBetween(0L, Math.min(persistedCurrentTerm, lastAcceptedTerm));
                            newLastAcceptedVersion = ESTestCase.randomLongBetween(0L, newLastAcceptedTerm == lastAcceptedTerm ? lastAcceptedVersion - 1L : Long.MAX_VALUE);
                        }
                        CoordinationMetadata.VotingConfiguration newVotingConfiguration = new CoordinationMetadata.VotingConfiguration(ESTestCase.randomBoolean() ? Collections.emptySet() : Collections.singleton(ESTestCase.randomAlphaOfLength(10)));
                        long newValue = ESTestCase.randomLong();
                        AbstractCoordinatorTestCase.this.logger.trace("rolling back persisted cluster state on master-ineligible node [{}]: previously currentTerm={}, lastAcceptedTerm={}, lastAcceptedVersion={} but now currentTerm={}, lastAcceptedTerm={}, lastAcceptedVersion={}", (Object)newLocalNode, (Object)oldState.getCurrentTerm(), (Object)lastAcceptedTerm, (Object)lastAcceptedVersion, (Object)persistedCurrentTerm, (Object)newLastAcceptedTerm, (Object)newLastAcceptedVersion);
                        CoordinationStateTestCluster.clusterState(newLastAcceptedTerm, newLastAcceptedVersion, newLocalNode, newVotingConfiguration, newVotingConfiguration, newValue).writeTo((StreamOutput)outStream);
                    } else {
                        persistedCurrentTerm = oldState.getCurrentTerm();
                        Metadata updatedMetadata = adaptGlobalMetadata.apply(oldState.getLastAcceptedState().metadata());
                        if (updatedMetadata != oldState.getLastAcceptedState().metadata()) {
                            ClusterState.builder((ClusterState)oldState.getLastAcceptedState()).metadata(updatedMetadata).build().writeTo((StreamOutput)outStream);
                        } else {
                            oldState.getLastAcceptedState().writeTo((StreamOutput)outStream);
                        }
                    }
                    NamedWriteableAwareStreamInput inStream = new NamedWriteableAwareStreamInput(outStream.bytes().streamInput(), namedWriteableRegistry);
                    this.delegate = new InMemoryPersistedState(adaptCurrentTerm.apply(persistedCurrentTerm).longValue(), ClusterStateUpdaters.addStateNotRecoveredBlock((ClusterState)ClusterState.readFrom((StreamInput)inStream, (DiscoveryNode)newLocalNode)));
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to create MockPersistedState", e);
                }
            }
        }

        private void possiblyFail(String description) {
            if (this.disruptStorage.getAsBoolean() && LuceneTestCase.rarely()) {
                AbstractCoordinatorTestCase.this.logger.trace("simulating IO exception [{}]", (Object)description);
                throw new UncheckedIOException(new IOException("simulated IO exception [" + description + "]"));
            }
        }

        public long getCurrentTerm() {
            return this.delegate.getCurrentTerm();
        }

        public ClusterState getLastAcceptedState() {
            return this.delegate.getLastAcceptedState();
        }

        public void setCurrentTerm(long currentTerm) {
            this.possiblyFail("before writing term of " + currentTerm);
            this.delegate.setCurrentTerm(currentTerm);
        }

        public void setLastAcceptedState(ClusterState clusterState) {
            this.possiblyFail("before writing last-accepted state of term=" + clusterState.term() + ", version=" + clusterState.version());
            this.delegate.setLastAcceptedState(clusterState);
        }

        public void close() {
            Assert.assertTrue((boolean)AbstractCoordinatorTestCase.this.openPersistedStates.remove(this));
            try {
                this.delegate.close();
            }
            catch (IOException e) {
                ESTestCase.fail(e);
            }
        }

        public String toString() {
            return "MockPersistedState[" + this.localNode.descriptionWithoutAttributes() + "]";
        }
    }

    public static interface CoordinatorTestClusterStateUpdateTask
    extends ClusterStateTaskListener {
        default public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
        }
    }

    static class ClearableRecycler
    implements Recycler<BytesRef> {
        private final Recycler<BytesRef> delegate;
        private final Set<Recycler.V<BytesRef>> trackedRefs = new HashSet<Recycler.V<BytesRef>>();

        ClearableRecycler(Recycler<BytesRef> delegate) {
            this.delegate = delegate;
        }

        public Recycler.V<BytesRef> obtain() {
            final Recycler.V innerRef = this.delegate.obtain();
            Recycler.V<BytesRef> trackedRef = new Recycler.V<BytesRef>(){

                public BytesRef v() {
                    return (BytesRef)innerRef.v();
                }

                public boolean isRecycled() {
                    return innerRef.isRecycled();
                }

                public void close() {
                    if (trackedRefs.remove(this)) {
                        innerRef.close();
                    }
                }
            };
            this.trackedRefs.add(trackedRef);
            return trackedRef;
        }

        void clear() {
            for (Recycler.V<BytesRef> trackedRef : List.copyOf(this.trackedRefs)) {
                trackedRef.close();
            }
            assert (this.trackedRefs.isEmpty()) : this.trackedRefs;
        }
    }

    static enum ClusterStateApplyResponse {
        SUCCEED,
        FAIL,
        HANG;

    }

    static class DisruptableClusterApplierService
    extends ClusterApplierService {
        private final String nodeName;
        private final String nodeId;
        private final DeterministicTaskQueue deterministicTaskQueue;
        private final UnaryOperator<Runnable> taskWrapper;
        ClusterStateApplyResponse clusterStateApplyResponse = ClusterStateApplyResponse.SUCCEED;
        private boolean applicationMayFail;

        DisruptableClusterApplierService(String nodeName, String nodeId, Settings settings, ClusterSettings clusterSettings, DeterministicTaskQueue deterministicTaskQueue, UnaryOperator<Runnable> taskWrapper, ThreadPool threadPool) {
            super(nodeName, settings, clusterSettings, threadPool);
            this.nodeName = nodeName;
            this.nodeId = nodeId;
            this.deterministicTaskQueue = deterministicTaskQueue;
            this.taskWrapper = taskWrapper;
            this.addStateApplier(event -> {
                switch (this.clusterStateApplyResponse) {
                    case SUCCEED: 
                    case HANG: {
                        ClusterState oldClusterState = event.previousState();
                        ClusterState newClusterState = event.state();
                        assert (oldClusterState.version() <= newClusterState.version()) : "updating cluster state from version " + oldClusterState + " to stale version " + newClusterState;
                        break;
                    }
                    case FAIL: {
                        throw new ElasticsearchException("simulated cluster state applier failure", new Object[0]);
                    }
                }
            });
        }

        protected PrioritizedEsThreadPoolExecutor createThreadPoolExecutor() {
            return this.deterministicTaskQueue.getPrioritizedEsThreadPoolExecutor(command -> (Runnable)this.taskWrapper.apply(new Runnable(){
                final /* synthetic */ Runnable val$command;
                {
                    this.val$command = runnable;
                }

                @Override
                public void run() {
                    try (CloseableThreadContext.Instance ignored = DeterministicTaskQueue.getLogContext("{" + nodeName + "}{" + nodeId + "}");){
                        this.val$command.run();
                    }
                }

                public String toString() {
                    return "DisruptableClusterApplierService[" + this.val$command + "]";
                }
            }));
        }

        public void onNewClusterState(String source, Supplier<ClusterState> clusterStateSupplier, ActionListener<Void> listener) {
            if (this.clusterStateApplyResponse == ClusterStateApplyResponse.HANG) {
                if (ESTestCase.randomBoolean()) {
                    super.onNewClusterState(source, clusterStateSupplier, ActionListener.noop());
                }
            } else {
                super.onNewClusterState(source, clusterStateSupplier, listener);
            }
        }

        protected void connectToNodesAndWait(ClusterState newClusterState) {
            this.connectToNodesAsync(newClusterState, () -> {});
        }

        protected boolean applicationMayFail() {
            return this.applicationMayFail;
        }

        void allowClusterStateApplicationFailure() {
            this.applicationMayFail = true;
        }
    }

    static class AckedFakeThreadPoolMasterService
    extends FakeThreadPoolMasterService {
        AckCollector nextAckCollector = new AckCollector();
        boolean publicationMayFail = false;

        AckedFakeThreadPoolMasterService(String nodeName, ThreadPool threadPool, Consumer<Runnable> onTaskAvailableToRun) {
            super(nodeName, threadPool, onTaskAvailableToRun);
        }

        @Override
        protected ClusterStatePublisher.AckListener wrapAckListener(final ClusterStatePublisher.AckListener ackListener) {
            final AckCollector ackCollector = this.nextAckCollector;
            this.nextAckCollector = new AckCollector();
            return new ClusterStatePublisher.AckListener(){

                public void onCommit(TimeValue commitTime) {
                    ackCollector.onCommit(commitTime);
                    ackListener.onCommit(commitTime);
                }

                public void onNodeAck(DiscoveryNode node, Exception e) {
                    ackCollector.onNodeAck(node, e);
                    ackListener.onNodeAck(node, e);
                }
            };
        }

        public void allowPublicationFailure() {
            this.publicationMayFail = true;
        }

        protected boolean publicationMayFail() {
            return this.publicationMayFail;
        }
    }

    static class AckCollector
    implements ClusterStatePublisher.AckListener {
        private final Set<DiscoveryNode> ackedNodes = new HashSet<DiscoveryNode>();
        private final List<DiscoveryNode> successfulNodes = new ArrayList<DiscoveryNode>();
        private final List<DiscoveryNode> unsuccessfulNodes = new ArrayList<DiscoveryNode>();

        AckCollector() {
        }

        public void onCommit(TimeValue commitTime) {
        }

        public void onNodeAck(DiscoveryNode node, Exception e) {
            Assert.assertTrue((String)("duplicate ack from " + node), (boolean)this.ackedNodes.add(node));
            if (e == null) {
                this.successfulNodes.add(node);
            } else {
                this.unsuccessfulNodes.add(node);
            }
        }

        boolean hasAckedSuccessfully(Cluster.ClusterNode clusterNode) {
            return this.successfulNodes.contains(clusterNode.localNode);
        }

        boolean hasAckedUnsuccessfully(Cluster.ClusterNode clusterNode) {
            return this.unsuccessfulNodes.contains(clusterNode.localNode);
        }

        boolean hasAcked(Cluster.ClusterNode clusterNode) {
            return this.ackedNodes.contains(clusterNode.localNode);
        }

        int getSuccessfulAckIndex(Cluster.ClusterNode clusterNode) {
            assert (this.successfulNodes.contains(clusterNode.localNode)) : "get index of " + clusterNode;
            return this.successfulNodes.indexOf(clusterNode.localNode);
        }
    }

    protected static interface CoordinationServices {
        public ElectionStrategy getElectionStrategy();

        public Reconfigurator getReconfigurator();

        public LeaderHeartbeatService getLeaderHeartbeatService();

        public PreVoteCollector.Factory getPreVoteCollectorFactory();
    }

    protected static interface CoordinatorStrategy
    extends Closeable {
        public CoordinationServices getCoordinationServices(ThreadPool var1, Settings var2, ClusterSettings var3, CoordinationState.PersistedState var4, DisruptibleRegisterConnection var5);

        public CoordinationState.PersistedState createFreshPersistedState(DiscoveryNode var1, BooleanSupplier var2, ThreadPool var3);

        public CoordinationState.PersistedState createPersistedStateFromExistingState(DiscoveryNode var1, CoordinationState.PersistedState var2, Function<Metadata, Metadata> var3, Function<Long, Long> var4, LongSupplier var5, NamedWriteableRegistry var6, BooleanSupplier var7, ThreadPool var8);

        @Override
        default public void close() {
        }

        default public boolean verifyElectionSchedulerState(Cluster.ClusterNode clusterNode) {
            return clusterNode.getHealthStatus() == StatusInfo.Status.HEALTHY;
        }
    }

    public static interface DisruptibleRegisterConnection {
        public <R> void runDisrupted(ActionListener<R> var1, Consumer<ActionListener<R>> var2);

        public <R> void runDisruptedOrDrop(ActionListener<R> var1, Consumer<ActionListener<R>> var2);
    }
}

