/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Predicate;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.spi.Element;
import org.elasticsearch.common.inject.spi.Elements;
import org.elasticsearch.common.inject.spi.InstanceBinding;
import org.elasticsearch.common.inject.spi.ProviderInstanceBinding;
import org.elasticsearch.test.ESTestCase;

public abstract class ModuleTestCase
extends ESTestCase {
    public static <T> void assertInstanceBinding(Module module, Class<T> to, Predicate<T> tester) {
        ModuleTestCase.assertInstanceBindingWithAnnotation(module, to, tester, null);
    }

    private static <T> void assertInstanceBindingWithAnnotation(Module module, Class<T> to, Predicate<T> tester, Class<? extends Annotation> annotation) {
        List elements = Elements.getElements((Module[])new Module[]{module});
        for (Element element : elements) {
            ProviderInstanceBinding binding;
            if (element instanceof InstanceBinding) {
                InstanceBinding binding2 = (InstanceBinding)element;
                if (!to.equals(binding2.getKey().getTypeLiteral().getType()) || annotation != null && !annotation.equals(binding2.getKey().getAnnotationType())) continue;
                ModuleTestCase.assertTrue((boolean)tester.test(to.cast(binding2.getInstance())));
                return;
            }
            if (!(element instanceof ProviderInstanceBinding) || !to.equals((binding = (ProviderInstanceBinding)element).getKey().getTypeLiteral().getType())) continue;
            ModuleTestCase.assertTrue((boolean)tester.test(to.cast(binding.getProviderInstance().get())));
            return;
        }
        StringBuilder s = new StringBuilder();
        for (Element element : elements) {
            s.append(element).append("\n");
        }
        ModuleTestCase.fail((String)("Did not find any instance binding to " + to.getName() + ". Found these bindings:\n" + s));
    }
}

