/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.store.LuceneFilesExtensions;
import org.elasticsearch.test.ESTestCase;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public class ESIndexInputTestCase
extends ESTestCase {
    private static EsThreadPoolExecutor executor;
    private AtomicLong uniqueIdGenerator;

    @BeforeClass
    public static void createExecutor() {
        String name = "TEST-" + ESIndexInputTestCase.getTestClass().getSimpleName() + "#randomReadAndSlice";
        executor = EsExecutors.newFixed((String)name, (int)10, (int)0, (ThreadFactory)EsExecutors.daemonThreadFactory((String)name), (ThreadContext)new ThreadContext(Settings.EMPTY), (EsExecutors.TaskTrackingConfig)EsExecutors.TaskTrackingConfig.DO_NOT_TRACK);
    }

    @AfterClass
    public static void destroyExecutor() {
        executor.shutdown();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.uniqueIdGenerator = new AtomicLong();
    }

    protected byte[] randomReadAndSlice(final IndexInput indexInput, final int length) throws IOException {
        int readPos = (int)indexInput.getFilePointer();
        byte[] output = new byte[length];
        while (readPos < length) {
            int readStrategy = ESIndexInputTestCase.between(0, 8);
            switch (readStrategy) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if (length - readPos >= 8 && readStrategy <= 0) {
                        ByteBuffer.wrap(output, readPos, 8).order(ByteOrder.LITTLE_ENDIAN).putLong(indexInput.readLong());
                        readPos += 8;
                        break;
                    }
                    if (length - readPos >= 4 && readStrategy <= 1) {
                        ByteBuffer.wrap(output, readPos, 4).order(ByteOrder.LITTLE_ENDIAN).putInt(indexInput.readInt());
                        readPos += 4;
                        break;
                    }
                    if (length - readPos >= 2 && readStrategy <= 2) {
                        ByteBuffer.wrap(output, readPos, 2).order(ByteOrder.LITTLE_ENDIAN).putShort(indexInput.readShort());
                        readPos += 2;
                        break;
                    }
                    output[readPos++] = indexInput.readByte();
                    break;
                }
                case 4: {
                    int len = ESIndexInputTestCase.randomIntBetween(1, length - readPos);
                    indexInput.readBytes(output, readPos, len);
                    readPos += len;
                    break;
                }
                case 5: {
                    int len = ESIndexInputTestCase.randomIntBetween(1, length - readPos);
                    byte[] temp = new byte[len];
                    indexInput.readBytes(temp, 0, len);
                    System.arraycopy(temp, 0, output, readPos, len);
                    readPos += len;
                    break;
                }
                case 6: {
                    int len = ESIndexInputTestCase.randomIntBetween(1, length - readPos);
                    String sliceExtension = ESIndexInputTestCase.randomValueOtherThan(".cfs", ESIndexInputTestCase::randomFileExtension);
                    IndexInput slice = indexInput.slice(this.randomUniqueSliceName() + sliceExtension, (long)readPos, (long)len);
                    byte[] temp = this.randomReadAndSlice(slice, len);
                    ESIndexInputTestCase.assertEquals((long)readPos, (long)indexInput.getFilePointer());
                    System.arraycopy(temp, 0, output, readPos, len);
                    indexInput.seek((long)(readPos += len));
                    ESIndexInputTestCase.assertEquals((long)readPos, (long)indexInput.getFilePointer());
                    break;
                }
                case 7: {
                    int lastReadPos = readPos;
                    readPos = ESIndexInputTestCase.randomIntBetween(0, length - 1);
                    indexInput.seek((long)readPos);
                    ESIndexInputTestCase.assertEquals((long)readPos, (long)indexInput.getFilePointer());
                    boolean bytesToRead = true;
                    byte[] temp = this.randomReadAndSlice(indexInput, readPos + 1);
                    System.arraycopy(temp, readPos, output, readPos, 1);
                    readPos = lastReadPos;
                    indexInput.seek((long)readPos);
                    ESIndexInputTestCase.assertEquals((long)readPos, (long)indexInput.getFilePointer());
                    break;
                }
                case 8: {
                    int cloneCount = ESIndexInputTestCase.between(1, 3);
                    final CountDownLatch startLatch = new CountDownLatch(1 + cloneCount);
                    final CountDownLatch finishLatch = new CountDownLatch(cloneCount);
                    final PlainActionFuture mainThreadResultFuture = new PlainActionFuture();
                    final int mainThreadReadStart = readPos;
                    final int mainThreadReadEnd = ESIndexInputTestCase.randomIntBetween(readPos + 1, length);
                    for (int i = 0; i < cloneCount; ++i) {
                        executor.execute((Runnable)new AbstractRunnable(){

                            public void onFailure(Exception e) {
                                throw new AssertionError((Object)e);
                            }

                            protected void doRun() throws Exception {
                                int minEnd;
                                int maxStart;
                                IndexInput clone;
                                boolean keepPosition = ESTestCase.randomBoolean();
                                int readStart = keepPosition ? (int)indexInput.getFilePointer() : ESTestCase.between(0, length);
                                int readEnd = ESTestCase.between(readStart, length);
                                if (keepPosition || ESTestCase.randomBoolean()) {
                                    clone = indexInput.clone();
                                } else {
                                    int sliceEnd = ESTestCase.between(readEnd, length);
                                    String sliceExtension = ESTestCase.randomValueOtherThan(".cfs", ESIndexInputTestCase::randomFileExtension);
                                    clone = indexInput.slice("slice" + ESIndexInputTestCase.this.randomUniqueSliceName() + sliceExtension, 0L, (long)sliceEnd);
                                }
                                startLatch.countDown();
                                startLatch.await();
                                if (!keepPosition) {
                                    clone.seek((long)readStart);
                                }
                                byte[] cloneResult = ESIndexInputTestCase.this.randomReadAndSlice(clone, readEnd);
                                if (ESTestCase.randomBoolean()) {
                                    clone.close();
                                }
                                if ((maxStart = Math.max(mainThreadReadStart, readStart)) < (minEnd = Math.min(mainThreadReadEnd, readEnd))) {
                                    byte[] mainThreadResult = (byte[])mainThreadResultFuture.actionGet();
                                    int overlapLen = minEnd - maxStart;
                                    byte[] fromMainThread = new byte[overlapLen];
                                    byte[] fromClone = new byte[overlapLen];
                                    System.arraycopy(mainThreadResult, maxStart, fromMainThread, 0, overlapLen);
                                    System.arraycopy(cloneResult, maxStart, fromClone, 0, overlapLen);
                                    Assert.assertArrayEquals((byte[])fromMainThread, (byte[])fromClone);
                                }
                            }

                            public void onAfter() {
                                finishLatch.countDown();
                            }

                            public void onRejection(Exception e) {
                                startLatch.countDown();
                            }
                        });
                    }
                    try {
                        startLatch.countDown();
                        startLatch.await();
                        ActionListener.completeWith((ActionListener)mainThreadResultFuture, () -> this.randomReadAndSlice(indexInput, mainThreadReadEnd));
                        System.arraycopy(mainThreadResultFuture.actionGet(), readPos, output, readPos, mainThreadReadEnd - readPos);
                        readPos = mainThreadReadEnd;
                        finishLatch.await();
                        break;
                    }
                    catch (InterruptedException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                default: {
                    ESIndexInputTestCase.fail();
                }
            }
            ESIndexInputTestCase.assertEquals((long)readPos, (long)indexInput.getFilePointer());
        }
        ESIndexInputTestCase.assertEquals((long)length, (long)indexInput.getFilePointer());
        return output;
    }

    private String randomUniqueSliceName() {
        return ESIndexInputTestCase.randomAlphaOfLength(10) + this.uniqueIdGenerator.incrementAndGet();
    }

    protected static String randomFileExtension() {
        return "." + ESIndexInputTestCase.randomFrom(LuceneFilesExtensions.values()).getExtension();
    }
}

