/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexableField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperServiceTestCase;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class MapperScriptTestCase<FactoryType>
extends MapperServiceTestCase {
    protected abstract String type();

    protected abstract FactoryType serializableScript();

    protected abstract FactoryType errorThrowingScript();

    protected abstract FactoryType singleValueScript();

    protected abstract FactoryType multipleValuesScript();

    protected FactoryType script(String id) {
        throw new UnsupportedOperationException("Unknown script " + id);
    }

    @Override
    protected <T> T compileScript(Script script, ScriptContext<T> context) {
        if (script.getIdOrCode().equals("serializer_test")) {
            return (T)this.serializableScript();
        }
        if (script.getIdOrCode().equals("throws")) {
            return (T)this.errorThrowingScript();
        }
        if (script.getIdOrCode().equals("single-valued")) {
            return (T)this.singleValueScript();
        }
        if (script.getIdOrCode().equals("multi-valued")) {
            return (T)this.multipleValuesScript();
        }
        return (T)this.script(script.getIdOrCode());
    }

    public void testToXContent() throws IOException {
        DocumentMapper mapper = this.createDocumentMapper(MapperScriptTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("scripted");
            b.field("type", this.type());
            b.field("script", "serializer_test");
            b.endObject();
        })));
        MapperScriptTestCase.assertThat((Object)Strings.toString((ToXContent)mapper.mapping()), (Matcher)CoreMatchers.containsString((String)"\"script\":{\"source\":\"serializer_test\",\"lang\":\"painless\"}"));
    }

    public void testCannotIndexDirectlyIntoScriptMapper() throws IOException {
        DocumentMapper mapper = this.createDocumentMapper(MapperScriptTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("scripted");
            b.field("type", this.type());
            b.field("script", "serializer_test");
            b.endObject();
        })));
        Exception e = (Exception)MapperScriptTestCase.expectThrows(DocumentParsingException.class, () -> mapper.parse(MapperScriptTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("scripted", "foo")))));
        MapperScriptTestCase.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"failed to parse field [scripted]"));
        MapperScriptTestCase.assertEquals((Object)"Cannot index data directly into a field with a [script] parameter", (Object)e.getCause().getMessage());
    }

    public final void testStoredScriptsNotPermitted() {
        Exception e = (Exception)MapperScriptTestCase.expectThrows(MapperParsingException.class, () -> this.createDocumentMapper(MapperScriptTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.field("type", this.type());
            b.startObject("script").field("id", "foo").endObject();
        }))));
        MapperScriptTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"Failed to parse mapping: stored scripts are not supported on field [field]"));
    }

    public final void testIndexAndDocValuesFalseNotPermitted() {
        Exception e = (Exception)MapperScriptTestCase.expectThrows(MapperParsingException.class, () -> this.createDocumentMapper(MapperScriptTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.field("type", this.type());
            b.field("index", false);
            b.field("doc_values", false);
            b.field("script", "serializer_test");
        }))));
        MapperScriptTestCase.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot define script on field with index:false and doc_values:false"));
    }

    public final void testMultiFieldsNotPermitted() {
        Exception e = (Exception)MapperScriptTestCase.expectThrows(MapperParsingException.class, () -> this.createDocumentMapper(MapperScriptTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.field("type", this.type());
            b.field("script", "serializer_test");
            b.startObject("fields");
            b.startObject("subfield").field("type", "keyword").endObject();
            b.endObject();
        }))));
        MapperScriptTestCase.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot define multifields on a field with a script"));
    }

    public final void testCopyToNotPermitted() {
        Exception e = (Exception)MapperScriptTestCase.expectThrows(MapperParsingException.class, () -> this.createDocumentMapper(MapperScriptTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.field("type", this.type());
            b.field("script", "serializer_test");
            b.array("copy_to", new String[]{"foo"});
        }))));
        MapperScriptTestCase.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot define copy_to parameter on a field with a script"));
    }

    public final void testOnScriptErrorParameterRequiresScript() {
        Exception e = (Exception)MapperScriptTestCase.expectThrows(MapperParsingException.class, () -> this.createDocumentMapper(MapperScriptTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.field("type", this.type());
            b.field("on_script_error", "continue");
        }))));
        MapperScriptTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"Failed to parse mapping: Field [on_script_error] requires field [script] to be configured"));
    }

    public final void testOnScriptErrorContinue() throws IOException {
        DocumentMapper mapper = this.createDocumentMapper(MapperScriptTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("message").field("type", "keyword").endObject();
            b.startObject("message_error");
            b.field("type", this.type());
            b.field("script", "throws");
            b.field("on_script_error", "continue");
            b.endObject();
        })));
        ParsedDocument doc = mapper.parse(MapperScriptTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("message", "this is some text"))));
        MapperScriptTestCase.assertThat((Object)doc.rootDoc().getFields("message_error"), (Matcher)Matchers.hasSize((int)0));
        MapperScriptTestCase.assertThat((Object)doc.rootDoc().getField("_ignored").stringValue(), (Matcher)Matchers.equalTo((Object)"message_error"));
    }

    public final void testRejectScriptErrors() throws IOException {
        DocumentMapper mapper = this.createDocumentMapper(MapperScriptTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("message").field("type", "keyword").endObject();
            b.startObject("message_error");
            b.field("type", this.type());
            b.field("script", "throws");
            b.endObject();
        })));
        Exception e = (Exception)MapperScriptTestCase.expectThrows(DocumentParsingException.class, () -> mapper.parse(MapperScriptTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("message", "foo")))));
        MapperScriptTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"Error executing script on field [message_error]"));
        MapperScriptTestCase.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(UnsupportedOperationException.class));
    }

    public final void testMultipleValues() throws IOException {
        DocumentMapper mapper = this.createDocumentMapper(MapperScriptTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.field("type", this.type());
            b.field("script", "multi-valued");
        })));
        ParsedDocument doc = mapper.parse(MapperScriptTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {})));
        this.assertMultipleValues(doc.rootDoc().getFields("field"));
    }

    protected abstract void assertMultipleValues(List<IndexableField> var1);

    public final void testDocValuesDisabled() throws IOException {
        DocumentMapper mapper = this.createDocumentMapper(MapperScriptTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.field("type", this.type());
            b.field("script", "single-valued");
            b.field("doc_values", false);
        })));
        ParsedDocument doc = mapper.parse(MapperScriptTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {})));
        this.assertDocValuesDisabled(doc.rootDoc().getFields("field"));
    }

    protected abstract void assertDocValuesDisabled(List<IndexableField> var1);

    public final void testIndexDisabled() throws IOException {
        DocumentMapper mapper = this.createDocumentMapper(MapperScriptTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.field("type", this.type());
            b.field("script", "single-valued");
            b.field("index", false);
        })));
        ParsedDocument doc = mapper.parse(MapperScriptTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {})));
        this.assertIndexDisabled(doc.rootDoc().getFields("field"));
    }

    protected abstract void assertIndexDisabled(List<IndexableField> var1);
}

