/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.lucene99.Lucene99Codec;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.MockBigArrays;
import org.elasticsearch.common.util.MockPageCacheRecycler;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NameOrDefinition;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.codec.PerFieldMapperCodec;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperRegistry;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.NestedLookup;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.support.NestedScope;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.internal.DocumentParsingObserver;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.SubSearchContext;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.FieldMaskingReader;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.mockito.Mockito;

public abstract class MapperServiceTestCase
extends ESTestCase {
    protected static final Settings SETTINGS = Settings.builder().put("index.version.created", (VersionId)IndexVersion.current()).build();
    protected static final ToXContent.Params INCLUDE_DEFAULTS = new ToXContent.MapParams(Map.of("include_defaults", "true"));

    protected Collection<? extends Plugin> getPlugins() {
        return Collections.emptyList();
    }

    protected Settings getIndexSettings() {
        return SETTINGS;
    }

    protected final Settings.Builder getIndexSettingsBuilder() {
        return Settings.builder().put(this.getIndexSettings());
    }

    protected IndexAnalyzers createIndexAnalyzers(IndexSettings indexSettings) {
        return MapperServiceTestCase.createIndexAnalyzers();
    }

    protected static IndexAnalyzers createIndexAnalyzers() {
        return IndexAnalyzers.of(Map.of("default", new NamedAnalyzer("default", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer())));
    }

    protected static String randomIndexOptions() {
        return MapperServiceTestCase.randomFrom("docs", "freqs", "positions", "offsets");
    }

    protected final DocumentMapper createDocumentMapper(XContentBuilder mappings) throws IOException {
        return this.createMapperService(mappings).documentMapper();
    }

    protected final DocumentMapper createTimeSeriesModeDocumentMapper(XContentBuilder mappings) throws IOException {
        Settings settings = Settings.builder().put(IndexSettings.MODE.getKey(), "time_series").put(IndexMetadata.INDEX_ROUTING_PATH.getKey(), "uid").build();
        return this.createMapperService(settings, mappings).documentMapper();
    }

    protected final DocumentMapper createDocumentMapper(IndexVersion version, XContentBuilder mappings) throws IOException {
        return this.createMapperService(version, mappings).documentMapper();
    }

    protected final DocumentMapper createDocumentMapper(String mappings) throws IOException {
        MapperService mapperService = this.createMapperService(MapperServiceTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {})));
        MapperServiceTestCase.merge(mapperService, mappings);
        return mapperService.documentMapper();
    }

    protected final MapperService createMapperService(XContentBuilder mappings) throws IOException {
        return this.createMapperService(this.getVersion(), mappings);
    }

    protected IndexVersion getVersion() {
        return IndexVersion.current();
    }

    protected final MapperService createMapperService(Settings settings, XContentBuilder mappings) throws IOException {
        return this.createMapperService(this.getVersion(), settings, () -> true, mappings);
    }

    protected final MapperService createMapperService(BooleanSupplier idFieldEnabled, XContentBuilder mappings) throws IOException {
        return this.createMapperService(this.getVersion(), this.getIndexSettings(), idFieldEnabled, mappings);
    }

    protected final MapperService createMapperService(String mappings) throws IOException {
        MapperService mapperService = this.createMapperService(MapperServiceTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {})));
        MapperServiceTestCase.merge(mapperService, mappings);
        return mapperService;
    }

    protected final MapperService createMapperService(Settings settings, String mappings) throws IOException {
        MapperService mapperService = this.createMapperService(IndexVersion.current(), settings, () -> true, MapperServiceTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {})));
        MapperServiceTestCase.merge(mapperService, mappings);
        return mapperService;
    }

    protected final MapperService createMapperService(IndexVersion version, XContentBuilder mapping) throws IOException {
        return this.createMapperService(version, this.getIndexSettings(), () -> true, mapping);
    }

    protected final MapperService createMapperService(IndexVersion version, Settings settings, BooleanSupplier idFieldDataEnabled, XContentBuilder mapping) throws IOException {
        MapperService mapperService = this.createMapperService(version, settings, idFieldDataEnabled);
        MapperServiceTestCase.merge(mapperService, mapping);
        return mapperService;
    }

    protected final MapperService createMapperService(IndexVersion version, Settings settings, BooleanSupplier idFieldDataEnabled) {
        IndexSettings indexSettings = MapperServiceTestCase.createIndexSettings(version, settings);
        MapperRegistry mapperRegistry = new IndicesModule(this.getPlugins().stream().filter(p -> p instanceof MapperPlugin).map(p -> (MapperPlugin)p).collect(Collectors.toList())).getMapperRegistry();
        SimilarityService similarityService = new SimilarityService(indexSettings, null, Map.of());
        return new MapperService(() -> TransportVersion.current(), indexSettings, this.createIndexAnalyzers(indexSettings), this.parserConfig(), similarityService, mapperRegistry, () -> {
            throw new UnsupportedOperationException();
        }, indexSettings.getMode().buildIdFieldMapper(idFieldDataEnabled), this::compileScript, () -> DocumentParsingObserver.EMPTY_INSTANCE);
    }

    protected <T> T compileScript(Script script, ScriptContext<T> context) {
        throw new UnsupportedOperationException("Cannot compile script " + Strings.toString((ToXContent)script));
    }

    protected static IndexSettings createIndexSettings(IndexVersion version, Settings settings) {
        settings = MapperServiceTestCase.indexSettings(1, 0).put(settings).put("index.version.created", (VersionId)version).build();
        IndexMetadata meta = IndexMetadata.builder((String)"index").settings(settings).build();
        return new IndexSettings(meta, settings);
    }

    protected static void withLuceneIndex(MapperService mapperService, CheckedConsumer<RandomIndexWriter, IOException> builder, CheckedConsumer<DirectoryReader, IOException> test) throws IOException {
        IndexWriterConfig iwc = new IndexWriterConfig(IndexShard.buildIndexAnalyzer((MapperService)mapperService)).setCodec((Codec)new PerFieldMapperCodec(Lucene99Codec.Mode.BEST_SPEED, mapperService, BigArrays.NON_RECYCLING_INSTANCE));
        try (BaseDirectoryWrapper dir = MapperServiceTestCase.newDirectory();
             RandomIndexWriter iw = new RandomIndexWriter(MapperServiceTestCase.random(), (Directory)dir, iwc);){
            builder.accept((Object)iw);
            try (DirectoryReader reader = iw.getReader();){
                test.accept((Object)reader);
            }
        }
    }

    protected static SourceToParse source(CheckedConsumer<XContentBuilder, IOException> build) throws IOException {
        return MapperServiceTestCase.source("1", build, null);
    }

    protected static SourceToParse source(@Nullable String id, CheckedConsumer<XContentBuilder, IOException> build, @Nullable String routing) throws IOException {
        return MapperServiceTestCase.source(id, build, routing, Map.of());
    }

    protected static SourceToParse source(@Nullable String id, CheckedConsumer<XContentBuilder, IOException> build, @Nullable String routing, Map<String, String> dynamicTemplates) throws IOException {
        XContentBuilder builder = JsonXContent.contentBuilder().startObject();
        build.accept((Object)builder);
        builder.endObject();
        return new SourceToParse(id, BytesReference.bytes((XContentBuilder)builder), XContentType.JSON, routing, dynamicTemplates, false);
    }

    protected static SourceToParse source(String source) {
        return new SourceToParse("1", (BytesReference)new BytesArray(source), XContentType.JSON);
    }

    protected static void merge(MapperService mapperService, XContentBuilder mapping) throws IOException {
        MapperServiceTestCase.merge(mapperService, MapperService.MergeReason.MAPPING_UPDATE, mapping);
    }

    protected static void merge(MapperService mapperService, String mapping) throws IOException {
        mapperService.merge(null, new CompressedXContent(mapping), MapperService.MergeReason.MAPPING_UPDATE);
    }

    protected static void merge(MapperService mapperService, MapperService.MergeReason reason, String mapping) throws IOException {
        mapperService.merge(null, new CompressedXContent(mapping), reason);
    }

    protected static void merge(MapperService mapperService, MapperService.MergeReason reason, XContentBuilder mapping) throws IOException {
        mapperService.merge(null, new CompressedXContent(BytesReference.bytes((XContentBuilder)mapping)), reason);
    }

    protected static XContentBuilder topMapping(CheckedConsumer<XContentBuilder, IOException> buildFields) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("_doc");
        buildFields.accept((Object)builder);
        return builder.endObject().endObject();
    }

    protected static XContentBuilder mappingNoSubobjects(CheckedConsumer<XContentBuilder, IOException> buildFields) throws IOException {
        return MapperServiceTestCase.topMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)xContentBuilder -> {
            xContentBuilder.field("subobjects", false);
            xContentBuilder.startObject("properties");
            buildFields.accept(xContentBuilder);
            xContentBuilder.endObject();
        }));
    }

    protected static XContentBuilder mapping(CheckedConsumer<XContentBuilder, IOException> buildFields) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("properties");
        buildFields.accept((Object)builder);
        return builder.endObject().endObject().endObject();
    }

    protected static XContentBuilder dynamicMapping(Mapping dynamicMapping) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
        dynamicMapping.toXContent(builder, ToXContent.EMPTY_PARAMS);
        return builder.endObject();
    }

    protected static XContentBuilder fieldMapping(CheckedConsumer<XContentBuilder, IOException> buildField) throws IOException {
        return MapperServiceTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            buildField.accept(b);
            b.endObject();
        }));
    }

    protected static XContentBuilder runtimeFieldMapping(CheckedConsumer<XContentBuilder, IOException> buildField) throws IOException {
        return MapperServiceTestCase.runtimeMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            buildField.accept(b);
            b.endObject();
        }));
    }

    protected static XContentBuilder runtimeMapping(CheckedConsumer<XContentBuilder, IOException> buildFields) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("runtime");
        buildFields.accept((Object)builder);
        return builder.endObject().endObject().endObject();
    }

    private AggregationContext aggregationContext(final ValuesSourceRegistry valuesSourceRegistry, final MapperService mapperService, final IndexSearcher searcher, final Query query, final Supplier<SearchLookup> lookupSupplier) {
        return new AggregationContext(){
            private final CircuitBreaker breaker = (CircuitBreaker)Mockito.mock(CircuitBreaker.class);

            public IndexSearcher searcher() {
                return searcher;
            }

            public Aggregator profileIfEnabled(Aggregator agg) throws IOException {
                return agg;
            }

            public boolean profiling() {
                return false;
            }

            public Query query() {
                return query;
            }

            public long nowInMillis() {
                return 0L;
            }

            public Analyzer getNamedAnalyzer(String analyzer) {
                return null;
            }

            public Analyzer buildCustomAnalyzer(IndexSettings indexSettings, boolean normalizer, NameOrDefinition tokenizer, List<NameOrDefinition> charFilters, List<NameOrDefinition> tokenFilters) {
                return null;
            }

            public SearchLookup lookup() {
                return (SearchLookup)lookupSupplier.get();
            }

            public ValuesSourceRegistry getValuesSourceRegistry() {
                return valuesSourceRegistry;
            }

            public IndexSettings getIndexSettings() {
                throw new UnsupportedOperationException();
            }

            public ClusterSettings getClusterSettings() {
                throw new UnsupportedOperationException();
            }

            public MappedFieldType getFieldType(String path) {
                return mapperService.fieldType(path);
            }

            public Set<String> getMatchingFieldNames(String pattern) {
                throw new UnsupportedOperationException();
            }

            public <FactoryType> FactoryType compile(Script script, ScriptContext<FactoryType> context) {
                return MapperServiceTestCase.this.compileScript(script, context);
            }

            public Optional<SortAndFormats> buildSort(List<SortBuilder<?>> sortBuilders) throws IOException {
                throw new UnsupportedOperationException();
            }

            public Query buildQuery(QueryBuilder builder) throws IOException {
                throw new UnsupportedOperationException();
            }

            public Query filterQuery(Query query2) {
                throw new UnsupportedOperationException();
            }

            protected IndexFieldData<?> buildFieldData(MappedFieldType ft) {
                return ft.fielddataBuilder(FieldDataContext.noRuntimeFields((String)"test")).build((IndexFieldDataCache)new IndexFieldDataCache.None(), (CircuitBreakerService)new NoneCircuitBreakerService());
            }

            public BigArrays bigArrays() {
                return new MockBigArrays((PageCacheRecycler)new MockPageCacheRecycler(Settings.EMPTY), (CircuitBreakerService)new NoneCircuitBreakerService());
            }

            public NestedLookup nestedLookup() {
                throw new UnsupportedOperationException();
            }

            public NestedScope nestedScope() {
                throw new UnsupportedOperationException();
            }

            public SubSearchContext subSearchContext() {
                throw new UnsupportedOperationException();
            }

            public void addReleasable(Aggregator aggregator) {
            }

            public void removeReleasable(Aggregator aggregator) {
            }

            public int maxBuckets() {
                return Integer.MAX_VALUE;
            }

            public BitsetFilterCache bitsetFilterCache() {
                throw new UnsupportedOperationException();
            }

            public BucketedSort buildBucketedSort(SortBuilder<?> sort, int size, BucketedSort.ExtraData values) throws IOException {
                throw new UnsupportedOperationException();
            }

            public int shardRandomSeed() {
                throw new UnsupportedOperationException();
            }

            public long getRelativeTimeInMillis() {
                return 0L;
            }

            public boolean isCancelled() {
                return false;
            }

            public CircuitBreaker breaker() {
                return this.breaker;
            }

            public Analyzer getIndexAnalyzer(Function<String, NamedAnalyzer> unindexedFieldAnalyzer) {
                throw new UnsupportedOperationException();
            }

            public boolean isCacheable() {
                throw new UnsupportedOperationException();
            }

            public boolean enableRewriteToFilterByFilter() {
                throw new UnsupportedOperationException();
            }

            public boolean isInSortOrderExecutionRequired() {
                return false;
            }

            public Set<String> sourcePath(String fullName) {
                return Set.of(fullName);
            }

            public void close() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected final void withAggregationContext(MapperService mapperService, List<SourceToParse> docs, CheckedConsumer<AggregationContext, IOException> test) throws IOException {
        this.withAggregationContext(mapperService, docs, test, () -> {
            throw new UnsupportedOperationException();
        });
    }

    protected final void withAggregationContext(MapperService mapperService, List<SourceToParse> docs, CheckedConsumer<AggregationContext, IOException> test, Supplier<SearchLookup> lookupSupplier) throws IOException {
        this.withAggregationContext(null, mapperService, docs, null, test, lookupSupplier);
    }

    protected final void withAggregationContext(ValuesSourceRegistry valuesSourceRegistry, MapperService mapperService, List<SourceToParse> docs, Query query, CheckedConsumer<AggregationContext, IOException> test) throws IOException {
        this.withAggregationContext(valuesSourceRegistry, mapperService, docs, query, test, () -> {
            throw new UnsupportedOperationException();
        });
    }

    protected final void withAggregationContext(ValuesSourceRegistry valuesSourceRegistry, MapperService mapperService, List<SourceToParse> docs, Query query, CheckedConsumer<AggregationContext, IOException> test, Supplier<SearchLookup> lookupSupplier) throws IOException {
        MapperServiceTestCase.withLuceneIndex(mapperService, (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)writer -> {
            for (SourceToParse doc : docs) {
                writer.addDocuments((Iterable)mapperService.documentMapper().parse(doc).docs());
            }
        }), (CheckedConsumer<DirectoryReader, IOException>)((CheckedConsumer)reader -> test.accept((Object)this.aggregationContext(valuesSourceRegistry, mapperService, MapperServiceTestCase.newSearcher((IndexReader)reader), query, lookupSupplier))));
    }

    protected SearchExecutionContext createSearchExecutionContext(MapperService mapperService) {
        return this.createSearchExecutionContext(mapperService, null, Settings.EMPTY);
    }

    protected SearchExecutionContext createSearchExecutionContext(MapperService mapperService, IndexSearcher searcher) {
        return this.createSearchExecutionContext(mapperService, searcher, Settings.EMPTY);
    }

    protected SearchExecutionContext createSearchExecutionContext(MapperService mapperService, IndexSearcher searcher, Settings settings) {
        Settings mergedSettings = Settings.builder().put(mapperService.getIndexSettings().getSettings()).put(settings).build();
        IndexMetadata indexMetadata = IndexMetadata.builder((IndexMetadata)mapperService.getIndexSettings().getIndexMetadata()).settings(mergedSettings).build();
        IndexSettings indexSettings = new IndexSettings(indexMetadata, Settings.EMPTY);
        SimilarityService similarityService = new SimilarityService(indexSettings, null, Map.of());
        long nowInMillis = MapperServiceTestCase.randomNonNegativeLong();
        return new SearchExecutionContext(0, 0, indexSettings, new BitsetFilterCache(indexSettings, new BitsetFilterCache.Listener(){

            public void onCache(ShardId shardId, Accountable accountable) {
            }

            public void onRemoval(ShardId shardId, Accountable accountable) {
            }
        }), (ft, fdc) -> ft.fielddataBuilder(fdc).build((IndexFieldDataCache)new IndexFieldDataCache.None(), (CircuitBreakerService)new NoneCircuitBreakerService()), mapperService, mapperService.mappingLookup(), similarityService, this::compileScript, this.parserConfig(), this.writableRegistry(), null, searcher, () -> nowInMillis, null, null, () -> true, null, Collections.emptyMap());
    }

    protected TriFunction<MappedFieldType, Supplier<SearchLookup>, MappedFieldType.FielddataOperation, IndexFieldData<?>> fieldDataLookup(MapperService mapperService) {
        return this.fieldDataLookup(arg_0 -> ((MappingLookup)mapperService.mappingLookup()).sourcePaths(arg_0));
    }

    protected TriFunction<MappedFieldType, Supplier<SearchLookup>, MappedFieldType.FielddataOperation, IndexFieldData<?>> fieldDataLookup(Function<String, Set<String>> sourcePathsLookup) {
        return (mft, lookupSource, fdo) -> mft.fielddataBuilder(new FieldDataContext("test", lookupSource, sourcePathsLookup, fdo)).build((IndexFieldDataCache)new IndexFieldDataCache.None(), (CircuitBreakerService)new NoneCircuitBreakerService());
    }

    protected final String syntheticSource(DocumentMapper mapper, CheckedConsumer<XContentBuilder, IOException> build) throws IOException {
        try (BaseDirectoryWrapper directory = MapperServiceTestCase.newDirectory();){
            String string;
            block12: {
                RandomIndexWriter iw = new RandomIndexWriter(MapperServiceTestCase.random(), (Directory)directory);
                LuceneDocument doc = mapper.parse(MapperServiceTestCase.source(build)).rootDoc();
                iw.addDocument((Iterable)doc);
                iw.close();
                DirectoryReader reader = DirectoryReader.open((Directory)directory);
                try {
                    String syntheticSource = MapperServiceTestCase.syntheticSource(mapper, (IndexReader)reader, 0);
                    this.roundTripSyntheticSource(mapper, syntheticSource, reader);
                    string = syntheticSource;
                    if (reader == null) break block12;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return string;
        }
    }

    private void roundTripSyntheticSource(DocumentMapper mapper, String syntheticSource, DirectoryReader reader) throws IOException {
        try (BaseDirectoryWrapper roundTripDirectory = MapperServiceTestCase.newDirectory();){
            RandomIndexWriter roundTripIw = new RandomIndexWriter(MapperServiceTestCase.random(), (Directory)roundTripDirectory);
            roundTripIw.addDocument((Iterable)mapper.parse(new SourceToParse("1", (BytesReference)new BytesArray(syntheticSource), XContentType.JSON, null, Map.of(), false)).rootDoc());
            roundTripIw.close();
            try (DirectoryReader roundTripReader = DirectoryReader.open((Directory)roundTripDirectory);){
                String roundTripSyntheticSource = MapperServiceTestCase.syntheticSource(mapper, (IndexReader)roundTripReader, 0);
                MapperServiceTestCase.assertThat((Object)roundTripSyntheticSource, (Matcher)Matchers.equalTo((Object)syntheticSource));
                this.validateRoundTripReader(syntheticSource, reader, roundTripReader);
            }
        }
    }

    private static String syntheticSource(DocumentMapper mapper, IndexReader reader, int docId) throws IOException {
        SourceProvider provider = SourceProvider.fromSyntheticSource((Mapping)mapper.mapping());
        Source synthetic = provider.getSource(MapperServiceTestCase.getOnlyLeafReader((IndexReader)reader).getContext(), docId);
        return synthetic.internalSourceRef().utf8ToString();
    }

    protected static LeafStoredFieldLoader syntheticSourceStoredFieldLoader(DocumentMapper mapper, LeafReader leafReader, SourceLoader loader) throws IOException {
        if (loader.requiredStoredFields().isEmpty()) {
            return StoredFieldLoader.empty().getLoader(leafReader.getContext(), null);
        }
        LeafStoredFieldLoader storedFields = StoredFieldLoader.create((boolean)false, (Set)loader.requiredStoredFields()).getLoader(leafReader.getContext(), null);
        storedFields.advanceTo(0);
        return storedFields;
    }

    protected void validateRoundTripReader(String syntheticSource, DirectoryReader reader, DirectoryReader roundTripReader) throws IOException {
        this.assertReaderEquals("round trip " + syntheticSource, (IndexReader)new FieldMaskingReader("_recovery_source", reader), (IndexReader)new FieldMaskingReader("_recovery_source", roundTripReader));
    }

    protected static XContentBuilder syntheticSourceMapping(CheckedConsumer<XContentBuilder, IOException> buildFields) throws IOException {
        return MapperServiceTestCase.topMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("_source").field("mode", "synthetic").endObject();
            b.startObject("properties");
            buildFields.accept(b);
            b.endObject();
        }));
    }

    protected static XContentBuilder syntheticSourceFieldMapping(CheckedConsumer<XContentBuilder, IOException> buildField) throws IOException {
        return MapperServiceTestCase.syntheticSourceMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            buildField.accept(b);
            b.endObject();
        }));
    }
}

