/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.tests.analysis.MockAnalyzer;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.LeafFieldData;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockLoaderStoredFieldsFromLeafLoader;
import org.elasticsearch.index.mapper.BlockSourceReader;
import org.elasticsearch.index.mapper.DocValueFetcher;
import org.elasticsearch.index.mapper.DocumentLeafReader;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldTypeLookup;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MapperServiceTestCase;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.TestBlock;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.termvectors.TermVectorsService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptFactory;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.lookup.LeafStoredFieldsLookup;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.test.ListMatcher;
import org.elasticsearch.test.MapMatcher;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.mockito.Mockito;

public abstract class MapperTestCase
extends MapperServiceTestCase {
    public static final IndexVersion DEPRECATED_BOOST_INDEX_VERSION = IndexVersions.V_7_10_0;

    protected abstract void minimalMapping(XContentBuilder var1) throws IOException;

    protected void minimalMapping(XContentBuilder b, IndexVersion indexVersion) throws IOException {
        this.minimalMapping(b);
    }

    protected void writeField(XContentBuilder builder) throws IOException {
        builder.field("field");
        builder.value(this.getSampleValueForDocument());
    }

    protected abstract Object getSampleValueForDocument();

    protected Object getSampleObjectForDocument() {
        throw new UnsupportedOperationException("Field doesn't support object parsing.");
    }

    protected Object getSampleValueForQuery() {
        return this.getSampleValueForDocument();
    }

    public final void testExistsQueryMinimalMapping() throws IOException {
        MapperService mapperService = this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        this.assertExistsQuery(mapperService);
        this.assertParseMinimalWarnings();
    }

    public void testAggregatableConsistency() throws IOException {
        MapperService mapperService = this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        this.assertAggregatableConsistency(mapperService.fieldType("field"));
        this.assertParseMinimalWarnings();
    }

    protected void assertAggregatableConsistency(MappedFieldType ft) {
        if (ft.isAggregatable()) {
            try {
                ft.fielddataBuilder(FieldDataContext.noRuntimeFields((String)"aggregation_test"));
            }
            catch (Exception e) {
                MapperTestCase.fail((String)"Unexpected exception when fetching field data from aggregatable field type");
            }
        } else {
            MapperTestCase.expectThrows(IllegalArgumentException.class, () -> ft.fielddataBuilder(FieldDataContext.noRuntimeFields((String)"aggregation_test")));
        }
    }

    protected abstract boolean supportsIgnoreMalformed();

    protected final ExampleMalformedValue exampleMalformedValue(String value) {
        return this.exampleMalformedValue((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.value(value)));
    }

    protected final ExampleMalformedValue exampleMalformedValue(CheckedConsumer<XContentBuilder, IOException> value) {
        return new ExampleMalformedValue((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping), value, (Matcher<String>)Matchers.equalTo((Object)"unset"));
    }

    protected List<ExampleMalformedValue> exampleMalformedValues() {
        MapperTestCase.assertFalse((String)"mappers that support ignore_malformed values most override exampleMalformedValues", (boolean)this.supportsIgnoreMalformed());
        return List.of();
    }

    public final void testIgnoreMalformedFalseByDefault() throws IOException {
        for (ExampleMalformedValue example : this.exampleMalformedValues()) {
            this.assertIgnoreMalformedFalse(example.mapping, example.value, example.exceptionMessageMatcher);
        }
    }

    public final void testIgnoreMalformedExplicitlyFalse() throws IOException {
        if (!this.supportsIgnoreMalformed()) {
            Exception e = (Exception)MapperTestCase.expectThrows(MapperParsingException.class, () -> this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                this.minimalMapping((XContentBuilder)b);
                b.field("ignore_malformed", false);
            }))));
            MapperTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"unknown parameter [ignore_malformed] on mapper [field]"));
            return;
        }
        for (ExampleMalformedValue example : this.exampleMalformedValues()) {
            this.assertIgnoreMalformedFalse((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                example.mapping.accept(b);
                b.field("ignore_malformed", false);
            }), example.value, example.exceptionMessageMatcher);
        }
    }

    private void assertIgnoreMalformedFalse(CheckedConsumer<XContentBuilder, IOException> mapping, CheckedConsumer<XContentBuilder, IOException> value, Matcher<String> exceptionMessageMatcher) throws IOException {
        MapperService mapperService = this.createMapperService(MapperTestCase.fieldMapping(mapping));
        FieldMapper mapper = (FieldMapper)mapperService.documentMapper().mappers().getMapper("field");
        MapperTestCase.assertFalse((boolean)mapper.ignoreMalformed());
        SourceToParse source = MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.field("field");
            value.accept(b);
        }));
        DocumentParsingException e = (DocumentParsingException)MapperTestCase.expectThrows(DocumentParsingException.class, (String)("didn't throw while parsing " + source.source().utf8ToString()), () -> mapperService.documentMapper().parse(source));
        MapperTestCase.assertThat((String)("incorrect exception while parsing " + source.source().utf8ToString()), (Object)e.getCause().getMessage(), exceptionMessageMatcher);
    }

    public final void testIgnoreMalformedTrue() throws IOException {
        if (!this.supportsIgnoreMalformed()) {
            Exception e = (Exception)MapperTestCase.expectThrows(MapperParsingException.class, () -> this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                this.minimalMapping((XContentBuilder)b);
                b.field("ignore_malformed", true);
            }))));
            MapperTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"unknown parameter [ignore_malformed] on mapper [field]"));
            return;
        }
        for (ExampleMalformedValue example : this.exampleMalformedValues()) {
            XContentBuilder mapping = MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                example.mapping.accept(b);
                b.field("ignore_malformed", true);
            }));
            MapperService mapperService = this.createMapperService(mapping);
            FieldMapper mapper = (FieldMapper)mapperService.documentMapper().mappers().getMapper("field");
            MapperTestCase.assertTrue((boolean)mapper.ignoreMalformed());
            ParsedDocument doc = mapperService.documentMapper().parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                b.field("field");
                example.value.accept(b);
            })));
            List fields = doc.rootDoc().getFields("field");
            MapperTestCase.assertThat((Object)fields, (Matcher)Matchers.empty());
            MapperTestCase.assertThat((Object)TermVectorsService.getValues((List)doc.rootDoc().getFields("_ignored")), (Matcher)Matchers.contains((Object[])new String[]{"field"}));
        }
    }

    protected void assertExistsQuery(MapperService mapperService) throws IOException {
        LuceneDocument fields = mapperService.documentMapper().parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::writeField))).rootDoc();
        SearchExecutionContext searchExecutionContext = this.createSearchExecutionContext(mapperService);
        MappedFieldType fieldType = mapperService.fieldType("field");
        Query query = fieldType.existsQuery(searchExecutionContext);
        this.assertExistsQuery(fieldType, query, fields);
    }

    protected void assertExistsQuery(MappedFieldType fieldType, Query query, LuceneDocument fields) {
        if (fieldType.hasDocValues() || fieldType.getTextSearchInfo().hasNorms()) {
            MapperTestCase.assertThat((Object)query, (Matcher)Matchers.instanceOf(FieldExistsQuery.class));
            FieldExistsQuery fieldExistsQuery = (FieldExistsQuery)query;
            MapperTestCase.assertEquals((Object)"field", (Object)fieldExistsQuery.getField());
            MapperTestCase.assertNoFieldNamesField(fields);
        } else {
            MapperTestCase.assertThat((Object)query, (Matcher)Matchers.instanceOf(TermQuery.class));
            TermQuery termQuery = (TermQuery)query;
            MapperTestCase.assertEquals((Object)"_field_names", (Object)termQuery.getTerm().field());
            MapperTestCase.assertEquals((Object)"field", (Object)termQuery.getTerm().text());
            MapperTestCase.assertNoDocValuesField(fields, "field");
            if (fieldType.isIndexed() || fieldType.isStored()) {
                MapperTestCase.assertNotNull((Object)fields.getField("_field_names"));
            } else {
                MapperTestCase.assertNoFieldNamesField(fields);
            }
        }
    }

    protected static void assertNoFieldNamesField(LuceneDocument fields) {
        MapperTestCase.assertNull((Object)fields.getField("_field_names"));
    }

    protected static void assertHasNorms(LuceneDocument doc, String field) {
        List fields = doc.getFields(field);
        for (IndexableField indexableField : fields) {
            IndexableFieldType indexableFieldType = indexableField.fieldType();
            if (indexableFieldType.indexOptions() == IndexOptions.NONE) continue;
            MapperTestCase.assertFalse((boolean)indexableFieldType.omitNorms());
            return;
        }
        MapperTestCase.fail((String)("field [" + field + "] should be indexed but it isn't"));
    }

    protected static void assertNoDocValuesField(LuceneDocument doc, String field) {
        List fields = doc.getFields(field);
        for (IndexableField indexableField : fields) {
            MapperTestCase.assertEquals((Object)DocValuesType.NONE, (Object)indexableField.fieldType().docValuesType());
        }
    }

    protected <T> void assertDimension(boolean isDimension, Function<T, Boolean> checker) throws IOException {
        MapperService mapperService = this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("time_series_dimension", isDimension);
        })));
        MappedFieldType fieldType = mapperService.fieldType("field");
        MapperTestCase.assertThat((Object)checker.apply(fieldType), (Matcher)Matchers.equalTo((Object)isDimension));
    }

    protected <T> void assertMetricType(String metricType, Function<T, Enum<TimeSeriesParams.MetricType>> checker) throws IOException {
        MapperService mapperService = this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("time_series_metric", metricType);
        })));
        MappedFieldType fieldType = mapperService.fieldType("field");
        MapperTestCase.assertThat((Object)checker.apply(fieldType).toString(), (Matcher)Matchers.equalTo((Object)metricType));
    }

    public final void testEmptyName() {
        MapperParsingException e = (MapperParsingException)MapperTestCase.expectThrows(MapperParsingException.class, () -> this.createMapperService(MapperTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("");
            this.minimalMapping((XContentBuilder)b);
            b.endObject();
        }))));
        MapperTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"field name cannot be an empty string"));
    }

    public final void testBlankName() {
        IndexVersion version = this.getVersion();
        MapperTestCase.assumeTrue((String)"blank field names are rejected from 8.6.0 onwards", (boolean)version.onOrAfter((VersionId)IndexVersions.V_8_6_0));
        MapperParsingException e = (MapperParsingException)MapperTestCase.expectThrows(MapperParsingException.class, () -> this.createMapperService(version, MapperTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("  ");
            this.minimalMapping((XContentBuilder)b);
            b.endObject();
        }))));
        MapperTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"field name cannot contain only whitespaces"));
    }

    public final void testMinimalSerializesToItself() throws IOException {
        XContentBuilder orig = JsonXContent.contentBuilder().startObject();
        this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping))).documentMapper().mapping().toXContent(orig, ToXContent.EMPTY_PARAMS);
        orig.endObject();
        XContentBuilder parsedFromOrig = JsonXContent.contentBuilder().startObject();
        this.createMapperService(orig).documentMapper().mapping().toXContent(parsedFromOrig, ToXContent.EMPTY_PARAMS);
        parsedFromOrig.endObject();
        MapperTestCase.assertEquals((Object)Strings.toString((XContentBuilder)orig), (Object)Strings.toString((XContentBuilder)parsedFromOrig));
        this.assertParseMinimalWarnings();
    }

    public final void testMinimalToMaximal() throws IOException {
        XContentBuilder orig = JsonXContent.contentBuilder().startObject();
        this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping))).documentMapper().mapping().toXContent(orig, INCLUDE_DEFAULTS);
        orig.endObject();
        XContentBuilder parsedFromOrig = JsonXContent.contentBuilder().startObject();
        this.createMapperService(orig).documentMapper().mapping().toXContent(parsedFromOrig, INCLUDE_DEFAULTS);
        parsedFromOrig.endObject();
        MapperTestCase.assertEquals((Object)Strings.toString((XContentBuilder)orig), (Object)Strings.toString((XContentBuilder)parsedFromOrig));
        this.assertParseMaximalWarnings();
    }

    protected final void assertParseMinimalWarnings() {
        String[] warnings = this.getParseMinimalWarnings();
        if (warnings.length > 0) {
            this.assertWarnings(warnings);
        }
    }

    protected final void assertParseMaximalWarnings() {
        String[] warnings = this.getParseMaximalWarnings();
        if (warnings.length > 0) {
            this.assertWarnings(warnings);
        }
    }

    protected String[] getParseMinimalWarnings() {
        return Strings.EMPTY_ARRAY;
    }

    protected String[] getParseMinimalWarnings(IndexVersion indexVersion) {
        return this.getParseMinimalWarnings();
    }

    protected String[] getParseMaximalWarnings() {
        return Strings.EMPTY_ARRAY;
    }

    protected boolean supportsMeta() {
        return true;
    }

    protected boolean supportsCopyTo() {
        return true;
    }

    protected void metaMapping(XContentBuilder b) throws IOException {
        this.minimalMapping(b);
    }

    public final void testMeta() throws IOException {
        MapperTestCase.assumeTrue((String)"Field doesn't support meta", (boolean)this.supportsMeta());
        XContentBuilder mapping = MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.metaMapping((XContentBuilder)b);
            b.field("meta", Collections.singletonMap("foo", "bar"));
        }));
        MapperService mapperService = this.createMapperService(mapping);
        MapperTestCase.assertEquals((Object)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)mapping), (boolean)false, (XContentType)mapping.contentType()).v2(), (Object)XContentHelper.convertToMap((BytesReference)mapperService.documentMapper().mappingSource().uncompressed(), (boolean)false, (XContentType)mapping.contentType()).v2());
        mapping = MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::metaMapping));
        MapperTestCase.merge(mapperService, mapping);
        MapperTestCase.assertEquals((Object)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)mapping), (boolean)false, (XContentType)mapping.contentType()).v2(), (Object)XContentHelper.convertToMap((BytesReference)mapperService.documentMapper().mappingSource().uncompressed(), (boolean)false, (XContentType)mapping.contentType()).v2());
        mapping = MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.metaMapping((XContentBuilder)b);
            b.field("meta", Collections.singletonMap("baz", "quux"));
        }));
        MapperTestCase.merge(mapperService, mapping);
        MapperTestCase.assertEquals((Object)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)mapping), (boolean)false, (XContentType)mapping.contentType()).v2(), (Object)XContentHelper.convertToMap((BytesReference)mapperService.documentMapper().mappingSource().uncompressed(), (boolean)false, (XContentType)mapping.contentType()).v2());
    }

    public final void testDeprecatedBoostWarning() throws IOException {
        try {
            this.createMapperService(DEPRECATED_BOOST_INDEX_VERSION, MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                this.minimalMapping((XContentBuilder)b, DEPRECATED_BOOST_INDEX_VERSION);
                b.field("boost", 2.0);
            })));
            String[] warnings = Strings.concatStringArrays((String[])this.getParseMinimalWarnings(DEPRECATED_BOOST_INDEX_VERSION), (String[])new String[]{"Parameter [boost] on field [field] is deprecated and has no effect"});
            this.assertWarnings(warnings);
        }
        catch (MapperParsingException e) {
            MapperTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.anyOf((Matcher)Matchers.containsString((String)"Unknown parameter [boost]"), (Matcher)Matchers.containsString((String)"[boost : 2.0]")));
        }
    }

    public void testBoostNotAllowed() throws IOException {
        MapperParsingException e = (MapperParsingException)MapperTestCase.expectThrows(MapperParsingException.class, () -> this.createMapperService(this.boostNotAllowedIndexVersion(), MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("boost", 2.0);
        }))));
        MapperTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.anyOf((Matcher)Matchers.containsString((String)"Unknown parameter [boost]"), (Matcher)Matchers.containsString((String)"[boost : 2.0]")));
        this.assertParseMinimalWarnings();
    }

    protected IndexVersion boostNotAllowedIndexVersion() {
        return IndexVersions.V_8_0_0;
    }

    protected final List<?> fetchFromDocValues(MapperService mapperService, MappedFieldType ft, DocValueFormat format, Object sourceValue) throws IOException {
        SetOnce result = new SetOnce();
        MapperTestCase.withLuceneIndex(mapperService, (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)iw -> iw.addDocument((Iterable)mapperService.documentMapper().parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field(ft.name(), sourceValue)))).rootDoc())), (CheckedConsumer<DirectoryReader, IOException>)((CheckedConsumer)iw -> {
            SearchLookup lookup = new SearchLookup(arg_0 -> ((MapperService)mapperService).fieldType(arg_0), this.fieldDataLookup(mapperService), SourceProvider.fromStoredFields());
            DocValueFetcher valueFetcher = new DocValueFetcher(format, lookup.getForField(ft, MappedFieldType.FielddataOperation.SEARCH));
            IndexSearcher searcher = MapperTestCase.newSearcher((IndexReader)iw);
            LeafReaderContext context = (LeafReaderContext)searcher.getIndexReader().leaves().get(0);
            Source source = lookup.getSource(context, 0);
            valueFetcher.setNextReader(context);
            result.set((Object)valueFetcher.fetchValues(source, 0, new ArrayList()));
        }));
        return (List)result.get();
    }

    protected static void assertScriptDocValues(MapperService mapperService, Object sourceValue, Matcher<List<?>> dvMatcher) throws IOException {
        MapperTestCase.withLuceneIndex(mapperService, (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)iw -> iw.addDocument((Iterable)mapperService.documentMapper().parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("field", sourceValue)))).rootDoc())), (CheckedConsumer<DirectoryReader, IOException>)((CheckedConsumer)iw -> {
            IndexSearcher searcher = MapperTestCase.newSearcher((IndexReader)iw);
            MappedFieldType ft = mapperService.fieldType("field");
            SourceProvider sourceProvider = mapperService.mappingLookup().isSourceSynthetic() ? (ctx, doc) -> {
                throw new IllegalArgumentException("Can't load source in scripts in synthetic mode");
            } : SourceProvider.fromStoredFields();
            SearchLookup searchLookup = new SearchLookup(null, null, sourceProvider);
            IndexFieldData sfd = ft.fielddataBuilder(new FieldDataContext("", () -> searchLookup, Set::of, MappedFieldType.FielddataOperation.SCRIPT)).build(null, null);
            LeafFieldData lfd = sfd.load(MapperTestCase.getOnlyLeafReader((IndexReader)searcher.getIndexReader()).getContext());
            DocValuesScriptFieldFactory sff = lfd.getScriptFieldFactory("field");
            sff.setNextDocId(0);
            MapperTestCase.assertThat((Object)sff.toScriptDocValues(), (Matcher)dvMatcher);
        }));
    }

    protected abstract void registerParameters(ParameterChecker var1) throws IOException;

    public void testUpdates() throws IOException {
        MapperService mapperService;
        ParameterChecker checker = new ParameterChecker();
        this.registerParameters(checker);
        if (this.supportsIgnoreMalformed()) {
            checker.registerUpdateCheck((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("ignore_malformed", true)), m -> MapperTestCase.assertTrue((boolean)m.ignoreMalformed()));
        } else {
            MapperService mapperService2 = this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
            Exception e = (Exception)MapperTestCase.expectThrows(MapperParsingException.class, (String)"No conflict when setting parameter [ignore_malformed]", () -> MapperTestCase.merge(mapperService2, MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                this.minimalMapping((XContentBuilder)b);
                b.field("ignore_malformed", true);
            }))));
            MapperTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"unknown parameter [ignore_malformed] on mapper [field]"));
        }
        for (UpdateCheck updateCheck : checker.updateChecks) {
            mapperService = this.createMapperService(updateCheck.init);
            MapperTestCase.merge(mapperService, updateCheck.update);
            FieldMapper mapper = (FieldMapper)mapperService.documentMapper().mappers().getMapper("field");
            updateCheck.check.accept(mapper);
            MapperTestCase.merge(mapperService, updateCheck.update);
            mapper = (FieldMapper)mapperService.documentMapper().mappers().getMapper("field");
            updateCheck.check.accept(mapper);
        }
        for (String param : checker.conflictChecks.keySet()) {
            mapperService = this.createMapperService(checker.conflictChecks.get((Object)param).init);
            MapperTestCase.merge(mapperService, checker.conflictChecks.get((Object)param).init);
            Exception e = (Exception)MapperTestCase.expectThrows(IllegalArgumentException.class, (String)("No conflict when updating parameter [" + param + "]"), () -> MapperTestCase.merge(mapperService, checker.conflictChecks.get((Object)param).update));
            MapperTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.anyOf((Matcher)Matchers.containsString((String)("Cannot update parameter [" + param + "]")), (Matcher)Matchers.containsString((String)("different [" + param + "]"))));
        }
        this.assertParseMaximalWarnings();
    }

    public final void testTextSearchInfoConsistency() throws IOException {
        MapperService mapperService = this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        MappedFieldType fieldType = mapperService.fieldType("field");
        if (fieldType.getTextSearchInfo() == TextSearchInfo.NONE) {
            MapperTestCase.expectThrows(IllegalArgumentException.class, () -> fieldType.termQuery(null, null));
        } else {
            SearchExecutionContext searchExecutionContext = this.createSearchExecutionContext(mapperService);
            MapperTestCase.assertNotNull((Object)fieldType.termQuery(this.getSampleValueForQuery(), searchExecutionContext));
        }
        this.assertSearchable(fieldType);
        this.assertParseMinimalWarnings();
    }

    protected void assertSearchable(MappedFieldType fieldType) {
        MapperTestCase.assertEquals((Object)fieldType.isIndexed(), (Object)(fieldType.getTextSearchInfo() != TextSearchInfo.NONE ? 1 : 0));
    }

    public final void testFetch() throws IOException {
        MapperService mapperService = this.randomFetchTestMapper();
        try {
            MappedFieldType ft = mapperService.fieldType("field");
            this.assertFetch(mapperService, "field", this.generateRandomInputValue(ft), this.randomFetchTestFormat());
        }
        finally {
            this.assertParseMinimalWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void testFetchMany() throws IOException {
        MapperService mapperService = this.randomFetchTestMapper();
        try {
            MappedFieldType ft = mapperService.fieldType("field");
            int count = MapperTestCase.between(2, 10);
            ArrayList<Object> values = new ArrayList<Object>(count);
            while (values.size() < count) {
                values.add(this.generateRandomInputValue(ft));
            }
            this.assertFetchMany(mapperService, "field", values, this.randomFetchTestFormat(), count);
        }
        finally {
            this.assertParseMinimalWarnings();
        }
    }

    protected final MapperService randomFetchTestMapper() throws IOException {
        return this.createMapperService(MapperTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            this.randomFetchTestFieldConfig((XContentBuilder)b);
            b.endObject();
        })));
    }

    protected void randomFetchTestFieldConfig(XContentBuilder b) throws IOException {
        this.minimalMapping(b);
    }

    protected String randomFetchTestFormat() {
        return null;
    }

    protected void registerDimensionChecks(ParameterChecker checker) throws IOException {
        checker.registerConflictCheck("time_series_dimension", (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("time_series_dimension", true)));
        checker.registerConflictCheck("time_series_dimension", (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("time_series_dimension", false)));
        checker.registerConflictCheck("time_series_dimension", MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("time_series_dimension", false);
        })), MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("time_series_dimension", true);
        })));
        checker.registerConflictCheck("time_series_dimension", MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("time_series_dimension", true);
        })), MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("time_series_dimension", false);
        })));
    }

    protected abstract Object generateRandomInputValue(MappedFieldType var1);

    protected void assertFetchMany(MapperService mapperService, String field, Object value, String format, int count) throws IOException {
        this.assertFetch(mapperService, field, value, format);
    }

    protected void assertFetch(MapperService mapperService, String field, Object value, String format) throws IOException {
        MappedFieldType ft = mapperService.fieldType(field);
        MappedFieldType.FielddataOperation fdt = MappedFieldType.FielddataOperation.SEARCH;
        SourceToParse source = MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field(ft.name(), value)));
        DocValueFetcher docValueFetcher = new DocValueFetcher(ft.docValueFormat(format, null), ft.fielddataBuilder(FieldDataContext.noRuntimeFields((String)"test")).build((IndexFieldDataCache)new IndexFieldDataCache.None(), (CircuitBreakerService)new NoneCircuitBreakerService()));
        SearchExecutionContext searchExecutionContext = (SearchExecutionContext)Mockito.mock(SearchExecutionContext.class);
        Mockito.when((Object)searchExecutionContext.isSourceEnabled()).thenReturn((Object)true);
        Mockito.when((Object)searchExecutionContext.sourcePath(field)).thenReturn(Set.of(field));
        Mockito.when((Object)searchExecutionContext.getForField(ft, fdt)).thenAnswer(inv -> this.fieldDataLookup(mapperService).apply((Object)ft, () -> {
            throw new UnsupportedOperationException();
        }, (Object)fdt));
        ValueFetcher nativeFetcher = ft.valueFetcher(searchExecutionContext, format);
        ParsedDocument doc = mapperService.documentMapper().parse(source);
        MapperTestCase.withLuceneIndex(mapperService, (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)iw -> iw.addDocuments((Iterable)doc.docs())), (CheckedConsumer<DirectoryReader, IOException>)((CheckedConsumer)arg_0 -> this.lambda$assertFetch$48((ValueFetcher)docValueFetcher, nativeFetcher, value, arg_0)));
    }

    protected boolean dedupAfterFetch() {
        return false;
    }

    protected boolean supportsSearchLookup() {
        return true;
    }

    public final void testIndexTimeFieldData() throws IOException {
        MapperTestCase.assumeTrue((String)"Field type does not support access via search lookup", (boolean)this.supportsSearchLookup());
        MapperService mapperService = this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        this.assertParseMinimalWarnings();
        MappedFieldType fieldType = mapperService.fieldType("field");
        if (!fieldType.isAggregatable()) {
            return;
        }
        SourceToParse source = MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::writeField));
        ParsedDocument doc = mapperService.documentMapper().parse(source);
        MapperTestCase.withLuceneIndex(mapperService, (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)iw -> iw.addDocument((Iterable)doc.rootDoc())), (CheckedConsumer<DirectoryReader, IOException>)((CheckedConsumer)ir -> {
            LeafReaderContext ctx = (LeafReaderContext)ir.leaves().get(0);
            DocValuesScriptFieldFactory docValuesFieldSource = fieldType.fielddataBuilder(FieldDataContext.noRuntimeFields((String)"test")).build((IndexFieldDataCache)new IndexFieldDataCache.None(), (CircuitBreakerService)new NoneCircuitBreakerService()).load(ctx).getScriptFieldFactory("test");
            docValuesFieldSource.setNextDocId(0);
            DocumentLeafReader reader = new DocumentLeafReader(doc.rootDoc(), Collections.emptyMap());
            DocValuesScriptFieldFactory indexData = fieldType.fielddataBuilder(FieldDataContext.noRuntimeFields((String)"test")).build((IndexFieldDataCache)new IndexFieldDataCache.None(), (CircuitBreakerService)new NoneCircuitBreakerService()).load(reader.getContext()).getScriptFieldFactory("test");
            indexData.setNextDocId(0);
            MapperTestCase.assertThat((Object)docValuesFieldSource.toScriptDocValues(), (Matcher)Matchers.equalTo((Object)indexData.toScriptDocValues()));
        }));
    }

    protected boolean supportsStoredFields() {
        return true;
    }

    protected void minimalStoreMapping(XContentBuilder b) throws IOException {
        this.minimalMapping(b);
        b.field("store", true);
    }

    public final void testIndexTimeStoredFieldsAccess() throws IOException {
        MapperTestCase.assumeTrue((String)"Field type does not support stored fields", (boolean)this.supportsStoredFields());
        MapperService mapperService = this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalStoreMapping)));
        this.assertParseMinimalWarnings();
        MappedFieldType fieldType = mapperService.fieldType("field");
        SourceToParse source = MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::writeField));
        ParsedDocument doc = mapperService.documentMapper().parse(source);
        SearchLookup lookup = new SearchLookup(f -> fieldType, (f, s, t) -> {
            throw new UnsupportedOperationException();
        }, (ctx, docid) -> Source.fromBytes((BytesReference)doc.source()));
        MapperTestCase.withLuceneIndex(mapperService, (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)iw -> iw.addDocument((Iterable)doc.rootDoc())), (CheckedConsumer<DirectoryReader, IOException>)((CheckedConsumer)ir -> {
            LeafReaderContext ctx = (LeafReaderContext)ir.leaves().get(0);
            LeafStoredFieldsLookup storedFields = lookup.getLeafSearchLookup(ctx).fields();
            storedFields.setDocument(0);
            DocumentLeafReader reader = new DocumentLeafReader(doc.rootDoc(), Collections.emptyMap());
            LeafStoredFieldsLookup indexStoredFields = lookup.getLeafSearchLookup(reader.getContext()).fields();
            indexStoredFields.setDocument(0);
            MapperTestCase.assertThat((Object)storedFields.get((Object)"field").getValues(), (Matcher)Matchers.equalTo((Object)indexStoredFields.get((Object)"field").getValues()));
        }));
    }

    public final void testNullInput() throws Exception {
        DocumentMapper mapper = this.createDocumentMapper(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        if (this.allowsNullValues()) {
            ParsedDocument doc = mapper.parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.nullField("field"))));
            MapperTestCase.assertThat((Object)((LuceneDocument)doc.docs().get(0)).getFields("field"), (Matcher)Matchers.empty());
            MapperTestCase.assertThat((Object)((LuceneDocument)doc.docs().get(0)).getFields("_field_names"), (Matcher)Matchers.empty());
        } else {
            MapperTestCase.expectThrows(DocumentParsingException.class, () -> mapper.parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.nullField("field")))));
        }
        this.assertWarnings(this.getParseMinimalWarnings());
    }

    protected boolean allowsNullValues() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void testMinimalIsInvalidInRoutingPath() throws IOException {
        MapperService mapper = this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        try {
            IndexSettings settings = MapperTestCase.createIndexSettings(IndexVersion.current(), Settings.builder().put(IndexSettings.MODE.getKey(), "time_series").put(IndexMetadata.INDEX_ROUTING_PATH.getKey(), "field").put(IndexSettings.TIME_SERIES_START_TIME.getKey(), "2021-04-28T00:00:00Z").put(IndexSettings.TIME_SERIES_END_TIME.getKey(), "2021-04-29T00:00:00Z").build());
            Exception e = (Exception)MapperTestCase.expectThrows(IllegalArgumentException.class, () -> mapper.documentMapper().validate(settings, false));
            MapperTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)this.minimalIsInvalidRoutingPathErrorMessage(mapper.mappingLookup().getMapper("field"))));
        }
        finally {
            this.assertParseMinimalWarnings();
        }
    }

    protected String minimalIsInvalidRoutingPathErrorMessage(Mapper mapper) {
        return "All fields that match routing_path must be keywords with [time_series_dimension: true] or flattened fields with a list of dimensions in [time_series_dimensions] and without the [script] parameter. [" + mapper.name() + "] was [" + mapper.typeName() + "].";
    }

    protected abstract SyntheticSourceSupport syntheticSourceSupport(boolean var1);

    public final void testSyntheticSource() throws IOException {
        boolean ignoreMalformed = this.supportsIgnoreMalformed() ? MapperTestCase.rarely() : false;
        this.assertSyntheticSource(this.syntheticSourceSupport(ignoreMalformed).example(5));
    }

    public final void testSyntheticSourceIgnoreMalformedExamples() throws IOException {
        MapperTestCase.assumeTrue((String)"type doesn't support ignore_malformed", (boolean)this.supportsIgnoreMalformed());
        CheckedConsumer<XContentBuilder, IOException> mapping = this.syntheticSourceSupport(true).example(1).mapping();
        for (ExampleMalformedValue v : this.exampleMalformedValues()) {
            this.assertSyntheticSource(new SyntheticSourceExample(v.value, v.value, v.value, mapping));
        }
    }

    private void assertSyntheticSource(SyntheticSourceExample example) throws IOException {
        DocumentMapper mapper = this.createDocumentMapper(MapperTestCase.syntheticSourceMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            example.mapping().accept(b);
            b.endObject();
        })));
        MapperTestCase.assertThat((Object)this.syntheticSource(mapper, (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)example::buildInput)), (Matcher)Matchers.equalTo((Object)example.expected()));
    }

    protected boolean supportsEmptyInputArray() {
        return true;
    }

    public void testSupportsParsingObject() throws IOException {
        DocumentMapper mapper = this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping))).documentMapper();
        FieldMapper fieldMapper = (FieldMapper)mapper.mappers().getMapper("field");
        if (fieldMapper.supportsParsingObject()) {
            Object sampleValueForDocument = this.getSampleObjectForDocument();
            MapperTestCase.assertThat((Object)sampleValueForDocument, (Matcher)Matchers.instanceOf(Map.class));
            SourceToParse source = MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)builder -> {
                builder.field("field");
                builder.value(sampleValueForDocument);
            }));
            ParsedDocument doc = mapper.parse(source);
            MapperTestCase.assertNotNull((Object)doc);
        } else {
            MapperTestCase.expectThrows(Exception.class, () -> mapper.parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                b.startObject("field");
                b.endObject();
            }))));
        }
    }

    public final void testSyntheticSourceMany() throws IOException {
        boolean ignoreMalformed = this.supportsIgnoreMalformed() ? MapperTestCase.rarely() : false;
        int maxValues = MapperTestCase.randomBoolean() ? 1 : 5;
        SyntheticSourceSupport support = this.syntheticSourceSupport(ignoreMalformed);
        DocumentMapper mapper = this.createDocumentMapper(MapperTestCase.syntheticSourceMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            support.example(maxValues).mapping().accept(b);
            b.endObject();
        })));
        int count = MapperTestCase.between(2, 1000);
        String[] expected = new String[count];
        try (BaseDirectoryWrapper directory = MapperTestCase.newDirectory();){
            int i;
            try (RandomIndexWriter iw = new RandomIndexWriter(MapperTestCase.random(), (Directory)directory, LuceneTestCase.newIndexWriterConfig((Random)MapperTestCase.random(), (Analyzer)new MockAnalyzer(MapperTestCase.random())).setMergePolicy(NoMergePolicy.INSTANCE));){
                for (i = 0; i < count; ++i) {
                    if (MapperTestCase.rarely() && this.supportsEmptyInputArray()) {
                        expected[i] = "{}";
                        iw.addDocument((Iterable)mapper.parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.startArray("field").endArray()))).rootDoc());
                        continue;
                    }
                    SyntheticSourceExample example = support.example(maxValues);
                    expected[i] = example.expected();
                    iw.addDocument((Iterable)mapper.parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)example::buildInput))).rootDoc());
                }
            }
            try (DirectoryReader reader = DirectoryReader.open((Directory)directory);){
                i = 0;
                SourceLoader loader = mapper.sourceMapper().newSourceLoader(mapper.mapping());
                StoredFieldLoader storedFieldLoader = loader.requiredStoredFields().isEmpty() ? StoredFieldLoader.empty() : StoredFieldLoader.create((boolean)false, (Set)loader.requiredStoredFields());
                for (LeafReaderContext leaf : reader.leaves()) {
                    int[] docIds = IntStream.range(0, leaf.reader().maxDoc()).toArray();
                    SourceLoader.Leaf sourceLoaderLeaf = loader.leaf(leaf.reader(), docIds);
                    LeafStoredFieldLoader storedLeaf = storedFieldLoader.getLoader(leaf, docIds);
                    for (int docId : docIds) {
                        storedLeaf.advanceTo(docId);
                        String source = sourceLoaderLeaf.source(storedLeaf, docId).internalSourceRef().utf8ToString();
                        MapperTestCase.assertThat((String)("doc " + docId), (Object)source, (Matcher)Matchers.equalTo((Object)expected[i++]));
                    }
                }
            }
        }
    }

    public final void testNoSyntheticSourceForScript() throws IOException {
        this.ingestScriptSupport();
        DocumentMapper mapper = this.createDocumentMapper(MapperTestCase.syntheticSourceMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            this.minimalMapping((XContentBuilder)b);
            b.field("script", MapperTestCase.randomBoolean() ? "empty" : "non-empty");
            b.endObject();
        })));
        MapperTestCase.assertThat((Object)this.syntheticSource(mapper, (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {})), (Matcher)Matchers.equalTo((Object)"{}"));
    }

    public final void testSyntheticSourceInObject() throws IOException {
        boolean ignoreMalformed = this.supportsIgnoreMalformed() ? MapperTestCase.rarely() : false;
        SyntheticSourceExample syntheticSourceExample = this.syntheticSourceSupport(ignoreMalformed).example(5);
        DocumentMapper mapper = this.createDocumentMapper(MapperTestCase.syntheticSourceMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("obj").startObject("properties").startObject("field");
            syntheticSourceExample.mapping().accept(b);
            b.endObject().endObject().endObject();
        })));
        MapperTestCase.assertThat((Object)this.syntheticSource(mapper, (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("obj");
            syntheticSourceExample.buildInput((XContentBuilder)b);
            b.endObject();
        })), (Matcher)Matchers.equalTo((Object)("{\"obj\":" + syntheticSourceExample.expected() + "}")));
    }

    public final void testSyntheticEmptyList() throws IOException {
        MapperTestCase.assumeTrue((String)"Field does not support [] as input", (boolean)this.supportsEmptyInputArray());
        boolean ignoreMalformed = this.supportsIgnoreMalformed() ? MapperTestCase.rarely() : false;
        SyntheticSourceExample syntheticSourceExample = this.syntheticSourceSupport(ignoreMalformed).example(5);
        DocumentMapper mapper = this.createDocumentMapper(MapperTestCase.syntheticSourceMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            syntheticSourceExample.mapping().accept(b);
            b.endObject();
        })));
        MapperTestCase.assertThat((Object)this.syntheticSource(mapper, (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.startArray("field").endArray())), (Matcher)Matchers.equalTo((Object)"{}"));
    }

    public final void testSyntheticEmptyListNoDocValuesLoader() throws IOException {
        MapperTestCase.assumeTrue((String)"Field does not support [] as input", (boolean)this.supportsEmptyInputArray());
        this.assertNoDocValueLoader((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.startArray("field").endArray()));
    }

    public final void testBlockLoaderFromColumnReader() throws IOException {
        this.testBlockLoader(true);
    }

    public final void testBlockLoaderFromRowStrideReader() throws IOException {
        this.testBlockLoader(false);
    }

    protected boolean supportsColumnAtATimeReader(MapperService mapper, MappedFieldType ft) {
        return ft.hasDocValues();
    }

    private void testBlockLoader(boolean columnReader) throws IOException {
        SyntheticSourceExample example = this.syntheticSourceSupport(false).example(5);
        MapperService mapper = this.createMapperService(MapperTestCase.syntheticSourceMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            example.mapping().accept(b);
            b.endObject();
        })));
        this.testBlockLoader(columnReader, example, mapper, "field");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void testBlockLoader(boolean columnReader, SyntheticSourceExample example, final MapperService mapper, String loaderFieldName) throws IOException {
        final SearchLookup searchLookup = new SearchLookup(arg_0 -> ((FieldTypeLookup)mapper.mappingLookup().fieldTypesLookup()).get(arg_0), null, null);
        BlockLoader loader = mapper.fieldType(loaderFieldName).blockLoader(new MappedFieldType.BlockLoaderContext(){

            public String indexName() {
                throw new UnsupportedOperationException();
            }

            public SearchLookup lookup() {
                return searchLookup;
            }

            public Set<String> sourcePaths(String name) {
                return mapper.mappingLookup().sourcePaths(name);
            }

            public String parentField(String field) {
                return mapper.mappingLookup().parentField(field);
            }
        });
        Function<Object, Object> valuesConvert = this.loadBlockExpected();
        if (valuesConvert == null) {
            MapperTestCase.assertNull((Object)loader);
            return;
        }
        try (BaseDirectoryWrapper directory = MapperTestCase.newDirectory();){
            RandomIndexWriter iw = new RandomIndexWriter(MapperTestCase.random(), (Directory)directory);
            LuceneDocument doc = mapper.documentMapper().parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                b.field("field");
                example.inputValue.accept(b);
            }))).rootDoc();
            iw.addDocument((Iterable)doc);
            iw.close();
            try (DirectoryReader reader = DirectoryReader.open((Directory)directory);){
                Object expected;
                TestBlock block;
                LeafReaderContext ctx = (LeafReaderContext)reader.leaves().get(0);
                if (columnReader) {
                    if (!this.supportsColumnAtATimeReader(mapper, mapper.fieldType(loaderFieldName))) {
                        MapperTestCase.assertNull((Object)loader.columnAtATimeReader(ctx));
                        return;
                    }
                    block = (TestBlock)loader.columnAtATimeReader(ctx).read(TestBlock.factory(ctx.reader().numDocs()), TestBlock.docs(0));
                } else {
                    BlockLoaderStoredFieldsFromLeafLoader storedFieldsLoader = new BlockLoaderStoredFieldsFromLeafLoader(StoredFieldLoader.fromSpec((StoredFieldsSpec)loader.rowStrideStoredFieldSpec()).getLoader(ctx, null), loader.rowStrideStoredFieldSpec().requiresSource() ? SourceLoader.FROM_STORED_SOURCE.leaf(ctx.reader(), null) : null);
                    storedFieldsLoader.advanceTo(0);
                    BlockLoader.Builder builder = loader.builder(TestBlock.factory(ctx.reader().numDocs()), 1);
                    loader.rowStrideReader(ctx).read(0, (BlockLoader.StoredFields)storedFieldsLoader, builder);
                    block = (TestBlock)builder.build();
                }
                List<Object> inBlock = block.get(0);
                if (inBlock != null) {
                    if (inBlock instanceof List) {
                        List l = inBlock;
                        inBlock = l.stream().map(valuesConvert).toList();
                    } else {
                        inBlock = valuesConvert.apply(inBlock);
                    }
                }
                Object object = expected = loader instanceof BlockSourceReader ? example.expectedParsed() : example.expectedParsedBlockLoader();
                if (List.of().equals(expected)) {
                    MapperTestCase.assertThat(inBlock, (Matcher)Matchers.nullValue());
                    return;
                }
                if (expected instanceof List) {
                    List l = (List)expected;
                    ListMatcher m = ListMatcher.matchesList();
                    Iterator iterator = l.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            MapMatcher.assertMap(inBlock, m);
                            return;
                        }
                        Object v = iterator.next();
                        m = m.item(this.blockItemMatcher(v));
                    }
                }
                Matcher<?> e = this.blockItemMatcher(expected);
                MapperTestCase.assertThat(inBlock, e);
                return;
            }
        }
    }

    protected Matcher<?> blockItemMatcher(Object expected) {
        return Matchers.equalTo((Object)expected);
    }

    protected Function<Object, Object> loadBlockExpected() {
        return null;
    }

    public final void testEmptyDocumentNoDocValueLoader() throws IOException {
        MapperTestCase.assumeFalse((String)"Field will add values even if no fields are supplied", (boolean)this.addsValueWhenNotSupplied());
        this.assertNoDocValueLoader((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {}));
    }

    protected boolean addsValueWhenNotSupplied() {
        return false;
    }

    private void assertNoDocValueLoader(CheckedConsumer<XContentBuilder, IOException> doc) throws IOException {
        boolean ignoreMalformed = this.supportsIgnoreMalformed() ? MapperTestCase.rarely() : false;
        SyntheticSourceExample syntheticSourceExample = this.syntheticSourceSupport(ignoreMalformed).example(5);
        DocumentMapper mapper = this.createDocumentMapper(MapperTestCase.syntheticSourceMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            syntheticSourceExample.mapping().accept(b);
            b.endObject();
        })));
        try (BaseDirectoryWrapper directory = MapperTestCase.newDirectory();){
            RandomIndexWriter iw = new RandomIndexWriter(MapperTestCase.random(), (Directory)directory);
            iw.addDocument((Iterable)mapper.parse(MapperTestCase.source(doc)).rootDoc());
            iw.close();
            try (DirectoryReader reader = DirectoryReader.open((Directory)directory);){
                LeafReader leafReader = MapperTestCase.getOnlyLeafReader((IndexReader)reader);
                SourceLoader.SyntheticFieldLoader fieldLoader = mapper.mapping().getRoot().getMapper("field").syntheticFieldLoader();
                MapperTestCase.assertThat((Object)fieldLoader.docValuesLoader(leafReader, new int[]{0}), (Matcher)Matchers.nullValue());
            }
        }
    }

    public final void testSyntheticSourceInvalid() throws IOException {
        boolean ignoreMalformed = this.supportsIgnoreMalformed() ? MapperTestCase.rarely() : false;
        ArrayList<SyntheticSourceInvalidExample> examples = new ArrayList<SyntheticSourceInvalidExample>(this.syntheticSourceSupport(ignoreMalformed).invalidExample());
        if (this.supportsCopyTo()) {
            examples.add(new SyntheticSourceInvalidExample((Matcher<String>)Matchers.matchesPattern((String)"field \\[field] of type \\[.+] doesn't support synthetic source because it declares copy_to"), (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                this.syntheticSourceSupport(ignoreMalformed).example(5).mapping().accept(b);
                b.field("copy_to", "bar");
            })));
        }
        for (SyntheticSourceInvalidExample example : examples) {
            Exception e = (Exception)MapperTestCase.expectThrows(IllegalArgumentException.class, (String)example.toString(), () -> this.createDocumentMapper(MapperTestCase.syntheticSourceMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                b.startObject("field");
                example.mapping.accept(b);
                b.endObject();
            }))));
            MapperTestCase.assertThat((Object)e.getMessage(), example.error);
        }
    }

    @Override
    protected final <T> T compileScript(Script script, ScriptContext<T> context) {
        return this.ingestScriptSupport().compileScript(script, context);
    }

    protected abstract IngestScriptSupport ingestScriptSupport();

    private /* synthetic */ void lambda$assertFetch$48(ValueFetcher docValueFetcher, ValueFetcher nativeFetcher, Object value, DirectoryReader ir) throws IOException {
        Source s = SourceProvider.fromStoredFields().getSource((LeafReaderContext)ir.leaves().get(0), 0);
        docValueFetcher.setNextReader((LeafReaderContext)ir.leaves().get(0));
        nativeFetcher.setNextReader((LeafReaderContext)ir.leaves().get(0));
        List fromDocValues = docValueFetcher.fetchValues(s, 0, new ArrayList());
        List fromNative = nativeFetcher.fetchValues(s, 0, new ArrayList());
        fromNative = fromNative.stream().map(o -> {
            if (o instanceof Integer || o instanceof Short || o instanceof Byte) {
                return ((Number)o).longValue();
            }
            if (o instanceof Float) {
                return ((Float)o).doubleValue();
            }
            return o;
        }).collect(Collectors.toList());
        if (this.dedupAfterFetch()) {
            fromNative = fromNative.stream().distinct().collect(Collectors.toList());
        }
        MapperTestCase.assertThat((String)("fetching " + value), fromNative, (Matcher)Matchers.containsInAnyOrder((Object[])fromDocValues.toArray()));
    }

    public static class ExampleMalformedValue {
        private final CheckedConsumer<XContentBuilder, IOException> mapping;
        private final CheckedConsumer<XContentBuilder, IOException> value;
        private final Matcher<String> exceptionMessageMatcher;

        private ExampleMalformedValue(CheckedConsumer<XContentBuilder, IOException> mapping, CheckedConsumer<XContentBuilder, IOException> value, Matcher<String> exceptionMessageMatcher) {
            this.mapping = mapping;
            this.value = value;
            this.exceptionMessageMatcher = exceptionMessageMatcher;
        }

        public ExampleMalformedValue mapping(CheckedConsumer<XContentBuilder, IOException> newMapping) {
            return new ExampleMalformedValue(newMapping, this.value, this.exceptionMessageMatcher);
        }

        public ExampleMalformedValue errorMatches(String contains) {
            return this.errorMatches((Matcher<String>)Matchers.containsString((String)contains));
        }

        public ExampleMalformedValue errorMatches(Matcher<String> newMatcher) {
            return new ExampleMalformedValue(this.mapping, this.value, newMatcher);
        }
    }

    public class ParameterChecker {
        List<UpdateCheck> updateChecks = new ArrayList<UpdateCheck>();
        Map<String, ConflictCheck> conflictChecks = new HashMap<String, ConflictCheck>();

        public void registerUpdateCheck(CheckedConsumer<XContentBuilder, IOException> update, Consumer<FieldMapper> check) throws IOException {
            this.updateChecks.add(new UpdateCheck(update, check));
        }

        public void registerUpdateCheck(CheckedConsumer<XContentBuilder, IOException> init, CheckedConsumer<XContentBuilder, IOException> update, Consumer<FieldMapper> check) throws IOException {
            this.updateChecks.add(new UpdateCheck(init, update, check));
        }

        public void registerConflictCheck(String param, CheckedConsumer<XContentBuilder, IOException> update) throws IOException {
            this.conflictChecks.put(param, new ConflictCheck(MapperServiceTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)MapperTestCase.this::minimalMapping)), MapperServiceTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                MapperTestCase.this.minimalMapping((XContentBuilder)b);
                update.accept(b);
            }))));
        }

        public void registerConflictCheck(String param, XContentBuilder init, XContentBuilder update) {
            this.conflictChecks.put(param, new ConflictCheck(init, update));
        }
    }

    private class UpdateCheck {
        final XContentBuilder init;
        final XContentBuilder update;
        final Consumer<FieldMapper> check;

        private UpdateCheck(CheckedConsumer<XContentBuilder, IOException> update, Consumer<FieldMapper> check) throws IOException {
            this.init = MapperServiceTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)MapperTestCase.this::minimalMapping));
            this.update = MapperServiceTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                MapperTestCase.this.minimalMapping((XContentBuilder)b);
                update.accept(b);
            }));
            this.check = check;
        }

        private UpdateCheck(CheckedConsumer<XContentBuilder, IOException> init, CheckedConsumer<XContentBuilder, IOException> update, Consumer<FieldMapper> check) throws IOException {
            this.init = MapperServiceTestCase.fieldMapping(init);
            this.update = MapperServiceTestCase.fieldMapping(update);
            this.check = check;
        }
    }

    private record ConflictCheck(XContentBuilder init, XContentBuilder update) {
    }

    public static interface SyntheticSourceSupport {
        public SyntheticSourceExample example(int var1) throws IOException;

        public List<SyntheticSourceInvalidExample> invalidExample() throws IOException;
    }

    public record SyntheticSourceExample(CheckedConsumer<XContentBuilder, IOException> inputValue, CheckedConsumer<XContentBuilder, IOException> result, CheckedConsumer<XContentBuilder, IOException> blockLoaderResult, CheckedConsumer<XContentBuilder, IOException> mapping) {
        public SyntheticSourceExample(Object inputValue, Object result, CheckedConsumer<XContentBuilder, IOException> mapping) {
            this((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.value(inputValue)), (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.value(result)), (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.value(result)), mapping);
        }

        public SyntheticSourceExample(Object inputValue, Object result, Object blockLoaderResults, CheckedConsumer<XContentBuilder, IOException> mapping) {
            this((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.value(inputValue)), (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.value(result)), (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.value(blockLoaderResults)), mapping);
        }

        private void buildInput(XContentBuilder b) throws IOException {
            b.field("field");
            this.inputValue.accept((Object)b);
        }

        private String expected() throws IOException {
            XContentBuilder b = JsonXContent.contentBuilder().startObject().field("field");
            this.result.accept((Object)b);
            return Strings.toString((XContentBuilder)b.endObject());
        }

        private Object expectedParsed() throws IOException {
            return XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)this.expected(), (boolean)false).get("field");
        }

        private String expectedBlockLoader() throws IOException {
            XContentBuilder b = JsonXContent.contentBuilder().startObject().field("field");
            this.blockLoaderResult.accept((Object)b);
            return Strings.toString((XContentBuilder)b.endObject());
        }

        private Object expectedParsedBlockLoader() throws IOException {
            return XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)this.expectedBlockLoader(), (boolean)false).get("field");
        }
    }

    protected abstract class IngestScriptSupport {
        protected IngestScriptSupport() {
        }

        private <T> T compileScript(Script script, ScriptContext<T> context) {
            switch (script.getIdOrCode()) {
                case "empty": {
                    return context.factoryClazz.cast(this.emptyFieldScript());
                }
                case "non-empty": {
                    return context.factoryClazz.cast(this.nonEmptyFieldScript());
                }
            }
            return this.compileOtherScript(script, context);
        }

        protected <T> T compileOtherScript(Script script, ScriptContext<T> context) {
            throw new UnsupportedOperationException("Unknown script " + script.getIdOrCode());
        }

        abstract ScriptFactory emptyFieldScript();

        abstract ScriptFactory nonEmptyFieldScript();
    }

    public record SyntheticSourceInvalidExample(Matcher<String> error, CheckedConsumer<XContentBuilder, IOException> mapping) {
    }
}

