/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MapperServiceTestCase;
import org.elasticsearch.test.index.IndexVersionUtils;
import org.elasticsearch.xcontent.XContentBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class MetadataMapperTestCase
extends MapperServiceTestCase {
    protected abstract String fieldName();

    protected abstract boolean isConfigurable();

    protected boolean isSupportedOn(IndexVersion version) {
        return true;
    }

    protected abstract void registerParameters(ParameterChecker var1) throws IOException;

    public final void testUpdates() throws IOException {
        MapperService mapperService;
        MetadataMapperTestCase.assumeTrue((String)("Metadata field " + this.fieldName() + " isn't configurable"), (boolean)this.isConfigurable());
        ParameterChecker checker = new ParameterChecker();
        this.registerParameters(checker);
        for (String param : checker.conflictChecks.keySet()) {
            mapperService = this.createMapperService(checker.conflictChecks.get((Object)param).init);
            MetadataMapperTestCase.merge(mapperService, checker.conflictChecks.get((Object)param).init);
            Exception e = (Exception)MetadataMapperTestCase.expectThrows(IllegalArgumentException.class, (String)("No conflict when updating parameter [" + param + "]"), () -> MetadataMapperTestCase.merge(mapperService, checker.conflictChecks.get((Object)param).update));
            MetadataMapperTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.anyOf((Matcher)Matchers.containsString((String)("Cannot update parameter [" + param + "]")), (Matcher)Matchers.containsString((String)("different [" + param + "]"))));
        }
        for (UpdateCheck updateCheck : checker.updateChecks) {
            mapperService = this.createMapperService(updateCheck.init);
            MetadataMapperTestCase.merge(mapperService, updateCheck.update);
            updateCheck.check.accept(mapperService.documentMapper());
        }
    }

    public final void testUnsupportedParametersAreRejected() throws IOException {
        MetadataMapperTestCase.assumeTrue((String)("Metadata field " + this.fieldName() + " isn't configurable"), (boolean)this.isConfigurable());
        IndexVersion version = IndexVersionUtils.randomCompatibleVersion(MetadataMapperTestCase.random());
        MetadataMapperTestCase.assumeTrue((String)("Metadata field " + this.fieldName() + " is not supported on version " + version), (boolean)this.isSupportedOn(version));
        MapperService mapperService = this.createMapperService(version, MetadataMapperTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)xContentBuilder -> {})));
        String mappingAsString = "{\n    \"_doc\" : {\n      \"" + this.fieldName() + "\" : {\n        \"anything\" : \"anything\"\n      }\n    }\n}";
        MapperParsingException exception = (MapperParsingException)MetadataMapperTestCase.expectThrows(MapperParsingException.class, () -> mapperService.parseMapping("_doc", new CompressedXContent(mappingAsString)));
        MetadataMapperTestCase.assertEquals((Object)("Failed to parse mapping: unknown parameter [anything] on metadata field [" + this.fieldName() + "]"), (Object)exception.getMessage());
    }

    public final void testFixedMetaFieldsAreNotConfigurable() throws IOException {
        MetadataMapperTestCase.assumeFalse((String)("Metadata field " + this.fieldName() + " is configurable"), (boolean)this.isConfigurable());
        IndexVersion version = IndexVersionUtils.randomCompatibleVersion(MetadataMapperTestCase.random());
        MetadataMapperTestCase.assumeTrue((String)("Metadata field " + this.fieldName() + " is not supported on version " + version), (boolean)this.isSupportedOn(version));
        MapperService mapperService = this.createMapperService(version, MetadataMapperTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)xContentBuilder -> {})));
        String mappingAsString = "{\n    \"_doc\" : {\n      \"" + this.fieldName() + "\" : {\n      }\n    }\n}";
        MapperParsingException exception = (MapperParsingException)MetadataMapperTestCase.expectThrows(MapperParsingException.class, () -> mapperService.parseMapping("_doc", new CompressedXContent(mappingAsString)));
        MetadataMapperTestCase.assertEquals((Object)("Failed to parse mapping: " + this.fieldName() + " is not configurable"), (Object)exception.getMessage());
    }

    public void testTypeAndFriendsAreAcceptedBefore_8_6_0() throws IOException {
        String[] unsupportedParameters;
        MetadataMapperTestCase.assumeTrue((String)("Metadata field " + this.fieldName() + " isn't configurable"), (boolean)this.isConfigurable());
        IndexVersion previousVersion = IndexVersionUtils.getPreviousVersion(IndexVersions.V_8_6_0);
        IndexVersion version = IndexVersionUtils.randomVersionBetween(MetadataMapperTestCase.random(), IndexVersions.V_7_0_0, previousVersion);
        MetadataMapperTestCase.assumeTrue((String)("Metadata field " + this.fieldName() + " is not supported on version " + version), (boolean)this.isSupportedOn(version));
        MapperService mapperService = this.createMapperService(version, MetadataMapperTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {})));
        for (String param : unsupportedParameters = new String[]{"fields", "copy_to", "boost", "type"}) {
            String mappingAsString = "{\n    \"_doc\" : {\n      \"" + this.fieldName() + "\" : {\n        \"" + param + "\" : \"any\"\n      }\n    }\n}";
            MetadataMapperTestCase.assertNotNull((Object)mapperService.parseMapping("_doc", new CompressedXContent(mappingAsString)));
        }
    }

    public void testTypeAndFriendsAreDeprecatedFrom_8_6_0() throws IOException {
        String[] unsupportedParameters;
        MetadataMapperTestCase.assumeTrue((String)("Metadata field " + this.fieldName() + " isn't configurable"), (boolean)this.isConfigurable());
        IndexVersion version = IndexVersionUtils.randomVersionBetween(MetadataMapperTestCase.random(), IndexVersions.V_8_6_0, IndexVersion.current());
        MetadataMapperTestCase.assumeTrue((String)("Metadata field " + this.fieldName() + " is not supported on version " + version), (boolean)this.isSupportedOn(version));
        MapperService mapperService = this.createMapperService(version, MetadataMapperTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {})));
        for (String param : unsupportedParameters = new String[]{"fields", "copy_to", "boost", "type"}) {
            String mappingAsString = "{\n    \"_doc\" : {\n      \"" + this.fieldName() + "\" : {\n        \"" + param + "\" : \"any\"\n      }\n    }\n}";
            MetadataMapperTestCase.assertNotNull((Object)mapperService.parseMapping("_doc", new CompressedXContent(mappingAsString)));
            this.assertWarnings("Parameter [" + param + "] has no effect on metadata field [" + this.fieldName() + "] and will be removed in future");
        }
    }

    public class ParameterChecker {
        Map<String, ConflictCheck> conflictChecks = new HashMap<String, ConflictCheck>();
        List<UpdateCheck> updateChecks = new ArrayList<UpdateCheck>();

        public void registerConflictCheck(String param, CheckedConsumer<XContentBuilder, IOException> update) throws IOException {
            this.conflictChecks.put(param, new ConflictCheck(MapperServiceTestCase.topMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.startObject(MetadataMapperTestCase.this.fieldName()).endObject())), MapperServiceTestCase.topMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                b.startObject(MetadataMapperTestCase.this.fieldName());
                update.accept(b);
                b.endObject();
            }))));
        }

        public void registerConflictCheck(String param, XContentBuilder init, XContentBuilder update) {
            this.conflictChecks.put(param, new ConflictCheck(init, update));
        }

        public void registerUpdateCheck(XContentBuilder init, XContentBuilder update, Consumer<DocumentMapper> check) {
            this.updateChecks.add(new UpdateCheck(init, update, check));
        }
    }

    private record ConflictCheck(XContentBuilder init, XContentBuilder update) {
    }

    private record UpdateCheck(XContentBuilder init, XContentBuilder update, Consumer<DocumentMapper> check) {
    }
}

