/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.readiness;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Set;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.readiness.ReadinessService;

public class MockReadinessService
extends ReadinessService {
    private static final int RETRIES = 3;
    private static final int RETRY_DELAY_IN_MILLIS = 10;
    private static final String METHOD_NOT_MOCKED = "This method has not been mocked";

    public MockReadinessService(ClusterService clusterService, Environment environment) {
        super(clusterService, environment, MockServerSocketChannel::openMock);
    }

    private static boolean socketIsOpen(ReadinessService readinessService) {
        ServerSocketChannel mockedSocket = readinessService.serverChannel();
        return mockedSocket != null && mockedSocket.isOpen();
    }

    public static void tcpReadinessProbeTrue(ReadinessService readinessService) throws InterruptedException {
        for (int i = 1; i <= 3; ++i) {
            if (MockReadinessService.socketIsOpen(readinessService)) {
                return;
            }
            Thread.sleep(10 * i);
        }
        throw new AssertionError((Object)"Readiness socket should be open");
    }

    public static void tcpReadinessProbeFalse(ReadinessService readinessService) throws InterruptedException {
        for (int i = 0; i < 3; ++i) {
            if (!MockReadinessService.socketIsOpen(readinessService)) {
                return;
            }
            Thread.sleep(10 * i);
        }
        throw new AssertionError((Object)"Readiness socket should be closed");
    }

    private static class MockServerSocketChannel
    extends ServerSocketChannel {
        static ServerSocketChannel openMock() {
            return new MockServerSocketChannel();
        }

        private MockServerSocketChannel() {
            super(SelectorProvider.provider());
        }

        @Override
        public ServerSocketChannel bind(SocketAddress local, int backlog) {
            assert (this.isOpen());
            return this;
        }

        @Override
        public <T> ServerSocketChannel setOption(SocketOption<T> name, T value) {
            throw new UnsupportedOperationException(MockReadinessService.METHOD_NOT_MOCKED);
        }

        @Override
        public <T> T getOption(SocketOption<T> name) {
            throw new UnsupportedOperationException(MockReadinessService.METHOD_NOT_MOCKED);
        }

        @Override
        public Set<SocketOption<?>> supportedOptions() {
            throw new UnsupportedOperationException(MockReadinessService.METHOD_NOT_MOCKED);
        }

        @Override
        public ServerSocket socket() {
            throw new UnsupportedOperationException(MockReadinessService.METHOD_NOT_MOCKED);
        }

        @Override
        public SocketChannel accept() {
            return null;
        }

        @Override
        public SocketAddress getLocalAddress() {
            return new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
        }

        @Override
        protected void implCloseSelectableChannel() {
        }

        @Override
        protected void implConfigureBlocking(boolean block) {
            throw new UnsupportedOperationException(MockReadinessService.METHOD_NOT_MOCKED);
        }
    }

    public static class TestPlugin
    extends Plugin {
    }
}

