/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.geometry.utils.Geohash;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

@ESIntegTestCase.SuiteScopeTestCase
public abstract class AbstractGeoTestCase
extends ESIntegTestCase {
    protected static final String SINGLE_VALUED_FIELD_NAME = "spatial_value";
    protected static final String MULTI_VALUED_FIELD_NAME = "spatial_values";
    protected static final String NUMBER_FIELD_NAME = "l_values";
    protected static final String UNMAPPED_IDX_NAME = "idx_unmapped";
    protected static final String IDX_NAME = "idx";
    protected static final String EMPTY_IDX_NAME = "empty_idx";
    protected static final String DATELINE_IDX_NAME = "dateline_idx";
    protected static final String HIGH_CARD_IDX_NAME = "high_card_idx";
    protected static final String IDX_ZERO_NAME = "idx_zero";
    protected static final double GEOHASH_TOLERANCE = 1.0E-5;
    protected static int numDocs;
    protected static int numUniqueGeoPoints;
    protected static SpatialPoint[] singleValues;
    protected static SpatialPoint[] multiValues;
    protected static SpatialPoint singleTopLeft;
    protected static SpatialPoint singleBottomRight;
    protected static SpatialPoint multiTopLeft;
    protected static SpatialPoint multiBottomRight;
    protected static SpatialPoint singleCentroid;
    protected static SpatialPoint multiCentroid;
    protected static SpatialPoint unmappedCentroid;
    protected static Map<String, Integer> expectedDocCountsForGeoHash;
    protected static Map<String, SpatialPoint> expectedCentroidsForGeoHash;

    protected abstract String fieldTypeName();

    protected abstract SpatialPoint makePoint(double var1, double var3);

    protected abstract SpatialPoint randomPoint();

    protected abstract void resetX(SpatialPoint var1, double var2);

    protected abstract void resetY(SpatialPoint var1, double var2);

    protected abstract SpatialPoint reset(SpatialPoint var1, double var2, double var4);

    @Override
    public void setupSuiteScopeCluster() throws Exception {
        int i;
        int i2;
        this.createIndex(UNMAPPED_IDX_NAME);
        ElasticsearchAssertions.assertAcked(this.prepareCreate(IDX_NAME).setMapping(new String[]{SINGLE_VALUED_FIELD_NAME, "type=" + this.fieldTypeName(), MULTI_VALUED_FIELD_NAME, "type=" + this.fieldTypeName(), NUMBER_FIELD_NAME, "type=long", "tag", "type=keyword"}));
        singleTopLeft = this.makePoint(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
        singleBottomRight = this.makePoint(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        multiTopLeft = this.makePoint(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
        multiBottomRight = this.makePoint(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        singleCentroid = this.makePoint(0.0, 0.0);
        multiCentroid = this.makePoint(0.0, 0.0);
        unmappedCentroid = this.makePoint(0.0, 0.0);
        numDocs = AbstractGeoTestCase.randomIntBetween(6, 20);
        numUniqueGeoPoints = AbstractGeoTestCase.randomIntBetween(1, numDocs);
        expectedDocCountsForGeoHash = new HashMap<String, Integer>(numDocs * 2);
        expectedCentroidsForGeoHash = new HashMap<String, SpatialPoint>(numDocs * 2);
        singleValues = new SpatialPoint[numUniqueGeoPoints];
        for (i2 = 0; i2 < singleValues.length; ++i2) {
            AbstractGeoTestCase.singleValues[i2] = this.randomPoint();
            this.updateBoundsTopLeft(singleValues[i2], singleTopLeft);
            this.updateBoundsBottomRight(singleValues[i2], singleBottomRight);
        }
        multiValues = new SpatialPoint[numUniqueGeoPoints];
        for (i2 = 0; i2 < multiValues.length; ++i2) {
            AbstractGeoTestCase.multiValues[i2] = this.randomPoint();
            this.updateBoundsTopLeft(multiValues[i2], multiTopLeft);
            this.updateBoundsBottomRight(multiValues[i2], multiBottomRight);
        }
        ArrayList<IndexRequestBuilder> builders = new ArrayList<IndexRequestBuilder>();
        SpatialPoint[] allSingleVal = new SpatialPoint[numDocs];
        SpatialPoint[] allMultiVal = new SpatialPoint[2 * numDocs];
        for (int i3 = 0; i3 < numDocs; ++i3) {
            allSingleVal[i3] = singleValues[i3 % numUniqueGeoPoints];
            allMultiVal[2 * i3] = multiValues[i3 % numUniqueGeoPoints];
            allMultiVal[2 * i3 + 1] = multiValues[(i3 + 1) % numUniqueGeoPoints];
            builders.add(AbstractGeoTestCase.prepareIndex(IDX_NAME).setSource(XContentFactory.jsonBuilder().startObject().array(SINGLE_VALUED_FIELD_NAME, new Object[]{allSingleVal[i3].getX(), allSingleVal[i3].getY()}).startArray(MULTI_VALUED_FIELD_NAME).startArray().value(allMultiVal[2 * i3].getX()).value(allMultiVal[2 * i3].getY()).endArray().startArray().value(allMultiVal[2 * i3 + 1].getX()).value(allMultiVal[2 * i3 + 1].getY()).endArray().endArray().field(NUMBER_FIELD_NAME, i3).field("tag", "tag" + i3).endObject()));
        }
        singleCentroid = this.computeCentroid(allSingleVal);
        multiCentroid = this.computeCentroid(allMultiVal);
        ElasticsearchAssertions.assertAcked(this.prepareCreate(EMPTY_IDX_NAME).setMapping(new String[]{SINGLE_VALUED_FIELD_NAME, "type=" + this.fieldTypeName()}));
        ElasticsearchAssertions.assertAcked(this.prepareCreate(DATELINE_IDX_NAME).setMapping(new String[]{SINGLE_VALUED_FIELD_NAME, "type=" + this.fieldTypeName(), MULTI_VALUED_FIELD_NAME, "type=" + this.fieldTypeName(), NUMBER_FIELD_NAME, "type=long", "tag", "type=keyword"}));
        SpatialPoint[] geoValues = new SpatialPoint[]{this.makePoint(178.0, 38.0), this.makePoint(-179.0, 12.0), this.makePoint(170.0, -24.0), this.makePoint(-175.0, 32.0), this.makePoint(178.0, -11.0)};
        for (i = 0; i < 5; ++i) {
            builders.add(AbstractGeoTestCase.prepareIndex(DATELINE_IDX_NAME).setSource(XContentFactory.jsonBuilder().startObject().array(SINGLE_VALUED_FIELD_NAME, new Object[]{geoValues[i].getX(), geoValues[i].getY()}).field(NUMBER_FIELD_NAME, i).field("tag", "tag" + i).endObject()));
        }
        ElasticsearchAssertions.assertAcked(this.prepareCreate(HIGH_CARD_IDX_NAME).setSettings(Settings.builder().put("number_of_shards", 2)).setMapping(new String[]{SINGLE_VALUED_FIELD_NAME, "type=" + this.fieldTypeName(), MULTI_VALUED_FIELD_NAME, "type=" + this.fieldTypeName(), NUMBER_FIELD_NAME, "type=long,store=true", "tag", "type=keyword"}));
        for (i = 0; i < 2000; ++i) {
            SpatialPoint singleVal = singleValues[i % numUniqueGeoPoints];
            builders.add(AbstractGeoTestCase.prepareIndex(HIGH_CARD_IDX_NAME).setSource(XContentFactory.jsonBuilder().startObject().array(SINGLE_VALUED_FIELD_NAME, new Object[]{singleVal.getX(), singleVal.getY()}).startArray(MULTI_VALUED_FIELD_NAME).startArray().value(multiValues[i % numUniqueGeoPoints].getX()).value(multiValues[i % numUniqueGeoPoints].getY()).endArray().startArray().value(multiValues[(i + 1) % numUniqueGeoPoints].getX()).value(multiValues[(i + 1) % numUniqueGeoPoints].getY()).endArray().endArray().field(NUMBER_FIELD_NAME, i).field("tag", "tag" + i).endObject()));
            this.updateGeohashBucketsCentroid(singleVal);
        }
        builders.add(AbstractGeoTestCase.prepareIndex(IDX_ZERO_NAME).setSource(XContentFactory.jsonBuilder().startObject().array(SINGLE_VALUED_FIELD_NAME, new Object[]{0.0, 1.0}).endObject()));
        ElasticsearchAssertions.assertAcked(this.prepareCreate(IDX_ZERO_NAME).setMapping(new String[]{SINGLE_VALUED_FIELD_NAME, "type=" + this.fieldTypeName()}));
        this.indexRandom(true, builders);
        this.ensureSearchable(new String[0]);
        ElasticsearchAssertions.assertCheckedResponse(AbstractGeoTestCase.prepareSearch(HIGH_CARD_IDX_NAME).addStoredField(NUMBER_FIELD_NAME).addSort(SortBuilders.fieldSort((String)NUMBER_FIELD_NAME).order(SortOrder.ASC)).setSize(5000), (CheckedConsumer<SearchResponse, IOException>)((CheckedConsumer)response -> {
            ElasticsearchAssertions.assertNoFailures(response);
            long totalHits = response.getHits().getTotalHits().value;
            XContentBuilder builder = XContentFactory.jsonBuilder();
            ChunkedToXContent.wrapAsToXContent((ChunkedToXContent)response).toXContent(builder, ToXContent.EMPTY_PARAMS);
            this.logger.info("Full high_card_idx Response Content:\n{ {} }", (Object)Strings.toString((XContentBuilder)builder));
            int i = 0;
            while ((long)i < totalHits) {
                SearchHit searchHit = response.getHits().getAt(i);
                AbstractGeoTestCase.assertThat((String)("Hit " + i + " with id: " + searchHit.getId()), (Object)searchHit.getIndex(), (Matcher)Matchers.equalTo((Object)HIGH_CARD_IDX_NAME));
                DocumentField hitField = searchHit.field(NUMBER_FIELD_NAME);
                AbstractGeoTestCase.assertThat((String)("Hit " + i + " has wrong number of values"), (Object)hitField.getValues().size(), (Matcher)Matchers.equalTo((Object)1));
                Long value = (Long)hitField.getValue();
                AbstractGeoTestCase.assertThat((String)("Hit " + i + " has wrong value"), (Object)value.intValue(), (Matcher)Matchers.equalTo((Object)i));
                ++i;
            }
            AbstractGeoTestCase.assertThat((Object)totalHits, (Matcher)Matchers.equalTo((Object)2000L));
        }));
    }

    private SpatialPoint computeCentroid(SpatialPoint[] points) {
        CompensatedSum compensatedSumX = new CompensatedSum(0.0, 0.0);
        CompensatedSum compensatedSumY = new CompensatedSum(0.0, 0.0);
        for (SpatialPoint spatialPoint : points) {
            compensatedSumX.add(spatialPoint.getX());
            compensatedSumY.add(spatialPoint.getY());
        }
        return this.makePoint(compensatedSumX.value() / (double)points.length, compensatedSumY.value() / (double)points.length);
    }

    private void updateGeohashBucketsCentroid(SpatialPoint location) {
        String hash = Geohash.stringEncode((double)location.getX(), (double)location.getY(), (int)12);
        for (int precision = 12; precision > 0; --precision) {
            String h = hash.substring(0, precision);
            expectedDocCountsForGeoHash.put(h, expectedDocCountsForGeoHash.getOrDefault(h, 0) + 1);
            expectedCentroidsForGeoHash.put(h, this.updateHashCentroid(h, location));
        }
    }

    private SpatialPoint updateHashCentroid(String hash, SpatialPoint location) {
        SpatialPoint centroid = expectedCentroidsForGeoHash.getOrDefault(hash, null);
        if (centroid == null) {
            return this.makePoint(location.getX(), location.getY());
        }
        int docCount = expectedDocCountsForGeoHash.get(hash);
        double newLon = centroid.getX() + (location.getX() - centroid.getX()) / (double)docCount;
        double newLat = centroid.getY() + (location.getY() - centroid.getY()) / (double)docCount;
        return this.reset(centroid, newLon, newLat);
    }

    private void updateBoundsBottomRight(SpatialPoint point, SpatialPoint currentBound) {
        if (point.getY() < currentBound.getY()) {
            this.resetY(currentBound, point.getY());
        }
        if (point.getX() > currentBound.getX()) {
            this.resetX(currentBound, point.getX());
        }
    }

    private void updateBoundsTopLeft(SpatialPoint point, SpatialPoint currentBound) {
        if (point.getY() > currentBound.getY()) {
            this.resetY(currentBound, point.getY());
        }
        if (point.getX() < currentBound.getX()) {
            this.resetX(currentBound, point.getX());
        }
    }

    static {
        expectedDocCountsForGeoHash = null;
        expectedCentroidsForGeoHash = null;
    }
}

