/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.util.List;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.global.Global;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.AbstractGeoTestCase;
import org.elasticsearch.search.aggregations.metrics.SpatialBounds;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

@ESIntegTestCase.SuiteScopeTestCase
public abstract class SpatialBoundsAggregationTestBase<T extends SpatialPoint>
extends AbstractGeoTestCase {
    protected abstract String aggName();

    protected abstract ValuesSourceAggregationBuilder<?> boundsAgg(String var1, String var2);

    protected abstract void assertBoundsLimits(SpatialBounds<T> var1);

    public void testSingleValuedField() throws Exception {
        ElasticsearchAssertions.assertNoFailuresAndResponse(SpatialBoundsAggregationTestBase.client().prepareSearch(new String[]{"idx"}).addAggregation(this.boundsAgg(this.aggName(), "spatial_value")), response -> {
            SpatialBounds geoBounds = (SpatialBounds)response.getAggregations().get(this.aggName());
            SpatialBoundsAggregationTestBase.assertThat((Object)geoBounds, (Matcher)Matchers.notNullValue());
            SpatialBoundsAggregationTestBase.assertThat((Object)geoBounds.getName(), (Matcher)Matchers.equalTo((Object)this.aggName()));
            SpatialPoint topLeft = geoBounds.topLeft();
            SpatialPoint bottomRight = geoBounds.bottomRight();
            SpatialBoundsAggregationTestBase.assertThat((Object)topLeft.getY(), (Matcher)Matchers.closeTo((double)singleTopLeft.getY(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat((Object)topLeft.getX(), (Matcher)Matchers.closeTo((double)singleTopLeft.getX(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat((Object)bottomRight.getY(), (Matcher)Matchers.closeTo((double)singleBottomRight.getY(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat((Object)bottomRight.getX(), (Matcher)Matchers.closeTo((double)singleBottomRight.getX(), (double)1.0E-5));
        });
    }

    public void testSingleValuedField_getProperty() {
        ElasticsearchAssertions.assertNoFailuresAndResponse(SpatialBoundsAggregationTestBase.client().prepareSearch(new String[]{"idx"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).addAggregation((AggregationBuilder)AggregationBuilders.global((String)"global").subAggregation(this.boundsAgg(this.aggName(), "spatial_value"))), response -> {
            Global global = (Global)response.getAggregations().get("global");
            SpatialBoundsAggregationTestBase.assertThat((Object)global, (Matcher)Matchers.notNullValue());
            SpatialBoundsAggregationTestBase.assertThat((Object)global.getName(), (Matcher)Matchers.equalTo((Object)"global"));
            SpatialBoundsAggregationTestBase.assertThat((Object)global.getDocCount(), (Matcher)Matchers.equalTo((Object)numDocs));
            SpatialBoundsAggregationTestBase.assertThat((Object)global.getAggregations(), (Matcher)Matchers.notNullValue());
            SpatialBoundsAggregationTestBase.assertThat((Object)global.getAggregations().asMap().size(), (Matcher)Matchers.equalTo((Object)1));
            SpatialBounds geobounds = (SpatialBounds)global.getAggregations().get(this.aggName());
            SpatialBoundsAggregationTestBase.assertThat((Object)geobounds, (Matcher)Matchers.notNullValue());
            SpatialBoundsAggregationTestBase.assertThat((Object)geobounds.getName(), (Matcher)Matchers.equalTo((Object)this.aggName()));
            SpatialBoundsAggregationTestBase.assertThat((Object)((SpatialBounds)((InternalAggregation)global).getProperty(this.aggName())), (Matcher)Matchers.sameInstance((Object)geobounds));
            SpatialPoint topLeft = geobounds.topLeft();
            SpatialPoint bottomRight = geobounds.bottomRight();
            SpatialBoundsAggregationTestBase.assertThat((Object)topLeft.getY(), (Matcher)Matchers.closeTo((double)singleTopLeft.getY(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat((Object)topLeft.getX(), (Matcher)Matchers.closeTo((double)singleTopLeft.getX(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat((Object)bottomRight.getY(), (Matcher)Matchers.closeTo((double)singleBottomRight.getY(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat((Object)bottomRight.getX(), (Matcher)Matchers.closeTo((double)singleBottomRight.getX(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat((Object)((Double)((InternalAggregation)global).getProperty(this.aggName() + ".top")), (Matcher)Matchers.closeTo((double)singleTopLeft.getY(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat((Object)((Double)((InternalAggregation)global).getProperty(this.aggName() + ".left")), (Matcher)Matchers.closeTo((double)singleTopLeft.getX(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat((Object)((Double)((InternalAggregation)global).getProperty(this.aggName() + ".bottom")), (Matcher)Matchers.closeTo((double)singleBottomRight.getY(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat((Object)((Double)((InternalAggregation)global).getProperty(this.aggName() + ".right")), (Matcher)Matchers.closeTo((double)singleBottomRight.getX(), (double)1.0E-5));
        });
    }

    public void testMultiValuedField() throws Exception {
        ElasticsearchAssertions.assertNoFailuresAndResponse(SpatialBoundsAggregationTestBase.client().prepareSearch(new String[]{"idx"}).addAggregation(this.boundsAgg(this.aggName(), "spatial_values")), response -> {
            SpatialBounds geoBounds = (SpatialBounds)response.getAggregations().get(this.aggName());
            SpatialBoundsAggregationTestBase.assertThat((Object)geoBounds, (Matcher)Matchers.notNullValue());
            SpatialBoundsAggregationTestBase.assertThat((Object)geoBounds.getName(), (Matcher)Matchers.equalTo((Object)this.aggName()));
            SpatialPoint topLeft = geoBounds.topLeft();
            SpatialPoint bottomRight = geoBounds.bottomRight();
            SpatialBoundsAggregationTestBase.assertThat((Object)topLeft.getY(), (Matcher)Matchers.closeTo((double)multiTopLeft.getY(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat((Object)topLeft.getX(), (Matcher)Matchers.closeTo((double)multiTopLeft.getX(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat((Object)bottomRight.getY(), (Matcher)Matchers.closeTo((double)multiBottomRight.getY(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat((Object)bottomRight.getX(), (Matcher)Matchers.closeTo((double)multiBottomRight.getX(), (double)1.0E-5));
        });
    }

    public void testUnmapped() throws Exception {
        ElasticsearchAssertions.assertNoFailuresAndResponse(SpatialBoundsAggregationTestBase.client().prepareSearch(new String[]{"idx_unmapped"}).addAggregation(this.boundsAgg(this.aggName(), "spatial_value")), response -> {
            SpatialBounds geoBounds = (SpatialBounds)response.getAggregations().get(this.aggName());
            SpatialBoundsAggregationTestBase.assertThat((Object)geoBounds, (Matcher)Matchers.notNullValue());
            SpatialBoundsAggregationTestBase.assertThat((Object)geoBounds.getName(), (Matcher)Matchers.equalTo((Object)this.aggName()));
            SpatialPoint topLeft = geoBounds.topLeft();
            SpatialPoint bottomRight = geoBounds.bottomRight();
            SpatialBoundsAggregationTestBase.assertThat((Object)topLeft, (Matcher)Matchers.equalTo(null));
            SpatialBoundsAggregationTestBase.assertThat((Object)bottomRight, (Matcher)Matchers.equalTo(null));
        });
    }

    public void testPartiallyUnmapped() throws Exception {
        ElasticsearchAssertions.assertNoFailuresAndResponse(SpatialBoundsAggregationTestBase.client().prepareSearch(new String[]{"idx", "idx_unmapped"}).addAggregation(this.boundsAgg(this.aggName(), "spatial_value")), response -> {
            SpatialBounds geoBounds = (SpatialBounds)response.getAggregations().get(this.aggName());
            SpatialBoundsAggregationTestBase.assertThat((Object)geoBounds, (Matcher)Matchers.notNullValue());
            SpatialBoundsAggregationTestBase.assertThat((Object)geoBounds.getName(), (Matcher)Matchers.equalTo((Object)this.aggName()));
            SpatialPoint topLeft = geoBounds.topLeft();
            SpatialPoint bottomRight = geoBounds.bottomRight();
            SpatialBoundsAggregationTestBase.assertThat((Object)topLeft.getY(), (Matcher)Matchers.closeTo((double)singleTopLeft.getY(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat((Object)topLeft.getX(), (Matcher)Matchers.closeTo((double)singleTopLeft.getX(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat((Object)bottomRight.getY(), (Matcher)Matchers.closeTo((double)singleBottomRight.getY(), (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat((Object)bottomRight.getX(), (Matcher)Matchers.closeTo((double)singleBottomRight.getX(), (double)1.0E-5));
        });
    }

    public void testEmptyAggregation() throws Exception {
        ElasticsearchAssertions.assertNoFailuresAndResponse(SpatialBoundsAggregationTestBase.client().prepareSearch(new String[]{"empty_idx"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).addAggregation(this.boundsAgg(this.aggName(), "spatial_value")), response -> {
            SpatialBoundsAggregationTestBase.assertThat((Object)response.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)0L));
            SpatialBounds geoBounds = (SpatialBounds)response.getAggregations().get(this.aggName());
            SpatialBoundsAggregationTestBase.assertThat((Object)geoBounds, (Matcher)Matchers.notNullValue());
            SpatialBoundsAggregationTestBase.assertThat((Object)geoBounds.getName(), (Matcher)Matchers.equalTo((Object)this.aggName()));
            SpatialPoint topLeft = geoBounds.topLeft();
            SpatialPoint bottomRight = geoBounds.bottomRight();
            SpatialBoundsAggregationTestBase.assertThat((Object)topLeft, (Matcher)Matchers.equalTo(null));
            SpatialBoundsAggregationTestBase.assertThat((Object)bottomRight, (Matcher)Matchers.equalTo(null));
        });
    }

    public void testSingleValuedFieldAsSubAggToHighCardTermsAgg() {
        ElasticsearchAssertions.assertNoFailuresAndResponse(SpatialBoundsAggregationTestBase.client().prepareSearch(new String[]{"high_card_idx"}).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"terms").field("l_values")).subAggregation(this.boundsAgg(this.aggName(), "spatial_value"))), response -> {
            Terms terms = (Terms)response.getAggregations().get("terms");
            SpatialBoundsAggregationTestBase.assertThat((Object)terms, (Matcher)Matchers.notNullValue());
            SpatialBoundsAggregationTestBase.assertThat((Object)terms.getName(), (Matcher)Matchers.equalTo((Object)"terms"));
            List buckets = terms.getBuckets();
            SpatialBoundsAggregationTestBase.assertThat((Object)buckets.size(), (Matcher)Matchers.equalTo((Object)10));
            for (int i = 0; i < 10; ++i) {
                Terms.Bucket bucket = (Terms.Bucket)buckets.get(i);
                SpatialBoundsAggregationTestBase.assertThat((Object)bucket, (Matcher)Matchers.notNullValue());
                SpatialBoundsAggregationTestBase.assertThat((String)("InternalBucket " + bucket.getKey() + " has wrong number of documents"), (Object)bucket.getDocCount(), (Matcher)Matchers.equalTo((Object)1L));
                SpatialBounds geoBounds = (SpatialBounds)bucket.getAggregations().get(this.aggName());
                SpatialBoundsAggregationTestBase.assertThat((Object)geoBounds, (Matcher)Matchers.notNullValue());
                SpatialBoundsAggregationTestBase.assertThat((Object)geoBounds.getName(), (Matcher)Matchers.equalTo((Object)this.aggName()));
                this.assertBoundsLimits(geoBounds);
            }
        });
    }

    public void testSingleValuedFieldWithZeroLon() {
        ElasticsearchAssertions.assertNoFailuresAndResponse(SpatialBoundsAggregationTestBase.client().prepareSearch(new String[]{"idx_zero"}).addAggregation(this.boundsAgg(this.aggName(), "spatial_value")), response -> {
            SpatialBounds geoBounds = (SpatialBounds)response.getAggregations().get(this.aggName());
            SpatialBoundsAggregationTestBase.assertThat((Object)geoBounds, (Matcher)Matchers.notNullValue());
            SpatialBoundsAggregationTestBase.assertThat((Object)geoBounds.getName(), (Matcher)Matchers.equalTo((Object)this.aggName()));
            SpatialPoint topLeft = geoBounds.topLeft();
            SpatialPoint bottomRight = geoBounds.bottomRight();
            SpatialBoundsAggregationTestBase.assertThat((Object)topLeft.getY(), (Matcher)Matchers.closeTo((double)1.0, (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat((Object)topLeft.getX(), (Matcher)Matchers.closeTo((double)0.0, (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat((Object)bottomRight.getY(), (Matcher)Matchers.closeTo((double)1.0, (double)1.0E-5));
            SpatialBoundsAggregationTestBase.assertThat((Object)bottomRight.getX(), (Matcher)Matchers.closeTo((double)0.0, (double)1.0E-5));
        });
    }
}

