/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MapperServiceTestCase;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.FetchContext;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.FetchSubPhaseProcessor;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.fetch.subphase.highlight.DefaultHighlighter;
import org.elasticsearch.search.fetch.subphase.highlight.FastVectorHighlighter;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightPhase;
import org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import org.elasticsearch.search.fetch.subphase.highlight.PlainHighlighter;
import org.elasticsearch.search.lookup.Source;
import org.mockito.Mockito;

public class HighlighterTestCase
extends MapperServiceTestCase {
    protected Map<String, Highlighter> getHighlighters() {
        return Map.of("unified", new DefaultHighlighter(), "fvh", new FastVectorHighlighter(this.getIndexSettings()), "plain", new PlainHighlighter());
    }

    protected final Map<String, HighlightField> highlight(MapperService mapperService, ParsedDocument doc, SearchSourceBuilder search) throws IOException {
        HashMap<String, HighlightField> highlights = new HashMap<String, HighlightField>();
        HighlighterTestCase.withLuceneIndex(mapperService, (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)iw -> iw.addDocument((Iterable)doc.rootDoc())), (CheckedConsumer<DirectoryReader, IOException>)((CheckedConsumer)ir -> {
            SearchExecutionContext context = this.createSearchExecutionContext(mapperService, HighlighterTestCase.newSearcher((IndexReader)new NoStoredFieldsFilterDirectoryReader((DirectoryReader)ir)));
            HighlightPhase highlightPhase = new HighlightPhase(this.getHighlighters());
            FetchSubPhaseProcessor processor = highlightPhase.getProcessor(HighlighterTestCase.fetchContext(context, search));
            Map<String, List<Object>> storedFields = HighlighterTestCase.storedFields(processor.storedFieldsSpec(), doc);
            Source source = Source.fromBytes((BytesReference)doc.source());
            FetchSubPhase.HitContext hitContext = new FetchSubPhase.HitContext(new SearchHit(0, "id"), (LeafReaderContext)ir.leaves().get(0), 0, storedFields, source);
            processor.process(hitContext);
            highlights.putAll(hitContext.hit().getHighlightFields());
        }));
        return highlights;
    }

    private static Map<String, List<Object>> storedFields(StoredFieldsSpec spec, ParsedDocument doc) {
        HashMap<String, List<Object>> storedFields = new HashMap<String, List<Object>>();
        for (String field : spec.requiredStoredFields()) {
            List values = storedFields.computeIfAbsent(field, f -> new ArrayList());
            for (IndexableField f2 : doc.rootDoc().getFields(field)) {
                values.add(f2.stringValue());
            }
        }
        return storedFields;
    }

    protected static void assertHighlights(Map<String, HighlightField> highlights, String field, String ... fragments) {
        HighlighterTestCase.assertNotNull((String)("No highlights reported for field [" + field + "]"), (Object)highlights.get(field));
        HighlightField highlightField = highlights.get(field);
        List actualFragments = Arrays.stream(highlightField.fragments()).map(Text::toString).collect(Collectors.toList());
        List<String> expectedFragments = List.of(fragments);
        HighlighterTestCase.assertEquals(expectedFragments, actualFragments);
    }

    private static FetchContext fetchContext(SearchExecutionContext context, SearchSourceBuilder search) throws IOException {
        FetchContext fetchContext = (FetchContext)Mockito.mock(FetchContext.class);
        Mockito.when((Object)fetchContext.highlight()).thenReturn((Object)search.highlighter().build(context));
        Mockito.when((Object)fetchContext.parsedQuery()).thenReturn((Object)new ParsedQuery(search.query().toQuery(context)));
        Mockito.when((Object)fetchContext.getSearchExecutionContext()).thenReturn((Object)context);
        Mockito.when((Object)fetchContext.sourceLoader()).thenReturn((Object)context.newSourceLoader(false));
        return fetchContext;
    }

    private static class NoStoredFieldsFilterDirectoryReader
    extends FilterDirectoryReader {
        NoStoredFieldsFilterDirectoryReader(DirectoryReader in) throws IOException {
            super(in, new FilterDirectoryReader.SubReaderWrapper(){

                public LeafReader wrap(LeafReader reader) {
                    return new FilterLeafReader(reader){

                        public StoredFields storedFields() throws IOException {
                            throw new AssertionError((Object)"Called Stored Fields!");
                        }

                        public IndexReader.CacheHelper getCoreCacheHelper() {
                            return this.in.getCoreCacheHelper();
                        }

                        public IndexReader.CacheHelper getReaderCacheHelper() {
                            return this.in.getReaderCacheHelper();
                        }
                    };
                }
            });
        }

        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return new NoStoredFieldsFilterDirectoryReader(in);
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }
    }
}

