/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.geo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.geo.GeoJson;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.geo.GeometryTestUtils;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.GeometryValidator;
import org.elasticsearch.geometry.utils.StandardValidator;
import org.elasticsearch.geometry.utils.WellKnownText;
import org.elasticsearch.index.query.AbstractGeometryQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.geo.BasePointShapeQueryTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class BaseShapeQueryTestCase<T extends AbstractGeometryQueryBuilder<T>>
extends BasePointShapeQueryTestCase<T> {
    @Override
    protected void createMapping(String indexName, String fieldName, Settings settings) throws Exception {
        XContentBuilder xcb = XContentFactory.jsonBuilder().startObject().startObject("properties").startObject(fieldName).field("type", this.fieldTypeName()).endObject().endObject().endObject();
        this.client().admin().indices().prepareCreate(indexName).setMapping(xcb).setSettings(settings).get();
    }

    public void testFieldAlias() throws IOException {
        String mapping = Strings.toString((XContentBuilder)XContentFactory.jsonBuilder().startObject().startObject("properties").startObject("geo").field("type", this.fieldTypeName()).endObject().startObject("alias").field("type", "alias").field("path", "geo").endObject().endObject().endObject());
        this.client().admin().indices().prepareCreate("test").setMapping(mapping).get();
        this.ensureGreen(new String[0]);
        MultiPoint multiPoint = GeometryTestUtils.randomMultiPoint(false);
        ((IndexRequestBuilder)this.prepareIndex("test").setId("1").setSource(GeoJson.toXContent((Geometry)multiPoint, (XContentBuilder)XContentFactory.jsonBuilder().startObject().field("geo"), null).endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ElasticsearchAssertions.assertHitCount(this.client().prepareSearch(new String[]{"test"}).setQuery(this.queryBuilder().shapeQuery("alias", (Geometry)multiPoint)), 1L);
    }

    public void testShapeFetchingPath() throws Exception {
        this.createIndex("shapes");
        this.createMapping("test", "geo");
        this.ensureGreen(new String[0]);
        String geo = "\"geo\" : {\"type\":\"polygon\", \"coordinates\":[[[-10,-10],[10,-10],[10,10],[-10,10],[-10,-10]]]}";
        ((IndexRequestBuilder)this.prepareIndex("shapes").setId("1").setSource(Strings.format((String)"{ %s, \"1\" : { %s, \"2\" : { %s, \"3\" : { %s } }} }\n", (Object[])new Object[]{geo, geo, geo, geo}), XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ((IndexRequestBuilder)this.prepareIndex("test").setId("1").setSource(XContentFactory.jsonBuilder().startObject().startObject("geo").field("type", "polygon").startArray("coordinates").startArray().startArray().value(-20).value(-20).endArray().startArray().value(20).value(-20).endArray().startArray().value(20).value(20).endArray().startArray().value(-20).value(20).endArray().startArray().value(-20).value(-20).endArray().endArray().endArray().endObject().endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        AbstractGeometryQueryBuilder filter = this.queryBuilder().shapeQuery("geo", "1").relation(ShapeRelation.INTERSECTS).indexedShapeIndex("shapes").indexedShapePath("geo");
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter((QueryBuilder)filter), 1L);
        filter = this.queryBuilder().shapeQuery("geo", "1").relation(ShapeRelation.INTERSECTS).indexedShapeIndex("shapes").indexedShapePath("1.geo");
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter((QueryBuilder)filter), 1L);
        filter = this.queryBuilder().shapeQuery("geo", "1").relation(ShapeRelation.INTERSECTS).indexedShapeIndex("shapes").indexedShapePath("1.2.geo");
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter((QueryBuilder)filter), 1L);
        filter = this.queryBuilder().shapeQuery("geo", "1").relation(ShapeRelation.INTERSECTS).indexedShapeIndex("shapes").indexedShapePath("1.2.3.geo");
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter((QueryBuilder)filter), 1L);
        AbstractGeometryQueryBuilder query = this.queryBuilder().shapeQuery("geo", "1").indexedShapeIndex("shapes").indexedShapePath("geo");
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)query), 1L);
        query = this.queryBuilder().shapeQuery("geo", "1").indexedShapeIndex("shapes").indexedShapePath("1.geo");
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)query), 1L);
        query = this.queryBuilder().shapeQuery("geo", "1").indexedShapeIndex("shapes").indexedShapePath("1.2.geo");
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)query), 1L);
        query = this.queryBuilder().shapeQuery("geo", "1").indexedShapeIndex("shapes").indexedShapePath("1.2.3.geo");
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)query), 1L);
    }

    public void testRandomGeoCollectionQuery() throws Exception {
        Polygon polygon = this.nextPolygon2();
        GeometryCollection<Geometry> gcb = this.makeRandomGeometryCollectionWithoutCircle(new Geometry[]{polygon});
        this.logger.info("Created Random GeometryCollection containing {} shapes", (Object)gcb.size());
        this.createMapping("test", "geo", Settings.builder().put("index.number_of_shards", 1).build());
        this.ensureGreen(new String[0]);
        XContentBuilder docSource = GeoJson.toXContent(gcb, (XContentBuilder)XContentFactory.jsonBuilder().startObject().field("geo"), null).endObject();
        ((IndexRequestBuilder)this.prepareIndex("test").setId("1").setSource(docSource).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        GeometryCollection<Geometry> randomQueryCollection = this.makeRandomGeometryCollection();
        ArrayList<Object> queryGeometries = new ArrayList<Object>();
        for (Geometry geometry : randomQueryCollection) {
            queryGeometries.add(geometry);
        }
        queryGeometries.add(polygon);
        GeometryCollection queryCollection = new GeometryCollection(queryGeometries);
        AbstractGeometryQueryBuilder intersects = this.queryBuilder().intersectionQuery("geo", (Geometry)queryCollection);
        ElasticsearchAssertions.assertNoFailuresAndResponse(this.client().prepareSearch(new String[]{"test"}).setQuery(intersects), response -> BaseShapeQueryTestCase.assertTrue((String)("query: " + intersects + " doc: " + Strings.toString((XContentBuilder)docSource)), (response.getHits().getTotalHits().value > 0L ? 1 : 0) != 0));
    }

    public void testGeometryCollectionRelations() throws Exception {
        Settings settings = Settings.builder().put("index.number_of_shards", 1).build();
        this.createMapping("test", "geo", settings);
        this.ensureGreen(new String[0]);
        Rectangle envelope = new Rectangle(-10.0, 10.0, 10.0, -10.0);
        this.client().index((IndexRequest)new IndexRequest("test").source(XContentFactory.jsonBuilder().startObject().field("geo", WellKnownText.toWKT((Geometry)envelope)).endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
        ArrayList<Point> geometries = new ArrayList<Point>();
        geometries.add(new Point(1.0, 2.0));
        geometries.add(new Point(-2.0, -1.0));
        GeometryCollection collection = new GeometryCollection(geometries);
        ElasticsearchAssertions.assertHitCount(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery("geo", (Geometry)collection).relation(ShapeRelation.CONTAINS)), 1L);
        ElasticsearchAssertions.assertHitCount(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery("geo", (Geometry)collection).relation(ShapeRelation.INTERSECTS)), 1L);
        ElasticsearchAssertions.assertHitCount(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery("geo", (Geometry)collection).relation(ShapeRelation.DISJOINT)), 0L);
        geometries = new ArrayList();
        geometries.add(new Point(1.0, 2.0));
        geometries.add(new Point(20.0, 30.0));
        collection = new GeometryCollection(geometries);
        ElasticsearchAssertions.assertHitCount(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery("geo", (Geometry)collection).relation(ShapeRelation.CONTAINS)), 0L);
        ElasticsearchAssertions.assertHitCount(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery("geo", (Geometry)collection).relation(ShapeRelation.INTERSECTS)), 1L);
        ElasticsearchAssertions.assertHitCount(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery("geo", (Geometry)collection).relation(ShapeRelation.DISJOINT)), 0L);
        geometries = new ArrayList();
        geometries.add(new Point(-20.0, -30.0));
        geometries.add(new Point(20.0, 30.0));
        collection = new GeometryCollection(geometries);
        ElasticsearchAssertions.assertHitCount(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery("geo", (Geometry)collection).relation(ShapeRelation.CONTAINS)), 0L);
        ElasticsearchAssertions.assertHitCount(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery("geo", (Geometry)collection).relation(ShapeRelation.INTERSECTS)), 0L);
        ElasticsearchAssertions.assertHitCount(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery("geo", (Geometry)collection).relation(ShapeRelation.DISJOINT)), 1L);
    }

    public void testEdgeCases() throws Exception {
        XContentBuilder xcb = XContentFactory.jsonBuilder().startObject().startObject("properties").startObject("geo").field("type", this.fieldTypeName()).endObject().endObject().endObject();
        String mapping = Strings.toString((XContentBuilder)xcb);
        this.client().admin().indices().prepareCreate("test").setMapping(mapping).get();
        this.ensureGreen(new String[0]);
        ((IndexRequestBuilder)this.prepareIndex("test").setId("blakely").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Blakely Island").startObject("geo").field("type", "polygon").startArray("coordinates").startArray().startArray().value(-122.83).value(48.57).endArray().startArray().value(-122.77).value(48.56).endArray().startArray().value(-122.79).value(48.53).endArray().startArray().value(-122.83).value(48.57).endArray().endArray().endArray().endObject().endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        Rectangle query = new Rectangle(-122.88, -122.82, 48.62, 48.54);
        ElasticsearchAssertions.assertNoFailuresAndResponse(this.client().prepareSearch(new String[]{"test"}).setQuery(this.queryBuilder().intersectionQuery("geo", (Geometry)query)), response -> {
            BaseShapeQueryTestCase.assertThat((Object)response.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
            BaseShapeQueryTestCase.assertThat((Object)response.getHits().getHits().length, (Matcher)Matchers.equalTo((Object)1));
            BaseShapeQueryTestCase.assertThat((Object)response.getHits().getAt(0).getId(), (Matcher)Matchers.equalTo((Object)"blakely"));
        });
    }

    public void testIndexedShapeReferenceSourceDisabled() throws Exception {
        this.createMapping("test", "geo", Settings.builder().put("index.number_of_shards", 1).build());
        this.createIndex("shapes", Settings.EMPTY, "shape_type", "_source", "enabled=false");
        this.ensureGreen(new String[0]);
        Rectangle shape = new Rectangle(-45.0, 45.0, 45.0, -45.0);
        ((IndexRequestBuilder)this.prepareIndex("shapes").setId("Big_Rectangle").setSource(XContentFactory.jsonBuilder().startObject().field("shape", WellKnownText.toWKT((Geometry)shape)).endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        IllegalArgumentException e = (IllegalArgumentException)BaseShapeQueryTestCase.expectThrows(IllegalArgumentException.class, () -> this.client().prepareSearch(new String[]{"test"}).setQuery(this.queryBuilder().intersectionQuery("geo", "Big_Rectangle")).get());
        BaseShapeQueryTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"source disabled"));
    }

    public void testPointQuery() throws Exception {
        Point point = this.nextPoint();
        GeometryCollection<Geometry> gcb = this.makeRandomGeometryCollectionWithoutCircle(new Geometry[]{point});
        this.createMapping("test", "geo");
        this.ensureGreen(new String[0]);
        XContentBuilder docSource = GeoJson.toXContent(gcb, (XContentBuilder)XContentFactory.jsonBuilder().startObject().field("geo"), (ToXContent.Params)ToXContent.EMPTY_PARAMS).endObject();
        ((IndexRequestBuilder)this.prepareIndex("test").setId("1").setSource(docSource).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{"test"}).setQuery(this.queryBuilder().intersectionQuery("geo", (Geometry)point)), 1L);
    }

    public void testContainsShapeQuery() throws Exception {
        Polygon polygon = new Polygon(new LinearRing(new double[]{-30.0, 30.0, 30.0, -30.0, -30.0}, new double[]{-30.0, -30.0, 30.0, 30.0, -30.0}));
        Polygon innerPolygon = new Polygon(new LinearRing(new double[]{-5.0, 5.0, 5.0, -5.0, -5.0}, new double[]{-5.0, -5.0, 5.0, 5.0, -5.0}));
        this.createMapping("test", "geo");
        XContentBuilder docSource = GeoJson.toXContent((Geometry)polygon, (XContentBuilder)XContentFactory.jsonBuilder().startObject().field("geo"), null).endObject();
        ((IndexRequestBuilder)this.prepareIndex("test").setId("1").setSource(docSource).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        AbstractGeometryQueryBuilder filter = this.queryBuilder().shapeQuery("geo", (Geometry)innerPolygon).relation(ShapeRelation.CONTAINS);
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)filter), 1L);
    }

    public void testExistsQuery() throws Exception {
        GeometryCollection<Geometry> gcb = this.makeRandomGeometryCollectionWithoutCircle(new Geometry[0]);
        this.logger.info("Created Random GeometryCollection containing {} shapes", (Object)gcb.size());
        this.createMapping("test", "geo");
        XContentBuilder docSource = GeoJson.toXContent(gcb, (XContentBuilder)XContentFactory.jsonBuilder().startObject().field("geo"), null).endObject();
        ((IndexRequestBuilder)this.prepareIndex("test").setId("1").setSource(docSource).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ExistsQueryBuilder eqb = QueryBuilders.existsQuery((String)"geo");
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)eqb), 1L);
    }

    public void testIndexedShapeReference() throws Exception {
        this.createMapping("test", "geo");
        this.ensureGreen(new String[0]);
        Rectangle shape = new Rectangle(-45.0, 45.0, 45.0, -45.0);
        ((IndexRequestBuilder)this.prepareIndex("shapes").setId("Big_Rectangle").setSource(GeoJson.toXContent((Geometry)shape, (XContentBuilder)XContentFactory.jsonBuilder().startObject().field("shape"), null).endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ((IndexRequestBuilder)this.prepareIndex("test").setId("1").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Document 1").startObject("geo").field("type", "point").startArray("coordinates").value(-30).value(-30).endArray().endObject().endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ElasticsearchAssertions.assertNoFailuresAndResponse(this.client().prepareSearch(new String[]{"test"}).setQuery(this.queryBuilder().intersectionQuery("geo", "Big_Rectangle")), response -> {
            BaseShapeQueryTestCase.assertThat((Object)response.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
            BaseShapeQueryTestCase.assertThat((Object)response.getHits().getHits().length, (Matcher)Matchers.equalTo((Object)1));
            BaseShapeQueryTestCase.assertThat((Object)response.getHits().getAt(0).getId(), (Matcher)Matchers.equalTo((Object)"1"));
        });
        ElasticsearchAssertions.assertNoFailuresAndResponse(this.client().prepareSearch(new String[]{"test"}).setQuery(this.queryBuilder().shapeQuery("geo", "Big_Rectangle")), response -> {
            BaseShapeQueryTestCase.assertThat((Object)response.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
            BaseShapeQueryTestCase.assertThat((Object)response.getHits().getHits().length, (Matcher)Matchers.equalTo((Object)1));
            BaseShapeQueryTestCase.assertThat((Object)response.getHits().getAt(0).getId(), (Matcher)Matchers.equalTo((Object)"1"));
        });
    }

    public void testQueryRandomGeoCollection() throws Exception {
        Polygon polygon = this.nextPolygon();
        GeometryCollection<Geometry> gcb = this.makeRandomGeometryCollectionWithoutCircle(new Geometry[]{polygon});
        this.logger.info("Created Random GeometryCollection containing {} shapes", (Object)gcb.size());
        this.createMapping("test", "geo");
        this.ensureGreen(new String[0]);
        XContentBuilder docSource = GeoJson.toXContent(gcb, (XContentBuilder)XContentFactory.jsonBuilder().startObject().field("geo"), null).endObject();
        ((IndexRequestBuilder)this.prepareIndex("test").setId("1").setSource(docSource).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{"test"}).setQuery(this.queryBuilder().intersectionQuery("geo", (Geometry)polygon)), 1L);
    }

    public void testShapeFilterWithDefinedGeoCollection() throws Exception {
        this.createMapping("test", "geo");
        this.ensureGreen(new String[0]);
        XContentBuilder docSource = XContentFactory.jsonBuilder().startObject().startObject("geo").field("type", "geometrycollection").startArray("geometries").startObject().field("type", "point").startArray("coordinates").value(100.0).value(0.0).endArray().endObject().startObject().field("type", "linestring").startArray("coordinates").startArray().value(101.0).value(0.0).endArray().startArray().value(102.0).value(1.0).endArray().endArray().endObject().endArray().endObject().endObject();
        ((IndexRequestBuilder)this.prepareIndex("test").setId("1").setSource(docSource).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        Polygon polygon1 = new Polygon(new LinearRing(new double[]{99.0, 99.0, 103.0, 103.0, 99.0}, new double[]{-1.0, 3.0, 3.0, -1.0, -1.0}));
        Polygon polygon2 = new Polygon(new LinearRing(new double[]{199.0, 199.0, 193.0, 193.0, 199.0}, new double[]{-11.0, 13.0, 13.0, -11.0, -11.0}));
        AbstractGeometryQueryBuilder filter = this.queryBuilder().intersectionQuery("geo", (Geometry)new GeometryCollection(List.of(polygon1)));
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter(filter), 1L);
        filter = this.queryBuilder().intersectionQuery("geo", (Geometry)new GeometryCollection(List.of(polygon2)));
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter(filter), 0L);
        filter = this.queryBuilder().intersectionQuery("geo", (Geometry)new GeometryCollection(List.of(polygon1, polygon2)));
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter(filter), 1L);
        filter = this.queryBuilder().shapeQuery("geo", (Geometry)GeometryCollection.EMPTY);
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter(filter), 0L);
    }

    public void testDistanceQuery() throws Exception {
        this.createMapping("test", "geo");
        this.ensureGreen(new String[0]);
        double radius = this.fieldTypeName().contains("geo") ? 350000.0 : 35.0;
        Circle circle = new Circle(1.0, 0.0, radius);
        this.client().index((IndexRequest)new IndexRequest("test").source(XContentFactory.jsonBuilder().startObject().field("geo", WellKnownText.toWKT((Geometry)new Point(2.0, 2.0))).endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
        this.client().index((IndexRequest)new IndexRequest("test").source(XContentFactory.jsonBuilder().startObject().field("geo", WellKnownText.toWKT((Geometry)new Point(3.0, 1.0))).endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
        this.client().index((IndexRequest)new IndexRequest("test").source(XContentFactory.jsonBuilder().startObject().field("geo", WellKnownText.toWKT((Geometry)new Point(-20.0, -30.0))).endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
        this.client().index((IndexRequest)new IndexRequest("test").source(XContentFactory.jsonBuilder().startObject().field("geo", WellKnownText.toWKT((Geometry)new Point(20.0, 30.0))).endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
        ElasticsearchAssertions.assertHitCount(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery("geo", (Geometry)circle).relation(ShapeRelation.WITHIN)), 2L);
        ElasticsearchAssertions.assertHitCount(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery("geo", (Geometry)circle).relation(ShapeRelation.INTERSECTS)), 2L);
        ElasticsearchAssertions.assertHitCount(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery("geo", (Geometry)circle).relation(ShapeRelation.DISJOINT)), 2L);
        ElasticsearchAssertions.assertHitCount(this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery("geo", (Geometry)circle).relation(ShapeRelation.CONTAINS)), 0L);
    }

    public void testIndexLineQueryPoints() throws Exception {
        this.createMapping("test", "geo");
        this.ensureGreen(new String[0]);
        Line line = this.makeRandomLine();
        ((IndexRequestBuilder)this.prepareIndex("test").setSource(XContentFactory.jsonBuilder().startObject().field("geo", WellKnownText.toWKT((Geometry)line)).endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        for (int i = 0; i < line.length(); ++i) {
            Point point = new Point(line.getLon(i), line.getLat(i));
            ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{"test"}).setTrackTotalHits(true).setQuery((QueryBuilder)this.queryBuilder().shapeQuery("geo", (Geometry)point).relation(ShapeRelation.INTERSECTS)), 1L);
        }
    }

    public void testIndexPolygonQueryPoints() throws Exception {
        this.createMapping("test", "geo");
        this.ensureGreen(new String[0]);
        Polygon polygon = this.makeRandomPolygon();
        ((IndexRequestBuilder)this.prepareIndex("test").setSource(XContentFactory.jsonBuilder().startObject().field("geo", WellKnownText.toWKT((Geometry)polygon)).endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        LinearRing linearRing = polygon.getPolygon();
        for (int i = 0; i < linearRing.length(); ++i) {
            Point point = new Point(linearRing.getLon(i), linearRing.getLat(i));
            ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{"test"}).setTrackTotalHits(true).setQuery((QueryBuilder)this.queryBuilder().shapeQuery("geo", (Geometry)point).relation(ShapeRelation.INTERSECTS)), 1L);
        }
    }

    public void testNeighbours() throws Exception {
        String[] polygons;
        this.createMapping("test", "geo");
        this.ensureGreen(new String[0]);
        for (String polygon : polygons = new String[]{"POLYGON((1 1, 2 1, 2 2, 1 2, 1 1))", "POLYGON((0 1, 1 1, 1 2, 0 2, 0 1))", "POLYGON((0 2, 1 2, 1 3, 0 3, 0 2))", "POLYGON((1 2, 2 2, 2 3, 1 3, 1 2))", "POLYGON((2 2, 3 2, 3 3, 2 3, 2 2))", "POLYGON((2 1, 3 1, 3 2, 2 2, 2 1))", "POLYGON((2 0, 3 0, 3 1, 2 1, 2 0))", "POLYGON((1 0, 2 0, 2 1, 1 1, 1 0))", "POLYGON((0 0, 1 0, 1 1, 0 1, 0 0))"}) {
            ((IndexRequestBuilder)this.prepareIndex("test").setSource(XContentFactory.jsonBuilder().startObject().field("geo", polygon).endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        }
        Geometry center = WellKnownText.fromWKT((GeometryValidator)StandardValidator.instance((boolean)false), (boolean)false, (String)polygons[0]);
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{"test"}).setTrackTotalHits(true).setQuery((QueryBuilder)this.queryBuilder().shapeQuery("geo", center).relation(ShapeRelation.INTERSECTS)), polygons.length);
    }

    protected abstract Line makeRandomLine();

    protected abstract Polygon makeRandomPolygon();

    protected abstract GeometryCollection<Geometry> makeRandomGeometryCollection();

    protected abstract GeometryCollection<Geometry> makeRandomGeometryCollectionWithoutCircle(Geometry ... var1);

    protected abstract Point nextPoint();

    protected abstract Polygon nextPolygon();

    protected abstract Polygon nextPolygon2();
}

