/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.geo;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.geo.GeometryTestUtils;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.WellKnownText;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.test.AbstractQueryTestCase;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;

public abstract class GeoShapeQueryBuilderTestCase
extends AbstractQueryTestCase<GeoShapeQueryBuilder> {
    protected static String indexedShapeId;
    protected static String indexedShapePath;
    protected static String indexedShapeIndex;
    protected static String indexedShapeRouting;
    protected static Geometry indexedShapeToReturn;

    protected abstract String getFieldName();

    @Override
    protected GeoShapeQueryBuilder doCreateTestQueryBuilder() {
        return this.doCreateTestQueryBuilder(GeoShapeQueryBuilderTestCase.randomBoolean());
    }

    protected abstract GeoShapeQueryBuilder doCreateTestQueryBuilder(boolean var1);

    @Override
    protected GetResponse executeGet(GetRequest getRequest) {
        String json;
        GeoShapeQueryBuilderTestCase.assertThat((Object)indexedShapeToReturn, (Matcher)CoreMatchers.notNullValue());
        GeoShapeQueryBuilderTestCase.assertThat((Object)indexedShapeId, (Matcher)CoreMatchers.notNullValue());
        GeoShapeQueryBuilderTestCase.assertThat((Object)getRequest.id(), (Matcher)Matchers.equalTo((Object)indexedShapeId));
        GeoShapeQueryBuilderTestCase.assertThat((Object)getRequest.routing(), (Matcher)Matchers.equalTo((Object)indexedShapeRouting));
        String expectedShapeIndex = indexedShapeIndex == null ? "shapes" : indexedShapeIndex;
        GeoShapeQueryBuilderTestCase.assertThat((Object)getRequest.index(), (Matcher)Matchers.equalTo((Object)expectedShapeIndex));
        String expectedShapePath = indexedShapePath == null ? "shape" : indexedShapePath;
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            builder.field(expectedShapePath, WellKnownText.toWKT((Geometry)indexedShapeToReturn));
            builder.field(GeoShapeQueryBuilderTestCase.randomAlphaOfLengthBetween(10, 20), "something");
            builder.endObject();
            json = Strings.toString((XContentBuilder)builder);
        }
        catch (IOException ex) {
            throw new ElasticsearchException("boom", (Throwable)ex, new Object[0]);
        }
        return new GetResponse(new GetResult(indexedShapeIndex, indexedShapeId, 0L, 1L, 0L, true, (BytesReference)new BytesArray(json), null, null));
    }

    @After
    public void clearShapeFields() {
        indexedShapeToReturn = null;
        indexedShapeId = null;
        indexedShapePath = null;
        indexedShapeIndex = null;
        indexedShapeRouting = null;
    }

    @Override
    protected void doAssertLuceneQuery(GeoShapeQueryBuilder queryBuilder, Query query, SearchExecutionContext context) throws IOException {
        GeoShapeQueryBuilderTestCase.assertThat((Object)query, (Matcher)Matchers.anyOf((Matcher)CoreMatchers.instanceOf(BooleanQuery.class), (Matcher)CoreMatchers.instanceOf(ConstantScoreQuery.class)));
    }

    public void testNoFieldName() throws Exception {
        Geometry geometry = GeometryTestUtils.randomGeometry(false);
        IllegalArgumentException e = (IllegalArgumentException)GeoShapeQueryBuilderTestCase.expectThrows(IllegalArgumentException.class, () -> new GeoShapeQueryBuilder(null, geometry));
        GeoShapeQueryBuilderTestCase.assertEquals((Object)"fieldName is required", (Object)e.getMessage());
    }

    public void testNoShape() {
        GeoShapeQueryBuilderTestCase.expectThrows(IllegalArgumentException.class, () -> new GeoShapeQueryBuilder(this.getFieldName(), (Geometry)null));
    }

    public void testNoIndexedShape() {
        IllegalArgumentException e = (IllegalArgumentException)GeoShapeQueryBuilderTestCase.expectThrows(IllegalArgumentException.class, () -> new GeoShapeQueryBuilder(this.getFieldName(), null, null));
        GeoShapeQueryBuilderTestCase.assertEquals((Object)"either shape or indexedShapeId is required", (Object)e.getMessage());
    }

    public void testNoRelation() {
        Geometry shape = GeometryTestUtils.randomGeometry(false);
        GeoShapeQueryBuilder builder = new GeoShapeQueryBuilder(this.getFieldName(), shape);
        IllegalArgumentException e = (IllegalArgumentException)GeoShapeQueryBuilderTestCase.expectThrows(IllegalArgumentException.class, () -> builder.relation(null));
        GeoShapeQueryBuilderTestCase.assertEquals((Object)"No Shape Relation defined", (Object)e.getMessage());
    }

    public void testThatXContentSerializationInsideOfArrayWorks() throws Exception {
        Rectangle rectangle = new Rectangle(0.0, 10.0, 10.0, 0.0);
        GeoShapeQueryBuilder geoQuery = QueryBuilders.geoShapeQuery((String)"searchGeometry", (Geometry)rectangle);
        JsonXContent.contentBuilder().startArray().value((ToXContent)geoQuery).endArray();
    }

    public void testFromJson() throws IOException {
        String json = "{\n  \"geo_shape\" : {\n    \"location\" : {\n      \"shape\" : {\n        \"type\" : \"Envelope\",\n        \"coordinates\" : [ [ 13.0, 53.0 ], [ 14.0, 52.0 ] ]\n      },\n      \"relation\" : \"intersects\"\n    },\n    \"ignore_unmapped\" : false,\n    \"boost\" : 42.0\n  }\n}";
        GeoShapeQueryBuilder parsed = (GeoShapeQueryBuilder)this.parseQuery(json);
        GeoShapeQueryBuilderTestCase.checkGeneratedJson(json, (QueryBuilder)parsed);
        GeoShapeQueryBuilderTestCase.assertEquals((String)json, (double)42.0, (double)parsed.boost(), (double)1.0E-4);
    }

    @Override
    public void testMustRewrite() throws IOException {
        GeoShapeQueryBuilder query = this.doCreateTestQueryBuilder(true);
        UnsupportedOperationException e = (UnsupportedOperationException)GeoShapeQueryBuilderTestCase.expectThrows(UnsupportedOperationException.class, () -> query.toQuery(GeoShapeQueryBuilderTestCase.createSearchExecutionContext()));
        GeoShapeQueryBuilderTestCase.assertEquals((Object)"query must be rewritten first", (Object)e.getMessage());
        QueryBuilder rewrite = this.rewriteAndFetch((QueryBuilder)query, (QueryRewriteContext)GeoShapeQueryBuilderTestCase.createSearchExecutionContext());
        GeoShapeQueryBuilder geoShapeQueryBuilder = new GeoShapeQueryBuilder(query.fieldName(), indexedShapeToReturn);
        geoShapeQueryBuilder.strategy(query.strategy());
        geoShapeQueryBuilder.relation(query.relation());
        GeoShapeQueryBuilderTestCase.assertEquals((Object)geoShapeQueryBuilder, (Object)rewrite);
    }

    public void testMultipleRewrite() {
        GeoShapeQueryBuilder shape = this.doCreateTestQueryBuilder(true);
        BoolQueryBuilder builder = new BoolQueryBuilder().should((QueryBuilder)shape).should((QueryBuilder)shape);
        builder = this.rewriteAndFetch((QueryBuilder)builder, (QueryRewriteContext)GeoShapeQueryBuilderTestCase.createSearchExecutionContext());
        GeoShapeQueryBuilder expectedShape = new GeoShapeQueryBuilder(shape.fieldName(), indexedShapeToReturn);
        expectedShape.strategy(shape.strategy());
        expectedShape.relation(shape.relation());
        BoolQueryBuilder expected = new BoolQueryBuilder().should((QueryBuilder)expectedShape).should((QueryBuilder)expectedShape);
        GeoShapeQueryBuilderTestCase.assertEquals((Object)expected, (Object)builder);
    }

    public void testIgnoreUnmapped() throws IOException {
        Geometry geometry = GeometryTestUtils.randomGeometry(false);
        GeoShapeQueryBuilder queryBuilder = new GeoShapeQueryBuilder("unmapped", geometry);
        queryBuilder.ignoreUnmapped(true);
        Query query = queryBuilder.toQuery(GeoShapeQueryBuilderTestCase.createSearchExecutionContext());
        GeoShapeQueryBuilderTestCase.assertThat((Object)query, (Matcher)CoreMatchers.notNullValue());
        GeoShapeQueryBuilderTestCase.assertThat((Object)query, (Matcher)CoreMatchers.instanceOf(MatchNoDocsQuery.class));
        GeoShapeQueryBuilder failingQueryBuilder = new GeoShapeQueryBuilder("unmapped", geometry);
        failingQueryBuilder.ignoreUnmapped(false);
        QueryShardException e = (QueryShardException)GeoShapeQueryBuilderTestCase.expectThrows(QueryShardException.class, () -> failingQueryBuilder.toQuery(GeoShapeQueryBuilderTestCase.createSearchExecutionContext()));
        GeoShapeQueryBuilderTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"failed to find type for field [unmapped]"));
    }

    public void testWrongFieldType() {
        Geometry geometry = GeometryTestUtils.randomGeometry(false);
        GeoShapeQueryBuilder queryBuilder = new GeoShapeQueryBuilder("mapped_string", geometry);
        QueryShardException e = (QueryShardException)GeoShapeQueryBuilderTestCase.expectThrows(QueryShardException.class, () -> queryBuilder.toQuery(GeoShapeQueryBuilderTestCase.createSearchExecutionContext()));
        GeoShapeQueryBuilderTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Field [mapped_string] is of unsupported type [text] for [geo_shape] query"));
    }

    public void testSerializationFailsUnlessFetched() throws IOException {
        GeoShapeQueryBuilder builder = this.doCreateTestQueryBuilder(true);
        QueryBuilder queryBuilder = (QueryBuilder)Rewriteable.rewrite((Rewriteable)builder, (QueryRewriteContext)GeoShapeQueryBuilderTestCase.createSearchExecutionContext());
        IllegalStateException ise = (IllegalStateException)GeoShapeQueryBuilderTestCase.expectThrows(IllegalStateException.class, () -> queryBuilder.writeTo((StreamOutput)new BytesStreamOutput(10)));
        GeoShapeQueryBuilderTestCase.assertEquals((Object)ise.getMessage(), (Object)"supplier must be null, can't serialize suppliers, missing a rewriteAndFetch?");
        builder = this.rewriteAndFetch((QueryBuilder)builder, (QueryRewriteContext)GeoShapeQueryBuilderTestCase.createSearchExecutionContext());
        builder.writeTo((StreamOutput)new BytesStreamOutput(10));
    }

    @Override
    protected QueryBuilder parseQuery(XContentParser parser) throws IOException {
        QueryBuilder query = super.parseQuery(parser);
        GeoShapeQueryBuilderTestCase.assertThat((Object)query, (Matcher)CoreMatchers.instanceOf(GeoShapeQueryBuilder.class));
        return query;
    }

    @Override
    protected Map<String, String> getObjectsHoldingArbitraryContent() {
        return Collections.singletonMap("shape", "Required [type]");
    }
}

