/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.runtime.AbstractScriptFieldQuery;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.EqualsHashCodeTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public abstract class AbstractScriptFieldQueryTestCase<T extends AbstractScriptFieldQuery<?>>
extends ESTestCase {
    protected abstract T createTestInstance();

    protected abstract T copy(T var1);

    protected abstract T mutate(T var1);

    protected final Script randomScript() {
        return new Script(AbstractScriptFieldQueryTestCase.randomAlphaOfLength(10));
    }

    public final void testEqualsAndHashCode() {
        EqualsHashCodeTestUtils.checkEqualsAndHashCode(this.createTestInstance(), this::copy, this::mutate);
    }

    public abstract void testMatches() throws IOException;

    public final void testToString() {
        T query = this.createTestInstance();
        AbstractScriptFieldQueryTestCase.assertThat((Object)query.toString(), (Matcher)Matchers.equalTo((Object)(query.fieldName() + ":" + query.toString(query.fieldName()))));
        this.assertToString(query);
    }

    protected abstract void assertToString(T var1);

    public abstract void testVisit();

    protected final void assertEmptyVisit() {
        T query = this.createTestInstance();
        final ArrayList leavesVisited = new ArrayList();
        query.visit(new QueryVisitor(){

            public void consumeTerms(Query query, Term ... terms) {
                Assert.fail();
            }

            public void consumeTermsMatching(Query query, String field, Supplier<ByteRunAutomaton> automaton) {
                Assert.fail();
            }

            public void visitLeaf(Query query) {
                leavesVisited.add(query);
            }
        });
        AbstractScriptFieldQueryTestCase.assertThat(leavesVisited, (Matcher)Matchers.equalTo(List.of(query)));
    }
}

