/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots.mockstore;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.CorruptIndexException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.DeleteResult;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.blobstore.fs.FsBlobContainer;
import org.elasticsearch.common.blobstore.support.BlobMetadata;
import org.elasticsearch.common.blobstore.support.FilterBlobContainer;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.fs.FsRepository;
import org.elasticsearch.snapshots.mockstore.BlobStoreWrapper;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class MockRepository
extends FsRepository {
    private static final Logger logger = LogManager.getLogger(MockRepository.class);
    public static final String DUMMY_UPDATABLE_SETTING_NAME = "dummy_setting";
    private final AtomicLong failureCounter = new AtomicLong();
    private volatile double randomControlIOExceptionRate;
    private volatile double randomDataFileIOExceptionRate;
    private volatile Predicate<String> randomIOExceptionPattern;
    private volatile boolean useLuceneCorruptionException;
    private volatile long maximumNumberOfFailures;
    private final long waitAfterUnblock;
    private final String randomPrefix;
    private final Environment env;
    private volatile boolean blockOnAnyFiles;
    private volatile boolean blockOnDataFiles;
    private volatile boolean blockAndFailOnDataFiles;
    private volatile boolean blockOnDeleteIndexN;
    private volatile boolean blockAndFailOnWriteIndexFile;
    private volatile boolean blockOnWriteIndexFile;
    private volatile boolean blockAndFailOnWriteSnapFile;
    private volatile String blockedIndexId;
    private volatile boolean blockOnWriteShardLevelMeta;
    private volatile boolean blockAndFailOnWriteShardLevelMeta;
    private volatile boolean blockOnReadIndexMeta;
    private final AtomicBoolean blockOnceOnReadSnapshotInfo = new AtomicBoolean(false);
    private volatile boolean failOnIndexLatest = false;
    private volatile boolean failReadsAfterUnblock;
    private volatile boolean throwReadErrorAfterUnblock = false;
    private volatile boolean blockAndFailOnReadSnapFile;
    private volatile boolean blockAndFailOnReadIndexFile;
    private volatile boolean blocked = false;
    private volatile boolean failOnDeleteContainer = false;

    public long getFailureCount() {
        return this.failureCounter.get();
    }

    public MockRepository(RepositoryMetadata metadata, Environment environment, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings) {
        super(MockRepository.overrideSettings(metadata, environment), environment, namedXContentRegistry, clusterService, bigArrays, recoverySettings);
        this.randomControlIOExceptionRate = metadata.settings().getAsDouble("random_control_io_exception_rate", Double.valueOf(0.0));
        this.randomDataFileIOExceptionRate = metadata.settings().getAsDouble("random_data_file_io_exception_rate", Double.valueOf(0.0));
        this.randomIOExceptionPattern = Pattern.compile(metadata.settings().get("random_io_exception_pattern", ".*")).asMatchPredicate();
        this.useLuceneCorruptionException = metadata.settings().getAsBoolean("use_lucene_corruption", Boolean.valueOf(false));
        this.maximumNumberOfFailures = metadata.settings().getAsLong("max_failure_number", Long.valueOf(100L));
        this.blockOnAnyFiles = metadata.settings().getAsBoolean("block_on_control", Boolean.valueOf(false));
        this.blockOnDataFiles = metadata.settings().getAsBoolean("block_on_data", Boolean.valueOf(false));
        this.blockAndFailOnWriteSnapFile = metadata.settings().getAsBoolean("block_on_snap", Boolean.valueOf(false));
        this.randomPrefix = metadata.settings().get("random", "default");
        this.waitAfterUnblock = metadata.settings().getAsLong("wait_after_unblock", Long.valueOf(0L));
        this.env = environment;
        logger.info("starting mock repository with random prefix {}", (Object)this.randomPrefix);
    }

    public RepositoryMetadata getMetadata() {
        return MockRepository.overrideSettings(super.getMetadata(), this.env);
    }

    public boolean canUpdateInPlace(Settings updatedSettings, Set<String> ignoredSettings) {
        return super.canUpdateInPlace(updatedSettings, Sets.union(ignoredSettings, Set.of(DUMMY_UPDATABLE_SETTING_NAME)));
    }

    private static RepositoryMetadata overrideSettings(RepositoryMetadata metadata, Environment environment) {
        if (metadata.settings().getAsBoolean("localize_location", Boolean.valueOf(false)).booleanValue()) {
            Path location = PathUtils.get((String)metadata.settings().get("location"), (String[])new String[0]);
            location = location.resolve(Integer.toString(environment.hashCode()));
            return new RepositoryMetadata(metadata.name(), metadata.type(), Settings.builder().put(metadata.settings()).put("location", location.toAbsolutePath()).build());
        }
        return metadata;
    }

    private long incrementAndGetFailureCount() {
        return this.failureCounter.incrementAndGet();
    }

    protected void doStop() {
        this.unblock();
        super.doStop();
    }

    protected BlobStore createBlobStore() throws Exception {
        return new MockBlobStore(super.createBlobStore());
    }

    public synchronized void unblock() {
        this.blocked = false;
        this.blockOnDataFiles = false;
        this.blockAndFailOnDataFiles = false;
        this.blockOnAnyFiles = false;
        this.blockAndFailOnWriteIndexFile = false;
        this.blockOnWriteIndexFile = false;
        this.blockAndFailOnWriteSnapFile = false;
        this.blockedIndexId = null;
        this.blockOnDeleteIndexN = false;
        this.blockOnWriteShardLevelMeta = false;
        this.blockAndFailOnWriteShardLevelMeta = false;
        this.blockOnReadIndexMeta = false;
        this.blockOnceOnReadSnapshotInfo.set(false);
        this.blockAndFailOnReadSnapFile = false;
        this.blockAndFailOnReadIndexFile = false;
        ((Object)((Object)this)).notifyAll();
    }

    public void setMaximumNumberOfFailures(long maximumNumberOfFailures) {
        logger.debug("Setting maximum number of failures to [{}]", (Object)maximumNumberOfFailures);
        this.maximumNumberOfFailures = maximumNumberOfFailures;
    }

    public void setUseLuceneCorruptionException(boolean useLuceneCorruptionException) {
        logger.debug("Setting using lucene corruption exception to [{}]", (Object)useLuceneCorruptionException);
        this.useLuceneCorruptionException = useLuceneCorruptionException;
    }

    public void setRandomControlIOExceptionRate(double randomControlIOExceptionRate) {
        logger.debug("Setting random control I/O exception rate to [{}]", (Object)randomControlIOExceptionRate);
        this.randomControlIOExceptionRate = randomControlIOExceptionRate;
    }

    public void setRandomDataFileIOExceptionRate(double randomDataFileIOExceptionRate) {
        logger.debug("Setting random data file I/O exception rate to [{}]", (Object)randomDataFileIOExceptionRate);
        this.randomDataFileIOExceptionRate = randomDataFileIOExceptionRate;
    }

    public void setRandomIOExceptionPattern(String randomIOExceptionPattern) {
        logger.debug("Setting random I/O exception pattern to [{}]", (Object)randomIOExceptionPattern);
        this.randomIOExceptionPattern = Pattern.compile(randomIOExceptionPattern).asMatchPredicate();
    }

    public void blockOnDataFiles() {
        assert (!this.blockAndFailOnDataFiles) : "Either fail or wait after data file, not both";
        this.blockOnDataFiles = true;
    }

    public void blockAndFailOnDataFiles() {
        assert (!this.blockOnDataFiles) : "Either fail or wait after data file, not both";
        this.blockAndFailOnDataFiles = true;
    }

    public void setBlockOnAnyFiles() {
        this.blockOnAnyFiles = true;
    }

    public void setBlockAndFailOnWriteSnapFiles() {
        this.blockAndFailOnWriteSnapFile = true;
    }

    public void setBlockOnShardLevelSnapFiles(String indexId) {
        this.blockedIndexId = indexId;
    }

    public void setBlockAndFailOnWriteIndexFile() {
        assert (!this.blockOnWriteIndexFile) : "Either fail or wait after blocking on index-N not both";
        this.blockAndFailOnWriteIndexFile = true;
    }

    public void setBlockOnWriteIndexFile() {
        assert (!this.blockAndFailOnWriteIndexFile) : "Either fail or wait after blocking on index-N not both";
        this.blockOnWriteIndexFile = true;
    }

    public void setBlockOnDeleteIndexFile() {
        this.blockOnDeleteIndexN = true;
    }

    public void setBlockOnWriteShardLevelMeta() {
        assert (!this.blockAndFailOnWriteShardLevelMeta) : "Either fail or wait after blocking on shard level metadata, not both";
        this.blockOnWriteShardLevelMeta = true;
    }

    public void setBlockAndFailOnWriteShardLevelMeta() {
        assert (!this.blockOnWriteShardLevelMeta) : "Either fail or wait after blocking on shard level metadata, not both";
        this.blockAndFailOnWriteShardLevelMeta = true;
    }

    public void setBlockOnReadIndexMeta() {
        this.blockOnReadIndexMeta = true;
    }

    public void setFailReadsAfterUnblock(boolean failReadsAfterUnblock) {
        this.failReadsAfterUnblock = failReadsAfterUnblock;
    }

    public void setBlockAndFailOnReadSnapFiles() {
        this.blockAndFailOnReadSnapFile = true;
    }

    public void setBlockAndFailOnReadIndexFiles() {
        this.blockAndFailOnReadIndexFile = true;
    }

    public void setBlockOnceOnReadSnapshotInfoIfAlreadyBlocked() {
        this.blockOnceOnReadSnapshotInfo.set(true);
    }

    public void setFailOnDeleteContainer(boolean failOnDeleteContainer) {
        this.failOnDeleteContainer = failOnDeleteContainer;
    }

    public boolean blocked() {
        return this.blocked;
    }

    public void setFailOnIndexLatest(boolean failOnIndexLatest) {
        this.failOnIndexLatest = failOnIndexLatest;
    }

    private synchronized boolean blockExecution() {
        logger.debug("[{}] Blocking execution", (Object)this.metadata.name());
        boolean wasBlocked = false;
        try {
            while (this.blockAndFailOnDataFiles || this.blockOnDataFiles || this.blockOnAnyFiles || this.blockAndFailOnWriteIndexFile || this.blockOnWriteIndexFile || this.blockAndFailOnWriteSnapFile || this.blockOnDeleteIndexN || this.blockOnWriteShardLevelMeta || this.blockAndFailOnWriteShardLevelMeta || this.blockOnReadIndexMeta || this.blockAndFailOnReadSnapFile || this.blockAndFailOnReadIndexFile || this.blockedIndexId != null) {
                this.blocked = true;
                ((Object)((Object)this)).wait();
                wasBlocked = true;
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        logger.debug("[{}] Unblocking execution", (Object)this.metadata.name());
        if (wasBlocked && this.failReadsAfterUnblock) {
            logger.debug("[{}] Next read operations will fail", (Object)this.metadata.name());
            this.throwReadErrorAfterUnblock = true;
        }
        return wasBlocked;
    }

    public class MockBlobStore
    extends BlobStoreWrapper {
        ConcurrentMap<String, AtomicLong> accessCounts;

        private long incrementAndGet(String path) {
            AtomicLong value = (AtomicLong)this.accessCounts.get(path);
            if (value == null) {
                value = this.accessCounts.putIfAbsent(path, new AtomicLong(1L));
            }
            if (value != null) {
                return value.incrementAndGet();
            }
            return 1L;
        }

        public MockBlobStore(BlobStore delegate) {
            super(delegate);
            this.accessCounts = new ConcurrentHashMap<String, AtomicLong>();
        }

        @Override
        public BlobContainer blobContainer(BlobPath path) {
            return new MockBlobContainer(super.blobContainer(path));
        }

        private class MockBlobContainer
        extends FilterBlobContainer {
            private boolean shouldFail(String blobName, double probability) {
                if (probability > 0.0) {
                    String path = this.path().add(blobName).buildAsString() + MockRepository.this.randomPrefix;
                    if ((double)Math.abs(this.hashCode(path = path + "/" + MockBlobStore.this.incrementAndGet(path))) < 2.147483647E9 * probability) {
                        if (MockRepository.this.randomIOExceptionPattern.test(path)) {
                            if (MockRepository.this.incrementAndGetFailureCount() <= MockRepository.this.maximumNumberOfFailures) {
                                logger.info("failing [{}]", (Object)path);
                                return true;
                            }
                            logger.info("did not fail [{}] because failure count larger than maximum", (Object)path);
                        } else {
                            logger.info("did not fail [{}] because it does not match the pattern", (Object)path);
                        }
                    } else {
                        logger.info("did not fail [{}] due to probability", (Object)path);
                    }
                }
                return false;
            }

            private int hashCode(String path) {
                try {
                    MessageDigest digest = MessageDigest.getInstance("MD5");
                    byte[] bytes = digest.digest(path.getBytes(StandardCharsets.UTF_8));
                    int i = 0;
                    return (bytes[i++] & 0xFF) << 24 | (bytes[i++] & 0xFF) << 16 | (bytes[i++] & 0xFF) << 8 | bytes[i++] & 0xFF;
                }
                catch (NoSuchAlgorithmException ex) {
                    throw new ElasticsearchException("cannot calculate hashcode", (Throwable)ex, new Object[0]);
                }
            }

            private void maybeIOExceptionOrBlock(String blobName) throws IOException {
                if ("index.latest".equals(blobName)) {
                    return;
                }
                if (blobName.startsWith("__")) {
                    if (this.shouldFail(blobName, MockRepository.this.randomDataFileIOExceptionRate)) {
                        logger.info("throwing random IOException for file [{}] at path [{}]", (Object)blobName, (Object)this.path());
                        if (MockRepository.this.useLuceneCorruptionException) {
                            throw new CorruptIndexException("Random corruption", "random file");
                        }
                        throw new IOException("Random IOException");
                    }
                    if (MockRepository.this.blockOnDataFiles) {
                        this.blockExecutionAndMaybeWait(blobName);
                    } else if (MockRepository.this.blockAndFailOnDataFiles) {
                        this.blockExecutionAndFail(blobName);
                    }
                } else {
                    if (this.shouldFail(blobName, MockRepository.this.randomControlIOExceptionRate)) {
                        logger.info("throwing random IOException for file [{}] at path [{}]", (Object)blobName, (Object)this.path());
                        throw new IOException("Random IOException");
                    }
                    if (MockRepository.this.blockOnAnyFiles) {
                        this.blockExecutionAndMaybeWait(blobName);
                    } else if (blobName.startsWith("snap-") && (MockRepository.this.blockAndFailOnWriteSnapFile || MockRepository.this.blockAndFailOnReadSnapFile)) {
                        this.blockExecutionAndFail(blobName);
                    } else if (blobName.startsWith("index-") && MockRepository.this.blockAndFailOnReadIndexFile) {
                        this.blockExecutionAndFail(blobName);
                    } else if (MockRepository.this.blockedIndexId != null && this.path().parts().contains(MockRepository.this.blockedIndexId) && blobName.startsWith("snap-")) {
                        this.blockExecutionAndMaybeWait(blobName);
                    }
                }
            }

            private void blockExecutionAndMaybeWait(String blobName) throws IOException {
                logger.info("[{}] blocking I/O operation for file [{}] at path [{}]", (Object)MockRepository.this.metadata.name(), (Object)blobName, (Object)this.path());
                boolean wasBlocked = MockRepository.this.blockExecution();
                if (wasBlocked && MockRepository.this.lifecycle.stoppedOrClosed()) {
                    throw new IOException("already closed");
                }
                if (wasBlocked && MockRepository.this.waitAfterUnblock > 0L) {
                    try {
                        Thread.sleep(MockRepository.this.waitAfterUnblock);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }

            private void blockExecutionAndFail(String blobName) throws IOException {
                logger.info("blocking I/O operation for file [{}] at path [{}]", (Object)blobName, (Object)this.path());
                MockRepository.this.blockExecution();
                throw new IOException("exception after block");
            }

            private void maybeReadErrorAfterBlock(String blobName) {
                if (MockRepository.this.throwReadErrorAfterUnblock) {
                    throw new AssertionError((Object)("Read operation are not allowed anymore at this point [blob=" + blobName + "]"));
                }
            }

            MockBlobContainer(BlobContainer delegate) {
                super(delegate);
            }

            protected BlobContainer wrapChild(BlobContainer child) {
                return new MockBlobContainer(child);
            }

            public InputStream readBlob(OperationPurpose purpose, String name) throws IOException {
                if (MockRepository.this.blockOnReadIndexMeta && name.startsWith("meta-") && !this.path().equals((Object)MockRepository.this.basePath())) {
                    this.blockExecutionAndMaybeWait(name);
                } else if (this.path().equals((Object)MockRepository.this.basePath()) && name.startsWith("snap-") && MockRepository.this.blockOnceOnReadSnapshotInfo.compareAndSet(true, false)) {
                    this.blockExecutionAndMaybeWait(name);
                } else {
                    this.maybeReadErrorAfterBlock(name);
                    this.maybeIOExceptionOrBlock(name);
                }
                return super.readBlob(purpose, name);
            }

            public InputStream readBlob(OperationPurpose purpose, String name, long position, long length) throws IOException {
                this.maybeReadErrorAfterBlock(name);
                this.maybeIOExceptionOrBlock(name);
                return super.readBlob(purpose, name, position, length);
            }

            public DeleteResult delete(OperationPurpose purpose) throws IOException {
                if (MockRepository.this.failOnDeleteContainer) {
                    throw new IOException("simulated delete-container failure");
                }
                DeleteResult deleteResult = DeleteResult.ZERO;
                for (BlobContainer child : this.children(purpose).values()) {
                    deleteResult = deleteResult.add(child.delete(purpose));
                }
                Map<String, BlobMetadata> blobs = this.listBlobs(purpose);
                long deleteBlobCount = blobs.size();
                long deleteByteCount = 0L;
                for (String blob : blobs.values().stream().map(BlobMetadata::name).toList()) {
                    this.maybeIOExceptionOrBlock(blob);
                    this.deleteBlobsIgnoringIfNotExists(purpose, Iterators.single((Object)blob));
                    deleteByteCount += blobs.get(blob).length();
                }
                MockRepository.this.blobStore().blobContainer(this.path().parent()).deleteBlobsIgnoringIfNotExists(purpose, Iterators.single((Object)((String)this.path().parts().get(this.path().parts().size() - 1))));
                return deleteResult.add(deleteBlobCount, deleteByteCount);
            }

            public void deleteBlobsIgnoringIfNotExists(OperationPurpose purpose, Iterator<String> blobNames) throws IOException {
                ArrayList names = new ArrayList();
                blobNames.forEachRemaining(names::add);
                if (MockRepository.this.blockOnDeleteIndexN && names.stream().anyMatch(name -> name.startsWith("index-"))) {
                    this.blockExecutionAndMaybeWait("index-{N}");
                }
                super.deleteBlobsIgnoringIfNotExists(purpose, names.iterator());
            }

            public Map<String, BlobMetadata> listBlobs(OperationPurpose purpose) throws IOException {
                this.maybeIOExceptionOrBlock("");
                return super.listBlobs(purpose);
            }

            public Map<String, BlobContainer> children(OperationPurpose purpose) throws IOException {
                HashMap<String, BlobContainer> res = new HashMap<String, BlobContainer>();
                for (Map.Entry entry : super.children(purpose).entrySet()) {
                    res.put((String)entry.getKey(), (BlobContainer)new MockBlobContainer((BlobContainer)entry.getValue()));
                }
                return res;
            }

            public Map<String, BlobMetadata> listBlobsByPrefix(OperationPurpose purpose, String blobNamePrefix) throws IOException {
                this.maybeIOExceptionOrBlock(blobNamePrefix);
                return super.listBlobsByPrefix(purpose, blobNamePrefix);
            }

            public void writeBlob(OperationPurpose purpose, String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
                this.beforeWrite(blobName);
                super.writeBlob(purpose, blobName, inputStream, blobSize, failIfAlreadyExists);
                if (RandomizedContext.current().getRandom().nextBoolean()) {
                    this.maybeIOExceptionOrBlock(blobName);
                }
            }

            public void writeMetadataBlob(OperationPurpose purpose, String blobName, boolean failIfAlreadyExists, boolean atomic, CheckedConsumer<OutputStream, IOException> writer) throws IOException {
                if (atomic) {
                    this.beforeAtomicWrite(blobName);
                } else {
                    this.beforeWrite(blobName);
                }
                super.writeMetadataBlob(purpose, blobName, failIfAlreadyExists, atomic, writer);
                if (RandomizedContext.current().getRandom().nextBoolean()) {
                    this.maybeIOExceptionOrBlock(blobName);
                }
            }

            private void beforeWrite(String blobName) throws IOException {
                this.maybeIOExceptionOrBlock(blobName);
                if (blobName.startsWith("snap-") && !this.path().equals((Object)MockRepository.this.basePath())) {
                    if (MockRepository.this.blockOnWriteShardLevelMeta) {
                        this.blockExecutionAndMaybeWait(blobName);
                    } else if (MockRepository.this.blockAndFailOnWriteShardLevelMeta) {
                        this.blockExecutionAndFail(blobName);
                    }
                }
            }

            public void writeBlobAtomic(OperationPurpose purpose, String blobName, BytesReference bytes, boolean failIfAlreadyExists) throws IOException {
                Random random = this.beforeAtomicWrite(blobName);
                if (MockBlobStore.this.delegate() instanceof FsBlobContainer && random.nextBoolean()) {
                    String tempBlobName = FsBlobContainer.tempBlobName((String)blobName);
                    super.writeBlob(purpose, tempBlobName, bytes, failIfAlreadyExists);
                    this.maybeIOExceptionOrBlock(blobName);
                    FsBlobContainer fsBlobContainer = (FsBlobContainer)MockBlobStore.this.delegate();
                    fsBlobContainer.moveBlobAtomic(purpose, tempBlobName, blobName, failIfAlreadyExists);
                } else {
                    this.maybeIOExceptionOrBlock(blobName);
                    super.writeBlobAtomic(purpose, blobName, bytes, failIfAlreadyExists);
                }
            }

            private Random beforeAtomicWrite(String blobName) throws IOException {
                Random random = RandomizedContext.current().getRandom();
                if (MockRepository.this.failOnIndexLatest && "index.latest".equals(blobName)) {
                    throw new IOException("Random IOException");
                }
                if (this.shouldFail(blobName, MockRepository.this.randomControlIOExceptionRate)) {
                    logger.info("throwing random IOException for atomic write of file [{}] at path [{}]", (Object)blobName, (Object)this.path());
                    throw new IOException("Random IOException");
                }
                if (blobName.startsWith("index-")) {
                    if (MockRepository.this.blockAndFailOnWriteIndexFile) {
                        this.blockExecutionAndFail(blobName);
                    } else if (MockRepository.this.blockOnWriteIndexFile) {
                        this.blockExecutionAndMaybeWait(blobName);
                    }
                }
                return random;
            }
        }
    }

    public static class Plugin
    extends org.elasticsearch.plugins.Plugin
    implements RepositoryPlugin {
        public static final Setting<String> USERNAME_SETTING = Setting.simpleString((String)"secret.mock.username", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> PASSWORD_SETTING = Setting.simpleString((String)"secret.mock.password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});

        public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings) {
            return Collections.singletonMap("mock", metadata -> new MockRepository(metadata, env, namedXContentRegistry, clusterService, bigArrays, recoverySettings));
        }

        public List<Setting<?>> getSettings() {
            return Arrays.asList(USERNAME_SETTING, PASSWORD_SETTING);
        }
    }
}

