/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry;

import java.util.List;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.TelemetryPlugin;
import org.elasticsearch.telemetry.InstrumentType;
import org.elasticsearch.telemetry.Measurement;
import org.elasticsearch.telemetry.RecordingMeterRegistry;
import org.elasticsearch.telemetry.Registration;
import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.telemetry.metric.Instrument;
import org.elasticsearch.telemetry.metric.MeterRegistry;
import org.elasticsearch.telemetry.tracing.Tracer;

public class TestTelemetryPlugin
extends Plugin
implements TelemetryPlugin {
    protected final RecordingMeterRegistry meter = new RecordingMeterRegistry();

    Registration getRegistration(Instrument instrument) {
        return this.meter.getRecorder().getRegistration(instrument);
    }

    public List<Measurement> getMetrics(Instrument instrument) {
        return this.meter.getRecorder().getMeasurements(instrument);
    }

    public List<Measurement> getDoubleCounterMeasurement(String name) {
        return this.meter.getRecorder().getMeasurements(InstrumentType.DOUBLE_COUNTER, name);
    }

    public List<Measurement> getLongCounterMeasurement(String name) {
        return this.meter.getRecorder().getMeasurements(InstrumentType.LONG_COUNTER, name);
    }

    public List<Measurement> getDoubleUpDownCounterMeasurement(String name) {
        return this.meter.getRecorder().getMeasurements(InstrumentType.DOUBLE_UP_DOWN_COUNTER, name);
    }

    public List<Measurement> getLongUpDownCounterMeasurement(String name) {
        return this.meter.getRecorder().getMeasurements(InstrumentType.LONG_UP_DOWN_COUNTER, name);
    }

    public List<Measurement> getDoubleGaugeMeasurement(String name) {
        return this.meter.getRecorder().getMeasurements(InstrumentType.DOUBLE_GAUGE, name);
    }

    public List<Measurement> getLongGaugeMeasurement(String name) {
        return this.meter.getRecorder().getMeasurements(InstrumentType.LONG_GAUGE, name);
    }

    public List<Measurement> getDoubleHistogramMeasurement(String name) {
        return this.meter.getRecorder().getMeasurements(InstrumentType.DOUBLE_HISTOGRAM, name);
    }

    public List<Measurement> getLongHistogramMeasurement(String name) {
        return this.meter.getRecorder().getMeasurements(InstrumentType.LONG_HISTOGRAM, name);
    }

    public void resetMeter() {
        this.meter.getRecorder().resetCalls();
    }

    public TelemetryProvider getTelemetryProvider(Settings settings) {
        return new TelemetryProvider(){

            public Tracer getTracer() {
                return Tracer.NOOP;
            }

            public MeterRegistry getMeterRegistry() {
                return TestTelemetryPlugin.this.meter;
            }
        };
    }
}

