/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequestBuilder;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequestBuilder;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.MockScriptPlugin;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.internal.ReaderContext;
import org.elasticsearch.search.lookup.LeafStoredFieldsLookup;
import org.elasticsearch.tasks.TaskInfo;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;

public class AbstractSearchCancellationTestCase
extends ESIntegTestCase {
    protected static boolean lowLevelCancellation;

    @BeforeClass
    public static void init() {
        lowLevelCancellation = AbstractSearchCancellationTestCase.randomBoolean();
    }

    @Override
    protected Collection<Class<? extends Plugin>> nodePlugins() {
        return List.of(ScriptedBlockPlugin.class, SearchShardBlockingPlugin.class);
    }

    @Override
    protected Settings nodeSettings(int nodeOrdinal, Settings otherSettings) {
        this.logger.info("Using lowLevelCancellation: {}", (Object)lowLevelCancellation);
        return Settings.builder().put(super.nodeSettings(nodeOrdinal, otherSettings)).put(SearchService.LOW_LEVEL_CANCELLATION_SETTING.getKey(), lowLevelCancellation).build();
    }

    protected void indexTestData() {
        for (int i = 0; i < 5; ++i) {
            BulkRequestBuilder bulkRequestBuilder = (BulkRequestBuilder)AbstractSearchCancellationTestCase.client().prepareBulk().setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            for (int j = 0; j < 20; ++j) {
                bulkRequestBuilder.add(AbstractSearchCancellationTestCase.prepareIndex("test").setId(Integer.toString(i * 5 + j)).setSource(new Object[]{"field", "value"}));
            }
            ElasticsearchAssertions.assertNoFailures((BulkResponse)bulkRequestBuilder.get());
        }
    }

    protected List<ScriptedBlockPlugin> initBlockFactory() {
        ArrayList<ScriptedBlockPlugin> plugins = new ArrayList<ScriptedBlockPlugin>();
        for (PluginsService pluginsService : AbstractSearchCancellationTestCase.internalCluster().getInstances(PluginsService.class)) {
            pluginsService.filterPlugins(ScriptedBlockPlugin.class).forEach(plugins::add);
        }
        for (ScriptedBlockPlugin plugin : plugins) {
            plugin.reset();
            plugin.enableBlock();
        }
        return plugins;
    }

    protected void awaitForBlock(List<ScriptedBlockPlugin> plugins) throws Exception {
        int numberOfShards = this.getNumShards((String)"test").numPrimaries;
        AbstractSearchCancellationTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            int numberOfBlockedPlugins = 0;
            for (ScriptedBlockPlugin plugin : plugins) {
                numberOfBlockedPlugins += plugin.hits.get();
            }
            this.logger.info("The plugin blocked on {} out of {} shards", (Object)numberOfBlockedPlugins, (Object)numberOfShards);
            AbstractSearchCancellationTestCase.assertThat((Object)numberOfBlockedPlugins, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        }));
    }

    protected void disableBlocks(List<ScriptedBlockPlugin> plugins) throws Exception {
        for (ScriptedBlockPlugin plugin : plugins) {
            plugin.disableBlock();
        }
    }

    protected void cancelSearch(String action) {
        ListTasksResponse listTasksResponse = (ListTasksResponse)((ListTasksRequestBuilder)AbstractSearchCancellationTestCase.client().admin().cluster().prepareListTasks(new String[0]).setActions(new String[]{action})).get();
        AbstractSearchCancellationTestCase.assertThat((Object)listTasksResponse.getTasks(), (Matcher)Matchers.hasSize((int)1));
        TaskInfo searchTask = (TaskInfo)listTasksResponse.getTasks().get(0);
        this.logger.info("Cancelling search");
        CancelTasksResponse cancelTasksResponse = (CancelTasksResponse)((CancelTasksRequestBuilder)AbstractSearchCancellationTestCase.clusterAdmin().prepareCancelTasks(new String[0]).setTargetTaskId(searchTask.taskId())).get();
        AbstractSearchCancellationTestCase.assertThat((Object)cancelTasksResponse.getTasks(), (Matcher)Matchers.hasSize((int)1));
        AbstractSearchCancellationTestCase.assertThat((Object)((TaskInfo)cancelTasksResponse.getTasks().get(0)).taskId(), (Matcher)Matchers.equalTo((Object)searchTask.taskId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SearchResponse ensureSearchWasCancelled(ActionFuture<SearchResponse> searchResponse) {
        SearchResponse response = null;
        try {
            response = (SearchResponse)searchResponse.actionGet();
            this.logger.info("Search response {}", (Object)response);
            AbstractSearchCancellationTestCase.assertNotEquals((String)"At least one shard should have failed", (long)0L, (long)response.getFailedShards());
            for (SearchResponse failure : response.getShardFailures()) {
                AbstractSearchCancellationTestCase.assertThat((Object)ExceptionsHelper.status((Throwable)failure.getCause()), (Matcher)Matchers.equalTo((Object)RestStatus.BAD_REQUEST));
            }
            SearchResponse searchResponse2 = response;
            return searchResponse2;
        }
        catch (SearchPhaseExecutionException ex) {
            AbstractSearchCancellationTestCase.assertThat((Object)ExceptionsHelper.status((Throwable)ex), (Matcher)Matchers.equalTo((Object)RestStatus.BAD_REQUEST));
            this.logger.info("All shards failed with", (Throwable)ex);
            SearchResponse searchResponse3 = null;
            return searchResponse3;
        }
        finally {
            if (response != null) {
                response.decRef();
            }
        }
    }

    protected List<SearchShardBlockingPlugin> initSearchShardBlockingPlugin() {
        ArrayList<SearchShardBlockingPlugin> plugins = new ArrayList<SearchShardBlockingPlugin>();
        for (PluginsService pluginsService : AbstractSearchCancellationTestCase.internalCluster().getInstances(PluginsService.class)) {
            pluginsService.filterPlugins(SearchShardBlockingPlugin.class).forEach(plugins::add);
        }
        return plugins;
    }

    public static class ScriptedBlockPlugin
    extends MockScriptPlugin {
        public static final String SEARCH_BLOCK_SCRIPT_NAME = "search_block";
        public static final String INIT_SCRIPT_NAME = "init";
        public static final String MAP_SCRIPT_NAME = "map";
        public static final String MAP_BLOCK_SCRIPT_NAME = "map_block";
        public static final String COMBINE_SCRIPT_NAME = "combine";
        static final String REDUCE_SCRIPT_NAME = "reduce";
        public static final String REDUCE_FAIL_SCRIPT_NAME = "reduce_fail";
        public static final String REDUCE_BLOCK_SCRIPT_NAME = "reduce_block";
        public static final String TERM_SCRIPT_NAME = "term";
        private final AtomicInteger hits = new AtomicInteger();
        private final Semaphore shouldBlock = new Semaphore(Integer.MAX_VALUE);
        private final AtomicReference<Runnable> beforeExecution = new AtomicReference();

        public void reset() {
            this.hits.set(0);
        }

        public void disableBlock() {
            this.shouldBlock.release(Integer.MAX_VALUE);
        }

        public void enableBlock() {
            try {
                this.shouldBlock.acquire(Integer.MAX_VALUE);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new AssertionError((Object)e);
            }
        }

        public void setBeforeExecution(Runnable runnable) {
            this.beforeExecution.set(runnable);
        }

        @Override
        public Map<String, Function<Map<String, Object>, Object>> pluginScripts() {
            return Map.of(SEARCH_BLOCK_SCRIPT_NAME, this::searchBlockScript, INIT_SCRIPT_NAME, this::nullScript, MAP_SCRIPT_NAME, this::nullScript, MAP_BLOCK_SCRIPT_NAME, this::mapBlockScript, COMBINE_SCRIPT_NAME, this::nullScript, REDUCE_BLOCK_SCRIPT_NAME, this::blockScript, REDUCE_SCRIPT_NAME, this::termScript, REDUCE_FAIL_SCRIPT_NAME, this::reduceFailScript, TERM_SCRIPT_NAME, this::termScript);
        }

        public void logIfBlocked(String logMessage) {
            if (!this.shouldBlock.tryAcquire(1)) {
                LogManager.getLogger(AbstractSearchCancellationTestCase.class).info(logMessage);
            } else {
                this.shouldBlock.release(1);
            }
        }

        public void waitForLock(int timeout, TimeUnit timeUnit) {
            try {
                Assert.assertTrue((boolean)this.shouldBlock.tryAcquire(timeout, timeUnit));
                this.shouldBlock.release(1);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private Object searchBlockScript(Map<String, Object> params) {
            Runnable runnable = this.beforeExecution.get();
            if (runnable != null) {
                runnable.run();
            }
            LeafStoredFieldsLookup fieldsLookup = (LeafStoredFieldsLookup)params.get("_fields");
            LogManager.getLogger(AbstractSearchCancellationTestCase.class).info("Blocking on the document {}", (Object)fieldsLookup.get((Object)"_id"));
            this.hits.incrementAndGet();
            this.waitForLock(10, TimeUnit.SECONDS);
            return true;
        }

        private Object reduceFailScript(Map<String, Object> params) {
            Assert.fail((String)"Shouldn't reach reduce");
            return true;
        }

        private Object nullScript(Map<String, Object> params) {
            return null;
        }

        private Object blockScript(Map<String, Object> params) {
            Runnable runnable = this.beforeExecution.get();
            if (runnable != null) {
                runnable.run();
            }
            this.logIfBlocked("Blocking in reduce");
            this.hits.incrementAndGet();
            this.waitForLock(10, TimeUnit.SECONDS);
            return 42;
        }

        private Object mapBlockScript(Map<String, Object> params) {
            Runnable runnable = this.beforeExecution.get();
            if (runnable != null) {
                runnable.run();
            }
            this.logIfBlocked("Blocking in map");
            this.hits.incrementAndGet();
            this.waitForLock(10, TimeUnit.SECONDS);
            return 1;
        }

        private Object termScript(Map<String, Object> params) {
            return 1;
        }
    }

    public static class SearchShardBlockingPlugin
    extends Plugin {
        private final AtomicReference<Consumer<ReaderContext>> runOnNewReaderContext = new AtomicReference();

        public void setRunOnNewReaderContext(Consumer<ReaderContext> consumer) {
            this.runOnNewReaderContext.set(consumer);
        }

        public void onIndexModule(IndexModule indexModule) {
            super.onIndexModule(indexModule);
            indexModule.addSearchOperationListener(new SearchOperationListener(){

                public void onNewReaderContext(ReaderContext c) {
                    if (runOnNewReaderContext.get() != null) {
                        runOnNewReaderContext.get().accept(c);
                    }
                }
            });
        }
    }
}

