/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Function;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class LambdaMatchers {
    public static <T, U> Matcher<T> transformedMatch(Function<T, U> function, Matcher<U> matcher) {
        return new TransformMatcher<T, U>(matcher, function);
    }

    public static <T, U> Matcher<Iterable<T>> transformedItemsMatch(Function<T, U> function, Matcher<Iterable<? extends U>> matcher) {
        return new ListTransformMatcher<T, U>(matcher, function);
    }

    public static <T, U> Matcher<T[]> transformedArrayItemsMatch(Function<T, U> function, Matcher<U[]> matcher) {
        return new ArrayTransformMatcher<T, U>(matcher, function);
    }

    private static class TransformMatcher<T, U>
    extends BaseMatcher<T> {
        private final Matcher<U> matcher;
        private final Function<T, U> transform;

        private TransformMatcher(Matcher<U> matcher, Function<T, U> transform) {
            this.matcher = matcher;
            this.transform = transform;
        }

        public boolean matches(Object actual) {
            U u;
            try {
                u = this.transform.apply(actual);
            }
            catch (ClassCastException e) {
                throw new AssertionError((Object)e);
            }
            return this.matcher.matches(u);
        }

        public void describeMismatch(Object item, Description description) {
            U u;
            try {
                u = this.transform.apply(item);
            }
            catch (ClassCastException e) {
                description.appendValue(item).appendText(" is not of the correct type (").appendText(e.getMessage()).appendText(")");
                return;
            }
            description.appendText("transformed value ");
            this.matcher.describeMismatch(u, description);
        }

        public void describeTo(Description description) {
            description.appendText("transformed to match ").appendDescriptionOf(this.matcher);
        }
    }

    private static class ListTransformMatcher<T, U>
    extends TypeSafeMatcher<Iterable<T>> {
        private final Matcher<Iterable<? extends U>> matcher;
        private final Function<T, U> transform;

        private ListTransformMatcher(Matcher<Iterable<? extends U>> matcher, Function<T, U> transform) {
            this.matcher = matcher;
            this.transform = transform;
        }

        protected boolean matchesSafely(Iterable<T> item) {
            ArrayList<U> us = new ArrayList<U>();
            for (T i : item) {
                try {
                    us.add(this.transform.apply(i));
                }
                catch (ClassCastException e) {
                    throw new AssertionError((Object)e);
                }
            }
            return this.matcher.matches(us);
        }

        protected void describeMismatchSafely(Iterable<T> item, Description description) {
            ArrayList<U> us = new ArrayList<U>();
            int i = 0;
            Iterator<T> iterator = item.iterator();
            while (iterator.hasNext()) {
                try {
                    us.add(this.transform.apply(iterator.next()));
                }
                catch (ClassCastException e) {
                    description.appendValue((Object)i).appendText(" at index " + i).appendText(" is not of the correct type (").appendText(e.getMessage()).appendText(")");
                    return;
                }
                ++i;
            }
            description.appendText("transformed item ");
            this.matcher.describeMismatch(us, description);
        }

        public void describeTo(Description description) {
            description.appendText("iterable with transformed items to match ").appendDescriptionOf(this.matcher);
        }
    }

    private static class ArrayTransformMatcher<T, U>
    extends TypeSafeMatcher<T[]> {
        private final Matcher<U[]> matcher;
        private final Function<T, U> transform;

        private ArrayTransformMatcher(Matcher<U[]> matcher, Function<T, U> transform) {
            this.matcher = matcher;
            this.transform = transform;
        }

        protected boolean matchesSafely(T[] item) {
            Object[] us = null;
            for (int i = 0; i < item.length; ++i) {
                U u;
                try {
                    u = this.transform.apply(item[i]);
                }
                catch (ClassCastException e) {
                    throw new AssertionError((Object)e);
                }
                if (us == null) {
                    us = (Object[])Array.newInstance(u.getClass(), item.length);
                }
                us[i] = u;
            }
            return this.matcher.matches(us);
        }

        protected void describeMismatchSafely(T[] item, Description description) {
            Object[] us = null;
            for (int i = 0; i < item.length; ++i) {
                U u;
                try {
                    u = this.transform.apply(item[i]);
                }
                catch (ClassCastException e) {
                    description.appendValue((Object)i).appendText(" at index " + i).appendText(" is not of the correct type (").appendText(e.getMessage()).appendText(")");
                    return;
                }
                if (us == null) {
                    us = (Object[])Array.newInstance(u.getClass(), item.length);
                }
                us[i] = u;
            }
            description.appendText("transformed item ");
            this.matcher.describeMismatch(us, description);
        }

        public void describeTo(Description description) {
            description.appendText("array with transformed items to match ").appendDescriptionOf(this.matcher);
        }
    }
}

