/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.client;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.Transport;

public class NoOpNodeClient
extends NodeClient {
    private final AtomicLong executionCount = new AtomicLong(0L);

    public NoOpNodeClient(ThreadPool threadPool) {
        super(Settings.EMPTY, threadPool);
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        this.executionCount.incrementAndGet();
        listener.onResponse(null);
    }

    public void initialize(Map<ActionType<? extends ActionResponse>, TransportAction<? extends ActionRequest, ? extends ActionResponse>> actions, TaskManager taskManager, Supplier<String> localNodeId, Transport.Connection localConnection, RemoteClusterService remoteClusterService, NamedWriteableRegistry namedWriteableRegistry) {
        throw new UnsupportedOperationException("cannot initialize " + ((Object)((Object)this)).getClass().getSimpleName());
    }

    public <Request extends ActionRequest, Response extends ActionResponse> Task executeLocally(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        this.executionCount.incrementAndGet();
        listener.onResponse(null);
        return null;
    }

    public String getLocalNodeId() {
        return null;
    }

    public Client getRemoteClusterClient(String clusterAlias, Executor responseExecutor) {
        return null;
    }
}

