/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.compiler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;
import org.elasticsearch.test.PrivilegedOperations;

public class InMemoryJavaCompiler {
    public static Map<String, byte[]> compile(Map<String, CharSequence> sources, String ... options) {
        List<InMemoryJavaFileObject> files = sources.entrySet().stream().map(e -> new InMemoryJavaFileObject((String)e.getKey(), (CharSequence)e.getValue())).toList();
        try (FileManagerWrapper wrapper = new FileManagerWrapper(files);){
            JavaCompiler.CompilationTask task = InMemoryJavaCompiler.getCompilationTask(wrapper, options);
            boolean result = PrivilegedOperations.compilationTaskCall(task);
            if (!result) {
                throw new RuntimeException("Could not compile " + sources.entrySet().stream().toList());
            }
        }
        catch (IOException e2) {
            throw new RuntimeException("Could not close file manager for " + sources.entrySet().stream().toList());
        }
        return files.stream().collect(Collectors.toMap(InMemoryJavaFileObject::getClassName, InMemoryJavaFileObject::getByteCode));
    }

    public static byte[] compile(String className, CharSequence sourceCode, String ... options) {
        InMemoryJavaFileObject file = new InMemoryJavaFileObject(className, sourceCode);
        try (FileManagerWrapper wrapper = new FileManagerWrapper(file);){
            JavaCompiler.CompilationTask task = InMemoryJavaCompiler.getCompilationTask(wrapper, options);
            boolean result = PrivilegedOperations.compilationTaskCall(task);
            if (!result) {
                throw new RuntimeException("Could not compile " + className + " with source code " + sourceCode);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not close file handler for class " + className + " with source code " + sourceCode);
        }
        return file.getByteCode();
    }

    private static JavaCompiler getCompiler() {
        return ToolProvider.getSystemJavaCompiler();
    }

    private static JavaCompiler.CompilationTask getCompilationTask(FileManagerWrapper wrapper, String ... options) {
        return InMemoryJavaCompiler.getCompiler().getTask(null, wrapper, null, List.of(options), null, wrapper.getFiles());
    }

    private static class FileManagerWrapper
    extends ForwardingJavaFileManager<JavaFileManager> {
        private final List<InMemoryJavaFileObject> files;

        FileManagerWrapper(List<InMemoryJavaFileObject> files) {
            super(InMemoryJavaCompiler.getCompiler().getStandardFileManager(null, null, null));
            this.files = List.copyOf(files);
        }

        FileManagerWrapper(InMemoryJavaFileObject file) {
            super(InMemoryJavaCompiler.getCompiler().getStandardFileManager(null, null, null));
            this.files = List.of(file);
        }

        public List<InMemoryJavaFileObject> getFiles() {
            return this.files;
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            return this.files.stream().filter(f -> f.getClassName().endsWith(className)).findFirst().orElseThrow(FileManagerWrapper.newIOException(className, this.files));
        }

        static Supplier<IOException> newIOException(String className, List<InMemoryJavaFileObject> files) {
            return () -> new IOException("Expected class with name " + className + ", in " + files.stream().map(InMemoryJavaFileObject::getClassName).toList());
        }
    }

    private static class InMemoryJavaFileObject
    extends SimpleJavaFileObject {
        private final String className;
        private final CharSequence sourceCode;
        private final ByteArrayOutputStream byteCode;

        InMemoryJavaFileObject(String className, CharSequence sourceCode) {
            super(URI.create("string:///" + className.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.className = className;
            this.sourceCode = sourceCode;
            this.byteCode = new ByteArrayOutputStream();
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.sourceCode;
        }

        @Override
        public OutputStream openOutputStream() {
            return this.byteCode;
        }

        public byte[] getByteCode() {
            return this.byteCode.toByteArray();
        }

        public String getClassName() {
            return this.className;
        }
    }
}

