/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.fixture;

import com.sun.net.httpserver.HttpServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.junit.rules.ExternalResource;

@SuppressForbidden(reason="uses httpserver by design")
public abstract class AbstractHttpFixture
extends ExternalResource {
    protected static final Map<String, String> TEXT_PLAIN_CONTENT_TYPE = AbstractHttpFixture.contentType("text/plain; charset=utf-8");
    protected static final Map<String, String> JSON_CONTENT_TYPE = AbstractHttpFixture.contentType("application/json; charset=utf-8");
    protected static final byte[] EMPTY_BYTE = new byte[0];
    private final AtomicLong requests = new AtomicLong(0L);
    private Path workingDirectory;
    private int port;
    private HttpServer httpServer;

    protected AbstractHttpFixture(String workingDir) {
        this(workingDir, 0);
    }

    protected AbstractHttpFixture(String workingDir, int port) {
        this.port = port;
        this.workingDirectory = PathUtils.get((String)Objects.requireNonNull(workingDir), (String[])new String[0]);
    }

    public AbstractHttpFixture() {
    }

    public final void listen() throws IOException, InterruptedException {
        this.listen(InetAddress.getLoopbackAddress(), true);
    }

    public final void listen(InetAddress inetAddress, boolean exposePidAndPort) throws IOException, InterruptedException {
        InetSocketAddress socketAddress = new InetSocketAddress(inetAddress, this.port);
        this.listenAndWait(socketAddress, exposePidAndPort);
    }

    public final void listenAndWait(InetSocketAddress socketAddress, boolean exposePidAndPort) throws IOException, InterruptedException {
        try {
            this.listen(socketAddress, exposePidAndPort);
            Thread.sleep(Long.MAX_VALUE);
        }
        finally {
            this.stop();
        }
    }

    public final void listen(InetSocketAddress socketAddress, boolean exposePidAndPort) throws IOException, InterruptedException {
        this.httpServer = HttpServer.create(socketAddress, 0);
        if (exposePidAndPort) {
            AbstractHttpFixture.writeFile(this.workingDirectory, "pid", ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
            String addressAndPort = AbstractHttpFixture.addressToString(this.httpServer.getAddress());
            AbstractHttpFixture.writeFile(this.workingDirectory, "ports", addressAndPort);
        }
        this.httpServer.createContext("/", exchange -> {
            try {
                Response response;
                String userAgent = exchange.getRequestHeaders().getFirst("User-Agent");
                if (userAgent != null && userAgent.startsWith("Apache Ant") && "GET".equals(exchange.getRequestMethod()) && "/".equals(exchange.getRequestURI().getPath())) {
                    response = new Response(200, TEXT_PLAIN_CONTENT_TYPE, "OK".getBytes(StandardCharsets.UTF_8));
                } else {
                    try {
                        long requestId = this.requests.getAndIncrement();
                        String method = exchange.getRequestMethod();
                        HashMap<String, String> headers = new HashMap<String, String>();
                        for (Map.Entry<String, List<String>> header : exchange.getRequestHeaders().entrySet()) {
                            headers.put(header.getKey(), exchange.getRequestHeaders().getFirst(header.getKey()));
                        }
                        ByteArrayOutputStream body = new ByteArrayOutputStream();
                        try (InputStream requestBody = exchange.getRequestBody();){
                            int i;
                            byte[] buffer = new byte[1024];
                            while ((i = requestBody.read(buffer, 0, buffer.length)) != -1) {
                                body.write(buffer, 0, i);
                            }
                            body.flush();
                        }
                        Request request = new Request(requestId, method, exchange.getRequestURI(), headers, body.toByteArray());
                        response = this.handle(request);
                    }
                    catch (Exception e) {
                        String error = e.getMessage() != null ? e.getMessage() : "Exception when processing the request";
                        response = new Response(500, Collections.singletonMap("Content-Type", "text/plain; charset=utf-8"), error.getBytes(StandardCharsets.UTF_8));
                    }
                }
                if (response == null) {
                    response = new Response(400, TEXT_PLAIN_CONTENT_TYPE, EMPTY_BYTE);
                }
                response.headers.forEach((k, v) -> exchange.getResponseHeaders().put((String)k, Collections.singletonList(v)));
                if (response.body.length > 0) {
                    exchange.sendResponseHeaders(response.status, response.body.length);
                    exchange.getResponseBody().write(response.body);
                } else {
                    exchange.sendResponseHeaders(response.status, -1L);
                }
            }
            finally {
                exchange.close();
            }
        });
        this.httpServer.start();
    }

    protected abstract Response handle(Request var1) throws IOException;

    protected void stop() {
        if (this.httpServer != null) {
            this.httpServer.stop(0);
        }
    }

    public String getAddress() {
        return "http://127.0.0.1:" + this.httpServer.getAddress().getPort();
    }

    private static void writeFile(Path dir, String fileName, String content) throws IOException {
        Path tempPidFile = Files.createTempFile(dir, null, null, new FileAttribute[0]);
        Files.write(tempPidFile, Collections.singleton(content), new OpenOption[0]);
        Files.move(tempPidFile, dir.resolve(fileName), StandardCopyOption.ATOMIC_MOVE);
    }

    private static String addressToString(SocketAddress address) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
        if (inetSocketAddress.getAddress() instanceof Inet6Address) {
            return "[" + inetSocketAddress.getHostString() + "]:" + inetSocketAddress.getPort();
        }
        return inetSocketAddress.getHostString() + ":" + inetSocketAddress.getPort();
    }

    protected static Map<String, String> contentType(String contentType) {
        return Collections.singletonMap("Content-Type", contentType);
    }

    protected record Response(int status, Map<String, String> headers, byte[] body) {
        public Response(int status, Map<String, String> headers, byte[] body) {
            this.status = status;
            this.headers = Objects.requireNonNull(headers);
            this.body = Objects.requireNonNull(body);
        }

        public String getContentType() {
            for (String header : this.headers.keySet()) {
                if (!header.equalsIgnoreCase("Content-Type")) continue;
                return this.headers.get(header);
            }
            return null;
        }
    }

    protected static class Request {
        private final long id;
        private final String method;
        private final URI uri;
        private final Map<String, String> parameters;
        private final Map<String, String> headers;
        private final byte[] body;

        public Request(long id, String method, URI uri, Map<String, String> headers, byte[] body) {
            this.id = id;
            this.method = Objects.requireNonNull(method);
            this.uri = Objects.requireNonNull(uri);
            this.headers = Objects.requireNonNull(headers);
            this.body = Objects.requireNonNull(body);
            HashMap<String, String> params = new HashMap<String, String>();
            if (uri.getQuery() != null && uri.getQuery().length() > 0) {
                for (String param : uri.getQuery().split("&")) {
                    int i = param.indexOf("=");
                    if (i > 0) {
                        params.put(param.substring(0, i), param.substring(i + 1));
                        continue;
                    }
                    params.put(param, "");
                }
            }
            this.parameters = params;
        }

        public long getId() {
            return this.id;
        }

        public String getMethod() {
            return this.method;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String getHeader(String headerName) {
            for (String header : this.headers.keySet()) {
                if (!header.equalsIgnoreCase(headerName)) continue;
                return this.headers.get(header);
            }
            return null;
        }

        public byte[] getBody() {
            return this.body;
        }

        public String getPath() {
            return this.uri.getRawPath();
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        public String getParam(String paramName) {
            for (String param : this.parameters.keySet()) {
                if (!param.equals(paramName)) continue;
                return this.parameters.get(param);
            }
            return null;
        }

        public String getContentType() {
            return this.getHeader("Content-Type");
        }

        public String toString() {
            return "Request{method='" + this.method + "', uri=" + this.uri + ", parameters=" + this.parameters + ", headers=" + this.headers + ", body=" + this.body + "}";
        }
    }

    @FunctionalInterface
    public static interface RequestHandler {
        public Response handle(Request var1) throws IOException;
    }
}

