/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.elasticsearch.Version;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.core.Strings;
import org.elasticsearch.features.FeatureData;
import org.elasticsearch.features.FeatureSpecification;

class TestFeatureService {
    private final Predicate<String> historicalFeaturesPredicate;
    private final Set<String> clusterStateFeatures;

    TestFeatureService(boolean hasHistoricalFeaturesInformation, List<? extends FeatureSpecification> specs, Collection<Version> nodeVersions, Set<String> clusterStateFeatures) {
        Optional<Version> minNodeVersion = nodeVersions.stream().min(VersionId::compareTo);
        FeatureData featureData = FeatureData.createFromSpecifications(specs);
        NavigableMap historicalFeatures = featureData.getHistoricalFeatures();
        Set allHistoricalFeatures = historicalFeatures.lastEntry() == null ? Set.of() : (Set)historicalFeatures.lastEntry().getValue();
        String errorMessage = hasHistoricalFeaturesInformation ? "Check the feature has been added to the correct FeatureSpecification in the relevant module or, if this is a legacy feature used only in tests, to a test-only FeatureSpecification" : "This test is running on the legacy test framework; historical features from production code will not be available. You need to port the test to the new test plugins in order to use historical features from production code. If this is a legacy feature used only in tests, you can add it to a test-only FeatureSpecification";
        this.historicalFeaturesPredicate = minNodeVersion.map(v -> featureId -> {
            assert (allHistoricalFeatures.contains(featureId)) : Strings.format((String)"Unknown historical feature %s: %s", (Object[])new Object[]{featureId, errorMessage});
            return TestFeatureService.hasHistoricalFeature(historicalFeatures, v, featureId);
        }).orElse(featureId -> {
            assert (allHistoricalFeatures.contains(featureId)) : Strings.format((String)"Unknown historical feature %s: %s", (Object[])new Object[]{featureId, errorMessage});
            return true;
        });
        this.clusterStateFeatures = clusterStateFeatures;
    }

    private static boolean hasHistoricalFeature(NavigableMap<Version, Set<String>> historicalFeatures, Version version, String featureId) {
        Map.Entry<Version, Set<String>> features = historicalFeatures.floorEntry(version);
        return features != null && features.getValue().contains(featureId);
    }

    boolean clusterHasFeature(String featureId) {
        if (this.clusterStateFeatures.contains(featureId)) {
            return true;
        }
        return this.historicalFeaturesPredicate.test(featureId);
    }
}

