/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import com.carrotsearch.randomizedtesting.RandomizedRunner;
import com.carrotsearch.randomizedtesting.RandomizedTest;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.elasticsearch.bootstrap.BootstrapInfo;
import org.elasticsearch.bootstrap.BootstrapSettings;
import org.elasticsearch.bootstrap.ESPolicy;
import org.elasticsearch.bootstrap.Elasticsearch;
import org.elasticsearch.bootstrap.FilePermissionUtils;
import org.elasticsearch.bootstrap.PolicyUtil;
import org.elasticsearch.bootstrap.Security;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.filesystem.FileSystemNatives;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.network.IfConfig;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.jdk.JarHell;
import org.elasticsearch.preallocate.Preallocate;
import org.elasticsearch.secure_sm.SecureSM;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.PrivilegedOperations;
import org.elasticsearch.test.mockito.SecureMockMaker;
import org.junit.Assert;

public class BootstrapForTesting {
    static Map<String, URL> getCodebases() {
        Map codebases = PolicyUtil.getCodebaseJarMap((Set)JarHell.parseClassPath());
        BootstrapForTesting.addClassCodebase(codebases, "elasticsearch", "org.elasticsearch.plugins.PluginsService");
        BootstrapForTesting.addClassCodebase(codebases, "elasticsearch-plugin-classloader", "org.elasticsearch.plugins.loader.ExtendedPluginsClassLoader");
        BootstrapForTesting.addClassCodebase(codebases, "elasticsearch-nio", "org.elasticsearch.nio.ChannelFactory");
        BootstrapForTesting.addClassCodebase(codebases, "elasticsearch-secure-sm", "org.elasticsearch.secure_sm.SecureSM");
        BootstrapForTesting.addClassCodebase(codebases, "elasticsearch-rest-client", "org.elasticsearch.client.RestClient");
        BootstrapForTesting.addClassCodebase(codebases, "elasticsearch-core", "org.elasticsearch.core.Booleans");
        BootstrapForTesting.addClassCodebase(codebases, "elasticsearch-cli", "org.elasticsearch.cli.Command");
        BootstrapForTesting.addClassCodebase(codebases, "elasticsearch-preallocate", "org.elasticsearch.preallocate.Preallocate");
        BootstrapForTesting.addClassCodebase(codebases, "elasticsearch-simdvec", "org.elasticsearch.simdvec.VectorScorerFactory");
        BootstrapForTesting.addClassCodebase(codebases, "framework", "org.elasticsearch.test.ESTestCase");
        return codebases;
    }

    private static void addClassCodebase(Map<String, URL> codebases, String name, String classname) {
        try {
            if (codebases.containsKey(name)) {
                return;
            }
            Class<?> clazz = BootstrapForTesting.class.getClassLoader().loadClass(classname);
            URL location = clazz.getProtectionDomain().getCodeSource().getLocation();
            if (!location.toString().endsWith(".jar") && codebases.put(name, location) != null) {
                throw new IllegalStateException("Already added " + name + " codebase for testing");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @SuppressForbidden(reason="accesses fully qualified URLs to configure security")
    static Map<URL, Policy> getPluginPermissions() throws Exception {
        ArrayList<URL> pluginPolicies = Collections.list(BootstrapForTesting.class.getClassLoader().getResources("plugin-security.policy"));
        if (pluginPolicies.isEmpty()) {
            return Collections.emptyMap();
        }
        HashSet<URL> codebases = new HashSet<URL>(BootstrapForTesting.parseClassPathWithSymlinks());
        HashSet<URL> excluded = new HashSet<URL>(Arrays.asList(Elasticsearch.class.getProtectionDomain().getCodeSource().getLocation(), BootstrapForTesting.class.getProtectionDomain().getCodeSource().getLocation(), LuceneTestCase.class.getProtectionDomain().getCodeSource().getLocation(), RandomizedRunner.class.getProtectionDomain().getCodeSource().getLocation(), Assert.class.getProtectionDomain().getCodeSource().getLocation()));
        codebases.removeAll(excluded);
        HashMap<String, URL> codebasesMap = PolicyUtil.getCodebaseJarMap(codebases);
        final ArrayList<Policy> policies = new ArrayList<Policy>(pluginPolicies.size());
        for (URL policyFile : pluginPolicies) {
            Path policyPath;
            Path codebasesPath;
            HashMap<String, URL> policyCodebases = codebasesMap;
            if (!policyFile.toString().contains(".jar!") && Files.exists(codebasesPath = (policyPath = PathUtils.get((URI)policyFile.toURI())).getParent().resolve("plugin-security.codebases"), new LinkOption[0])) {
                policyCodebases = new HashMap<String, URL>(codebasesMap);
                Map<String, String> codebasesProps = BootstrapForTesting.parsePropertiesFile(codebasesPath);
                for (Map.Entry<String, String> entry : codebasesProps.entrySet()) {
                    BootstrapForTesting.addClassCodebase(policyCodebases, entry.getKey(), entry.getValue());
                }
            }
            policies.add(PolicyUtil.readPolicy((URL)policyFile, (Map)policyCodebases));
        }
        HashMap<URL, 2> map = new HashMap<URL, 2>();
        for (URL url : codebases) {
            map.put(url, new Policy(){

                @Override
                public boolean implies(ProtectionDomain domain, Permission permission) {
                    for (Policy p : policies) {
                        if (!p.implies(domain, permission)) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
        return Collections.unmodifiableMap(map);
    }

    static Map<String, String> parsePropertiesFile(Path propertiesFile) throws Exception {
        Properties props = new Properties();
        try (InputStream is = Files.newInputStream(propertiesFile, new OpenOption[0]);){
            props.load(is);
        }
        return props.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
    }

    @SuppressForbidden(reason="does evil stuff with paths and urls because devs and jenkins do evil stuff with paths and urls")
    static Set<URL> parseClassPathWithSymlinks() throws Exception {
        Set raw = JarHell.parseClassPath();
        HashSet cooked = Sets.newHashSetWithExpectedSize((int)raw.size());
        for (URL url : raw) {
            boolean added;
            Path path = PathUtils.get((URI)url.toURI());
            if (!Files.exists(path, new LinkOption[0]) || (added = cooked.add(path.toRealPath(new LinkOption[0]).toUri().toURL()))) continue;
            throw new IllegalStateException("Duplicate in classpath after resolving symlinks: " + url);
        }
        return raw;
    }

    public static void ensureInitialized() {
    }

    public static Closeable disableTestSecurityManager() {
        StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
        if (!ESTestCase.class.getName().equals(caller.getClassName())) {
            throw new SecurityException("Cannot disable test SecurityManager directly. Use @NoSecurityManager to disable on a test suite");
        }
        SecurityManager sm = System.getSecurityManager();
        AccessController.doPrivileged(() -> {
            Security.setSecurityManager(null);
            return null;
        });
        return () -> AccessController.doPrivileged(() -> {
            Security.setSecurityManager((SecurityManager)sm);
            return null;
        });
    }

    static {
        Path javaTmpDir = PathUtils.get((String)Objects.requireNonNull(System.getProperty("java.io.tmpdir"), "please set ${java.io.tmpdir} in pom.xml"), (String[])new String[0]);
        try {
            Security.ensureDirectoryExists((Path)javaTmpDir);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to create test temp directory", e);
        }
        boolean memoryLock = (Boolean)BootstrapSettings.MEMORY_LOCK_SETTING.get(Settings.EMPTY);
        boolean systemCallFilter = Booleans.parseBoolean((String)System.getProperty("tests.system_call_filter", "true"));
        Elasticsearch.initializeNatives((Path)javaTmpDir, (boolean)memoryLock, (boolean)systemCallFilter, (boolean)true);
        FileSystemNatives.init();
        Elasticsearch.initializeProbes();
        BootstrapInfo.getSystemProperties();
        try {
            Logger logger = LogManager.getLogger(JarHell.class);
            JarHell.checkJarHell(arg_0 -> ((Logger)logger).debug(arg_0));
        }
        catch (Exception e) {
            throw new RuntimeException("found jar hell in test classpath", e);
        }
        SecureMockMaker.init();
        try {
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            lookup.ensureInitialized(PrivilegedOperations.class);
            lookup.ensureInitialized(Preallocate.class);
        }
        catch (IllegalAccessException unexpected) {
            throw new AssertionError((Object)unexpected);
        }
        IfConfig.logIfNecessary();
        if (RandomizedTest.systemPropertyAsBoolean((String)"tests.security.manager", (boolean)true)) {
            try {
                boolean testsCoverage;
                Permissions perms = new Permissions();
                Security.addClasspathPermissions((Permissions)perms);
                FilePermissionUtils.addDirectoryPath((Permissions)perms, (String)"java.io.tmpdir", (Path)javaTmpDir, (String)"read,readlink,write,delete", (boolean)false);
                if (Strings.hasLength((String)System.getProperty("tests.config"))) {
                    FilePermissionUtils.addSingleFilePath((Permissions)perms, (Path)PathUtils.get((String)System.getProperty("tests.config"), (String[])new String[0]), (String)"read,readlink");
                }
                if (testsCoverage = Booleans.parseBoolean((String)System.getProperty("tests.coverage", "false"))) {
                    Path coverageDir = PathUtils.get((String)System.getProperty("tests.coverage.dir"), (String[])new String[0]);
                    FilePermissionUtils.addSingleFilePath((Permissions)perms, (Path)coverageDir.resolve("jacoco.exec"), (String)"read,write");
                    FilePermissionUtils.addSingleFilePath((Permissions)perms, (Path)coverageDir.resolve("jacoco-it.exec"), (String)"read,write");
                }
                if (System.getProperty("tests.gradle") == null) {
                    perms.add(new RuntimePermission("setIO"));
                }
                perms.add(new SocketPermission("localhost:0", "listen,resolve"));
                perms.add(new SocketPermission("localhost:1024-", "listen,resolve"));
                Map<String, URL> codebases = BootstrapForTesting.getCodebases();
                Policy testFramework = PolicyUtil.readPolicy((URL)Elasticsearch.class.getResource("test-framework.policy"), codebases);
                Policy runnerPolicy = System.getProperty("tests.gradle") != null ? PolicyUtil.readPolicy((URL)Elasticsearch.class.getResource("gradle.policy"), codebases) : (codebases.containsKey("junit-rt.jar") ? PolicyUtil.readPolicy((URL)Elasticsearch.class.getResource("intellij.policy"), codebases) : PolicyUtil.readPolicy((URL)Elasticsearch.class.getResource("eclipse.policy"), codebases));
                Permissions fastPathPermissions = new Permissions();
                FilePermissionUtils.addDirectoryPath((Permissions)fastPathPermissions, (String)"java.io.tmpdir-fastpath", (Path)javaTmpDir, (String)"read,readlink,write,delete", (boolean)true);
                ESPolicy esPolicy = new ESPolicy(PolicyUtil.readPolicy((URL)ESPolicy.class.getResource("security.policy"), codebases), (PermissionCollection)perms, BootstrapForTesting.getPluginPermissions(), true, Security.toFilePermissions((Permissions)fastPathPermissions), Map.of());
                Policy.setPolicy(new Policy((Policy)esPolicy, testFramework, runnerPolicy){
                    final /* synthetic */ Policy val$esPolicy;
                    final /* synthetic */ Policy val$testFramework;
                    final /* synthetic */ Policy val$runnerPolicy;
                    {
                        this.val$esPolicy = policy;
                        this.val$testFramework = policy2;
                        this.val$runnerPolicy = policy3;
                    }

                    @Override
                    public boolean implies(ProtectionDomain domain, Permission permission) {
                        return this.val$esPolicy.implies(domain, permission) || this.val$testFramework.implies(domain, permission) || this.val$runnerPolicy.implies(domain, permission);
                    }
                });
                Security.prepopulateSecurityCaller();
                Security.setSecurityManager((SecurityManager)SecureSM.createTestSecureSM());
                Security.selfTest();
                for (URL url : Collections.list(BootstrapForTesting.class.getClassLoader().getResources("plugin-descriptor.properties"))) {
                    Properties properties = new Properties();
                    try (InputStream stream = FileSystemUtils.openFileURLStream((URL)url);){
                        properties.load(stream);
                    }
                    String clazz = properties.getProperty("classname");
                    if (clazz == null) continue;
                    Class.forName(clazz);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("unable to install test security manager", e);
            }
        }
    }
}

