/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.tests.mockfile.FilterFileStore;
import org.apache.lucene.tests.mockfile.FilterFileSystemProvider;
import org.apache.lucene.tests.mockfile.FilterPath;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.PathUtilsForTesting;
import org.elasticsearch.env.Environment;
import org.elasticsearch.monitor.fs.FsService;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.InternalSettingsPlugin;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class DiskUsageIntegTestCase
extends ESIntegTestCase {
    protected static TestFileSystemProvider fileSystemProvider;
    private FileSystem defaultFileSystem;

    @Before
    public void installFilesystemProvider() {
        DiskUsageIntegTestCase.assertNull((Object)this.defaultFileSystem);
        this.defaultFileSystem = PathUtils.getDefaultFileSystem();
        DiskUsageIntegTestCase.assertNull((Object)((Object)fileSystemProvider));
        fileSystemProvider = new TestFileSystemProvider(this.defaultFileSystem, DiskUsageIntegTestCase.createTempDir());
        PathUtilsForTesting.installMock(fileSystemProvider.getFileSystem(null));
    }

    @After
    public void removeFilesystemProvider() {
        fileSystemProvider = null;
        DiskUsageIntegTestCase.assertNotNull((Object)this.defaultFileSystem);
        PathUtilsForTesting.installMock(this.defaultFileSystem);
        this.defaultFileSystem = null;
    }

    @Override
    protected Collection<Class<? extends Plugin>> nodePlugins() {
        return List.of(InternalSettingsPlugin.class);
    }

    @Override
    protected Settings nodeSettings(int nodeOrdinal, Settings otherSettings) {
        Path dataPath = fileSystemProvider.getRootDir().resolve("node-" + nodeOrdinal);
        try {
            Files.createDirectories(dataPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            DiskUsageIntegTestCase.fail(e);
        }
        fileSystemProvider.addTrackedPath(dataPath);
        return Settings.builder().put(super.nodeSettings(nodeOrdinal, otherSettings)).put(Environment.PATH_DATA_SETTING.getKey(), dataPath).put(FsService.ALWAYS_REFRESH_SETTING.getKey(), true).build();
    }

    public TestFileStore getTestFileStore(String nodeName) {
        return fileSystemProvider.getTestFileStore(DiskUsageIntegTestCase.internalCluster().getInstance(Environment.class, nodeName).dataFiles()[0]);
    }

    private static boolean isFileNotFoundException(Exception e) {
        if (e instanceof DirectoryIteratorException) {
            e = ((DirectoryIteratorException)e).getCause();
        }
        return e instanceof NotDirectoryException || e instanceof NoSuchFileException || e instanceof FileNotFoundException;
    }

    private static class TestFileSystemProvider
    extends FilterFileSystemProvider {
        private final Map<Path, TestFileStore> trackedPaths = ConcurrentCollections.newConcurrentMap();
        private final Path rootDir;

        TestFileSystemProvider(FileSystem delegateInstance, Path rootDir) {
            super("diskthreshold://", delegateInstance);
            this.rootDir = new FilterPath(rootDir, this.fileSystem);
        }

        Path getRootDir() {
            return this.rootDir;
        }

        void addTrackedPath(Path path) {
            FileStore fileStore;
            Assert.assertTrue((String)(path + " starts with " + this.rootDir), (boolean)path.startsWith(this.rootDir));
            try {
                fileStore = super.getFileStore(path);
            }
            catch (IOException e) {
                throw new AssertionError("unexpected", e);
            }
            Assert.assertNull((Object)((Object)this.trackedPaths.put(path, new TestFileStore(fileStore, this.getScheme(), path))));
        }

        public FileStore getFileStore(Path path) {
            return this.getTestFileStore(path);
        }

        TestFileStore getTestFileStore(Path path) {
            TestFileStore fileStore = this.trackedPaths.get(path);
            if (fileStore != null) {
                return fileStore;
            }
            Assert.assertTrue((String)(path + " not tracked and not translog"), (boolean)path.getFileName().toString().equals("translog"));
            Set containingPaths = this.trackedPaths.keySet().stream().filter(path::startsWith).collect(Collectors.toSet());
            ESTestCase.assertThat(path + " not contained in a unique tracked path", containingPaths, Matchers.hasSize((int)1));
            return this.trackedPaths.get(containingPaths.iterator().next());
        }
    }

    protected static class TestFileStore
    extends FilterFileStore {
        private final Path path;
        private volatile long totalSpace = -1L;

        TestFileStore(FileStore delegate, String scheme, Path path) {
            super(delegate, scheme);
            this.path = path;
        }

        public String name() {
            return "fake";
        }

        public long getTotalSpace() throws IOException {
            long totalSpaceCopy = this.totalSpace;
            if (totalSpaceCopy == -1L) {
                return super.getTotalSpace();
            }
            return totalSpaceCopy;
        }

        public void setTotalSpace(long totalSpace) {
            ESTestCase.assertThat(totalSpace, Matchers.anyOf((Matcher)Matchers.is((Object)-1L), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L))));
            this.totalSpace = totalSpace;
        }

        public long getUsableSpace() throws IOException {
            long totalSpaceCopy = this.totalSpace;
            if (totalSpaceCopy == -1L) {
                return super.getUsableSpace();
            }
            return Math.max(0L, totalSpaceCopy - TestFileStore.getTotalFileSize(this.path));
        }

        public long getUnallocatedSpace() throws IOException {
            long totalSpaceCopy = this.totalSpace;
            if (totalSpaceCopy == -1L) {
                return super.getUnallocatedSpace();
            }
            return Math.max(0L, totalSpaceCopy - TestFileStore.getTotalFileSize(this.path));
        }

        private static long getTotalFileSize(Path path) throws IOException {
            long l;
            block15: {
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    if (path.getFileName().toString().equals("nodes") && Files.readString(path, StandardCharsets.UTF_8).contains("prevent a downgrade")) {
                        return 0L;
                    }
                    try {
                        return Files.size(path);
                    }
                    catch (FileNotFoundException | AccessDeniedException | NoSuchFileException e) {
                        return 0L;
                    }
                }
                if (path.getFileName().toString().equals("_state") || path.getFileName().toString().equals("translog")) {
                    return 0L;
                }
                DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);
                try {
                    long total = 0L;
                    for (Path subpath : directoryStream) {
                        total += TestFileStore.getTotalFileSize(subpath);
                    }
                    l = total;
                    if (directoryStream == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (directoryStream != null) {
                            try {
                                directoryStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | DirectoryIteratorException e) {
                        if (DiskUsageIntegTestCase.isFileNotFoundException(e) || e instanceof AccessDeniedException) {
                            return 0L;
                        }
                        throw e;
                    }
                }
                directoryStream.close();
            }
            return l;
        }
    }
}

