/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.util.stream.IntStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.bytes.AbstractBytesReference;
import org.elasticsearch.common.bytes.BytesReference;

public class ZeroBytesReference
extends AbstractBytesReference {
    public ZeroBytesReference(int length) {
        super(length);
        assert (0 <= length) : length;
    }

    public int indexOf(byte marker, int from) {
        assert (0 <= from && from <= this.length) : from + " vs " + this.length;
        if (marker == 0 && from < this.length) {
            return from;
        }
        return -1;
    }

    public byte get(int index) {
        assert (0 <= index && index < this.length) : index + " vs " + this.length;
        return 0;
    }

    public BytesReference slice(int from, int length) {
        assert (from + length <= this.length) : from + " and " + length + " vs " + this.length;
        return new ZeroBytesReference(length);
    }

    public long ramBytesUsed() {
        return 0L;
    }

    public BytesRef toBytesRef() {
        return new BytesRef(new byte[this.length], 0, this.length);
    }

    public BytesRefIterator iterator() {
        final byte[] buffer = new byte[Math.min(this.length, 16384)];
        return new BytesRefIterator(){
            int remaining;
            {
                this.remaining = ZeroBytesReference.this.length;
            }

            public BytesRef next() {
                if (IntStream.range(0, buffer.length).map(i -> buffer[i]).anyMatch(b -> b != 0)) {
                    throw new AssertionError((Object)"Internal pages from ZeroBytesReference must be zero");
                }
                if (this.remaining > 0) {
                    int nextLength = Math.min(this.remaining, buffer.length);
                    this.remaining -= nextLength;
                    return new BytesRef(buffer, 0, nextLength);
                }
                return null;
            }
        };
    }
}

