/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.ChunkedLoggingStream;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.test.ESTestCase;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class ChunkedLoggingStreamTestUtils {
    private ChunkedLoggingStreamTestUtils() {
    }

    /*
     * Exception decompiling
     */
    public static BytesReference getDecodedLoggedBody(Logger captureLogger, Level level, String prefix, ReferenceDocs referenceDocs, CheckedRunnable<Exception> runnable) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getLoggedBody(final Logger captureLogger, final Level level, final String prefix, final ReferenceDocs referenceDocs, CheckedRunnable<Exception> runnable) {
        class ChunkReadingAppender
        extends AbstractAppender {
            final StringBuilder encodedResponseBuilder;
            int chunks;
            boolean seenTotal;

            ChunkReadingAppender() {
                super("mock", null, null, false, Property.EMPTY_ARRAY);
                this.encodedResponseBuilder = new StringBuilder();
            }

            public void append(LogEvent event) {
                if (event.getLevel() != level) {
                    return;
                }
                if (!event.getLoggerName().equals(captureLogger.getName())) {
                    return;
                }
                Assert.assertFalse((boolean)this.seenTotal);
                String message = event.getMessage().getFormattedMessage();
                String onePartPrefix = prefix + " (gzip compressed and base64-encoded; for details see " + referenceDocs + "): ";
                String partPrefix = prefix + " [part " + (this.chunks + 1) + "]: ";
                if (message.startsWith(partPrefix)) {
                    ++this.chunks;
                    String chunk = message.substring(partPrefix.length());
                    ESTestCase.assertThat(chunk.length(), Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(ChunkedLoggingStream.CHUNK_SIZE)));
                    this.encodedResponseBuilder.append(chunk);
                } else if (message.startsWith(onePartPrefix)) {
                    Assert.assertEquals((long)0L, (long)this.chunks);
                    ++this.chunks;
                    String chunk = message.substring(onePartPrefix.length());
                    ESTestCase.assertThat(chunk.length(), Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(ChunkedLoggingStream.CHUNK_SIZE)));
                    this.encodedResponseBuilder.append(chunk);
                    this.seenTotal = true;
                } else {
                    Assert.assertEquals((Object)(prefix + " (gzip compressed, base64-encoded, and split into " + this.chunks + " parts on preceding log lines; for details see " + referenceDocs + ")"), (Object)message);
                    ESTestCase.assertThat(this.chunks, Matchers.greaterThan((Comparable)Integer.valueOf(1)));
                    this.seenTotal = true;
                }
            }
        }
        ChunkReadingAppender appender = new ChunkReadingAppender();
        try {
            appender.start();
            Loggers.addAppender((Logger)captureLogger, (Appender)appender);
            runnable.run();
        }
        catch (Exception e) {
            ESTestCase.fail(e);
        }
        finally {
            Loggers.removeAppender((Logger)captureLogger, (Appender)appender);
            appender.stop();
        }
        ESTestCase.assertThat(appender.chunks, Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assert.assertTrue((boolean)appender.seenTotal);
        return appender.encodedResponseBuilder.toString();
    }
}

