/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.MockInternalClusterInfoService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.MockBigArrays;
import org.elasticsearch.common.util.MockPageCacheRecycler;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.env.Environment;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.indices.ExecutorSelector;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.node.InternalSettingsPreparer;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeConstruction;
import org.elasticsearch.node.NodeMocksPlugin;
import org.elasticsearch.node.NodeServiceProvider;
import org.elasticsearch.node.RecoverySettingsChunkSizePlugin;
import org.elasticsearch.node.ResponseCollectorService;
import org.elasticsearch.plugins.MockPluginsService;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.readiness.MockReadinessService;
import org.elasticsearch.readiness.ReadinessService;
import org.elasticsearch.script.MockScriptService;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.MockSearchService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.rank.feature.RankFeatureShardPhase;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.telemetry.tracing.Tracer;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.MockHttpTransport;
import org.elasticsearch.test.transport.MockTransportService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.TransportSettings;

public class MockNode
extends Node {
    private final Collection<Class<? extends Plugin>> classpathPlugins;

    public MockNode(Settings settings, Collection<Class<? extends Plugin>> classpathPlugins) {
        this(settings, classpathPlugins, true);
    }

    public MockNode(Settings settings, Collection<Class<? extends Plugin>> classpathPlugins, boolean forbidPrivateIndexSettings) {
        this(settings, classpathPlugins, null, forbidPrivateIndexSettings);
    }

    public MockNode(Settings settings, Collection<Class<? extends Plugin>> classpathPlugins, Path configPath, boolean forbidPrivateIndexSettings) {
        this(InternalSettingsPreparer.prepareEnvironment((Settings)Settings.builder().put(TransportSettings.PORT.getKey(), ESTestCase.getPortRange()).put(settings).build(), Collections.emptyMap(), (Path)configPath, () -> "mock_ node"), classpathPlugins, forbidPrivateIndexSettings);
    }

    private MockNode(Environment environment, final Collection<Class<? extends Plugin>> classpathPlugins, boolean forbidPrivateIndexSettings) {
        super(NodeConstruction.prepareConstruction((Environment)environment, (NodeServiceProvider)new MockServiceProvider(){

            PluginsService newPluginService(Environment environment, Settings settings) {
                return new MockPluginsService(settings, environment, classpathPlugins);
            }
        }, (boolean)forbidPrivateIndexSettings));
        this.classpathPlugins = classpathPlugins;
    }

    public Collection<Class<? extends Plugin>> getClasspathPlugins() {
        return this.classpathPlugins;
    }

    protected void configureNodeAndClusterIdStateListener(ClusterService clusterService) {
    }

    public NamedWriteableRegistry getNamedWriteableRegistry() {
        return this.namedWriteableRegistry;
    }

    private static class MockServiceProvider
    extends NodeServiceProvider {
        private MockServiceProvider() {
        }

        BigArrays newBigArrays(PluginsService pluginsService, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService) {
            if (pluginsService.filterPlugins(NodeMocksPlugin.class).findAny().isEmpty()) {
                return super.newBigArrays(pluginsService, pageCacheRecycler, circuitBreakerService);
            }
            return new MockBigArrays(pageCacheRecycler, circuitBreakerService);
        }

        PageCacheRecycler newPageCacheRecycler(PluginsService pluginsService, Settings settings) {
            if (pluginsService.filterPlugins(NodeMocksPlugin.class).findAny().isEmpty()) {
                return super.newPageCacheRecycler(pluginsService, settings);
            }
            return new MockPageCacheRecycler(settings);
        }

        SearchService newSearchService(PluginsService pluginsService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ScriptService scriptService, BigArrays bigArrays, RankFeatureShardPhase rankFeatureShardPhase, FetchPhase fetchPhase, ResponseCollectorService responseCollectorService, CircuitBreakerService circuitBreakerService, ExecutorSelector executorSelector, Tracer tracer) {
            if (pluginsService.filterPlugins(MockSearchService.TestPlugin.class).findAny().isEmpty()) {
                return super.newSearchService(pluginsService, clusterService, indicesService, threadPool, scriptService, bigArrays, rankFeatureShardPhase, fetchPhase, responseCollectorService, circuitBreakerService, executorSelector, tracer);
            }
            return new MockSearchService(clusterService, indicesService, threadPool, scriptService, bigArrays, rankFeatureShardPhase, fetchPhase, responseCollectorService, circuitBreakerService, executorSelector, tracer);
        }

        ScriptService newScriptService(PluginsService pluginsService, Settings settings, Map<String, ScriptEngine> engines, Map<String, ScriptContext<?>> contexts, LongSupplier timeProvider) {
            if (pluginsService.filterPlugins(MockScriptService.TestPlugin.class).findAny().isEmpty()) {
                return super.newScriptService(pluginsService, settings, engines, contexts, timeProvider);
            }
            return new MockScriptService(settings, engines, contexts);
        }

        ReadinessService newReadinessService(PluginsService pluginsService, ClusterService clusterService, Environment environment) {
            if (pluginsService.filterPlugins(MockReadinessService.TestPlugin.class).findAny().isEmpty()) {
                return super.newReadinessService(pluginsService, clusterService, environment);
            }
            return new MockReadinessService(clusterService, environment);
        }

        protected TransportService newTransportService(PluginsService pluginsService, Settings settings, Transport transport, ThreadPool threadPool, TransportInterceptor interceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, ClusterSettings clusterSettings, TaskManager taskManager, Tracer tracer) {
            if (pluginsService.filterPlugins(MockTransportService.TestPlugin.class).findAny().isEmpty()) {
                return super.newTransportService(pluginsService, settings, transport, threadPool, interceptor, localNodeFactory, clusterSettings, taskManager, tracer);
            }
            return new MockTransportService(settings, transport, threadPool, interceptor, localNodeFactory, clusterSettings, taskManager.getTaskHeaders());
        }

        void processRecoverySettings(PluginsService pluginsService, ClusterSettings clusterSettings, RecoverySettings recoverySettings) {
            if (!pluginsService.filterPlugins(RecoverySettingsChunkSizePlugin.class).findAny().isEmpty()) {
                clusterSettings.addSettingsUpdateConsumer(RecoverySettingsChunkSizePlugin.CHUNK_SIZE_SETTING, arg_0 -> ((RecoverySettings)recoverySettings).setChunkSize(arg_0));
            }
        }

        protected ClusterInfoService newClusterInfoService(PluginsService pluginsService, Settings settings, ClusterService clusterService, ThreadPool threadPool, NodeClient client) {
            if (pluginsService.filterPlugins(MockInternalClusterInfoService.TestPlugin.class).findAny().isEmpty()) {
                return super.newClusterInfoService(pluginsService, settings, clusterService, threadPool, client);
            }
            MockInternalClusterInfoService service = new MockInternalClusterInfoService(settings, clusterService, threadPool, client);
            clusterService.addListener((ClusterStateListener)service);
            return service;
        }

        protected HttpServerTransport newHttpTransport(PluginsService pluginsService, NetworkModule networkModule) {
            if (pluginsService.filterPlugins(MockHttpTransport.TestPlugin.class).findAny().isEmpty()) {
                return super.newHttpTransport(pluginsService, networkModule);
            }
            return new MockHttpTransport();
        }
    }
}

