/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.admin.cluster.repositories.cleanup.CleanupRepositoryResponse;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.support.BlobMetadata;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Streams;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.repositories.blobstore.BlobStoreTestUtil;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.test.ESSingleNodeTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class AbstractThirdPartyRepositoryTestCase
extends ESSingleNodeTestCase {
    protected final String TEST_REPO_NAME = "test-repo";

    @Override
    protected Settings nodeSettings() {
        return Settings.builder().put(super.nodeSettings()).setSecureSettings(this.credentials()).build();
    }

    protected abstract SecureSettings credentials();

    protected abstract void createRepository(String var1);

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createRepository("test-repo");
        this.deleteAndAssertEmpty(this.getRepository().basePath());
    }

    @Override
    public void tearDown() throws Exception {
        this.deleteAndAssertEmpty(this.getRepository().basePath());
        this.clusterAdmin().prepareDeleteRepository(TEST_REQUEST_TIMEOUT, TEST_REQUEST_TIMEOUT, "test-repo").get();
        super.tearDown();
    }

    private void deleteAndAssertEmpty(BlobPath path) {
        BlobStoreRepository repo = this.getRepository();
        PlainActionFuture future = new PlainActionFuture();
        repo.threadPool().generic().execute((Runnable)ActionRunnable.run((ActionListener)future, () -> repo.blobStore().blobContainer(path).delete(BlobStoreTestUtil.randomPurpose())));
        future.actionGet();
        BlobPath parent = path.parent();
        if (parent == null) {
            this.assertChildren(path, Collections.emptyList());
        } else {
            AbstractThirdPartyRepositoryTestCase.assertThat(this.listChildren(parent), Matchers.not((Matcher)Matchers.contains((Object[])new String[]{(String)path.parts().get(path.parts().size() - 1)})));
        }
    }

    public void testCreateSnapshot() {
        this.createIndex("test-idx-1");
        this.createIndex("test-idx-2");
        this.createIndex("test-idx-3");
        this.ensureGreen(new String[0]);
        this.logger.info("--> indexing some data");
        for (int i = 0; i < 100; ++i) {
            this.prepareIndex("test-idx-1").setId(Integer.toString(i)).setSource(new Object[]{"foo", "bar" + i}).get();
            this.prepareIndex("test-idx-2").setId(Integer.toString(i)).setSource(new Object[]{"foo", "bar" + i}).get();
            this.prepareIndex("test-idx-3").setId(Integer.toString(i)).setSource(new Object[]{"foo", "bar" + i}).get();
        }
        this.client().admin().indices().prepareRefresh(new String[0]).get();
        String snapshotName = "test-snap-" + System.currentTimeMillis();
        this.logger.info("--> snapshot");
        CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)this.clusterAdmin().prepareCreateSnapshot(TEST_REQUEST_TIMEOUT, "test-repo", snapshotName).setWaitForCompletion(true).setIndices(new String[]{"test-idx-*", "-test-idx-3"}).get();
        AbstractThirdPartyRepositoryTestCase.assertThat(createSnapshotResponse.getSnapshotInfo().successfulShards(), Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        AbstractThirdPartyRepositoryTestCase.assertThat(createSnapshotResponse.getSnapshotInfo().successfulShards(), Matchers.equalTo((Object)createSnapshotResponse.getSnapshotInfo().totalShards()));
        AbstractThirdPartyRepositoryTestCase.assertThat(((SnapshotInfo)((GetSnapshotsResponse)this.clusterAdmin().prepareGetSnapshots(TEST_REQUEST_TIMEOUT, new String[]{"test-repo"}).setSnapshots(new String[]{snapshotName}).get()).getSnapshots().get(0)).state(), Matchers.equalTo((Object)SnapshotState.SUCCESS));
        AbstractThirdPartyRepositoryTestCase.assertTrue((boolean)((AcknowledgedResponse)this.clusterAdmin().prepareDeleteSnapshot(TEST_REQUEST_TIMEOUT, "test-repo", new String[]{snapshotName}).get()).isAcknowledged());
    }

    public void testListChildren() {
        BlobStoreRepository repo = this.getRepository();
        PlainActionFuture future = new PlainActionFuture();
        ExecutorService genericExec = repo.threadPool().generic();
        int testBlobLen = AbstractThirdPartyRepositoryTestCase.randomIntBetween(1, 100);
        genericExec.execute((Runnable)ActionRunnable.run((ActionListener)future, () -> {
            BlobStore blobStore = repo.blobStore();
            blobStore.blobContainer(repo.basePath().add("foo")).writeBlob(BlobStoreTestUtil.randomPurpose(), "nested-blob", (InputStream)new ByteArrayInputStream(AbstractThirdPartyRepositoryTestCase.randomByteArrayOfLength(testBlobLen)), (long)testBlobLen, false);
            blobStore.blobContainer(repo.basePath().add("foo").add("nested")).writeBlob(BlobStoreTestUtil.randomPurpose(), "bar", (InputStream)new ByteArrayInputStream(AbstractThirdPartyRepositoryTestCase.randomByteArrayOfLength(testBlobLen)), (long)testBlobLen, false);
            blobStore.blobContainer(repo.basePath().add("foo").add("nested2")).writeBlob(BlobStoreTestUtil.randomPurpose(), "blub", (InputStream)new ByteArrayInputStream(AbstractThirdPartyRepositoryTestCase.randomByteArrayOfLength(testBlobLen)), (long)testBlobLen, false);
        }));
        future.actionGet();
        this.assertChildren(repo.basePath(), Collections.singleton("foo"));
        BlobStoreTestUtil.assertBlobsByPrefix(repo, repo.basePath(), "fo", Collections.emptyMap());
        this.assertChildren(repo.basePath().add("foo"), List.of("nested", "nested2"));
        BlobStoreTestUtil.assertBlobsByPrefix(repo, repo.basePath().add("foo"), "nest", Collections.singletonMap("nested-blob", new BlobMetadata("nested-blob", (long)testBlobLen)));
        this.assertChildren(repo.basePath().add("foo").add("nested"), Collections.emptyList());
        if (AbstractThirdPartyRepositoryTestCase.randomBoolean()) {
            this.deleteAndAssertEmpty(repo.basePath());
        } else {
            this.deleteAndAssertEmpty(repo.basePath().add("foo"));
        }
    }

    public void testCleanup() throws Exception {
        this.createIndex("test-idx-1");
        this.createIndex("test-idx-2");
        this.createIndex("test-idx-3");
        this.ensureGreen(new String[0]);
        this.logger.info("--> indexing some data");
        for (int i = 0; i < 100; ++i) {
            this.prepareIndex("test-idx-1").setId(Integer.toString(i)).setSource(new Object[]{"foo", "bar" + i}).get();
            this.prepareIndex("test-idx-2").setId(Integer.toString(i)).setSource(new Object[]{"foo", "bar" + i}).get();
            this.prepareIndex("test-idx-3").setId(Integer.toString(i)).setSource(new Object[]{"foo", "bar" + i}).get();
        }
        this.client().admin().indices().prepareRefresh(new String[0]).get();
        String snapshotName = "test-snap-" + System.currentTimeMillis();
        this.logger.info("--> snapshot");
        CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)this.clusterAdmin().prepareCreateSnapshot(TEST_REQUEST_TIMEOUT, "test-repo", snapshotName).setWaitForCompletion(true).setIndices(new String[]{"test-idx-*", "-test-idx-3"}).get();
        AbstractThirdPartyRepositoryTestCase.assertThat(createSnapshotResponse.getSnapshotInfo().successfulShards(), Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        AbstractThirdPartyRepositoryTestCase.assertThat(createSnapshotResponse.getSnapshotInfo().successfulShards(), Matchers.equalTo((Object)createSnapshotResponse.getSnapshotInfo().totalShards()));
        AbstractThirdPartyRepositoryTestCase.assertThat(((SnapshotInfo)((GetSnapshotsResponse)this.clusterAdmin().prepareGetSnapshots(TEST_REQUEST_TIMEOUT, new String[]{"test-repo"}).setSnapshots(new String[]{snapshotName}).get()).getSnapshots().get(0)).state(), Matchers.equalTo((Object)SnapshotState.SUCCESS));
        BlobStoreRepository repo = (BlobStoreRepository)this.getInstanceFromNode(RepositoriesService.class).repository("test-repo");
        ExecutorService genericExec = repo.threadPool().executor("generic");
        this.logger.info("--> creating a dangling index folder");
        AbstractThirdPartyRepositoryTestCase.createDanglingIndex(repo, genericExec);
        this.logger.info("--> deleting a snapshot to trigger repository cleanup");
        this.clusterAdmin().prepareDeleteSnapshot(TEST_REQUEST_TIMEOUT, "test-repo", new String[]{snapshotName}).get();
        BlobStoreTestUtil.assertConsistency(repo);
        this.logger.info("--> Create dangling index");
        AbstractThirdPartyRepositoryTestCase.createDanglingIndex(repo, genericExec);
        this.logger.info("--> Execute repository cleanup");
        CleanupRepositoryResponse response = (CleanupRepositoryResponse)this.clusterAdmin().prepareCleanupRepository(TEST_REQUEST_TIMEOUT, TEST_REQUEST_TIMEOUT, "test-repo").get();
        this.assertCleanupResponse(response, 3L, 1L);
    }

    public void testIndexLatest() throws Exception {
        this.createIndex("test-idx-1");
        for (int i = 0; i < 100; ++i) {
            this.client().prepareIndex("test-idx-1").setId(Integer.toString(i)).setSource(new Object[]{"foo", "bar" + i}).get();
        }
        BlobStoreRepository repository = this.getRepository();
        HashSet<BytesReference> blobContents = new HashSet<BytesReference>();
        CreateSnapshotResponse createSnapshot1Response = (CreateSnapshotResponse)this.clusterAdmin().prepareCreateSnapshot(TEST_REQUEST_TIMEOUT, "test-repo", AbstractThirdPartyRepositoryTestCase.randomIdentifier()).setWaitForCompletion(true).get();
        AbstractThirdPartyRepositoryTestCase.assertTrue((boolean)blobContents.add(AbstractThirdPartyRepositoryTestCase.readIndexLatest(repository)));
        this.clusterAdmin().prepareGetSnapshots(TEST_REQUEST_TIMEOUT, new String[]{"test-repo"}).get();
        AbstractThirdPartyRepositoryTestCase.assertFalse((boolean)blobContents.add(AbstractThirdPartyRepositoryTestCase.readIndexLatest(repository)));
        CreateSnapshotResponse createSnapshot2Response = (CreateSnapshotResponse)this.clusterAdmin().prepareCreateSnapshot(TEST_REQUEST_TIMEOUT, "test-repo", AbstractThirdPartyRepositoryTestCase.randomIdentifier()).setWaitForCompletion(true).get();
        AbstractThirdPartyRepositoryTestCase.assertTrue((boolean)blobContents.add(AbstractThirdPartyRepositoryTestCase.readIndexLatest(repository)));
        ElasticsearchAssertions.assertAcked(this.clusterAdmin().prepareDeleteSnapshot(TEST_REQUEST_TIMEOUT, "test-repo", new String[]{createSnapshot1Response.getSnapshotInfo().snapshotId().getName()}));
        AbstractThirdPartyRepositoryTestCase.assertTrue((boolean)blobContents.add(AbstractThirdPartyRepositoryTestCase.readIndexLatest(repository)));
        ElasticsearchAssertions.assertAcked(this.clusterAdmin().prepareDeleteSnapshot(TEST_REQUEST_TIMEOUT, "test-repo", new String[]{createSnapshot2Response.getSnapshotInfo().snapshotId().getName()}));
        AbstractThirdPartyRepositoryTestCase.assertTrue((boolean)blobContents.add(AbstractThirdPartyRepositoryTestCase.readIndexLatest(repository)));
    }

    public void testReadFromPositionWithLength() {
        String blobName = AbstractThirdPartyRepositoryTestCase.randomIdentifier();
        BytesReference blobBytes = AbstractThirdPartyRepositoryTestCase.randomBytesReference(AbstractThirdPartyRepositoryTestCase.randomIntBetween(100, 2000));
        BlobStoreRepository repository = this.getRepository();
        AbstractThirdPartyRepositoryTestCase.executeOnBlobStore(repository, blobStore -> {
            blobStore.writeBlob(BlobStoreTestUtil.randomPurpose(), blobName, blobBytes, true);
            return null;
        });
        AbstractThirdPartyRepositoryTestCase.assertThat("Exact Range", AbstractThirdPartyRepositoryTestCase.readBlob(repository, blobName, 0L, blobBytes.length()), Matchers.equalTo((Object)blobBytes));
        int position = AbstractThirdPartyRepositoryTestCase.randomIntBetween(0, blobBytes.length() - 1);
        int length = AbstractThirdPartyRepositoryTestCase.randomIntBetween(1, blobBytes.length() - position);
        AbstractThirdPartyRepositoryTestCase.assertThat("Random Range: " + position + "-" + (position + length), AbstractThirdPartyRepositoryTestCase.readBlob(repository, blobName, position, length), Matchers.equalTo((Object)blobBytes.slice(position, length)));
        position = AbstractThirdPartyRepositoryTestCase.randomIntBetween(0, blobBytes.length() - 1);
        long length2 = AbstractThirdPartyRepositoryTestCase.randomLongBetween(1L, Long.MAX_VALUE - (long)position - 1L);
        AbstractThirdPartyRepositoryTestCase.assertThat("Random Larger Range: " + position + "-" + ((long)position + length2), AbstractThirdPartyRepositoryTestCase.readBlob(repository, blobName, position, length2), Matchers.equalTo((Object)blobBytes.slice(position, Math.toIntExact(Math.min(length2, (long)(blobBytes.length() - position))))));
    }

    protected static <T> T executeOnBlobStore(BlobStoreRepository repository, CheckedFunction<BlobContainer, T, IOException> fn) {
        PlainActionFuture future = new PlainActionFuture();
        repository.threadPool().generic().execute((Runnable)ActionRunnable.supply((ActionListener)future, () -> {
            BlobContainer blobContainer = repository.blobStore().blobContainer(repository.basePath());
            return fn.apply((Object)blobContainer);
        }));
        return (T)future.actionGet();
    }

    protected static BytesReference readBlob(BlobStoreRepository repository, String blobName, long position, long length) {
        return (BytesReference)AbstractThirdPartyRepositoryTestCase.executeOnBlobStore(repository, blobContainer -> {
            try (InputStream input = blobContainer.readBlob(BlobStoreTestUtil.randomPurpose(), blobName, position, length);){
                BytesReference bytesReference;
                try (BytesStreamOutput output = new BytesStreamOutput();){
                    Streams.copy((InputStream)input, (OutputStream)output);
                    bytesReference = output.bytes();
                }
                return bytesReference;
            }
        });
    }

    private static BytesReference readIndexLatest(BlobStoreRepository repository) throws IOException {
        try (BytesStreamOutput baos = new BytesStreamOutput();){
            Streams.copy((InputStream)repository.blobStore().blobContainer(repository.basePath()).readBlob(BlobStoreTestUtil.randomPurpose(), "index.latest"), (OutputStream)baos);
            BytesReference bytesReference = baos.bytes();
            return bytesReference;
        }
    }

    protected void assertCleanupResponse(CleanupRepositoryResponse response, long bytes, long blobs) {
        AbstractThirdPartyRepositoryTestCase.assertThat(response.result().blobs(), Matchers.equalTo((Object)3L));
        AbstractThirdPartyRepositoryTestCase.assertThat(response.result().bytes(), Matchers.equalTo((Object)9L));
    }

    private static void createDanglingIndex(BlobStoreRepository repo, Executor genericExec) throws Exception {
        PlainActionFuture future = new PlainActionFuture();
        genericExec.execute((Runnable)ActionRunnable.run((ActionListener)future, () -> {
            BlobStore blobStore = repo.blobStore();
            blobStore.blobContainer(repo.basePath().add("indices").add("foo")).writeBlob(BlobStoreTestUtil.randomPurpose(), "bar", (InputStream)new ByteArrayInputStream(new byte[3]), 3L, false);
            for (String prefix : Arrays.asList("snap-", "meta-")) {
                blobStore.blobContainer(repo.basePath()).writeBlob(BlobStoreTestUtil.randomNonDataPurpose(), prefix + "foo.dat", (InputStream)new ByteArrayInputStream(new byte[3]), 3L, false);
            }
        }));
        future.get();
        PlainActionFuture corruptionFuture = new PlainActionFuture();
        genericExec.execute((Runnable)ActionRunnable.supply((ActionListener)corruptionFuture, () -> {
            BlobStore blobStore = repo.blobStore();
            return blobStore.blobContainer(repo.basePath().add("indices")).children(BlobStoreTestUtil.randomPurpose()).containsKey("foo") && blobStore.blobContainer(repo.basePath().add("indices").add("foo")).blobExists(BlobStoreTestUtil.randomPurpose(), "bar") && blobStore.blobContainer(repo.basePath()).blobExists(BlobStoreTestUtil.randomNonDataPurpose(), "meta-foo.dat") && blobStore.blobContainer(repo.basePath()).blobExists(BlobStoreTestUtil.randomNonDataPurpose(), "snap-foo.dat");
        }));
        AbstractThirdPartyRepositoryTestCase.assertTrue((boolean)((Boolean)corruptionFuture.get()));
    }

    private void assertChildren(BlobPath path, Collection<String> children) {
        this.listChildren(path);
        Set<String> foundChildren = this.listChildren(path);
        if (children.isEmpty()) {
            AbstractThirdPartyRepositoryTestCase.assertThat(foundChildren, Matchers.empty());
        } else {
            AbstractThirdPartyRepositoryTestCase.assertThat(foundChildren, Matchers.containsInAnyOrder((Object[])children.toArray(Strings.EMPTY_ARRAY)));
        }
    }

    private Set<String> listChildren(BlobPath path) {
        PlainActionFuture future = new PlainActionFuture();
        BlobStoreRepository repository = this.getRepository();
        repository.threadPool().generic().execute((Runnable)ActionRunnable.supply((ActionListener)future, () -> repository.blobStore().blobContainer(path).children(BlobStoreTestUtil.randomPurpose()).keySet()));
        return (Set)future.actionGet();
    }

    protected BlobStoreRepository getRepository() {
        return (BlobStoreRepository)this.getInstanceFromNode(RepositoriesService.class).repository("test-repo");
    }
}

