/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.util.SameThreadExecutorService;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeUtils;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterApplierService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.blobstore.support.BlobMetadata;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshots;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public final class BlobStoreTestUtil {
    public static void assertConsistency(BlobStoreRepository repository) {
        PlainActionFuture<AssertionError> listener = BlobStoreTestUtil.assertConsistencyAsync(repository);
        AssertionError err = (AssertionError)listener.actionGet(TimeValue.timeValueMinutes((long)1L));
        if (err != null) {
            throw new AssertionError(err);
        }
    }

    public static PlainActionFuture<AssertionError> assertConsistencyAsync(BlobStoreRepository repository) {
        PlainActionFuture future = new PlainActionFuture();
        repository.threadPool().generic().execute((Runnable)ActionRunnable.wrap((ActionListener)future, listener -> {
            try {
                RepositoryData repositoryData;
                long latestGen;
                final BlobContainer blobContainer = repository.blobContainer();
                try (DataInputStream inputStream = new DataInputStream(blobContainer.readBlob(BlobStoreTestUtil.randomNonDataPurpose(), "index.latest"));){
                    latestGen = inputStream.readLong();
                }
                catch (NoSuchFileException e) {
                    throw new AssertionError((Object)("Could not find index.latest blob for repo [" + repository + "]"));
                }
                BlobStoreTestUtil.assertIndexGenerations(blobContainer, latestGen);
                try (InputStream blob = blobContainer.readBlob(BlobStoreTestUtil.randomNonDataPurpose(), "index-" + latestGen);
                     XContentParser parser = XContentType.JSON.xContent().createParser(XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), blob);){
                    repositoryData = RepositoryData.snapshotsFromXContent((XContentParser)parser, (long)latestGen, (boolean)false);
                }
                BlobStoreTestUtil.assertIndexUUIDs(repository, repositoryData);
                BlobStoreTestUtil.assertSnapshotUUIDs(repository, repositoryData, new ActionListener<AssertionError>(){

                    public void onResponse(AssertionError assertionError) {
                        if (assertionError == null) {
                            try {
                                try {
                                    BlobStoreTestUtil.assertShardIndexGenerations(blobContainer, repositoryData.shardGenerations());
                                }
                                catch (AssertionError e) {
                                    listener.onResponse((Object)e);
                                    return;
                                }
                            }
                            catch (Exception e) {
                                this.onFailure(e);
                                return;
                            }
                            listener.onResponse(null);
                        } else {
                            listener.onResponse((Object)assertionError);
                        }
                    }

                    public void onFailure(Exception e) {
                        listener.onResponse((Object)new AssertionError((Object)e));
                    }
                });
            }
            catch (AssertionError e) {
                listener.onResponse((Object)e);
            }
        }));
        return future;
    }

    private static void assertIndexGenerations(BlobContainer repoRoot, long latestGen) throws IOException {
        long[] indexGenerations = repoRoot.listBlobsByPrefix(BlobStoreTestUtil.randomPurpose(), "index-").keySet().stream().map(s -> s.replace("index-", "")).mapToLong(Long::parseLong).sorted().toArray();
        Assert.assertEquals((long)latestGen, (long)indexGenerations[indexGenerations.length - 1]);
        Assert.assertTrue((indexGenerations.length <= 2 ? 1 : 0) != 0);
    }

    private static void assertShardIndexGenerations(BlobContainer repoRoot, ShardGenerations shardGenerations) throws IOException {
        BlobContainer indicesContainer = (BlobContainer)repoRoot.children(BlobStoreTestUtil.randomPurpose()).get("indices");
        for (IndexId index : shardGenerations.indices()) {
            List gens = shardGenerations.getGens(index);
            if (gens.isEmpty()) continue;
            BlobContainer indexContainer = (BlobContainer)indicesContainer.children(BlobStoreTestUtil.randomPurpose()).get(index.getId());
            Map shardContainers = indexContainer.children(BlobStoreTestUtil.randomPurpose());
            for (int i = 0; i < gens.size(); ++i) {
                ShardGeneration generation = (ShardGeneration)gens.get(i);
                Assert.assertThat((Object)generation, (Matcher)Matchers.not((Object)ShardGenerations.DELETED_SHARD_GEN));
                if (generation == null || generation.equals((Object)ShardGenerations.NEW_SHARD_GEN)) continue;
                String shardId = Integer.toString(i);
                Assert.assertThat((Object)shardContainers, (Matcher)Matchers.hasKey((Object)shardId));
                Assert.assertThat((Object)((BlobContainer)shardContainers.get(shardId)).listBlobsByPrefix(BlobStoreTestUtil.randomPurpose(), "index-"), (Matcher)Matchers.hasKey((Object)("index-" + generation)));
            }
        }
    }

    private static void assertIndexUUIDs(BlobStoreRepository repository, RepositoryData repositoryData) throws IOException {
        List<String> expectedIndexUUIDs = repositoryData.getIndices().values().stream().map(IndexId::getId).toList();
        BlobContainer indicesContainer = (BlobContainer)repository.blobContainer().children(BlobStoreTestUtil.randomPurpose()).get("indices");
        List<String> foundIndexUUIDs = indicesContainer == null ? Collections.emptyList() : indicesContainer.children(BlobStoreTestUtil.randomPurpose()).keySet().stream().filter(s -> !s.startsWith("extra")).collect(Collectors.toList());
        Assert.assertThat(foundIndexUUIDs, (Matcher)Matchers.containsInAnyOrder((Object[])expectedIndexUUIDs.toArray(Strings.EMPTY_ARRAY)));
        for (String indexId : foundIndexUUIDs) {
            Set indexMetaGenerationsFound = ((BlobContainer)indicesContainer.children(BlobStoreTestUtil.randomPurpose()).get(indexId)).listBlobsByPrefix(BlobStoreTestUtil.randomPurpose(), "meta-").keySet().stream().map(p -> p.replace("meta-", "").replace(".dat", "")).collect(Collectors.toSet());
            HashSet<String> indexMetaGenerationsExpected = new HashSet<String>();
            IndexId idx = repositoryData.getIndices().values().stream().filter(i -> i.getId().equals(indexId)).findFirst().get();
            for (SnapshotId snapshotId : repositoryData.getSnapshots(idx)) {
                indexMetaGenerationsExpected.add(repositoryData.indexMetaDataGenerations().indexMetaBlobId(snapshotId, idx));
            }
            Assert.assertTrue((boolean)indexMetaGenerationsFound.containsAll(indexMetaGenerationsExpected));
        }
    }

    private static void assertSnapshotUUIDs(final BlobStoreRepository repository, final RepositoryData repositoryData, final ActionListener<AssertionError> listener) throws IOException {
        BlobContainer repoRoot = repository.blobContainer();
        Collection snapshotIds = repositoryData.getSnapshotIds();
        List<String> expectedSnapshotUUIDs = snapshotIds.stream().map(SnapshotId::getUUID).toList();
        for (String prefix : new String[]{"snap-", "meta-"}) {
            Collection foundSnapshotUUIDs = repoRoot.listBlobs(BlobStoreTestUtil.randomPurpose()).keySet().stream().filter(p -> p.startsWith(prefix)).map(p -> p.replace(prefix, "").replace(".dat", "")).collect(Collectors.toSet());
            Assert.assertThat((Object)foundSnapshotUUIDs, (Matcher)Matchers.containsInAnyOrder((Object[])expectedSnapshotUUIDs.toArray(Strings.EMPTY_ARRAY)));
        }
        BlobContainer indicesContainer = (BlobContainer)repository.getBlobContainer().children(BlobStoreTestUtil.randomPurpose()).get("indices");
        final Map indices = indicesContainer == null ? Collections.emptyMap() : indicesContainer.children(BlobStoreTestUtil.randomPurpose());
        if (snapshotIds.isEmpty()) {
            listener.onResponse(null);
            return;
        }
        final List snapshotInfos = Collections.synchronizedList(new ArrayList());
        repository.getSnapshotInfo(List.copyOf(snapshotIds), true, () -> false, snapshotInfos::add, (ActionListener)new ActionListener<Void>(){

            public void onResponse(Void unused) {
                try {
                    BlobStoreTestUtil.assertSnapshotInfosConsistency(repository, repositoryData, indices, snapshotInfos);
                }
                catch (Exception e) {
                    listener.onResponse((Object)new AssertionError((Object)e));
                    return;
                }
                catch (AssertionError e) {
                    listener.onResponse((Object)e);
                    return;
                }
                listener.onResponse(null);
            }

            public void onFailure(Exception e) {
                listener.onResponse((Object)new AssertionError((Object)e));
            }
        });
    }

    private static void assertSnapshotInfosConsistency(BlobStoreRepository repository, RepositoryData repositoryData, Map<String, BlobContainer> indices, List<SnapshotInfo> snapshotInfos) throws IOException {
        HashMap<IndexId, Integer> maxShardCountsExpected = new HashMap<IndexId, Integer>();
        HashMap<IndexId, Integer> maxShardCountsSeen = new HashMap<IndexId, Integer>();
        for (SnapshotInfo snapshotInfo : snapshotInfos) {
            SnapshotId snapshotId = snapshotInfo.snapshotId();
            for (String index : snapshotInfo.indices()) {
                IndexId indexId2 = repositoryData.resolveIndexId(index);
                Assert.assertThat(indices, (Matcher)Matchers.hasKey((Object)indexId2.getId()));
                BlobContainer indexContainer = indices.get(indexId2.getId());
                Assert.assertThat((Object)indexContainer.listBlobs(BlobStoreTestUtil.randomPurpose()), (Matcher)Matchers.hasKey((Object)String.format(Locale.ROOT, "meta-%s.dat", repositoryData.indexMetaDataGenerations().indexMetaBlobId(snapshotId, indexId2))));
                IndexMetadata indexMetadata = repository.getSnapshotIndexMetaData(repositoryData, snapshotId, indexId2);
                for (Map.Entry entry : indexContainer.children(BlobStoreTestUtil.randomPurpose()).entrySet()) {
                    if (((String)entry.getKey()).startsWith("extra")) continue;
                    int shardId = Integer.parseInt((String)entry.getKey());
                    int shardCount = indexMetadata.getNumberOfShards();
                    maxShardCountsExpected.compute(indexId2, (i, existing) -> existing == null || existing < shardCount ? shardCount : existing);
                    BlobContainer shardContainer = (BlobContainer)entry.getValue();
                    if (shardContainer.listBlobs(BlobStoreTestUtil.randomPurpose()).keySet().stream().anyMatch(blob -> !blob.startsWith("extra"))) {
                        int impliedCount = shardId - 1;
                        maxShardCountsSeen.compute(indexId2, (i, existing) -> existing == null || existing < impliedCount ? impliedCount : existing);
                    }
                    if (shardId >= shardCount || !snapshotInfo.shardFailures().stream().noneMatch(shardFailure -> shardFailure.index().equals(index) && shardFailure.shardId() == shardId)) continue;
                    Map shardPathContents = shardContainer.listBlobs(BlobStoreTestUtil.randomPurpose());
                    Assert.assertThat((Object)shardPathContents, (Matcher)Matchers.hasKey((Object)String.format(Locale.ROOT, "snap-%s.dat", snapshotId.getUUID())));
                    Assert.assertThat((Object)shardPathContents.keySet().stream().filter(name -> name.startsWith("index-")).count(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(2L)));
                    BlobStoreIndexShardSnapshots blobStoreIndexShardSnapshots = repository.getBlobStoreIndexShardSnapshots(indexId2, shardId, repositoryData.shardGenerations().getShardGen(indexId2, shardId));
                    Assert.assertTrue((boolean)blobStoreIndexShardSnapshots.snapshots().stream().anyMatch(snapshotFiles -> snapshotFiles.snapshot().equals(snapshotId.getName())));
                }
            }
        }
        maxShardCountsSeen.forEach((indexId, count) -> Assert.assertThat((String)("Found unreferenced shard paths for index [" + indexId + "]"), (Object)count, (Matcher)Matchers.lessThanOrEqualTo((Comparable)((Integer)maxShardCountsExpected.get(indexId)))));
    }

    public static void assertBlobsByPrefix(BlobStoreRepository repository, BlobPath path, String prefix, Map<String, BlobMetadata> blobs) {
        PlainActionFuture future = new PlainActionFuture();
        repository.threadPool().generic().execute((Runnable)ActionRunnable.supply((ActionListener)future, () -> repository.blobStore().blobContainer(path).listBlobsByPrefix(BlobStoreTestUtil.randomPurpose(), prefix)));
        Map foundBlobs = (Map)future.actionGet();
        if (blobs.isEmpty()) {
            Assert.assertThat(foundBlobs.keySet(), (Matcher)Matchers.empty());
        } else {
            Assert.assertThat(foundBlobs.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])blobs.keySet().toArray(Strings.EMPTY_ARRAY)));
            for (Map.Entry entry : foundBlobs.entrySet()) {
                Assert.assertEquals((long)((BlobMetadata)entry.getValue()).length(), (long)blobs.get(entry.getKey()).length());
            }
        }
    }

    public static ClusterService mockClusterService() {
        return BlobStoreTestUtil.mockClusterService(ClusterState.EMPTY_STATE);
    }

    public static ClusterService mockClusterService(RepositoryMetadata metadata) {
        return BlobStoreTestUtil.mockClusterService(ClusterState.builder((ClusterState)ClusterState.EMPTY_STATE).metadata(Metadata.builder().clusterUUID(UUIDs.randomBase64UUID((Random)LuceneTestCase.random())).putCustom("repositories", (Metadata.Custom)new RepositoriesMetadata(Collections.singletonList(metadata))).build()).build());
    }

    private static ClusterService mockClusterService(ClusterState initialState) {
        ThreadContext threadContext = new ThreadContext(Settings.EMPTY);
        ThreadPool threadPool = (ThreadPool)Mockito.mock(ThreadPool.class);
        Mockito.when((Object)threadPool.getThreadContext()).thenReturn((Object)threadContext);
        Mockito.when((Object)threadPool.executor("snapshot")).thenReturn((Object)new SameThreadExecutorService());
        Mockito.when((Object)threadPool.executor("snapshot_meta")).thenReturn((Object)new SameThreadExecutorService());
        Mockito.when((Object)threadPool.generic()).thenReturn((Object)new SameThreadExecutorService());
        Mockito.when((Object)threadPool.info("snapshot")).thenReturn((Object)new ThreadPool.Info("snapshot", ThreadPool.ThreadPoolType.FIXED, ESTestCase.randomIntBetween(1, 10)));
        ClusterService clusterService = (ClusterService)Mockito.mock(ClusterService.class);
        ClusterApplierService clusterApplierService = (ClusterApplierService)Mockito.mock(ClusterApplierService.class);
        Mockito.when((Object)clusterService.getClusterApplierService()).thenReturn((Object)clusterApplierService);
        DiscoveryNode localNode = DiscoveryNodeUtils.create("");
        Mockito.when((Object)clusterService.localNode()).thenReturn((Object)localNode);
        AtomicReference<ClusterState> currentState = new AtomicReference<ClusterState>(ClusterState.builder((ClusterState)initialState).nodes(DiscoveryNodes.builder().add(localNode).masterNodeId(localNode.getId()).localNodeId(localNode.getId()).build()).build());
        Mockito.when((Object)clusterService.state()).then(invocationOnMock -> currentState.get());
        CopyOnWriteArrayList appliers = new CopyOnWriteArrayList();
        ((ClusterService)Mockito.doAnswer(invocation -> {
            ClusterStateUpdateTask task = (ClusterStateUpdateTask)invocation.getArguments()[1];
            ClusterState current = (ClusterState)currentState.get();
            ClusterState next = task.execute(current);
            currentState.set(next);
            appliers.forEach(applier -> applier.applyClusterState(new ClusterChangedEvent((String)invocation.getArguments()[0], next, current)));
            task.clusterStateProcessed(current, next);
            return null;
        }).when((Object)clusterService)).submitUnbatchedStateUpdateTask(ArgumentMatchers.anyString(), (ClusterStateUpdateTask)ArgumentMatchers.any(ClusterStateUpdateTask.class));
        ((ClusterService)Mockito.doAnswer(invocation -> {
            appliers.add((ClusterStateApplier)invocation.getArguments()[0]);
            return null;
        }).when((Object)clusterService)).addStateApplier((ClusterStateApplier)ArgumentMatchers.any(ClusterStateApplier.class));
        Mockito.when((Object)clusterApplierService.threadPool()).thenReturn((Object)threadPool);
        return clusterService;
    }

    public static OperationPurpose randomPurpose() {
        return ESTestCase.randomFrom(OperationPurpose.values());
    }

    public static OperationPurpose randomNonDataPurpose() {
        return ESTestCase.randomValueOtherThan(OperationPurpose.SNAPSHOT_DATA, BlobStoreTestUtil::randomPurpose);
    }
}

