/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.SearchExtBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.builder.PointInTimeBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.builder.SubSearchSourceBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.rank.RankBuilder;
import org.elasticsearch.search.rescore.RescorerBuilder;
import org.elasticsearch.search.searchafter.SearchAfterBuilder;
import org.elasticsearch.search.slice.SliceBuilder;
import org.elasticsearch.search.sort.ScriptSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.elasticsearch.search.vectors.KnnSearchBuilder;
import org.elasticsearch.test.AbstractQueryTestCase;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class RandomSearchRequestGenerator {
    private RandomSearchRequestGenerator() {
    }

    public static SearchRequest randomSearchRequest(Supplier<SearchSourceBuilder> randomSearchSourceBuilder) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.allowPartialSearchResults(true);
        if (ESTestCase.randomBoolean()) {
            searchRequest.setCcsMinimizeRoundtrips(ESTestCase.randomBoolean());
        }
        if (ESTestCase.randomBoolean()) {
            searchRequest.indices(ESTestCase.generateRandomStringArray(10, 10, false, false));
        }
        if (ESTestCase.randomBoolean()) {
            searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)ESTestCase.randomBoolean(), (boolean)ESTestCase.randomBoolean(), (boolean)ESTestCase.randomBoolean(), (boolean)ESTestCase.randomBoolean()));
        }
        if (ESTestCase.randomBoolean()) {
            searchRequest.preference(ESTestCase.randomAlphaOfLengthBetween(3, 10));
        }
        if (ESTestCase.randomBoolean()) {
            searchRequest.requestCache(Boolean.valueOf(ESTestCase.randomBoolean()));
        }
        if (ESTestCase.randomBoolean()) {
            searchRequest.routing(ESTestCase.randomAlphaOfLengthBetween(3, 10));
        }
        if (ESTestCase.randomBoolean()) {
            searchRequest.scroll(ESTestCase.randomPositiveTimeValue());
        }
        if (ESTestCase.randomBoolean()) {
            searchRequest.searchType(ESTestCase.randomFrom(SearchType.DFS_QUERY_THEN_FETCH, SearchType.QUERY_THEN_FETCH));
        }
        if (ESTestCase.randomBoolean()) {
            searchRequest.source(randomSearchSourceBuilder.get());
        }
        if (ESTestCase.randomBoolean()) {
            searchRequest.setForceSyntheticSource(ESTestCase.randomBoolean());
        }
        return searchRequest;
    }

    public static SearchSourceBuilder randomSearchSourceBuilder(Supplier<HighlightBuilder> randomHighlightBuilder, Supplier<SuggestBuilder> randomSuggestBuilder, Supplier<RankBuilder> rankContextBuilderSupplier, Supplier<RescorerBuilder<?>> randomRescoreBuilder, Supplier<List<SearchExtBuilder>> randomExtBuilders, Supplier<CollapseBuilder> randomCollapseBuilder, Supplier<Map<String, Object>> randomRuntimeMappings) {
        String format;
        int numFields;
        int i;
        SearchSourceBuilder builder = new SearchSourceBuilder();
        if (ESTestCase.randomBoolean()) {
            builder.from(ESTestCase.randomIntBetween(0, 10000));
        }
        if (ESTestCase.randomBoolean()) {
            builder.size(ESTestCase.randomIntBetween(0, 10000));
        }
        if (ESTestCase.randomBoolean()) {
            builder.explain(Boolean.valueOf(ESTestCase.randomBoolean()));
        }
        if (ESTestCase.randomBoolean()) {
            builder.version(Boolean.valueOf(ESTestCase.randomBoolean()));
        }
        if (ESTestCase.randomBoolean()) {
            builder.seqNoAndPrimaryTerm(Boolean.valueOf(ESTestCase.randomBoolean()));
        }
        if (ESTestCase.randomBoolean()) {
            builder.trackScores(ESTestCase.randomBoolean());
        }
        if (ESTestCase.randomBoolean()) {
            builder.minScore(ESTestCase.randomFloat() * 1000.0f);
        }
        if (ESTestCase.randomBoolean()) {
            builder.timeout(ESTestCase.randomTimeValue());
        }
        if (ESTestCase.randomBoolean()) {
            builder.terminateAfter(ESTestCase.randomIntBetween(1, 100000));
        }
        if (ESTestCase.randomBoolean()) {
            if (ESTestCase.randomBoolean()) {
                builder.trackTotalHits(ESTestCase.randomBoolean());
            } else {
                builder.trackTotalHitsUpTo(ESTestCase.randomIntBetween(-1, Integer.MAX_VALUE));
            }
        }
        switch (ESTestCase.randomInt(2)) {
            case 0: {
                builder.storedFields();
                break;
            }
            case 1: {
                builder.storedField("_none_");
                break;
            }
            case 2: {
                int fieldsSize = ESTestCase.randomInt(25);
                ArrayList<String> fields = new ArrayList<String>(fieldsSize);
                for (i = 0; i < fieldsSize; ++i) {
                    fields.add(ESTestCase.randomAlphaOfLengthBetween(5, 50));
                }
                builder.storedFields(fields);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (ESTestCase.randomBoolean()) {
            numFields = ESTestCase.randomInt(5);
            for (int i2 = 0; i2 < numFields; ++i2) {
                String field = ESTestCase.randomAlphaOfLengthBetween(5, 10);
                format = ESTestCase.randomBoolean() ? ESTestCase.randomAlphaOfLengthBetween(5, 10) : null;
                builder.fetchField(new FieldAndFormat(field, format));
            }
        }
        if (ESTestCase.randomBoolean()) {
            numFields = ESTestCase.randomInt(5);
            for (int i3 = 0; i3 < numFields; ++i3) {
                String field = ESTestCase.randomAlphaOfLengthBetween(5, 10);
                format = ESTestCase.randomBoolean() ? ESTestCase.randomAlphaOfLengthBetween(5, 10) : null;
                builder.docValueField(field, format);
            }
        }
        if (ESTestCase.randomBoolean()) {
            int scriptFieldsSize = ESTestCase.randomInt(25);
            for (int i4 = 0; i4 < scriptFieldsSize; ++i4) {
                if (ESTestCase.randomBoolean()) {
                    builder.scriptField(ESTestCase.randomAlphaOfLengthBetween(5, 50), ESTestCase.mockScript("foo"), ESTestCase.randomBoolean());
                    continue;
                }
                builder.scriptField(ESTestCase.randomAlphaOfLengthBetween(5, 50), ESTestCase.mockScript("foo"));
            }
        }
        if (ESTestCase.randomBoolean()) {
            int branch = ESTestCase.randomInt(5);
            String[] includes = new String[ESTestCase.randomIntBetween(0, 20)];
            for (int i5 = 0; i5 < includes.length; ++i5) {
                includes[i5] = ESTestCase.randomAlphaOfLengthBetween(5, 20);
            }
            String[] excludes = new String[ESTestCase.randomIntBetween(0, 20)];
            for (int i6 = 0; i6 < excludes.length; ++i6) {
                excludes[i6] = ESTestCase.randomAlphaOfLengthBetween(5, 20);
            }
            FetchSourceContext fetchSourceContext = switch (branch) {
                case 0 -> FetchSourceContext.of((boolean)ESTestCase.randomBoolean());
                case 1 -> FetchSourceContext.of((boolean)true, (String[])includes, (String[])excludes);
                case 2 -> FetchSourceContext.of((boolean)true, (String[])new String[]{ESTestCase.randomAlphaOfLengthBetween(5, 20)}, (String[])new String[]{ESTestCase.randomAlphaOfLengthBetween(5, 20)});
                case 3 -> FetchSourceContext.of((boolean)true, (String[])includes, (String[])excludes);
                case 4 -> FetchSourceContext.of((boolean)true, (String[])includes, null);
                case 5 -> FetchSourceContext.of((boolean)true, (String[])new String[]{ESTestCase.randomAlphaOfLengthBetween(5, 20)}, null);
                default -> throw new IllegalStateException();
            };
            builder.fetchSource(fetchSourceContext);
        }
        if (ESTestCase.randomBoolean()) {
            int size = ESTestCase.randomIntBetween(0, 20);
            ArrayList<String> statsGroups = new ArrayList<String>(size);
            for (i = 0; i < size; ++i) {
                statsGroups.add(ESTestCase.randomAlphaOfLengthBetween(5, 20));
            }
            builder.stats(statsGroups);
        }
        if (ESTestCase.randomBoolean()) {
            int indexBoostSize = ESTestCase.randomIntBetween(1, 10);
            for (int i7 = 0; i7 < indexBoostSize; ++i7) {
                builder.indexBoost(ESTestCase.randomAlphaOfLengthBetween(5, 20), ESTestCase.randomFloat() * 10.0f);
            }
        }
        if (ESTestCase.randomBoolean()) {
            builder.query((QueryBuilder)QueryBuilders.termQuery((String)ESTestCase.randomAlphaOfLengthBetween(5, 20), (String)ESTestCase.randomAlphaOfLengthBetween(5, 20)));
        } else if (ESTestCase.randomBoolean()) {
            builder.subSearches(List.of(new SubSearchSourceBuilder((QueryBuilder)QueryBuilders.termQuery((String)ESTestCase.randomAlphaOfLengthBetween(5, 20), (String)ESTestCase.randomAlphaOfLengthBetween(5, 20))), new SubSearchSourceBuilder((QueryBuilder)QueryBuilders.termQuery((String)ESTestCase.randomAlphaOfLengthBetween(5, 20), (String)ESTestCase.randomAlphaOfLengthBetween(5, 20)))));
        }
        if (ESTestCase.randomBoolean()) {
            builder.postFilter((QueryBuilder)QueryBuilders.termQuery((String)ESTestCase.randomAlphaOfLengthBetween(5, 20), (String)ESTestCase.randomAlphaOfLengthBetween(5, 20)));
        }
        if (ESTestCase.randomBoolean()) {
            int numKClauses = ESTestCase.randomIntBetween(1, 5);
            ArrayList<KnnSearchBuilder> knnSearchBuilders = new ArrayList<KnnSearchBuilder>(numKClauses);
            for (int j = 0; j < numKClauses; ++j) {
                String field = ESTestCase.randomAlphaOfLength(6);
                int dim = ESTestCase.randomIntBetween(2, 30);
                float[] vector = new float[dim];
                for (int i8 = 0; i8 < vector.length; ++i8) {
                    vector[i8] = ESTestCase.randomFloat();
                }
                int k = ESTestCase.randomIntBetween(1, 100);
                int numCands = ESTestCase.randomIntBetween(k, 1000);
                knnSearchBuilders.add(new KnnSearchBuilder(field, vector, k, numCands, ESTestCase.randomBoolean() ? null : Float.valueOf(ESTestCase.randomFloat())));
            }
            builder.knnSearch(knnSearchBuilders);
        }
        if (ESTestCase.randomBoolean()) {
            int numSorts = ESTestCase.randomIntBetween(1, 5);
            block49: for (int i9 = 0; i9 < numSorts; ++i9) {
                int branch = ESTestCase.randomInt(5);
                switch (branch) {
                    case 0: {
                        builder.sort(SortBuilders.fieldSort((String)ESTestCase.randomAlphaOfLengthBetween(5, 20)).order(ESTestCase.randomFrom(SortOrder.values())));
                        continue block49;
                    }
                    case 1: {
                        builder.sort(SortBuilders.geoDistanceSort((String)ESTestCase.randomAlphaOfLengthBetween(5, 20), (String[])new String[]{AbstractQueryTestCase.randomGeohash(1, 12)}).order(ESTestCase.randomFrom(SortOrder.values())));
                        continue block49;
                    }
                    case 2: {
                        builder.sort(SortBuilders.scoreSort().order(ESTestCase.randomFrom(SortOrder.values())));
                        continue block49;
                    }
                    case 3: {
                        builder.sort(SortBuilders.scriptSort((Script)new Script(ScriptType.INLINE, "painless", "foo", Collections.emptyMap()), (ScriptSortBuilder.ScriptSortType)ScriptSortBuilder.ScriptSortType.NUMBER).order(ESTestCase.randomFrom(SortOrder.values())));
                        continue block49;
                    }
                    case 4: {
                        builder.sort(ESTestCase.randomAlphaOfLengthBetween(5, 20));
                        continue block49;
                    }
                    case 5: {
                        builder.sort(ESTestCase.randomAlphaOfLengthBetween(5, 20), ESTestCase.randomFrom(SortOrder.values()));
                    }
                }
            }
        }
        if (ESTestCase.randomBoolean()) {
            int numSearchFrom = ESTestCase.randomIntBetween(1, 5);
            try {
                XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();
                jsonBuilder.startObject();
                jsonBuilder.startArray("search_from");
                block50: for (i = 0; i < numSearchFrom; ++i) {
                    int branch = ESTestCase.randomInt(8);
                    switch (branch) {
                        case 0: {
                            jsonBuilder.value(ESTestCase.randomInt());
                            continue block50;
                        }
                        case 1: {
                            jsonBuilder.value(ESTestCase.randomFloat());
                            continue block50;
                        }
                        case 2: {
                            jsonBuilder.value(ESTestCase.randomLong());
                            continue block50;
                        }
                        case 3: {
                            jsonBuilder.value(ESTestCase.randomDouble());
                            continue block50;
                        }
                        case 4: {
                            jsonBuilder.value(ESTestCase.randomAlphaOfLengthBetween(5, 20));
                            continue block50;
                        }
                        case 5: {
                            jsonBuilder.value(ESTestCase.randomBoolean());
                            continue block50;
                        }
                        case 6: {
                            jsonBuilder.value(ESTestCase.randomByte());
                            continue block50;
                        }
                        case 7: {
                            jsonBuilder.value(ESTestCase.randomShort());
                            continue block50;
                        }
                        case 8: {
                            jsonBuilder.value((ToXContent)new Text(ESTestCase.randomAlphaOfLengthBetween(5, 20)));
                        }
                    }
                }
                jsonBuilder.endArray();
                jsonBuilder.endObject();
                try (XContentParser parser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)BytesReference.bytes((XContentBuilder)jsonBuilder), (XContentType)XContentType.JSON);){
                    parser.nextToken();
                    parser.nextToken();
                    parser.nextToken();
                    builder.searchAfter(SearchAfterBuilder.fromXContent((XContentParser)parser).getSortValues());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error building search_from", e);
            }
        }
        if (ESTestCase.randomBoolean()) {
            builder.highlighter(randomHighlightBuilder.get());
        }
        if (ESTestCase.randomBoolean()) {
            builder.suggest(randomSuggestBuilder.get());
        }
        if (ESTestCase.randomBoolean()) {
            builder.rankBuilder(rankContextBuilderSupplier.get());
        }
        if (ESTestCase.randomBoolean()) {
            int numRescores = ESTestCase.randomIntBetween(1, 5);
            for (int i10 = 0; i10 < numRescores; ++i10) {
                builder.addRescorer(randomRescoreBuilder.get());
            }
        }
        if (ESTestCase.randomBoolean()) {
            builder.aggregation((AggregationBuilder)AggregationBuilders.avg((String)ESTestCase.randomAlphaOfLengthBetween(5, 20)).field("foo"));
        }
        if (ESTestCase.randomBoolean()) {
            builder.ext(randomExtBuilders.get());
        }
        if (ESTestCase.randomBoolean()) {
            String field = ESTestCase.randomBoolean() ? null : ESTestCase.randomAlphaOfLengthBetween(5, 20);
            int max = ESTestCase.between(2, 1000);
            int id = ESTestCase.randomInt(max - 1);
            if (field == null) {
                builder.slice(new SliceBuilder(id, max));
            } else {
                builder.slice(new SliceBuilder(field, id, max));
            }
        }
        if (ESTestCase.randomBoolean()) {
            builder.collapse(randomCollapseBuilder.get());
        }
        if (ESTestCase.randomBoolean()) {
            PointInTimeBuilder pit = new PointInTimeBuilder((BytesReference)new BytesArray(Base64.getUrlEncoder().encode(ESTestCase.randomAlphaOfLengthBetween(3, 10).getBytes(StandardCharsets.UTF_8))));
            if (ESTestCase.randomBoolean()) {
                pit.setKeepAlive(TimeValue.timeValueMinutes((long)ESTestCase.randomIntBetween(1, 60)));
            }
            builder.pointInTimeBuilder(pit);
        }
        if (ESTestCase.randomBoolean()) {
            builder.runtimeMappings(randomRuntimeMappings.get());
        }
        return builder;
    }
}

