/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoGrid;
import org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoGrid;
import org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoGridBucket;
import org.elasticsearch.test.InternalMultiBucketAggregationTestCase;
import org.hamcrest.Matchers;

public abstract class GeoGridTestCase<B extends InternalGeoGridBucket, T extends InternalGeoGrid<B>>
extends InternalMultiBucketAggregationTestCase<T> {
    protected abstract T createInternalGeoGrid(String var1, int var2, List<InternalGeoGridBucket> var3, Map<String, Object> var4);

    protected abstract B createInternalGeoGridBucket(Long var1, long var2, InternalAggregations var4);

    protected abstract long longEncode(double var1, double var3, int var5);

    protected abstract int randomPrecision();

    @Override
    protected int minNumberOfBuckets() {
        return 1;
    }

    @Override
    protected int maxNumberOfBuckets() {
        return 3;
    }

    @Override
    protected boolean supportsSampling() {
        return true;
    }

    @Override
    protected T createTestInstance(String name, Map<String, Object> metadata, InternalAggregations aggregations) {
        int precision = this.randomPrecision();
        int size = this.randomNumberOfBuckets();
        ArrayList<InternalGeoGridBucket> buckets = new ArrayList<InternalGeoGridBucket>(size);
        ArrayList<Long> seen = new ArrayList<Long>(size);
        int finalSize = 0;
        for (int i = 0; i < size; ++i) {
            double latitude = GeoGridTestCase.randomDoubleBetween(-90.0, 90.0, false);
            double longitude = GeoGridTestCase.randomDoubleBetween(-180.0, 180.0, false);
            long hashAsLong = this.longEncode(longitude, latitude, precision);
            if (seen.contains(hashAsLong)) continue;
            buckets.add((InternalGeoGridBucket)this.createInternalGeoGridBucket(hashAsLong, GeoGridTestCase.randomInt(0x7FFFFF7F), aggregations));
            seen.add(hashAsLong);
            ++finalSize;
        }
        return this.createInternalGeoGrid(name, finalSize, buckets, metadata);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void assertReduced(T reduced, List<T> inputs) {
        void var6_11;
        HashMap<Long, ArrayList<InternalGeoGridBucket>> map = new HashMap<Long, ArrayList<InternalGeoGridBucket>>();
        for (Object input : inputs) {
            for (GeoGrid.Bucket bucketBase : input.getBuckets()) {
                InternalGeoGridBucket bucket = (InternalGeoGridBucket)bucketBase;
                ArrayList<InternalGeoGridBucket> buckets = (ArrayList<InternalGeoGridBucket>)map.get(bucket.hashAsLong);
                if (buckets == null) {
                    buckets = new ArrayList<InternalGeoGridBucket>();
                    map.put(bucket.hashAsLong, buckets);
                }
                buckets.add(bucket);
            }
        }
        List<B> expectedBuckets = new ArrayList();
        for (Map.Entry entry : map.entrySet()) {
            long docCount = 0L;
            for (InternalGeoGridBucket bucket : (List)entry.getValue()) {
                docCount += bucket.docCount;
            }
            expectedBuckets.add(this.createInternalGeoGridBucket((Long)entry.getKey(), docCount, InternalAggregations.EMPTY));
        }
        expectedBuckets.sort((first, second) -> {
            int cmp = Long.compare(second.docCount, first.docCount);
            if (cmp == 0) {
                return second.compareTo(first);
            }
            return cmp;
        });
        int requestedSize = reduced.getRequiredSize();
        expectedBuckets = expectedBuckets.subList(0, Math.min(requestedSize, expectedBuckets.size()));
        GeoGridTestCase.assertEquals((long)expectedBuckets.size(), (long)reduced.getBuckets().size());
        boolean bl = false;
        while (var6_11 < reduced.getBuckets().size()) {
            GeoGrid.Bucket expected = (GeoGrid.Bucket)expectedBuckets.get((int)var6_11);
            GeoGrid.Bucket actual = (GeoGrid.Bucket)reduced.getBuckets().get((int)var6_11);
            GeoGridTestCase.assertEquals((long)expected.getDocCount(), (long)actual.getDocCount());
            GeoGridTestCase.assertEquals((Object)expected.getKey(), (Object)actual.getKey());
            ++var6_11;
        }
    }

    @Override
    protected T mutateInstance(T instance) {
        Object name = instance.getName();
        int size = instance.getRequiredSize();
        ArrayList<InternalGeoGridBucket> buckets = instance.getBuckets();
        Map<String, Object> metadata = instance.getMetadata();
        switch (GeoGridTestCase.between(0, 3)) {
            case 0: {
                name = (String)name + GeoGridTestCase.randomAlphaOfLength(5);
                break;
            }
            case 1: {
                buckets = new ArrayList<InternalGeoGridBucket>(buckets);
                buckets.add((InternalGeoGridBucket)this.createInternalGeoGridBucket(GeoGridTestCase.randomNonNegativeLong(), GeoGridTestCase.randomInt(0x7FFFFF7F), InternalAggregations.EMPTY));
                break;
            }
            case 2: {
                size += GeoGridTestCase.between(1, 10);
                break;
            }
            case 3: {
                metadata = metadata == null ? Maps.newMapWithExpectedSize((int)1) : new HashMap<String, Object>(instance.getMetadata());
                metadata.put(GeoGridTestCase.randomAlphaOfLength(15), GeoGridTestCase.randomInt());
                break;
            }
            default: {
                throw new AssertionError((Object)"Illegal randomisation branch");
            }
        }
        return this.createInternalGeoGrid((String)name, size, buckets, metadata);
    }

    public void testCreateFromBuckets() {
        InternalGeoGrid original = (InternalGeoGrid)this.createTestInstance();
        GeoGridTestCase.assertThat(original, Matchers.equalTo((Object)((InternalGeoGrid)original.create(original.buckets))));
    }
}

