/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.geo;

import java.util.List;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.geo.BasePointShapeQueryTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.xcontent.XContentFactory;
import org.junit.Assert;

public class DatelinePointShapeQueryTestCase {
    protected static final String defaultFieldName = "geo";
    protected static final String defaultIndexName = "test";

    public void testRectangleSpanningDateline(BasePointShapeQueryTestCase<GeoShapeQueryBuilder> tests) throws Exception {
        tests.createMapping(defaultIndexName, defaultFieldName);
        tests.ensureGreen(new String[0]);
        tests.client().prepareIndex(defaultIndexName).setId("1").setSource(XContentFactory.jsonBuilder().startObject().field(defaultFieldName, "POINT(-169 0)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        tests.client().prepareIndex(defaultIndexName).setId("2").setSource(XContentFactory.jsonBuilder().startObject().field(defaultFieldName, "POINT(-179 0)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        tests.client().prepareIndex(defaultIndexName).setId("3").setSource(XContentFactory.jsonBuilder().startObject().field(defaultFieldName, "POINT(171 0)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        Rectangle rectangle = new Rectangle(169.0, -178.0, 1.0, -1.0);
        GeoShapeQueryBuilder geoShapeQueryBuilder = QueryBuilders.geoShapeQuery((String)defaultFieldName, (Geometry)rectangle);
        ElasticsearchAssertions.assertResponse(tests.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)geoShapeQueryBuilder), response -> {
            SearchHits searchHits = response.getHits();
            Assert.assertEquals((long)2L, (long)searchHits.getTotalHits().value);
            Assert.assertNotEquals((Object)"1", (Object)searchHits.getAt(0).getId());
            Assert.assertNotEquals((Object)"1", (Object)searchHits.getAt(1).getId());
        });
    }

    public void testPolygonSpanningDateline(BasePointShapeQueryTestCase<GeoShapeQueryBuilder> tests) throws Exception {
        tests.createMapping(defaultIndexName, defaultFieldName);
        tests.ensureGreen(new String[0]);
        tests.client().prepareIndex(defaultIndexName).setId("1").setSource(XContentFactory.jsonBuilder().startObject().field(defaultFieldName, "POINT(-169 7)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        tests.client().prepareIndex(defaultIndexName).setId("2").setSource(XContentFactory.jsonBuilder().startObject().field(defaultFieldName, "POINT(-179 7)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        tests.client().prepareIndex(defaultIndexName).setId("3").setSource(XContentFactory.jsonBuilder().startObject().field(defaultFieldName, "POINT(179 7)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        tests.client().prepareIndex(defaultIndexName).setId("4").setSource(XContentFactory.jsonBuilder().startObject().field(defaultFieldName, "POINT(171 7)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        Polygon polygon = new Polygon(new LinearRing(new double[]{-177.0, 177.0, 177.0, -177.0, -177.0}, new double[]{10.0, 10.0, 5.0, 5.0, 10.0}));
        GeoShapeQueryBuilder geoShapeQueryBuilder = QueryBuilders.geoShapeQuery((String)defaultFieldName, (Geometry)polygon);
        geoShapeQueryBuilder.relation(ShapeRelation.INTERSECTS);
        ElasticsearchAssertions.assertResponse(tests.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)geoShapeQueryBuilder), response -> {
            SearchHits searchHits = response.getHits();
            Assert.assertEquals((long)2L, (long)searchHits.getTotalHits().value);
            Assert.assertNotEquals((Object)"1", (Object)searchHits.getAt(0).getId());
            Assert.assertNotEquals((Object)"4", (Object)searchHits.getAt(0).getId());
            Assert.assertNotEquals((Object)"1", (Object)searchHits.getAt(1).getId());
            Assert.assertNotEquals((Object)"4", (Object)searchHits.getAt(1).getId());
        });
    }

    public void testMultiPolygonSpanningDateline(BasePointShapeQueryTestCase<GeoShapeQueryBuilder> tests) throws Exception {
        tests.createMapping(defaultIndexName, defaultFieldName);
        tests.ensureGreen(new String[0]);
        tests.client().prepareIndex(defaultIndexName).setId("1").setSource(XContentFactory.jsonBuilder().startObject().field(defaultFieldName, "POINT(-169 7)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        tests.client().prepareIndex(defaultIndexName).setId("2").setSource(XContentFactory.jsonBuilder().startObject().field(defaultFieldName, "POINT(-179 7)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        tests.client().prepareIndex(defaultIndexName).setId("3").setSource(XContentFactory.jsonBuilder().startObject().field(defaultFieldName, "POINT(171 7)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        Polygon polygon1 = new Polygon(new LinearRing(new double[]{-167.0, -171.0, 171.0, -167.0, -167.0}, new double[]{10.0, 10.0, 5.0, 5.0, 10.0}));
        Polygon polygon2 = new Polygon(new LinearRing(new double[]{-177.0, 177.0, 177.0, -177.0, -177.0}, new double[]{10.0, 10.0, 5.0, 5.0, 10.0}));
        MultiPolygon multiPolygon = new MultiPolygon(List.of(polygon1, polygon2));
        GeoShapeQueryBuilder geoShapeQueryBuilder = QueryBuilders.geoShapeQuery((String)defaultFieldName, (Geometry)multiPolygon);
        geoShapeQueryBuilder.relation(ShapeRelation.INTERSECTS);
        ElasticsearchAssertions.assertResponse(tests.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)geoShapeQueryBuilder), response -> {
            SearchHits searchHits = response.getHits();
            Assert.assertEquals((long)2L, (long)searchHits.getTotalHits().value);
            Assert.assertNotEquals((Object)"3", (Object)searchHits.getAt(0).getId());
            Assert.assertNotEquals((Object)"3", (Object)searchHits.getAt(1).getId());
        });
    }
}

